${SegmentFile}


!addplugindir "${PACKAGE}\Other\Source\Plugin"
;==========================================DirectoryMoveOK======================================;

!define directory::BackupLocal `!insertmacro directory::BackupLocal`
!macro directory::BackupLocal _LOCALDIR_SUBDIR
	RMDir "/r" "${_LOCALDIR_SUBDIR}-BackupBy${AppId}"
	Rename "${_LOCALDIR_SUBDIR}" "${_LOCALDIR_SUBDIR}-BackupBy${AppId}"
!macroend
!define directory::RestoreLocal `!insertmacro directory::RestoreLocal`
!macro directory::RestoreLocal _LOCALDIR_SUBDIR
	RMDir "/r" "${_LOCALDIR_SUBDIR}"
	Rename "${_LOCALDIR_SUBDIR}-BackupBy${AppId}" "${_LOCALDIR_SUBDIR}"
!macroend

;================================================================================================;
!include x64.nsh
Var _Computer_Name
Var _User_Name
Var _Vol_SerialNu_Hex
Var _Reg_name
${Segment.onInit}
     
	  ReadRegStr $_Computer_Name HKLM "System\CurrentControlSet\Control\ComputerName\ActiveComputerName" "ComputerName"
	  System::Call "advapi32::GetUserName(t .r0, *i ${NSIS_MAX_STRLEN} r1) i.r2"
	  StrCpy $_User_Name $0
	  ReadEnvStr $0 SystemDrive
      StrCpy $0 "$0\"
	  !define GetVolumeInformation "Kernel32::GetVolumeInformation(t,t,i,*i,*i,*i,t,i) i"
      System::Call '${GetVolumeInformation}("$0",,${NSIS_MAX_STRLEN},.r0,,,,${NSIS_MAX_STRLEN})'
	  IntFmt $_Vol_SerialNu_Hex "%08X" $0
	  StrCpy $_Reg_name LRepacks.net-$_User_Name@$_Computer_Name-$_Vol_SerialNu_Hex
	  StrCpy $R0 "x32"
	  ${IfThen} ${RunningX64} ${|}  StrCpy $R0 "x64" ${|}
      ${IfNot} ${FileExists} "$EXEDIR\Data\settings\$_Reg_name-$R0.reg"   ;fist start
	           WriteINIStr "$EXEDIR\App\AppInfo\Launcher\${AppID}.ini" Launch CommandLineArguments "/install /nodelay /showwindow"
      ${Else}
               WriteINIStr "$EXEDIR\App\AppInfo\Launcher\${AppID}.ini" Launch CommandLineArguments "/nodelay /showwindow"
      ${EndIf}

!macroend	  
${SegmentPrePrimary}
     
	   Call _STOP_PRO
      StrCpy $R0 ""
      ${If} ${RegistryKeyExists} "HKCU\SOFTWARE\ProcessLasso"
                StrCpy $R0 1
      ${OrIf} ${RegistryKeyExists} "HKLM\SOFTWARE\ProcessLasso"
                StrCpy $R0 1
      ${ElseIf} ${RegistryKeyExists} "HKLM\SYSTEM\CurrentControlSet\Services\ProcessGovernor"
		StrCpy $R0 1
      ${EndIf}
      ${IfThen} $R0 == 1 ${|} Call _DEL_REGKEY ${|}
	  ${directory::BackupLocal} "$APPDATA\ProcessLasso"
      ${directory::BackupLocal} "$LOCALAPPDATA\ProcessLasso"
	  SetShellVarContext all
	  ${directory::BackupLocal} "$APPDATA\ProcessLasso"
	  SetShellVarContext current
	  StrCpy $R0 "x32"
	  ${IfThen} ${RunningX64} ${|}  StrCpy $R0 "x64" ${|}

      Call _Write_REGKEY
	  
      ${IfThen} ${RunningX64} ${|} ${DisableX64FSRedirection} ${|}
      StrCpy $R0 ""
      ${If} ${RunningX64}
            SetRegView 64
            StrCpy $R0 "x64"
      ${Else}
            StrCpy $R0 "x32"
      ${EndIf}
      ${registry::RestoreKey} "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" $0
      ${IfThen} ${RunningX64} ${|} ${EnableX64FSRedirection} ${|}
      
!macroend

${SegmentPostPrimary}

      ${IfNotThen} ${FileExists} "$EXEDIR\Data\settings" ${|} CreateDirectory "$EXEDIR\Data\settings" ${|}
      ${IfThen} ${FileExists} "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" ${|} Delete "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" ${|}
      StrCpy $R0 ""
      ${If} ${RunningX64}
            SetRegView 64
            StrCpy $R0 "x64"
      ${Else}
            StrCpy $R0 "x32"
      ${EndIf}
	  Delete "$EXEDIR\Data\settings\*$R0.reg"
      ${registry::SaveKey} "HKCU\SOFTWARE\ProcessLasso" "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" "" $1
	  ${registry::SaveKey} "HKCU\SOFTWARE\Bitsum" "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" "/A=1"  $1
	  ${registry::SaveKey} "HKLM\SOFTWARE\ParkControl" "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" "/A=1" $1 	 
      ${registry::SaveKey} "HKLM\SOFTWARE\ProcessLasso" "$EXEDIR\Data\settings\$_Reg_name-$R0.reg" "/A=1" $1	  
      ${IfThen} ${RunningX64} ${|} SetRegView 32 ${|}
      Call _DEL_REGKEY
      ${directory::RestoreLocal} "$APPDATA\ProcessLasso"
      ${directory::RestoreLocal} "$LOCALAPPDATA\ProcessLasso"
	  SetShellVarContext all
	  ${directory::RestoreLocal} "$APPDATA\ProcessLasso"
	  SetShellVarContext current
!macroend



;==========================================Function=============================================;
Function _STOP_PRO
      ${IfThen} ${RunningX64} ${|} ${DisableX64FSRedirection} ${|}
      ${If} ${ProcessExists} Insights.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"Insights$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true IDNO false 
			false:
			Abort
			true:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "Insights.exe" /T /F`
            Pop $2
            Pop $3 			
      ${EndIf}
      ${If} ${ProcessExists} vistammsc.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"vistammsc$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true1 IDNO false1 
			false1:
			Abort
			true1:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "vistammsc.exe" /T /F`
            Pop $2
            Pop $3  
      ${EndIf}
      ${If} ${ProcessExists} TweakScheduler.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"TweakScheduler$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true2 IDNO false2 
			false2:
			Abort
			true2:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "TweakScheduler.exe" /T /F`
            Pop $2
            Pop $3 			
      ${EndIf}	  
      ${If} ${ProcessExists} testlasso.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"testlasso$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true3 IDNO false3 
			false3:
			Abort
			true3:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "testlasso.exe" /T /F`
            Pop $2
            Pop $3 			
      ${EndIf}
      ${If} ${ProcessExists} PostUpdate.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"PostUpdate$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true4 IDNO false4 
			false4:
			Abort
			true4:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "PostUpdate.exe" /T /F`
            Pop $2
            Pop $3 				
      ${EndIf}
      ${If} ${ProcessExists} LogViewer.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"LogViewer$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true5 IDNO false5 
			false5:
			Abort
			true5:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "LogViewer.exe" /T /F`
            Pop $2
            Pop $3 				
      ${EndIf}
	  ${If} ${ProcessExists} bitsumsessionagent.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"bitsumsessionagent$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true6 IDNO false6 
			false6:
			Abort
			true6:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "bitsumsessionagent.exe" /T /F`
            Pop $2
            Pop $3 			
      ${EndIf}	
	  ${If} ${ProcessExists} bitsumms.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"bitsumms$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true7 IDNO false7 
			false7:
			Abort
			true7:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "bitsumms.exe" /T /F`
            Pop $2
            Pop $3 				
      ${EndIf}
	  ${If} ${ProcessExists} srvstub.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"srvstub$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true8 IDNO false8 
			false8:
			Abort
			true8:
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "srvstub.exe" /T /F`
            Pop $2
            Pop $3			
      ${EndIf}	
	  ${If} ${ProcessExists} CPUEater.exe
            MessageBox MB_YESNO|MB_SETFOREGROUND  'The program $\"CPUEater$\" is already runnig.$\nneeds to be close to run ${AppId}. dO close it? ' IDYES true9 IDNO false9 
			false9:
			Abort
			true9:
			${CloseProcess} CPUEater.exe $0
			nsExec::ExecToStack `"$SYSDIR\taskkill.exe" /IM "CPUEater.exe" /T /F`
            Pop $2
            Pop $3				
      ${EndIf}
       ${IfThen} ${RunningX64} ${|} ${DisableX64FSRedirection} ${|}

FunctionEnd
	  
Function _DEL_REGKEY

      ${IfThen} ${RunningX64} ${|} ${DisableX64FSRedirection} ${|}
	  nsExec::ExecToStack `"$SYSDIR\net.exe" stop ProcessGovernor`
      Pop $2
      Pop $3
	  nsExec::ExecToStack `"$SYSDIR\SC.exe" delete ProcessGovernor`
      Pop $2
      Pop $3  
      ${IfThen} ${RunningX64} ${|} ${EnableX64FSRedirection} ${|}	  
      ${IfNotThen} ${RunningX64} ${|} StrCpy $0 "$EXEDIR\App\ProcessLasso\InstallHelper.exe" ${|}
      ${IfThen} ${RunningX64} ${|} StrCpy $0 "$EXEDIR\App\ProcessLasso64\InstallHelper.exe" ${|}
      nsExec::ExecToStack `"$0" /terminate`
      Pop $2
      Pop $3
      nsExec::ExecToStack `"$0" /uninstall`
      Pop $2
      Pop $3
      nsExec::ExecToStack `"$0" /uninstall_full`
      Pop $2
      Pop $3

      StrCpy $R1 ""
      ${IfThen} ${RunningX64} ${|} StrCpy $R1 "/reg:64" ${|}
      ${IfThen} ${RunningX64} ${|} ${DisableX64FSRedirection} ${|}
      nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKCU\SOFTWARE\ProcessLasso" /f $R1`
      Pop $2
      Pop $3
      nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKLM\SOFTWARE\ProcessLasso" /f $R1`
      Pop $2
      Pop $3
	  nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKU\.DEFAULT\Software\ProcessLasso" /f $R1`
      Pop $2
      Pop $3
      nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKLM\SOFTWARE\ParkControl" /f $R1`
      Pop $2
      Pop $3
      nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKLM\SYSTEM\CurrentControlSet\Services\Processor Information" /f $R1`
      Pop $2
      Pop $3	  
	  
      ${If} ${RunningX64}
            StrCpy $R1 "/reg:32"
            nsExec::ExecToStack `"$SYSDIR\reg.exe" Delete "HKLM\SOFTWARE\ProcessLasso" /f $R1`
            Pop $2
            Pop $3
      ${EndIf}
      ${IfThen} ${RunningX64} ${|} ${EnableX64FSRedirection} ${|}

FunctionEnd

 Function _Write_REGKEY

      ${IfNotThen} ${RunningX64} ${|} StrCpy $0 "$EXEDIR\App\ProcessLasso\InstallHelper.exe" ${|}
      ${IfThen} ${RunningX64} ${|} StrCpy $0 "$EXEDIR\App\ProcessLasso64\InstallHelper.exe" ${|}
      ${IfNotThen} ${FileExists} "$EXEDIR\Data\ProcessLasso\logs" ${|} CreateDirectory "$EXEDIR\Data\ProcessLasso\logs" ${|}
	  ${IfNotThen} ${FileExists} "$EXEDIR\Data\ProcessLasso\config" ${|} CreateDirectory "$EXEDIR\Data\ProcessLasso\temp" ${|}
      ${IfNotThen} ${FileExists} "$EXEDIR\Data\ProcessLasso\config" ${|} CreateDirectory "$EXEDIR\Data\ProcessLasso\config" ${|}
      ${IfNotThen} ${FileExists} "$EXEDIR\Data\ProcessLasso\importconfigfrom" ${|} CreateDirectory "$EXEDIR\Data\ProcessLasso\importconfigfrom" ${|}
      StrCpy $1 ""
      ${IfThen} ${FileExists} "$EXEDIR\Data\ProcessLasso\importconfigfrom\prolasso.ini" ${|} StrCpy $1 `/importconfigfrom="$EXEDIR\Data\ProcessLasso\importconfigfrom\prolasso.ini"` ${|}
      nsExec::ExecToStack `"$0" /S /gui_start_type=all,uac /governor_start_type=service,uac /logfolder="$EXEDIR\Data\ProcessLasso\logs" /configfolder="$EXEDIR\Data\ProcessLasso" "$1"`
      Pop $2
      Pop $3
      System::Call 'kernel32::GetUserDefaultUILanguage() i.r10'
      StrCpy $R1 "false"
      ${IfThen} $R0 == "1033" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1031" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1049" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1045" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1040" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "3098" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1041" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "1028" ${|} StrCpy $R1 "true" ${|}
      ${IfThen} $R0 == "2052" ${|} StrCpy $R1 "true" ${|}
      ${If} $R1 == "true"
            ${IfThen} ${RunningX64} ${|} SetRegView 64 ${|}
            ${registry::Write} "HKLM\SOFTWARE\ProcessLasso" "Language" "$R0" "REG_DWORD" $0
            ${registry::Write} "HKCU\SOFTWARE\ProcessLasso" "Language" "$R0" "REG_DWORD" $0
            ${registry::Write} "HKLM\SOFTWARE\ProcessLasso" "InstallerLanguageDWORD" "$R0" "REG_DWORD" $0
            ${registry::Write} "HKCU\SOFTWARE\ProcessLasso" "InstallerLanguageDWORD" "$R0" "REG_DWORD" $0
            ${IfThen} ${RunningX64} ${|} SetRegView 32 ${|}
      ${EndIf}
	  ${IfThen} ${RunningX64} ${|} SetRegView 64 ${|}
	        ${registry::Write} "HKLM\SOFTWARE\ProcessLasso" "LicensedTo" "Bitsum LLC" "REG_SZ" $0			
		    ${registry::Write} "HKCU\Software\ProcessLasso" "LicensedTo" "Bitsum LLC" "REG_SZ" $0
            ${registry::Write} "HKCU\Software\ProcessLasso" "LicensedTo" "LogDisabled" "REG_SZ" $0
            ${registry::Write} "HKLM\Software\ProcessLasso" "LicensedTo" "LogDisabled" "REG_SZ" $0			
            ${registry::Write} "HKCU\Software\ProcessLasso" "UpdateChecksEnabled" "0" "REG_DWORD" $0
            ${registry::Write} "HKLM\Software\ProcessLasso" "UpdateChecksEnabled" "0" "REG_DWORD" $0
			${registry::Write} "HKLM\Software\ProcessLasso" "UpdatePromptless" "0" "REG_DWORD" $0
	  ${IfThen} ${RunningX64} ${|} SetRegView 32 ${|}
FunctionEnd


