# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
pyFltk, the Python bindings to the FLTK GUI toolkit.
This is an easy to use and light-weight GUI toolkit
offering basic capabilities for the creation of
graphical user interfaces.
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _fltk
else:
    import _fltk

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref


import sys
if sys.version < '3':
  print("Python3 required!")
  exit(1)


sys_exit_original = sys.exit

def pyfltk_sys_exit(status = None):
    Fl.fltk_exit()
    return sys_exit_original(status)

sys.exit = pyfltk_sys_exit

sys.exit.__doc__ = \
r'''This is a sys.exit hooked by pyfltk. Discussion:

https://sourceforge.net/p/pyfltk/mailman/pyfltk-user/thread/87fsxgj3sh.fsf%40secretsauce.net/#msg37304779

 ''' + sys_exit_original.__doc__

FL_NO_EVENT = _fltk.FL_NO_EVENT

FL_PUSH = _fltk.FL_PUSH

FL_RELEASE = _fltk.FL_RELEASE

FL_ENTER = _fltk.FL_ENTER

FL_LEAVE = _fltk.FL_LEAVE

FL_DRAG = _fltk.FL_DRAG

FL_FOCUS = _fltk.FL_FOCUS

FL_UNFOCUS = _fltk.FL_UNFOCUS

FL_KEYDOWN = _fltk.FL_KEYDOWN

FL_KEYBOARD = _fltk.FL_KEYBOARD

FL_KEYUP = _fltk.FL_KEYUP

FL_CLOSE = _fltk.FL_CLOSE

FL_MOVE = _fltk.FL_MOVE

FL_SHORTCUT = _fltk.FL_SHORTCUT

FL_DEACTIVATE = _fltk.FL_DEACTIVATE

FL_ACTIVATE = _fltk.FL_ACTIVATE

FL_HIDE = _fltk.FL_HIDE

FL_SHOW = _fltk.FL_SHOW

FL_PASTE = _fltk.FL_PASTE

FL_SELECTIONCLEAR = _fltk.FL_SELECTIONCLEAR

FL_MOUSEWHEEL = _fltk.FL_MOUSEWHEEL

FL_DND_ENTER = _fltk.FL_DND_ENTER

FL_DND_DRAG = _fltk.FL_DND_DRAG

FL_DND_LEAVE = _fltk.FL_DND_LEAVE

FL_DND_RELEASE = _fltk.FL_DND_RELEASE

FL_SCREEN_CONFIGURATION_CHANGED = _fltk.FL_SCREEN_CONFIGURATION_CHANGED

FL_FULLSCREEN = _fltk.FL_FULLSCREEN

FL_ZOOM_GESTURE = _fltk.FL_ZOOM_GESTURE

FL_ZOOM_EVENT = _fltk.FL_ZOOM_EVENT

FL_BEFORE_TOOLTIP = _fltk.FL_BEFORE_TOOLTIP

FL_BEFORE_MENU = _fltk.FL_BEFORE_MENU

FL_WHEN_NEVER = _fltk.FL_WHEN_NEVER

FL_WHEN_CHANGED = _fltk.FL_WHEN_CHANGED

FL_WHEN_NOT_CHANGED = _fltk.FL_WHEN_NOT_CHANGED

FL_WHEN_RELEASE = _fltk.FL_WHEN_RELEASE

FL_WHEN_RELEASE_ALWAYS = _fltk.FL_WHEN_RELEASE_ALWAYS

FL_WHEN_ENTER_KEY = _fltk.FL_WHEN_ENTER_KEY

FL_WHEN_ENTER_KEY_ALWAYS = _fltk.FL_WHEN_ENTER_KEY_ALWAYS

FL_WHEN_ENTER_KEY_CHANGED = _fltk.FL_WHEN_ENTER_KEY_CHANGED

FL_WHEN_CLOSED = _fltk.FL_WHEN_CLOSED

FL_REASON_UNKNOWN = _fltk.FL_REASON_UNKNOWN

FL_REASON_SELECTED = _fltk.FL_REASON_SELECTED

FL_REASON_DESELECTED = _fltk.FL_REASON_DESELECTED

FL_REASON_RESELECTED = _fltk.FL_REASON_RESELECTED

FL_REASON_OPENED = _fltk.FL_REASON_OPENED

FL_REASON_CLOSED = _fltk.FL_REASON_CLOSED

FL_REASON_DRAGGED = _fltk.FL_REASON_DRAGGED

FL_REASON_CANCELLED = _fltk.FL_REASON_CANCELLED

FL_REASON_CHANGED = _fltk.FL_REASON_CHANGED

FL_REASON_GOT_FOCUS = _fltk.FL_REASON_GOT_FOCUS

FL_REASON_LOST_FOCUS = _fltk.FL_REASON_LOST_FOCUS

FL_REASON_RELEASED = _fltk.FL_REASON_RELEASED

FL_REASON_ENTER_KEY = _fltk.FL_REASON_ENTER_KEY

FL_REASON_USER = _fltk.FL_REASON_USER

FL_Button = _fltk.FL_Button

FL_BackSpace = _fltk.FL_BackSpace

FL_Tab = _fltk.FL_Tab

FL_Iso_Key = _fltk.FL_Iso_Key

FL_Enter = _fltk.FL_Enter

FL_Pause = _fltk.FL_Pause

FL_Scroll_Lock = _fltk.FL_Scroll_Lock

FL_Escape = _fltk.FL_Escape

FL_Kana = _fltk.FL_Kana

FL_Eisu = _fltk.FL_Eisu

FL_Yen = _fltk.FL_Yen

FL_JIS_Underscore = _fltk.FL_JIS_Underscore

FL_Home = _fltk.FL_Home

FL_Left = _fltk.FL_Left

FL_Up = _fltk.FL_Up

FL_Right = _fltk.FL_Right

FL_Down = _fltk.FL_Down

FL_Page_Up = _fltk.FL_Page_Up

FL_Page_Down = _fltk.FL_Page_Down

FL_End = _fltk.FL_End

FL_Print = _fltk.FL_Print

FL_Insert = _fltk.FL_Insert

FL_Menu = _fltk.FL_Menu

FL_Help = _fltk.FL_Help

FL_Num_Lock = _fltk.FL_Num_Lock

FL_KP = _fltk.FL_KP

FL_KP_Enter = _fltk.FL_KP_Enter

FL_KP_Last = _fltk.FL_KP_Last

FL_F = _fltk.FL_F

FL_F_Last = _fltk.FL_F_Last

FL_Shift_L = _fltk.FL_Shift_L

FL_Shift_R = _fltk.FL_Shift_R

FL_Control_L = _fltk.FL_Control_L

FL_Control_R = _fltk.FL_Control_R

FL_Caps_Lock = _fltk.FL_Caps_Lock

FL_Meta_L = _fltk.FL_Meta_L

FL_Meta_R = _fltk.FL_Meta_R

FL_Alt_L = _fltk.FL_Alt_L

FL_Alt_R = _fltk.FL_Alt_R

FL_Delete = _fltk.FL_Delete

FL_Alt_Gr = _fltk.FL_Alt_Gr

FL_Volume_Down = _fltk.FL_Volume_Down

FL_Volume_Mute = _fltk.FL_Volume_Mute

FL_Volume_Up = _fltk.FL_Volume_Up

FL_Media_Play = _fltk.FL_Media_Play

FL_Media_Stop = _fltk.FL_Media_Stop

FL_Media_Prev = _fltk.FL_Media_Prev

FL_Media_Next = _fltk.FL_Media_Next

FL_Home_Page = _fltk.FL_Home_Page

FL_Mail = _fltk.FL_Mail

FL_Search = _fltk.FL_Search

FL_Back = _fltk.FL_Back

FL_Forward = _fltk.FL_Forward

FL_Stop = _fltk.FL_Stop

FL_Refresh = _fltk.FL_Refresh

FL_Sleep = _fltk.FL_Sleep

FL_Favorites = _fltk.FL_Favorites

FL_LEFT_MOUSE = _fltk.FL_LEFT_MOUSE

FL_MIDDLE_MOUSE = _fltk.FL_MIDDLE_MOUSE

FL_RIGHT_MOUSE = _fltk.FL_RIGHT_MOUSE

FL_BACK_MOUSE = _fltk.FL_BACK_MOUSE

FL_FORWARD_MOUSE = _fltk.FL_FORWARD_MOUSE

FL_SHIFT = _fltk.FL_SHIFT

FL_CAPS_LOCK = _fltk.FL_CAPS_LOCK

FL_CTRL = _fltk.FL_CTRL

FL_ALT = _fltk.FL_ALT

FL_NUM_LOCK = _fltk.FL_NUM_LOCK

FL_META = _fltk.FL_META

FL_SCROLL_LOCK = _fltk.FL_SCROLL_LOCK

FL_BUTTON1 = _fltk.FL_BUTTON1

FL_BUTTON2 = _fltk.FL_BUTTON2

FL_BUTTON3 = _fltk.FL_BUTTON3

FL_BUTTON4 = _fltk.FL_BUTTON4

FL_BUTTON5 = _fltk.FL_BUTTON5

FL_BUTTONS = _fltk.FL_BUTTONS

FL_KEY_MASK = _fltk.FL_KEY_MASK

FL_NO_BOX = _fltk.FL_NO_BOX

FL_FLAT_BOX = _fltk.FL_FLAT_BOX

FL_UP_BOX = _fltk.FL_UP_BOX

FL_DOWN_BOX = _fltk.FL_DOWN_BOX

FL_UP_FRAME = _fltk.FL_UP_FRAME

FL_DOWN_FRAME = _fltk.FL_DOWN_FRAME

FL_THIN_UP_BOX = _fltk.FL_THIN_UP_BOX

FL_THIN_DOWN_BOX = _fltk.FL_THIN_DOWN_BOX

FL_THIN_UP_FRAME = _fltk.FL_THIN_UP_FRAME

FL_THIN_DOWN_FRAME = _fltk.FL_THIN_DOWN_FRAME

FL_ENGRAVED_BOX = _fltk.FL_ENGRAVED_BOX

FL_EMBOSSED_BOX = _fltk.FL_EMBOSSED_BOX

FL_ENGRAVED_FRAME = _fltk.FL_ENGRAVED_FRAME

FL_EMBOSSED_FRAME = _fltk.FL_EMBOSSED_FRAME

FL_BORDER_BOX = _fltk.FL_BORDER_BOX

_FL_SHADOW_BOX = _fltk._FL_SHADOW_BOX

FL_BORDER_FRAME = _fltk.FL_BORDER_FRAME

_FL_SHADOW_FRAME = _fltk._FL_SHADOW_FRAME

_FL_ROUNDED_BOX = _fltk._FL_ROUNDED_BOX

_FL_RSHADOW_BOX = _fltk._FL_RSHADOW_BOX

_FL_ROUNDED_FRAME = _fltk._FL_ROUNDED_FRAME

_FL_RFLAT_BOX = _fltk._FL_RFLAT_BOX

_FL_ROUND_UP_BOX = _fltk._FL_ROUND_UP_BOX

_FL_ROUND_DOWN_BOX = _fltk._FL_ROUND_DOWN_BOX

_FL_DIAMOND_UP_BOX = _fltk._FL_DIAMOND_UP_BOX

_FL_DIAMOND_DOWN_BOX = _fltk._FL_DIAMOND_DOWN_BOX

_FL_OVAL_BOX = _fltk._FL_OVAL_BOX

_FL_OSHADOW_BOX = _fltk._FL_OSHADOW_BOX

_FL_OVAL_FRAME = _fltk._FL_OVAL_FRAME

_FL_OFLAT_BOX = _fltk._FL_OFLAT_BOX

_FL_PLASTIC_UP_BOX = _fltk._FL_PLASTIC_UP_BOX

_FL_PLASTIC_DOWN_BOX = _fltk._FL_PLASTIC_DOWN_BOX

_FL_PLASTIC_UP_FRAME = _fltk._FL_PLASTIC_UP_FRAME

_FL_PLASTIC_DOWN_FRAME = _fltk._FL_PLASTIC_DOWN_FRAME

_FL_PLASTIC_THIN_UP_BOX = _fltk._FL_PLASTIC_THIN_UP_BOX

_FL_PLASTIC_THIN_DOWN_BOX = _fltk._FL_PLASTIC_THIN_DOWN_BOX

_FL_PLASTIC_ROUND_UP_BOX = _fltk._FL_PLASTIC_ROUND_UP_BOX

_FL_PLASTIC_ROUND_DOWN_BOX = _fltk._FL_PLASTIC_ROUND_DOWN_BOX

_FL_GTK_UP_BOX = _fltk._FL_GTK_UP_BOX

_FL_GTK_DOWN_BOX = _fltk._FL_GTK_DOWN_BOX

_FL_GTK_UP_FRAME = _fltk._FL_GTK_UP_FRAME

_FL_GTK_DOWN_FRAME = _fltk._FL_GTK_DOWN_FRAME

_FL_GTK_THIN_UP_BOX = _fltk._FL_GTK_THIN_UP_BOX

_FL_GTK_THIN_DOWN_BOX = _fltk._FL_GTK_THIN_DOWN_BOX

_FL_GTK_THIN_UP_FRAME = _fltk._FL_GTK_THIN_UP_FRAME

_FL_GTK_THIN_DOWN_FRAME = _fltk._FL_GTK_THIN_DOWN_FRAME

_FL_GTK_ROUND_UP_BOX = _fltk._FL_GTK_ROUND_UP_BOX

_FL_GTK_ROUND_DOWN_BOX = _fltk._FL_GTK_ROUND_DOWN_BOX

_FL_GLEAM_UP_BOX = _fltk._FL_GLEAM_UP_BOX

_FL_GLEAM_DOWN_BOX = _fltk._FL_GLEAM_DOWN_BOX

_FL_GLEAM_UP_FRAME = _fltk._FL_GLEAM_UP_FRAME

_FL_GLEAM_DOWN_FRAME = _fltk._FL_GLEAM_DOWN_FRAME

_FL_GLEAM_THIN_UP_BOX = _fltk._FL_GLEAM_THIN_UP_BOX

_FL_GLEAM_THIN_DOWN_BOX = _fltk._FL_GLEAM_THIN_DOWN_BOX

_FL_GLEAM_ROUND_UP_BOX = _fltk._FL_GLEAM_ROUND_UP_BOX

_FL_GLEAM_ROUND_DOWN_BOX = _fltk._FL_GLEAM_ROUND_DOWN_BOX

_FL_OXY_UP_BOX = _fltk._FL_OXY_UP_BOX

_FL_OXY_DOWN_BOX = _fltk._FL_OXY_DOWN_BOX

_FL_OXY_UP_FRAME = _fltk._FL_OXY_UP_FRAME

_FL_OXY_DOWN_FRAME = _fltk._FL_OXY_DOWN_FRAME

_FL_OXY_THIN_UP_BOX = _fltk._FL_OXY_THIN_UP_BOX

_FL_OXY_THIN_DOWN_BOX = _fltk._FL_OXY_THIN_DOWN_BOX

_FL_OXY_THIN_UP_FRAME = _fltk._FL_OXY_THIN_UP_FRAME

_FL_OXY_THIN_DOWN_FRAME = _fltk._FL_OXY_THIN_DOWN_FRAME

_FL_OXY_ROUND_UP_BOX = _fltk._FL_OXY_ROUND_UP_BOX

_FL_OXY_ROUND_DOWN_BOX = _fltk._FL_OXY_ROUND_DOWN_BOX

_FL_OXY_BUTTON_UP_BOX = _fltk._FL_OXY_BUTTON_UP_BOX

_FL_OXY_BUTTON_DOWN_BOX = _fltk._FL_OXY_BUTTON_DOWN_BOX

FL_FREE_BOXTYPE = _fltk.FL_FREE_BOXTYPE

FL_MAX_BOXTYPE = _fltk.FL_MAX_BOXTYPE


def fl_define_FL_ROUND_UP_BOX(*args):
    r"""fl_define_FL_ROUND_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_ROUND_UP_BOX(*args)

def fl_define_FL_SHADOW_BOX(*args):
    r"""fl_define_FL_SHADOW_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_SHADOW_BOX(*args)

def fl_define_FL_ROUNDED_BOX(*args):
    r"""fl_define_FL_ROUNDED_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_ROUNDED_BOX(*args)

def fl_define_FL_RFLAT_BOX(*args):
    r"""fl_define_FL_RFLAT_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_RFLAT_BOX(*args)

def fl_define_FL_RSHADOW_BOX(*args):
    r"""fl_define_FL_RSHADOW_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_RSHADOW_BOX(*args)

def fl_define_FL_DIAMOND_BOX(*args):
    r"""fl_define_FL_DIAMOND_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_DIAMOND_BOX(*args)

def fl_define_FL_OVAL_BOX(*args):
    r"""fl_define_FL_OVAL_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_OVAL_BOX(*args)

def fl_define_FL_PLASTIC_UP_BOX(*args):
    r"""fl_define_FL_PLASTIC_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_PLASTIC_UP_BOX(*args)

def fl_define_FL_GTK_UP_BOX(*args):
    r"""fl_define_FL_GTK_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_GTK_UP_BOX(*args)

def fl_define_FL_GLEAM_UP_BOX(*args):
    r"""fl_define_FL_GLEAM_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_GLEAM_UP_BOX(*args)

def fl_define_FL_OXY_UP_BOX(*args):
    r"""fl_define_FL_OXY_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_OXY_UP_BOX(*args)

def fl_box(*args):
    r"""fl_box(Fl_Boxtype b) -> Fl_Boxtype"""
    return _fltk.fl_box(*args)

def fl_down(*args):
    r"""fl_down(Fl_Boxtype b) -> Fl_Boxtype"""
    return _fltk.fl_down(*args)
FL_NORMAL_LABEL = _fltk.FL_NORMAL_LABEL

FL_NO_LABEL = _fltk.FL_NO_LABEL

_FL_SHADOW_LABEL = _fltk._FL_SHADOW_LABEL

_FL_ENGRAVED_LABEL = _fltk._FL_ENGRAVED_LABEL

_FL_EMBOSSED_LABEL = _fltk._FL_EMBOSSED_LABEL

_FL_MULTI_LABEL = _fltk._FL_MULTI_LABEL

_FL_ICON_LABEL = _fltk._FL_ICON_LABEL

_FL_IMAGE_LABEL = _fltk._FL_IMAGE_LABEL

FL_FREE_LABELTYPE = _fltk.FL_FREE_LABELTYPE


def fl_define_FL_SHADOW_LABEL(*args):
    r"""fl_define_FL_SHADOW_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_SHADOW_LABEL(*args)

def fl_define_FL_ENGRAVED_LABEL(*args):
    r"""fl_define_FL_ENGRAVED_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_ENGRAVED_LABEL(*args)

def fl_define_FL_EMBOSSED_LABEL(*args):
    r"""fl_define_FL_EMBOSSED_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_EMBOSSED_LABEL(*args)

def fl_define_FL_MULTI_LABEL(*args):
    r"""fl_define_FL_MULTI_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_MULTI_LABEL(*args)

def fl_define_FL_ICON_LABEL(*args):
    r"""fl_define_FL_ICON_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_ICON_LABEL(*args)

def fl_define_FL_IMAGE_LABEL(*args):
    r"""fl_define_FL_IMAGE_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_IMAGE_LABEL(*args)
FL_NUM_FREE_COLOR = _fltk.FL_NUM_FREE_COLOR

FL_NUM_GRAY = _fltk.FL_NUM_GRAY

FL_NUM_RED = _fltk.FL_NUM_RED

FL_NUM_GREEN = _fltk.FL_NUM_GREEN

FL_NUM_BLUE = _fltk.FL_NUM_BLUE


def fl_inactive(*args):
    r"""fl_inactive(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_inactive(*args)

def fl_contrast_function(*args):
    r"""fl_contrast_function(Fl_Contrast_Function * f)"""
    return _fltk.fl_contrast_function(*args)
FL_CONTRAST_NONE = _fltk.FL_CONTRAST_NONE

FL_CONTRAST_LEGACY = _fltk.FL_CONTRAST_LEGACY

FL_CONTRAST_CIELAB = _fltk.FL_CONTRAST_CIELAB

FL_CONTRAST_CUSTOM = _fltk.FL_CONTRAST_CUSTOM

FL_CONTRAST_LAST = _fltk.FL_CONTRAST_LAST


def fl_contrast_level(*args):
    r"""
    fl_contrast_level(int level)
    fl_contrast_level() -> int
    """
    return _fltk.fl_contrast_level(*args)

def fl_contrast_mode(*args):
    r"""
    fl_contrast_mode(int mode)
    fl_contrast_mode() -> int
    """
    return _fltk.fl_contrast_mode(*args)

def fl_contrast(*args):
    r"""fl_contrast(Fl_Color fg, Fl_Color bg, int context=0, int size=0) -> Fl_Color"""
    return _fltk.fl_contrast(*args)

def fl_lightness(*args):
    r"""fl_lightness(Fl_Color color) -> double"""
    return _fltk.fl_lightness(*args)

def fl_luminance(*args):
    r"""fl_luminance(Fl_Color color) -> double"""
    return _fltk.fl_luminance(*args)

def fl_color_average(*args):
    r"""fl_color_average(Fl_Color c1, Fl_Color c2, float weight) -> Fl_Color"""
    return _fltk.fl_color_average(*args)

def fl_lighter(*args):
    r"""fl_lighter(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_lighter(*args)

def fl_darker(*args):
    r"""fl_darker(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_darker(*args)

def fl_rgb_color(*args):
    r"""
    fl_rgb_color(uchar r, uchar g, uchar b) -> Fl_Color
    fl_rgb_color(uchar g) -> Fl_Color
    """
    return _fltk.fl_rgb_color(*args)

def fl_gray_ramp(*args):
    r"""fl_gray_ramp(int i) -> Fl_Color"""
    return _fltk.fl_gray_ramp(*args)

def fl_color_cube(*args):
    r"""fl_color_cube(int r, int g, int b) -> Fl_Color"""
    return _fltk.fl_color_cube(*args)
FL_CURSOR_DEFAULT = _fltk.FL_CURSOR_DEFAULT

FL_CURSOR_ARROW = _fltk.FL_CURSOR_ARROW

FL_CURSOR_CROSS = _fltk.FL_CURSOR_CROSS

FL_CURSOR_WAIT = _fltk.FL_CURSOR_WAIT

FL_CURSOR_INSERT = _fltk.FL_CURSOR_INSERT

FL_CURSOR_HAND = _fltk.FL_CURSOR_HAND

FL_CURSOR_HELP = _fltk.FL_CURSOR_HELP

FL_CURSOR_MOVE = _fltk.FL_CURSOR_MOVE

FL_CURSOR_NS = _fltk.FL_CURSOR_NS

FL_CURSOR_WE = _fltk.FL_CURSOR_WE

FL_CURSOR_NWSE = _fltk.FL_CURSOR_NWSE

FL_CURSOR_NESW = _fltk.FL_CURSOR_NESW

FL_CURSOR_N = _fltk.FL_CURSOR_N

FL_CURSOR_NE = _fltk.FL_CURSOR_NE

FL_CURSOR_E = _fltk.FL_CURSOR_E

FL_CURSOR_SE = _fltk.FL_CURSOR_SE

FL_CURSOR_S = _fltk.FL_CURSOR_S

FL_CURSOR_SW = _fltk.FL_CURSOR_SW

FL_CURSOR_W = _fltk.FL_CURSOR_W

FL_CURSOR_NW = _fltk.FL_CURSOR_NW

FL_CURSOR_NONE = _fltk.FL_CURSOR_NONE

FL_READ = _fltk.FL_READ

FL_WRITE = _fltk.FL_WRITE

FL_EXCEPT = _fltk.FL_EXCEPT

FL_RGB = _fltk.FL_RGB

FL_INDEX = _fltk.FL_INDEX

FL_SINGLE = _fltk.FL_SINGLE

FL_DOUBLE = _fltk.FL_DOUBLE

FL_ACCUM = _fltk.FL_ACCUM

FL_ALPHA = _fltk.FL_ALPHA

FL_DEPTH = _fltk.FL_DEPTH

FL_STENCIL = _fltk.FL_STENCIL

FL_RGB8 = _fltk.FL_RGB8

FL_MULTISAMPLE = _fltk.FL_MULTISAMPLE

FL_STEREO = _fltk.FL_STEREO

FL_FAKE_SINGLE = _fltk.FL_FAKE_SINGLE

FL_OPENGL3 = _fltk.FL_OPENGL3

FL_IMAGE_WITH_ALPHA = _fltk.FL_IMAGE_WITH_ALPHA

FL_DAMAGE_CHILD = _fltk.FL_DAMAGE_CHILD

FL_DAMAGE_EXPOSE = _fltk.FL_DAMAGE_EXPOSE

FL_DAMAGE_SCROLL = _fltk.FL_DAMAGE_SCROLL

FL_DAMAGE_OVERLAY = _fltk.FL_DAMAGE_OVERLAY

FL_DAMAGE_USER1 = _fltk.FL_DAMAGE_USER1

FL_DAMAGE_USER2 = _fltk.FL_DAMAGE_USER2

FL_DAMAGE_ALL = _fltk.FL_DAMAGE_ALL

FL_ARROW_SINGLE = _fltk.FL_ARROW_SINGLE

FL_ARROW_DOUBLE = _fltk.FL_ARROW_DOUBLE

FL_ARROW_CHOICE = _fltk.FL_ARROW_CHOICE

FL_ARROW_RETURN = _fltk.FL_ARROW_RETURN

FL_ORIENT_NONE = _fltk.FL_ORIENT_NONE

FL_ORIENT_RIGHT = _fltk.FL_ORIENT_RIGHT

FL_ORIENT_NE = _fltk.FL_ORIENT_NE

FL_ORIENT_UP = _fltk.FL_ORIENT_UP

FL_ORIENT_NW = _fltk.FL_ORIENT_NW

FL_ORIENT_LEFT = _fltk.FL_ORIENT_LEFT

FL_ORIENT_SW = _fltk.FL_ORIENT_SW

FL_ORIENT_DOWN = _fltk.FL_ORIENT_DOWN

FL_ORIENT_SE = _fltk.FL_ORIENT_SE


def fl_command_modifier(*args):
    r"""fl_command_modifier() -> int"""
    return _fltk.fl_command_modifier(*args)

def fl_control_modifier(*args):
    r"""fl_control_modifier() -> int"""
    return _fltk.fl_control_modifier(*args)

# events
FL_KEYBOARD=FL_KEYDOWN

# additional boxtypes instead of defines
FL_ROUND_UP_BOX=fl_define_FL_ROUND_UP_BOX()
FL_ROUND_DOWN_BOX=fl_define_FL_ROUND_UP_BOX()+1
FL_SHADOW_BOX=fl_define_FL_SHADOW_BOX()
FL_SHADOW_FRAME=fl_define_FL_SHADOW_BOX()+2
FL_ROUNDED_BOX=fl_define_FL_ROUNDED_BOX()
FL_ROUNDED_FRAME=fl_define_FL_ROUNDED_BOX()+2
FL_RFLAT_BOX=fl_define_FL_RFLAT_BOX()
FL_RSHADOW_BOX=fl_define_FL_RSHADOW_BOX()
FL_DIAMOND_UP_BOX=fl_define_FL_DIAMOND_BOX()
FL_DIAMOND_DOWN_BOX=fl_define_FL_DIAMOND_BOX()+1
FL_OVAL_BOX=fl_define_FL_OVAL_BOX()
FL_OSHADOW_BOX=fl_define_FL_OVAL_BOX()+1
FL_OVAL_FRAME=fl_define_FL_OVAL_BOX()+2
FL_OFLAT_BOX=fl_define_FL_OVAL_BOX()+3
FL_PLASTIC_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()
FL_PLASTIC_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+1
FL_PLASTIC_UP_FRAME=fl_define_FL_PLASTIC_UP_BOX()+2
FL_PLASTIC_DOWN_FRAME=fl_define_FL_PLASTIC_UP_BOX()+3
FL_PLASTIC_THIN_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+4
FL_PLASTIC_THIN_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+5
FL_PLASTIC_ROUND_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+6
FL_PLASTIC_ROUND_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+7

FL_GTK_UP_BOX=fl_define_FL_GTK_UP_BOX()
FL_GTK_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+1
FL_GTK_UP_FRAME=fl_define_FL_GTK_UP_BOX()+2
FL_GTK_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+3
FL_GTK_THIN_UP_BOX=fl_define_FL_GTK_UP_BOX()+4
FL_GTK_THIN_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+5
FL_GTK_THIN_UP_FRAME=fl_define_FL_GTK_UP_BOX()+6
FL_GTK_THIN_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+7
FL_GTK_ROUND_UP_BOX=fl_define_FL_GTK_UP_BOX()+8
FL_GTK_ROUND_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+9

FL_GLEAM_UP_BOX=fl_define_FL_GLEAM_UP_BOX()
FL_GLEAM_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+1
FL_GLEAM_UP_FRAME=fl_define_FL_GLEAM_UP_BOX()+2
FL_GLEAM_DOWN_FRAME=fl_define_FL_GLEAM_UP_BOX()+3
FL_GLEAM_THIN_UP_BOX=fl_define_FL_GLEAM_UP_BOX()+4
FL_GLEAM_THIN_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+5
FL_GLEAM_ROUND_UP_BOX=fl_define_FL_GLEAM_UP_BOX()+6
FL_GLEAM_ROUND_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+7

FL_OXY_UP_BOX=fl_define_FL_OXY_UP_BOX()
FL_OXY_DOWN_BOX=fl_define_FL_OXY_UP_BOX()+1
FL_OXY_UP_FRAME=fl_define_FL_OXY_UP_BOX()+2
FL_OXY_DOWN_FRAME=fl_define_FL_OXY_UP_BOX()+3
FL_OXY_THIN_UP_BOX=fl_define_FL_OXY_UP_BOX()+4
FL_OXY_THIN_DOWN_BOX=fl_define_FL_OXY_UP_BOX()+5
FL_OXY_THIN_UP_FRAME=fl_define_FL_OXY_UP_BOX()+6
FL_OXY_THIN_DOWN_FRAME=fl_define_FL_OXY_UP_BOX()+7
FL_OXY_ROUND_UP_BOX=fl_define_FL_OXY_UP_BOX()+8
FL_OXY_ROUND_DOWN_BOX=fl_define_FL_OXY_UP_BOX()+9
FL_OXY_BUTTON_UP_BOX=fl_define_FL_OXY_UP_BOX()+10
FL_OXY_BUTTON_DOWN_BOX=fl_define_FL_OXY_UP_BOX()+11


# color defines
FL_FOREGROUND_COLOR  = 0
FL_BACKGROUND2_COLOR = 7
FL_INACTIVE_COLOR    = 8
FL_SELECTION_COLOR   = 15

FL_GRAY0   = 32
FL_DARK3   = 39
FL_DARK2   = 45
FL_DARK1   = 47
FL_BACKGROUND_COLOR  = 49
FL_LIGHT1  = 50
FL_LIGHT2  = 52
FL_LIGHT3  = 54

FL_BLACK   = 56
FL_RED     = 88
FL_GREEN   = 63
FL_YELLOW  = 95
FL_BLUE    = 216
FL_MAGENTA = 248
FL_CYAN    = 223
FL_DARK_RED = 72

FL_DARK_GREEN    = 60
FL_DARK_YELLOW   = 76
FL_DARK_BLUE     = 136
FL_DARK_MAGENTA  = 152
FL_DARK_CYAN     = 140

FL_WHITE         = 255

FL_FREE_COLOR=16           
FL_NUM_FREE_COLOR=16       
FL_GRAY_RAMP=32           
FL_NUM_GRAY=24                     
FL_GRAY=49
FL_COLOR_CUBE=56           
FL_NUM_RED=5                      
FL_NUM_GREEN=8                      
FL_NUM_BLUE=5

# label defines
FL_SYMBOL_LABEL=FL_NORMAL_LABEL
FL_SHADOW_LABEL=fl_define_FL_SHADOW_LABEL()
FL_ENGRAVED_LABEL=fl_define_FL_ENGRAVED_LABEL()
FL_EMBOSSED_LABEL=fl_define_FL_EMBOSSED_LABEL()
FL_MULTI_LABEL=FL_EMBOSSED_LABEL+1
FL_ICON_LABEL=FL_MULTI_LABEL+1
FL_IMAGE_LABEL=FL_ICON_LABEL+1

FL_ALIGN_CENTER=0
FL_ALIGN_TOP=1
FL_ALIGN_BOTTOM=2
FL_ALIGN_LEFT=4
FL_ALIGN_RIGHT=8
FL_ALIGN_INSIDE=16
FL_ALIGN_TEXT_OVER_IMAGE=32
FL_ALIGN_IMAGE_OVER_TEXT=0
FL_ALIGN_CLIP=64
FL_ALIGN_WRAP=128
FL_ALIGN_IMAGE_NEXT_TO_TEXT=0x0100
FL_ALIGN_TEXT_NEXT_TO_IMAGE=0x0120
FL_ALIGN_IMAGE_BACKDROP=0x0200
FL_ALIGN_TOP_LEFT= FL_ALIGN_TOP | FL_ALIGN_LEFT
FL_ALIGN_TOP_RIGHT= FL_ALIGN_TOP | FL_ALIGN_RIGHT
FL_ALIGN_BOTTOM_LEFT= FL_ALIGN_BOTTOM | FL_ALIGN_LEFT
FL_ALIGN_BOTTOM_RIGHT= FL_ALIGN_BOTTOM | FL_ALIGN_RIGHT
FL_ALIGN_LEFT_TOP	= 0x0007
FL_ALIGN_RIGHT_TOP	= 0x000b 
FL_ALIGN_LEFT_BOTTOM	= 0x000d 
FL_ALIGN_RIGHT_BOTTOM	= 0x000e 
FL_ALIGN_NOWRAP		= 0 
FL_ALIGN_POSITION_MASK   = 0x000f
FL_ALIGN_IMAGE_MASK      = 0x0320 

# font defines
FL_HELVETICA              = 0	## Helvetica (or Arial) normal (0)
FL_HELVETICA_BOLD         = 1	## Helvetica (or Arial) bold
FL_HELVETICA_ITALIC       = 2	## Helvetica (or Arial) oblique
FL_HELVETICA_BOLD_ITALIC  = 3	## Helvetica (or Arial) bold-oblique
FL_COURIER                = 4	## Courier normal
FL_COURIER_BOLD           = 5	## Courier bold 
FL_COURIER_ITALIC         = 6	## Courier italic
FL_COURIER_BOLD_ITALIC    = 7	## Courier bold-italic
FL_TIMES                  = 8	## Times roman
FL_TIMES_BOLD             = 9	## Times roman bold
FL_TIMES_ITALIC           = 10	## Times roman italic
FL_TIMES_BOLD_ITALIC      = 11	## Times roman bold-italic
FL_SYMBOL                 = 12	## Standard symbol font
FL_SCREEN                 = 13	## Default monospaced screen font
FL_SCREEN_BOLD            = 14	## Default monospaced bold screen font
FL_ZAPF_DINGBATS          = 15	## Zapf-dingbats font

FL_FREE_FONT              = 16	## first one to allocate
FL_BOLD                   = 1	## add this to helvetica, courier, or times
FL_ITALIC                 = 2	## add this to helvetica, courier, or times
FL_BOLD_ITALIC            = 3	## add this to helvetica, courier, or times

FL_COMMAND=fl_command_modifier()
FL_CONTROL=fl_control_modifier()


FL_RGB_SCALING_NEAREST = _fltk.FL_RGB_SCALING_NEAREST

FL_RGB_SCALING_BILINEAR = _fltk.FL_RGB_SCALING_BILINEAR

class Fl_Image(object):
    r"""

    Fl_Image is the base class used for caching and drawing all kinds of images 
    in FLTK. This class keeps track of common image data such as the pixels, 
    colormap, width, height, and depth. Virtual methods are used to provide 
    type-specific image handling.

    Since the Fl_Image class does not support image drawing by itself, calling 
    the draw() method results in a box with an X in it being drawn instead.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def w(self, *args):
        r"""w(Fl_Image self) -> int"""
        return _fltk.Fl_Image_w(self, *args)

    def h(self, *args):
        r"""h(Fl_Image self) -> int"""
        return _fltk.Fl_Image_h(self, *args)

    def data_w(self, *args):
        r"""data_w(Fl_Image self) -> int"""
        return _fltk.Fl_Image_data_w(self, *args)

    def data_h(self, *args):
        r"""data_h(Fl_Image self) -> int"""
        return _fltk.Fl_Image_data_h(self, *args)

    def d(self, *args):
        r"""d(Fl_Image self) -> int"""
        return _fltk.Fl_Image_d(self, *args)

    def ld(self, *args):
        r"""ld(Fl_Image self) -> int"""
        return _fltk.Fl_Image_ld(self, *args)

    def count(self, *args):
        r"""count(Fl_Image self) -> int"""
        return _fltk.Fl_Image_count(self, *args)

    def data(self, *args):
        r"""data(Fl_Image self) -> char const *const *"""
        return _fltk.Fl_Image_data(self, *args)

    def fail(self, *args):
        r"""fail(Fl_Image self) -> int"""
        return _fltk.Fl_Image_fail(self, *args)

    def release(self, *args):
        r"""release(Fl_Image self)"""
        return _fltk.Fl_Image_release(self, *args)

    def as_shared_image(self, *args):
        r"""as_shared_image(Fl_Image self) -> Fl_Shared_Image"""
        return _fltk.Fl_Image_as_shared_image(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Image self, int W, int H, int D) -> Fl_Image"""
        if self.__class__ == Fl_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_Image_swiginit(self, _fltk.new_Fl_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Image

    def copy(self, *args):
        r"""
        copy(Fl_Image self, int W, int H) -> Fl_Image
        copy(Fl_Image self) -> Fl_Image
        """
        return _fltk.Fl_Image_copy(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Image_color_average(self, *args)

    def inactive(self, *args):
        r"""inactive(Fl_Image self)"""
        return _fltk.Fl_Image_inactive(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_Image self)"""
        return _fltk.Fl_Image_desaturate(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Image self, Fl_Widget w)
        label(Fl_Image self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Image_label(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Image self, int X, int Y)
        """
        return _fltk.Fl_Image_draw(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_Image self)"""
        return _fltk.Fl_Image_uncache(self, *args)

    @staticmethod
    def define_FL_IMAGE_LABEL(*args):
        r"""define_FL_IMAGE_LABEL() -> Fl_Labeltype"""
        return _fltk.Fl_Image_define_FL_IMAGE_LABEL(*args)

    @staticmethod
    def RGB_scaling(*args):
        r"""
        RGB_scaling(Fl_RGB_Scaling arg1)
        RGB_scaling() -> Fl_RGB_Scaling
        """
        return _fltk.Fl_Image_RGB_scaling(*args)

    def scale(self, *args):
        r"""scale(Fl_Image self, int width, int height, int proportional=1, int can_expand=0)"""
        return _fltk.Fl_Image_scale(self, *args)

    @staticmethod
    def scaling_algorithm(*args):
        r"""
        scaling_algorithm(Fl_RGB_Scaling algorithm)
        scaling_algorithm() -> Fl_RGB_Scaling
        """
        return _fltk.Fl_Image_scaling_algorithm(*args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Image(self)
        return weakref.proxy(self)

# Register Fl_Image in _fltk:
_fltk.Fl_Image_swigregister(Fl_Image)
class Fl_RGB_Image(Fl_Image):
    r"""Proxy of C++ Fl_RGB_Image class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_RGB_Image self, uchar const * bits, int W, int H, int D=3, int LD=0) -> Fl_RGB_Image
        __init__(Fl_RGB_Image self, uchar const * bits, int bits_length, int W, int H, int D, int LD) -> Fl_RGB_Image
        __init__(Fl_RGB_Image self, Fl_Pixmap pxm, Fl_Color bg=) -> Fl_RGB_Image
        """
        if self.__class__ == Fl_RGB_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_RGB_Image_swiginit(self, _fltk.new_Fl_RGB_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_RGB_Image

    def copy(self, *args):
        r"""
        copy(Fl_RGB_Image self, int W, int H) -> Fl_Image
        copy(Fl_RGB_Image self) -> Fl_Image
        """
        return _fltk.Fl_RGB_Image_copy(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_RGB_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_RGB_Image_color_average(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_RGB_Image self)"""
        return _fltk.Fl_RGB_Image_desaturate(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_RGB_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_RGB_Image self, int X, int Y)
        """
        return _fltk.Fl_RGB_Image_draw(self, *args)

    def label(self, *args):
        r"""
        label(Fl_RGB_Image self, Fl_Widget w)
        label(Fl_RGB_Image self, Fl_Menu_Item m)
        """
        return _fltk.Fl_RGB_Image_label(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_RGB_Image self)"""
        return _fltk.Fl_RGB_Image_uncache(self, *args)

    def cache_w(self, *args):
        r"""cache_w(Fl_RGB_Image self) -> int"""
        return _fltk.Fl_RGB_Image_cache_w(self, *args)

    def cache_h(self, *args):
        r"""cache_h(Fl_RGB_Image self) -> int"""
        return _fltk.Fl_RGB_Image_cache_h(self, *args)

    @staticmethod
    def max_size(*args):
        r"""
        max_size(size_t size)
        max_size() -> size_t
        """
        return _fltk.Fl_RGB_Image_max_size(*args)

    def as_svg_image(self, *args):
        r"""as_svg_image(Fl_RGB_Image self) -> Fl_SVG_Image"""
        return _fltk.Fl_RGB_Image_as_svg_image(self, *args)

    def normalize(self, *args):
        r"""normalize(Fl_RGB_Image self)"""
        return _fltk.Fl_RGB_Image_normalize(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_RGB_Image(self)
        return weakref.proxy(self)

# Register Fl_RGB_Image in _fltk:
_fltk.Fl_RGB_Image_swigregister(Fl_RGB_Image)
class Fl_Label(object):
    r"""Proxy of C++ Fl_Label class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Label self, int arg2, int arg3, int arg4, int arg5, Fl_Align arg6)"""
        return _fltk.Fl_Label_draw(self, *args)

    def measure(self, *args):
        r"""measure(Fl_Label self, int & w, int & h)"""
        return _fltk.Fl_Label_measure(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Label self) -> Fl_Label"""
        _fltk.Fl_Label_swiginit(self, _fltk.new_Fl_Label(*args))
    __swig_destroy__ = _fltk.delete_Fl_Label

# Register Fl_Label in _fltk:
_fltk.Fl_Label_swigregister(Fl_Label)
class Fl_Callback_User_Data(object):
    r"""Proxy of C++ Fl_Callback_User_Data class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Callback_User_Data self) -> Fl_Callback_User_Data"""
        if self.__class__ == Fl_Callback_User_Data:
            _self = None
        else:
            _self = self
        _fltk.Fl_Callback_User_Data_swiginit(self, _fltk.new_Fl_Callback_User_Data(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Callback_User_Data
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Callback_User_Data(self)
        return weakref.proxy(self)

# Register Fl_Callback_User_Data in _fltk:
_fltk.Fl_Callback_User_Data_swigregister(Fl_Callback_User_Data)
class Fl_Widget(object):
    r"""

    Fl_Widget is the base class for all widgets in FLTK. You can't create one of 
    these because the constructor is not public. However you can subclass it.

    All 'property' accessing methods, such as color(), parent(), or argument() 
    are implemented as trivial inline functions and thus are as fast and small 
    as accessing fields in a structure. Unless otherwise noted, the property 
    setting methods such as color(n) or label(s) are also trivial inline 
    functions, even if they change the widget's appearance. It is up to the user 
    code to call redraw() after these. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Widget self, int x, int y, int w, int h, char const * label=None) -> Fl_Widget"""
        if self.__class__ == Fl_Widget:
            _self = None
        else:
            _self = self
        _fltk.Fl_Widget_swiginit(self, _fltk.new_Fl_Widget(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Widget")
        #print("Adding type: ", Fl_Widget)



    __swig_destroy__ = _fltk.delete_Fl_Widget

    def draw(self, *args):
        r"""draw(Fl_Widget self)"""
        return _fltk.Fl_Widget_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Widget self, int event) -> int"""
        return _fltk.Fl_Widget_handle(self, *args)

    def is_label_copied(self, *args):
        r"""is_label_copied(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_is_label_copied(self, *args)

    def needs_keyboard(self, *args):
        r"""
        needs_keyboard(Fl_Widget self, bool needs)
        needs_keyboard(Fl_Widget self) -> bool
        """
        return _fltk.Fl_Widget_needs_keyboard(self, *args)

    def parent(self, *args):
        r"""
        parent(Fl_Widget self) -> Fl_Group
        parent(Fl_Widget self, Fl_Group p)
        """
        return _fltk.Fl_Widget_parent(self, *args)

    def type(self, *args):
        r"""
        type(Fl_Widget self) -> uchar
        type(Fl_Widget self, uchar t)
        """
        return _fltk.Fl_Widget_type(self, *args)

    def x(self, *args):
        r"""x(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_x(self, *args)

    def y(self, *args):
        r"""y(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_y(self, *args)

    def w(self, *args):
        r"""w(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_w(self, *args)

    def h(self, *args):
        r"""h(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_h(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Widget self, int x, int y, int w, int h)"""
        return _fltk.Fl_Widget_resize(self, *args)

    def damage_resize(self, *args):
        r"""damage_resize(Fl_Widget self, int arg2, int arg3, int arg4, int arg5) -> int"""
        return _fltk.Fl_Widget_damage_resize(self, *args)

    def position(self, *args):
        r"""position(Fl_Widget self, int X, int Y)"""
        return _fltk.Fl_Widget_position(self, *args)

    def size(self, *args):
        r"""size(Fl_Widget self, int W, int H)"""
        return _fltk.Fl_Widget_size(self, *args)

    def align(self, *args):
        r"""
        align(Fl_Widget self) -> Fl_Align
        align(Fl_Widget self, Fl_Align alignment)
        """
        return _fltk.Fl_Widget_align(self, *args)

    def box(self, *args):
        r"""
        box(Fl_Widget self) -> Fl_Boxtype
        box(Fl_Widget self, Fl_Boxtype new_box)
        """
        return _fltk.Fl_Widget_box(self, *args)

    def selection_color(self, *args):
        r"""
        selection_color(Fl_Widget self) -> Fl_Color
        selection_color(Fl_Widget self, Fl_Color a)
        """
        return _fltk.Fl_Widget_selection_color(self, *args)

    def color(self, *args):
        r"""
        color(Fl_Widget self) -> Fl_Color
        color(Fl_Widget self, Fl_Color bg)
        color(Fl_Widget self, Fl_Color bg, Fl_Color sel)
        """
        return _fltk.Fl_Widget_color(self, *args)

    def copy_label(self, *args):
        r"""copy_label(Fl_Widget self, char const * new_label)"""
        return _fltk.Fl_Widget_copy_label(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Widget self) -> char const
        label(Fl_Widget self, char const * text)
        label(Fl_Widget self, Fl_Labeltype a, char const * b)
        """
        val = _fltk.Fl_Widget_label(self, *args)

        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val


    def labeltype(self, *args):
        r"""
        labeltype(Fl_Widget self) -> Fl_Labeltype
        labeltype(Fl_Widget self, Fl_Labeltype a)
        """
        return _fltk.Fl_Widget_labeltype(self, *args)

    def labelcolor(self, *args):
        r"""
        labelcolor(Fl_Widget self) -> Fl_Color
        labelcolor(Fl_Widget self, Fl_Color c)
        """
        return _fltk.Fl_Widget_labelcolor(self, *args)

    def labelfont(self, *args):
        r"""
        labelfont(Fl_Widget self) -> Fl_Font
        labelfont(Fl_Widget self, Fl_Font f)
        """
        return _fltk.Fl_Widget_labelfont(self, *args)

    def labelsize(self, *args):
        r"""
        labelsize(Fl_Widget self) -> Fl_Fontsize
        labelsize(Fl_Widget self, Fl_Fontsize pix)
        """
        return _fltk.Fl_Widget_labelsize(self, *args)

    def image(self, *args):
        r"""
        image(Fl_Widget self) -> Fl_Image
        image(Fl_Widget self) -> Fl_Image
        image(Fl_Widget self, Fl_Image img)
        """
        val = _fltk.Fl_Widget_image(self, *args)

        if len(args) > 0:
        #delegate ownership to C++
            self.my_image = args[0]


        return val


    def bind_image(self, *args):
        r"""
        bind_image(Fl_Widget self, Fl_Image img)
        bind_image(Fl_Widget self, int f)
        """
        return _fltk.Fl_Widget_bind_image(self, *args)

    def image_bound(self, *args):
        r"""image_bound(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_image_bound(self, *args)

    def deimage(self, *args):
        r"""
        deimage(Fl_Widget self) -> Fl_Image
        deimage(Fl_Widget self) -> Fl_Image
        deimage(Fl_Widget self, Fl_Image img)
        """
        val = _fltk.Fl_Widget_deimage(self, *args)

        if len(args) > 0:
        #delegate ownership to C++
            self.my_deimage = args[0]


        return val


    def deimage_bound(self, *args):
        r"""deimage_bound(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_deimage_bound(self, *args)

    def bind_deimage(self, *args):
        r"""
        bind_deimage(Fl_Widget self, Fl_Image img)
        bind_deimage(Fl_Widget self, int f)
        """
        return _fltk.Fl_Widget_bind_deimage(self, *args)

    def label_image_spacing(self, *args):
        r"""
        label_image_spacing(Fl_Widget self, int gap)
        label_image_spacing(Fl_Widget self) -> int
        """
        return _fltk.Fl_Widget_label_image_spacing(self, *args)

    def horizontal_label_margin(self, *args):
        r"""
        horizontal_label_margin(Fl_Widget self, int px)
        horizontal_label_margin(Fl_Widget self) -> int
        """
        return _fltk.Fl_Widget_horizontal_label_margin(self, *args)

    def vertical_label_margin(self, *args):
        r"""
        vertical_label_margin(Fl_Widget self, int px)
        vertical_label_margin(Fl_Widget self) -> int
        """
        return _fltk.Fl_Widget_vertical_label_margin(self, *args)

    def tooltip(self, *args):
        r"""
        tooltip(Fl_Widget self) -> char const
        tooltip(Fl_Widget self, char const * text)
        """
        return _fltk.Fl_Widget_tooltip(self, *args)

    def copy_tooltip(self, *args):
        r"""copy_tooltip(Fl_Widget self, char const * text)"""
        return _fltk.Fl_Widget_copy_tooltip(self, *args)

    def argument(self, *args):
        r"""
        argument(Fl_Widget self) -> long
        argument(Fl_Widget self, long v)
        """
        return _fltk.Fl_Widget_argument(self, *args)

    def when(self, *args):
        r"""
        when(Fl_Widget self) -> Fl_When
        when(Fl_Widget self, uchar i)
        """
        return _fltk.Fl_Widget_when(self, *args)

    def visible(self, *args):
        r"""visible(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_visible(self, *args)

    def visible_r(self, *args):
        r"""visible_r(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_visible_r(self, *args)

    def show(self, *args):
        r"""show(Fl_Widget self)"""
        return _fltk.Fl_Widget_show(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Widget self)"""
        return _fltk.Fl_Widget_hide(self, *args)

    def set_visible(self, *args):
        r"""set_visible(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_visible(self, *args)

    def clear_visible(self, *args):
        r"""clear_visible(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_visible(self, *args)

    def active(self, *args):
        r"""active(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_active(self, *args)

    def active_r(self, *args):
        r"""active_r(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_active_r(self, *args)

    def activate(self, *args):
        r"""activate(Fl_Widget self)"""
        return _fltk.Fl_Widget_activate(self, *args)

    def deactivate(self, *args):
        r"""deactivate(Fl_Widget self)"""
        return _fltk.Fl_Widget_deactivate(self, *args)

    def output(self, *args):
        r"""output(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_output(self, *args)

    def set_output(self, *args):
        r"""set_output(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_output(self, *args)

    def clear_output(self, *args):
        r"""clear_output(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_output(self, *args)

    def takesevents(self, *args):
        r"""takesevents(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_takesevents(self, *args)

    def changed(self, *args):
        r"""changed(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_changed(self, *args)

    def set_changed(self, *args):
        r"""set_changed(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_changed(self, *args)

    def clear_changed(self, *args):
        r"""clear_changed(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_changed(self, *args)

    def clear_active(self, *args):
        r"""clear_active(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_active(self, *args)

    def set_active(self, *args):
        r"""set_active(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_active(self, *args)

    def take_focus(self, *args):
        r"""take_focus(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_take_focus(self, *args)

    def set_visible_focus(self, *args):
        r"""set_visible_focus(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_visible_focus(self, *args)

    def clear_visible_focus(self, *args):
        r"""clear_visible_focus(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_visible_focus(self, *args)

    def visible_focus(self, *args):
        r"""
        visible_focus(Fl_Widget self, int v)
        visible_focus(Fl_Widget self) -> unsigned int
        """
        return _fltk.Fl_Widget_visible_focus(self, *args)

    @staticmethod
    def default_callback(*args):
        r"""default_callback(Fl_Widget widget, void * data)"""
        return _fltk.Fl_Widget_default_callback(*args)

    def do_callback(self, *args):
        r"""
        do_callback(Fl_Widget self, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        do_callback(Fl_Widget self, Fl_Widget widget, long arg, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        do_callback(Fl_Widget self, Fl_Widget widget, void * arg=None, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        """
        return _fltk.Fl_Widget_do_callback(self, *args)

    @staticmethod
    def label_shortcut(*args):
        r"""label_shortcut(char const * t) -> unsigned int"""
        return _fltk.Fl_Widget_label_shortcut(*args)

    @staticmethod
    def test_shortcut(*args):
        r"""
        test_shortcut() -> int
        test_shortcut(char const * arg1, bool const require_alt=False) -> int
        """
        return _fltk.Fl_Widget_test_shortcut(*args)

    def _set_fullscreen(self, *args):
        r"""_set_fullscreen(Fl_Widget self)"""
        return _fltk.Fl_Widget__set_fullscreen(self, *args)

    def _clear_fullscreen(self, *args):
        r"""_clear_fullscreen(Fl_Widget self)"""
        return _fltk.Fl_Widget__clear_fullscreen(self, *args)

    def contains(self, *args):
        r"""contains(Fl_Widget self, Fl_Widget w) -> int"""
        return _fltk.Fl_Widget_contains(self, *args)

    def inside(self, *args):
        r"""inside(Fl_Widget self, Fl_Widget wgt) -> int"""
        return _fltk.Fl_Widget_inside(self, *args)

    def redraw(self, *args):
        r"""redraw(Fl_Widget self)"""
        return _fltk.Fl_Widget_redraw(self, *args)

    def redraw_label(self, *args):
        r"""redraw_label(Fl_Widget self)"""
        return _fltk.Fl_Widget_redraw_label(self, *args)

    def clear_damage(self, *args):
        r"""clear_damage(Fl_Widget self, uchar c=0)"""
        return _fltk.Fl_Widget_clear_damage(self, *args)

    def damage(self, *args):
        r"""
        damage(Fl_Widget self) -> uchar
        damage(Fl_Widget self, uchar c)
        damage(Fl_Widget self, uchar c, int x, int y, int w, int h)
        """
        return _fltk.Fl_Widget_damage(self, *args)

    def measure_label(self, *args):
        r"""measure_label(Fl_Widget self, int & ww, int & hh)"""
        return _fltk.Fl_Widget_measure_label(self, *args)

    def window(self, *args):
        r"""window(Fl_Widget self) -> Fl_Window"""
        return _fltk.Fl_Widget_window(self, *args)

    def top_window(self, *args):
        r"""top_window(Fl_Widget self) -> Fl_Window"""
        return _fltk.Fl_Widget_top_window(self, *args)

    def top_window_offset(self, *args):
        r"""top_window_offset(Fl_Widget self, int & xoff, int & yoff) -> Fl_Window"""
        return _fltk.Fl_Widget_top_window_offset(self, *args)

    def as_group(self, *args):
        r"""
        as_group(Fl_Widget self) -> Fl_Group
        as_group(Fl_Widget self) -> Fl_Group
        """
        return _fltk.Fl_Widget_as_group(self, *args)

    def as_window(self, *args):
        r"""
        as_window(Fl_Widget self) -> Fl_Window
        as_window(Fl_Widget self) -> Fl_Window
        """
        return _fltk.Fl_Widget_as_window(self, *args)

    def as_gl_window(self, *args):
        r"""
        as_gl_window(Fl_Widget self) -> Fl_Gl_Window
        as_gl_window(Fl_Widget self) -> Fl_Gl_Window
        """
        return _fltk.Fl_Widget_as_gl_window(self, *args)

    def as_vk_window(self, *args):
        r"""
        as_vk_window(Fl_Widget self) -> Fl_Vk_Window
        as_vk_window(Fl_Widget self) -> Fl_Vk_Window const *
        """
        return _fltk.Fl_Widget_as_vk_window(self, *args)

    def use_accents_menu(self, *args):
        r"""use_accents_menu(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_use_accents_menu(self, *args)

    def shortcut_label(self, *args):
        r"""
        shortcut_label(Fl_Widget self, int value)
        shortcut_label(Fl_Widget self) -> int
        """
        return _fltk.Fl_Widget_shortcut_label(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Widget self, char * Fl_Widget)"""
        return _fltk.Fl_Widget_init_type(self, *args)

    def draw_label(self, *args):
        r"""
        draw_label(Fl_Widget self, int arg2, int arg3, int arg4, int arg5, Fl_Align arg6)
        draw_label(Fl_Widget self)
        """
        return _fltk.Fl_Widget_draw_label(self, *args)

    def draw_backdrop(self, *args):
        r"""draw_backdrop(Fl_Widget self)"""
        return _fltk.Fl_Widget_draw_backdrop(self, *args)

    def callback(self, *args):
        r"""
        callback(Fl_Widget self) -> Fl_Callback_p
        callback(Fl_Widget self, Fl_Callback * cb, void * p)
        callback(Fl_Widget self, Fl_Callback * cb, Fl_Callback_User_Data p, bool auto_free)
        callback(Fl_Widget self, Fl_Callback * cb)
        callback(Fl_Widget self, Fl_Callback0 * cb)
        callback(Fl_Widget self, Fl_Callback1 * cb, long p=0)
        callback(Fl_Widget self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyData=None)
        """
        return _fltk.Fl_Widget_callback(self, *args)

    def user_data(self, *args):
        r"""
        user_data(Fl_Widget self, Fl_Callback_User_Data v, bool auto_free)
        user_data(Fl_Widget self, PyObject * PyData)
        user_data(Fl_Widget self) -> PyObject *
        """
        return _fltk.Fl_Widget_user_data(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Widget(self)
        return weakref.proxy(self)

# Register Fl_Widget in _fltk:
_fltk.Fl_Widget_swigregister(Fl_Widget)
FL_RESERVED_TYPE = _fltk.FL_RESERVED_TYPE

class Fl_Widget_Surface(object):
    r"""


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def translate(self, *args):
        r"""translate(Fl_Widget_Surface self, int x, int y)"""
        return _fltk.Fl_Widget_Surface_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_Widget_Surface self)"""
        return _fltk.Fl_Widget_Surface_untranslate(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Widget_Surface self, Fl_Widget widget, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Widget_Surface_draw(self, *args)

    def draw_decorated_window(self, *args):
        r"""draw_decorated_window(Fl_Widget_Surface self, Fl_Window win, int x_offset=0, int y_offset=0)"""
        return _fltk.Fl_Widget_Surface_draw_decorated_window(self, *args)

    def print_window_part(self, *args):
        r"""print_window_part(Fl_Widget_Surface self, Fl_Window win, int x, int y, int w, int h, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Widget_Surface_print_window_part(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_Widget_Surface self, int * w, int * h) -> int"""
        return _fltk.Fl_Widget_Surface_printable_rect(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_Widget_Surface self, int x, int y)
        origin(Fl_Widget_Surface self, int * x, int * y)
        """
        return _fltk.Fl_Widget_Surface_origin(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Widget_Surface

# Register Fl_Widget_Surface in _fltk:
_fltk.Fl_Widget_Surface_swigregister(Fl_Widget_Surface)
class Fl_Group(Fl_Widget):
    r"""

    The Fl_Group class is the FLTK container widget. It maintains an array of 
    child widgets. These children can themselves be any widget including Fl_Group. 
    The most important subclass of Fl_Group  is Fl_Window, however groups can 
    also be used to control radio buttons or to enforce resize behavior.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Group self)"""
        return _fltk.Fl_Group_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Group self, int arg0) -> int"""
        return _fltk.Fl_Group_handle(self, *args)

    def begin(self, *args):
        r"""begin(Fl_Group self)"""
        return _fltk.Fl_Group_begin(self, *args)

    def end(self, *args):
        r"""end(Fl_Group self)"""
        return _fltk.Fl_Group_end(self, *args)

    @staticmethod
    def current(*args):
        r"""
        current() -> Fl_Group
        current(Fl_Group g)
        """
        return _fltk.Fl_Group_current(*args)

    def children(self, *args):
        r"""children(Fl_Group self) -> int"""
        return _fltk.Fl_Group_children(self, *args)

    def child(self, *args):
        r"""child(Fl_Group self, int n) -> Fl_Widget"""
        return _fltk.Fl_Group_child(self, *args)

    def find(self, *args):
        r"""find(Fl_Group self, Fl_Widget o) -> int"""
        return _fltk.Fl_Group_find(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Group self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Group_resize(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Group self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Group"""
        if self.__class__ == Fl_Group:
            _self = None
        else:
            _self = self
        _fltk.Fl_Group_swiginit(self, _fltk.new_Fl_Group(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Group")
        #print("Adding type: ", Fl_Group)



    __swig_destroy__ = _fltk.delete_Fl_Group

    def add(self, *args):
        r"""add(Fl_Group self, Fl_Widget o)"""
        val = _fltk.Fl_Group_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args):
        r"""insert(Fl_Group self, Fl_Widget arg2, int i)"""
        return _fltk.Fl_Group_insert(self, *args)

    def insert_before(self, *args):
        r"""insert_before(Fl_Group self, Fl_Widget o, Fl_Widget before)"""
        return _fltk.Fl_Group_insert_before(self, *args)

    def remove(self, *args):
        r"""
        remove(Fl_Group self, int index)
        remove(Fl_Group self, Fl_Widget o)
        """
        val = _fltk.Fl_Group_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args):
        r"""clear(Fl_Group self)"""
        return _fltk.Fl_Group_clear(self, *args)

    def delete_child(self, *args):
        r"""delete_child(Fl_Group self, int n) -> int"""
        return _fltk.Fl_Group_delete_child(self, *args)

    def resizable(self, *args):
        r"""
        resizable(Fl_Group self, Fl_Widget o)
        resizable(Fl_Group self) -> Fl_Widget
        """
        return _fltk.Fl_Group_resizable(self, *args)

    def add_resizable(self, *args):
        r"""add_resizable(Fl_Group self, Fl_Widget o)"""
        return _fltk.Fl_Group_add_resizable(self, *args)

    def init_sizes(self, *args):
        r"""init_sizes(Fl_Group self)"""
        return _fltk.Fl_Group_init_sizes(self, *args)

    def clip_children(self, *args):
        r"""
        clip_children(Fl_Group self, int c)
        clip_children(Fl_Group self) -> unsigned int
        """
        return _fltk.Fl_Group_clip_children(self, *args)

    def as_group(self, *args):
        r"""
        as_group(Fl_Group self) -> Fl_Group
        as_group(Fl_Group self) -> Fl_Group
        """
        return _fltk.Fl_Group_as_group(self, *args)

    def _ddfdesign_kludge(self, *args):
        r"""_ddfdesign_kludge(Fl_Group self) -> Fl_Widget *&"""
        return _fltk.Fl_Group__ddfdesign_kludge(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Group self, char * Fl_Group)"""
        return _fltk.Fl_Group_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Group(self)
        return weakref.proxy(self)

# Register Fl_Group in _fltk:
_fltk.Fl_Group_swigregister(Fl_Group)
class Fl_End(object):
    r"""Proxy of C++ Fl_End class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_End self) -> Fl_End"""
        _fltk.Fl_End_swiginit(self, _fltk.new_Fl_End(*args))
    __swig_destroy__ = _fltk.delete_Fl_End

# Register Fl_End in _fltk:
_fltk.Fl_End_swigregister(Fl_End)
FL_NORMAL_BROWSER = _fltk.FL_NORMAL_BROWSER

FL_SELECT_BROWSER = _fltk.FL_SELECT_BROWSER

FL_HOLD_BROWSER = _fltk.FL_HOLD_BROWSER

FL_MULTI_BROWSER = _fltk.FL_MULTI_BROWSER

FL_SORT_ASCENDING = _fltk.FL_SORT_ASCENDING

FL_SORT_DESCENDING = _fltk.FL_SORT_DESCENDING

FL_SORT_CASEINSENSITIVE = _fltk.FL_SORT_CASEINSENSITIVE

class Fl_Browser_(Fl_Group):
    r"""

    This is the base class for browsers. To be useful it must be subclassed 
    and several virtual functions defined. The Forms-compatible browser and 
    the file chooser's browser are subclassed off of this.

    This has been designed so that the subclass has complete control over 
    the storage of the data, although because next() and prev() functions 
    are used to index, it works best as a linked list or as a large block 
    of characters in which the line breaks must be searched for.

    A great deal of work has been done so that the 'height' of a data object 
    does not need to be determined until it is drawn. This is useful if 
    actually figuring out the size of an object requires accessing image 
    data or doing stat() on a file or doing some other slow operation. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def item_first(self, *args):
        r"""item_first(Fl_Browser_ self) -> void *"""
        return _fltk.Fl_Browser__item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Browser_ self, void * item) -> void *"""
        return _fltk.Fl_Browser__item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Browser_ self, void * item) -> void *"""
        return _fltk.Fl_Browser__item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Browser_ self) -> void *"""
        return _fltk.Fl_Browser__item_last(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_width(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_quick_height(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Browser_ self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser__item_draw(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Browser_ self, void * item) -> char const *"""
        return _fltk.Fl_Browser__item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_Browser_ self, void * a, void * b)"""
        return _fltk.Fl_Browser__item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Browser_ self, int index) -> void *"""
        return _fltk.Fl_Browser__item_at(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__incr_height(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Browser_ self, void * item, int val=1)"""
        return _fltk.Fl_Browser__item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_selected(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Browser_ self, int X, int Y, int W, int H, char const * L=None) -> Fl_Browser_"""
        if self.__class__ == Fl_Browser_:
            _self = None
        else:
            _self = self
        _fltk.Fl_Browser__swiginit(self, _fltk.new_Fl_Browser_(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Browser_")
        #print("Adding type: ", Fl_Browser_)




    def handle(self, *args):
        r"""handle(Fl_Browser_ self, int event) -> int"""
        return _fltk.Fl_Browser__handle(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Browser_ self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser__resize(self, *args)

    def select(self, *args):
        r"""select(Fl_Browser_ self, void * item, int val=1, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__select(self, *args)

    def select_only(self, *args):
        r"""select_only(Fl_Browser_ self, void * item, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__select_only(self, *args)

    def deselect(self, *args):
        r"""deselect(Fl_Browser_ self, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__deselect(self, *args)

    def vposition(self, *args):
        r"""
        vposition(Fl_Browser_ self) -> int
        vposition(Fl_Browser_ self, int pos)
        """
        return _fltk.Fl_Browser__vposition(self, *args)

    def hposition(self, *args):
        r"""
        hposition(Fl_Browser_ self) -> int
        hposition(Fl_Browser_ self, int arg2)
        """
        return _fltk.Fl_Browser__hposition(self, *args)

    def display(self, *args):
        r"""display(Fl_Browser_ self, void * item)"""
        return _fltk.Fl_Browser__display(self, *args)
    HORIZONTAL = _fltk.Fl_Browser__HORIZONTAL
    
    VERTICAL = _fltk.Fl_Browser__VERTICAL
    
    BOTH = _fltk.Fl_Browser__BOTH
    
    ALWAYS_ON = _fltk.Fl_Browser__ALWAYS_ON
    
    HORIZONTAL_ALWAYS = _fltk.Fl_Browser__HORIZONTAL_ALWAYS
    
    VERTICAL_ALWAYS = _fltk.Fl_Browser__VERTICAL_ALWAYS
    
    BOTH_ALWAYS = _fltk.Fl_Browser__BOTH_ALWAYS
    

    def has_scrollbar(self, *args):
        r"""
        has_scrollbar(Fl_Browser_ self) -> uchar
        has_scrollbar(Fl_Browser_ self, uchar mode)
        """
        return _fltk.Fl_Browser__has_scrollbar(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Browser_ self) -> Fl_Font
        textfont(Fl_Browser_ self, Fl_Font font)
        """
        return _fltk.Fl_Browser__textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Browser_ self) -> Fl_Fontsize
        textsize(Fl_Browser_ self, Fl_Fontsize newSize)
        """
        return _fltk.Fl_Browser__textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Browser_ self) -> Fl_Color
        textcolor(Fl_Browser_ self, Fl_Color col)
        """
        return _fltk.Fl_Browser__textcolor(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Browser_ self) -> int
        scrollbar_size(Fl_Browser_ self, int newSize)
        """
        return _fltk.Fl_Browser__scrollbar_size(self, *args)

    def scrollbar_width(self, *args):
        r"""
        scrollbar_width(Fl_Browser_ self) -> int
        scrollbar_width(Fl_Browser_ self, int width)
        """
        return _fltk.Fl_Browser__scrollbar_width(self, *args)

    def scrollbar_right(self, *args):
        r"""scrollbar_right(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__scrollbar_right(self, *args)

    def scrollbar_left(self, *args):
        r"""scrollbar_left(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__scrollbar_left(self, *args)

    def sort(self, *args):
        r"""sort(Fl_Browser_ self, int flags=0)"""
        return _fltk.Fl_Browser__sort(self, *args)

    def linespacing(self, *args):
        r"""
        linespacing(Fl_Browser_ self, int pixels)
        linespacing(Fl_Browser_ self) -> int
        """
        return _fltk.Fl_Browser__linespacing(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Browser_ self, char * Fl_Browser_)"""
        return _fltk.Fl_Browser__init_type(self, *args)

    def getScrollbar(self, *args):
        r"""getScrollbar(Fl_Browser_ self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getScrollbar(self, *args)

    def getHScrollbar(self, *args):
        r"""getHScrollbar(Fl_Browser_ self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getHScrollbar(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Browser_
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser_(self)
        return weakref.proxy(self)

# Register Fl_Browser_ in _fltk:
_fltk.Fl_Browser__swigregister(Fl_Browser_)
class Fl_Browser(Fl_Browser_):
    r"""

    The Fl_Browser widget displays a scrolling list of text lines, and manages 
    all the storage for the text. This is not a text editor or spreadsheet! But 
    it is useful for showing a vertical list of named objects to the user.

    Each line in the browser is identified by number. The numbers start at one 
    (this is so that zero can be reserved for 'no line' in the selective browsers).
    Unless otherwise noted, the methods do not check to see if the passed line 
    number is in range and legal. It must always be greater than zero 
    and <= size().

    Each line contains a null-terminated string of text and a data pointer. 
    The text string is displayed, the  pointer can be used by the callbacks 
    to reference the object the text describes.

    The base class does nothing when the user clicks on it. The subclasses 
    Fl_Select_Browser, Fl_Hold_Browser, and Fl_Multi_Browser react to user 
    clicks to select lines in the browser and do callbacks.

    The base class called Fl_Browser_ provides the scrolling and selection 
    mechanisms of this and all the subclasses, but the dimensions and appearance 
    of each item are determined by the subclass. You can use Fl_Browser_ to 
    display information other than text, or text that is dynamically produced 
    from your own data structures. If you find that loading the browser is a 
    lot of work or is inefficient, you may want to make a subclass of Fl_Browser_. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def item_first(self, *args):
        r"""item_first(Fl_Browser self) -> void *"""
        return _fltk.Fl_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Browser self, void * item) -> void *"""
        return _fltk.Fl_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Browser self, void * item) -> void *"""
        return _fltk.Fl_Browser_item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Browser self) -> void *"""
        return _fltk.Fl_Browser_item_last(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_selected(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Browser self, void * item, int val)"""
        return _fltk.Fl_Browser_item_select(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_width(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser_item_draw(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_incr_height(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Browser_item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_Browser self, void * a, void * b)"""
        return _fltk.Fl_Browser_item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Browser self, int line) -> void *"""
        return _fltk.Fl_Browser_item_at(self, *args)

    def remove(self, *args):
        r"""remove(Fl_Browser self, int line)"""
        val = _fltk.Fl_Browser_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def move(self, *args):
        r"""move(Fl_Browser self, int to, int _from)"""
        return _fltk.Fl_Browser_move(self, *args)

    def load(self, *args):
        r"""load(Fl_Browser self, char const * filename) -> int"""
        return _fltk.Fl_Browser_load(self, *args)

    def swap(self, *args):
        r"""swap(Fl_Browser self, int a, int b)"""
        return _fltk.Fl_Browser_swap(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Browser self)"""
        return _fltk.Fl_Browser_clear(self, *args)

    def size(self, *args):
        r"""
        size(Fl_Browser self) -> int
        size(Fl_Browser self, int W, int H)
        """
        return _fltk.Fl_Browser_size(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Browser self) -> Fl_Fontsize
        textsize(Fl_Browser self, Fl_Fontsize newSize)
        """
        return _fltk.Fl_Browser_textsize(self, *args)
    TOP = _fltk.Fl_Browser_TOP
    
    BOTTOM = _fltk.Fl_Browser_BOTTOM
    
    MIDDLE = _fltk.Fl_Browser_MIDDLE
    

    def lineposition(self, *args):
        r"""lineposition(Fl_Browser self, int line, Fl_Browser::Fl_Line_Position pos)"""
        return _fltk.Fl_Browser_lineposition(self, *args)

    def topline(self, *args):
        r"""
        topline(Fl_Browser self) -> int
        topline(Fl_Browser self, int line)
        """
        return _fltk.Fl_Browser_topline(self, *args)

    def bottomline(self, *args):
        r"""bottomline(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_bottomline(self, *args)

    def middleline(self, *args):
        r"""middleline(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_middleline(self, *args)

    def select(self, *args):
        r"""select(Fl_Browser self, int line, int val=1) -> int"""
        return _fltk.Fl_Browser_select(self, *args)

    def selected(self, *args):
        r"""selected(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_selected(self, *args)

    def show(self, *args):
        r"""
        show(Fl_Browser self, int line)
        show(Fl_Browser self)
        """
        return _fltk.Fl_Browser_show(self, *args)

    def hide(self, *args):
        r"""
        hide(Fl_Browser self, int line)
        hide(Fl_Browser self)
        """
        return _fltk.Fl_Browser_hide(self, *args)

    def visible(self, *args):
        r"""visible(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_visible(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Browser self) -> int
        value(Fl_Browser self, int line)
        """
        return _fltk.Fl_Browser_value(self, *args)

    def text(self, *args):
        r"""
        text(Fl_Browser self, int line) -> char const
        text(Fl_Browser self, int line, char const * newtext)
        """
        return _fltk.Fl_Browser_text(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Browser"""
        if self.__class__ == Fl_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Browser_swiginit(self, _fltk.new_Fl_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Browser")
        #print("Adding type: ", Fl_Browser)



    __swig_destroy__ = _fltk.delete_Fl_Browser

    def format_char(self, *args):
        r"""
        format_char(Fl_Browser self) -> char
        format_char(Fl_Browser self, char c)
        """
        return _fltk.Fl_Browser_format_char(self, *args)

    def column_char(self, *args):
        r"""
        column_char(Fl_Browser self) -> char
        column_char(Fl_Browser self, char c)
        """
        return _fltk.Fl_Browser_column_char(self, *args)

    def displayed(self, *args):
        r"""displayed(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_displayed(self, *args)

    def make_visible(self, *args):
        r"""make_visible(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_make_visible(self, *args)

    def icon(self, *args):
        r"""
        icon(Fl_Browser self, int line, Fl_Image icon)
        icon(Fl_Browser self, int line) -> Fl_Image
        """
        return _fltk.Fl_Browser_icon(self, *args)

    def remove_icon(self, *args):
        r"""remove_icon(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_remove_icon(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Browser self, int a, char const * b)"""
        return _fltk.Fl_Browser_replace(self, *args)

    def display(self, *args):
        r"""display(Fl_Browser self, int line, int val=1)"""
        return _fltk.Fl_Browser_display(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Browser self, char * Fl_Browser)"""
        return _fltk.Fl_Browser_init_type(self, *args)

    def add(self, *args):
        r"""add(Fl_Browser self, char const * text, PyObject * data=None)"""
        val = _fltk.Fl_Browser_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args):
        r"""insert(Fl_Browser self, int index, char const * text, PyObject * data=None)"""
        return _fltk.Fl_Browser_insert(self, *args)

    def get_data(self, *args):
        r"""get_data(Fl_Browser self, int index) -> PyObject *"""
        return _fltk.Fl_Browser_get_data(self, *args)

    def data(self, *args):
        r"""data(Fl_Browser self, int index, PyObject * data=None) -> PyObject *"""
        return _fltk.Fl_Browser_data(self, *args)

    def column_widths(self, *args):
        r"""
        column_widths(Fl_Browser self) -> int const
        column_widths(Fl_Browser self, PyObject * widths)
        """
        return _fltk.Fl_Browser_column_widths(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Browser self)"""
        return _fltk.Fl_Browser_draw(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_quick_height(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_full_width(self, *args)

# Register Fl_Browser in _fltk:
_fltk.Fl_Browser_swigregister(Fl_Browser)
class Fl_File_Browser(Fl_Browser):
    r"""

    The Fl_File_Browser widget displays a list of filenames, optionally with 
    file-specific icons.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    FILES = _fltk.Fl_File_Browser_FILES
    
    DIRECTORIES = _fltk.Fl_File_Browser_DIRECTORIES
    

    def __init__(self, *args):
        r"""__init__(Fl_File_Browser self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_File_Browser"""
        if self.__class__ == Fl_File_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_File_Browser_swiginit(self, _fltk.new_Fl_File_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_File_Browser")
        #print("Adding type: ", Fl_File_Browser)



    __swig_destroy__ = _fltk.delete_Fl_File_Browser

    def iconsize(self, *args):
        r"""
        iconsize(Fl_File_Browser self) -> uchar
        iconsize(Fl_File_Browser self, uchar s)
        """
        return _fltk.Fl_File_Browser_iconsize(self, *args)

    def filter(self, *args):
        r"""
        filter(Fl_File_Browser self, char const * pattern)
        filter(Fl_File_Browser self) -> char const *
        """
        return _fltk.Fl_File_Browser_filter(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_File_Browser self) -> Fl_Fontsize
        textsize(Fl_File_Browser self, Fl_Fontsize s)
        """
        return _fltk.Fl_File_Browser_textsize(self, *args)

    def filetype(self, *args):
        r"""
        filetype(Fl_File_Browser self) -> int
        filetype(Fl_File_Browser self, int t)
        """
        return _fltk.Fl_File_Browser_filetype(self, *args)

    def errmsg(self, *args):
        r"""
        errmsg(Fl_File_Browser self, char const * emsg)
        errmsg(Fl_File_Browser self) -> char const *
        """
        return _fltk.Fl_File_Browser_errmsg(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_File_Browser self, char * Fl_File_Browser)"""
        return _fltk.Fl_File_Browser_init_type(self, *args)

    def load(self, *args):
        r"""load(Fl_File_Browser self, PyObject * dObj, PyObject * sObj) -> int"""
        return _fltk.Fl_File_Browser_load(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_File_Browser self)"""
        return _fltk.Fl_File_Browser_draw(self, *args)

    def item_first(self, *args):
        r"""item_first(Fl_File_Browser self) -> void *"""
        return _fltk.Fl_File_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_File_Browser self, void * item) -> void *"""
        return _fltk.Fl_File_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_File_Browser self, void * item) -> void *"""
        return _fltk.Fl_File_Browser_item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_File_Browser self) -> void *"""
        return _fltk.Fl_File_Browser_item_last(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_File_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_File_Browser_item_draw(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_File_Browser self, void * item) -> char const *"""
        return _fltk.Fl_File_Browser_item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_File_Browser self, void * a, void * b)"""
        return _fltk.Fl_File_Browser_item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_File_Browser self, int line) -> void *"""
        return _fltk.Fl_File_Browser_item_at(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_incr_height(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_File_Browser self, void * item, int val)"""
        return _fltk.Fl_File_Browser_item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_selected(self, *args)

# Register Fl_File_Browser in _fltk:
_fltk.Fl_File_Browser_swigregister(Fl_File_Browser)
FL_ALPHASORT = _fltk.FL_ALPHASORT

FL_CASEALPHASORT = _fltk.FL_CASEALPHASORT

FL_CASENUMERICSORT = _fltk.FL_CASENUMERICSORT

FL_NUMERICSORT = _fltk.FL_NUMERICSORT

class Fl_File_Icon(object):
    r"""

    The Fl_File_Icon class manages icon images that can be used as labels in 
    other widgets and as icons in the FileBrowser widget.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ANY = _fltk.Fl_File_Icon_ANY
    
    PLAIN = _fltk.Fl_File_Icon_PLAIN
    
    FIFO = _fltk.Fl_File_Icon_FIFO
    
    DEVICE = _fltk.Fl_File_Icon_DEVICE
    
    LINK = _fltk.Fl_File_Icon_LINK
    
    DIRECTORY = _fltk.Fl_File_Icon_DIRECTORY
    
    END = _fltk.Fl_File_Icon_END
    
    COLOR = _fltk.Fl_File_Icon_COLOR
    
    LINE = _fltk.Fl_File_Icon_LINE
    
    CLOSEDLINE = _fltk.Fl_File_Icon_CLOSEDLINE
    
    POLYGON = _fltk.Fl_File_Icon_POLYGON
    
    OUTLINEPOLYGON = _fltk.Fl_File_Icon_OUTLINEPOLYGON
    
    VERTEX = _fltk.Fl_File_Icon_VERTEX
    

    def __init__(self, *args):
        r"""__init__(Fl_File_Icon self, char const * p, int t, int nd=0, short * d=None) -> Fl_File_Icon"""
        _fltk.Fl_File_Icon_swiginit(self, _fltk.new_Fl_File_Icon(*args))
    __swig_destroy__ = _fltk.delete_Fl_File_Icon

    def add(self, *args):
        r"""add(Fl_File_Icon self, short d) -> short *"""
        return _fltk.Fl_File_Icon_add(self, *args)

    def add_color(self, *args):
        r"""add_color(Fl_File_Icon self, Fl_Color c) -> short *"""
        return _fltk.Fl_File_Icon_add_color(self, *args)

    def add_vertex(self, *args):
        r"""
        add_vertex(Fl_File_Icon self, int x, int y) -> short
        add_vertex(Fl_File_Icon self, float x, float y) -> short *
        """
        return _fltk.Fl_File_Icon_add_vertex(self, *args)

    def clear(self, *args):
        r"""clear(Fl_File_Icon self)"""
        return _fltk.Fl_File_Icon_clear(self, *args)

    def draw(self, *args):
        r"""draw(Fl_File_Icon self, int x, int y, int w, int h, Fl_Color ic, int active=1)"""
        return _fltk.Fl_File_Icon_draw(self, *args)

    def label(self, *args):
        r"""label(Fl_File_Icon self, Fl_Widget w)"""
        return _fltk.Fl_File_Icon_label(self, *args)

    @staticmethod
    def labeltype(*args):
        r"""labeltype(Fl_Label o, int x, int y, int w, int h, Fl_Align a)"""
        return _fltk.Fl_File_Icon_labeltype(*args)

    def load(self, *args):
        r"""load(Fl_File_Icon self, char const * f)"""
        return _fltk.Fl_File_Icon_load(self, *args)

    def load_fti(self, *args):
        r"""load_fti(Fl_File_Icon self, char const * fti) -> int"""
        return _fltk.Fl_File_Icon_load_fti(self, *args)

    def load_image(self, *args):
        r"""load_image(Fl_File_Icon self, char const * i) -> int"""
        return _fltk.Fl_File_Icon_load_image(self, *args)

    def next(self, *args):
        r"""next(Fl_File_Icon self) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_next(self, *args)

    def pattern(self, *args):
        r"""pattern(Fl_File_Icon self) -> char const *"""
        return _fltk.Fl_File_Icon_pattern(self, *args)

    def size(self, *args):
        r"""size(Fl_File_Icon self) -> int"""
        return _fltk.Fl_File_Icon_size(self, *args)

    def type(self, *args):
        r"""type(Fl_File_Icon self) -> int"""
        return _fltk.Fl_File_Icon_type(self, *args)

    def value(self, *args):
        r"""value(Fl_File_Icon self) -> short *"""
        return _fltk.Fl_File_Icon_value(self, *args)

    @staticmethod
    def find(*args):
        r"""find(char const * filename, int filetype=ANY) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_find(*args)

    @staticmethod
    def first(*args):
        r"""first() -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_first(*args)

    @staticmethod
    def load_system_icons(*args):
        r"""load_system_icons()"""
        return _fltk.Fl_File_Icon_load_system_icons(*args)

# Register Fl_File_Icon in _fltk:
_fltk.Fl_File_Icon_swigregister(Fl_File_Icon)
class Fl_File_Chooser(object):
    r"""

    The Fl_File_Chooser widget displays a standard file selection dialog that 
    supports various selection modes.

    The Fl_File_Chooser class also exports several static values that may be used 
    to localize or customize the appearance of all file chooser dialogs:
    Member 	Default value
    add_favorites_label 	'Add to Favorites'
    all_files_label 	'All Files (*)'
    custom_filter_label 	'Custom Filter'
    existing_file_label 	'Please choose an existing file!'
    favorites_label 	'Favorites'
    filename_label 		'Filename:'
    filesystems_label 	'My Computer' (WIN32)
    			'File Systems' (all others)
    manage_favorites_label 	'Manage Favorites'
    new_directory_label 	'New Directory?'
    new_directory_tooltip 	'Create a new directory.'
    preview_label 		'Preview'
    save_label 		'Save'
    show_label 		'Show:'
    sort 			fl_numericsort

    The sort member specifies the sort function that is used when loading the 
    contents of a directory. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SINGLE = _fltk.Fl_File_Chooser_SINGLE
    
    MULTI = _fltk.Fl_File_Chooser_MULTI
    
    CREATE = _fltk.Fl_File_Chooser_CREATE
    
    DIRECTORY = _fltk.Fl_File_Chooser_DIRECTORY
    

    def __init__(self, *args):
        r"""__init__(Fl_File_Chooser self, char const * pathname, char const * pattern, int type_val, char const * title) -> Fl_File_Chooser"""
        _fltk.Fl_File_Chooser_swiginit(self, _fltk.new_Fl_File_Chooser(*args))
    __swig_destroy__ = _fltk.delete_Fl_File_Chooser

    def color(self, *args):
        r"""
        color(Fl_File_Chooser self, Fl_Color c)
        color(Fl_File_Chooser self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_color(self, *args)

    def count(self, *args):
        r"""count(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_count(self, *args)

    def directory(self, *args):
        r"""
        directory(Fl_File_Chooser self, char const * d)
        directory(Fl_File_Chooser self) -> char *
        """
        return _fltk.Fl_File_Chooser_directory(self, *args)

    def filter(self, *args):
        r"""
        filter(Fl_File_Chooser self, char const * p)
        filter(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_filter(self, *args)

    def filter_value(self, *args):
        r"""
        filter_value(Fl_File_Chooser self) -> int
        filter_value(Fl_File_Chooser self, int f)
        """
        return _fltk.Fl_File_Chooser_filter_value(self, *args)

    def iconsize(self, *args):
        r"""
        iconsize(Fl_File_Chooser self, uchar s)
        iconsize(Fl_File_Chooser self) -> uchar
        """
        return _fltk.Fl_File_Chooser_iconsize(self, *args)

    def label(self, *args):
        r"""
        label(Fl_File_Chooser self, char const * l)
        label(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_label(self, *args)

    def ok_label(self, *args):
        r"""
        ok_label(Fl_File_Chooser self, char const * l)
        ok_label(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_ok_label(self, *args)

    def preview(self, *args):
        r"""
        preview(Fl_File_Chooser self, int e)
        preview(Fl_File_Chooser self) -> int
        """
        return _fltk.Fl_File_Chooser_preview(self, *args)

    def rescan(self, *args):
        r"""rescan(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_rescan(self, *args)

    def show(self, *args):
        r"""show(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_show(self, *args)

    def hide(self, *args):
        r"""hide(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_hide(self, *args)

    def shown(self, *args):
        r"""shown(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_shown(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_File_Chooser self, Fl_Color c)
        textcolor(Fl_File_Chooser self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_textcolor(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_File_Chooser self, Fl_Font f)
        textfont(Fl_File_Chooser self) -> Fl_Font
        """
        return _fltk.Fl_File_Chooser_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_File_Chooser self, Fl_Fontsize s)
        textsize(Fl_File_Chooser self) -> Fl_Fontsize
        """
        return _fltk.Fl_File_Chooser_textsize(self, *args)

    def type(self, *args):
        r"""
        type(Fl_File_Chooser self, int t)
        type(Fl_File_Chooser self) -> int
        """
        return _fltk.Fl_File_Chooser_type(self, *args)

    def value(self, *args):
        r"""
        value(Fl_File_Chooser self, int f=1) -> char const
        value(Fl_File_Chooser self, char const * filename)
        """
        return _fltk.Fl_File_Chooser_value(self, *args)

    def visible(self, *args):
        r"""visible(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_visible(self, *args)

    def position(self, *args):
        r"""position(Fl_File_Chooser self, int x, int y)"""
        return _fltk.Fl_File_Chooser_position(self, *args)

    def x(self, *args):
        r"""x(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_x(self, *args)

    def y(self, *args):
        r"""y(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_y(self, *args)

    def w(self, *args):
        r"""w(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_w(self, *args)

    def h(self, *args):
        r"""h(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_h(self, *args)

    def size(self, *args):
        r"""size(Fl_File_Chooser self, int w, int h)"""
        return _fltk.Fl_File_Chooser_size(self, *args)

    def resize(self, *args):
        r"""resize(Fl_File_Chooser self, int x, int y, int w, int h)"""
        return _fltk.Fl_File_Chooser_resize(self, *args)

    def add_extra(self, *args):
        r"""add_extra(Fl_File_Chooser self, Fl_Widget gr) -> Fl_Widget"""
        return _fltk.Fl_File_Chooser_add_extra(self, *args)

    def callback(self, *args):
        r"""
        callback(Fl_File_Chooser self, void (*)(Fl_File_Chooser *,void *) cb, void * d=None)
        callback(Fl_File_Chooser self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyData=None)
        """
        return _fltk.Fl_File_Chooser_callback(self, *args)

    def user_data(self, *args):
        r"""
        user_data(Fl_File_Chooser self, PyObject * PyData)
        user_data(Fl_File_Chooser self) -> PyObject *
        """
        return _fltk.Fl_File_Chooser_user_data(self, *args)

# Register Fl_File_Chooser in _fltk:
_fltk.Fl_File_Chooser_swigregister(Fl_File_Chooser)

def fl_dir_chooser(*args):
    r"""fl_dir_chooser(char const * message, char const * fname, int relative=0) -> char *"""
    return _fltk.fl_dir_chooser(*args)

def fl_file_chooser(*args):
    r"""fl_file_chooser(char const * message, char const * pat, char const * fname, int relative=0) -> char *"""
    return _fltk.fl_file_chooser(*args)

def fl_file_chooser_callback(*args):
    r"""fl_file_chooser_callback(void (*)(char const *) cb)"""
    return _fltk.fl_file_chooser_callback(*args)

def fl_file_chooser_ok_label(*args):
    r"""fl_file_chooser_ok_label(char const * l)"""
    return _fltk.fl_file_chooser_ok_label(*args)

def screen_driver(*args):
    r"""screen_driver() -> Fl_Screen_Driver *"""
    return _fltk.screen_driver(*args)

def system_driver(*args):
    r"""system_driver() -> Fl_System_Driver *"""
    return _fltk.system_driver(*args)

def box_shadow_width(*args):
    r"""
    box_shadow_width() -> int
    box_shadow_width(int W)
    """
    return _fltk.box_shadow_width(*args)

def box_border_radius_max(*args):
    r"""
    box_border_radius_max() -> int
    box_border_radius_max(int R)
    """
    return _fltk.box_border_radius_max(*args)

def call_screen_init(*args):
    r"""call_screen_init()"""
    return _fltk.call_screen_init(*args)

def idle(*args):
    r"""idle() -> bool"""
    return _fltk.idle(*args)

def version(*args):
    r"""version() -> double"""
    return _fltk.version(*args)

def api_version(*args):
    r"""api_version() -> int"""
    return _fltk.api_version(*args)

def abi_version(*args):
    r"""abi_version() -> int"""
    return _fltk.abi_version(*args)

def abi_check(*args):
    r"""abi_check(int const val=FL_ABI_VERSION) -> int"""
    return _fltk.abi_check(*args)

def arg(*args):
    r"""arg(int argc, char ** argv, int & i) -> int"""
    return _fltk.arg(*args)

def args(*args):
    r"""
    args(int argc, char ** argv, int & i, Fl_Args_Handler cb=0) -> int
    args(int argc, char ** argv)
    """
    return _fltk.args(*args)

def display(*args):
    r"""display(char const * arg1)"""
    return _fltk.display(*args)

def visual(*args):
    r"""visual(int arg1) -> int"""
    return _fltk.visual(*args)

def own_colormap(*args):
    r"""own_colormap()"""
    return _fltk.own_colormap(*args)

def get_system_colors(*args):
    r"""get_system_colors()"""
    return _fltk.get_system_colors(*args)

def foreground(*args):
    r"""foreground(uchar arg1, uchar arg2, uchar arg3)"""
    return _fltk.foreground(*args)

def background(*args):
    r"""background(uchar arg1, uchar arg2, uchar arg3)"""
    return _fltk.background(*args)

def background2(*args):
    r"""background2(uchar arg1, uchar arg2, uchar arg3)"""
    return _fltk.background2(*args)

def scheme(*args):
    r"""
    scheme(char const * name) -> int
    scheme() -> char const *
    """
    return _fltk.scheme(*args)

def is_scheme(*args):
    r"""is_scheme(char const * name) -> int"""
    return _fltk.is_scheme(*args)

def reload_scheme(*args):
    r"""reload_scheme() -> int"""
    return _fltk.reload_scheme(*args)

def scrollbar_size(*args):
    r"""
    scrollbar_size() -> int
    scrollbar_size(int W)
    """
    return _fltk.scrollbar_size(*args)

def menu_linespacing(*args):
    r"""
    menu_linespacing() -> int
    menu_linespacing(int H)
    """
    return _fltk.menu_linespacing(*args)

def wait(*args):
    r"""
    wait() -> int
    wait(double time) -> double
    """
    return _fltk.wait(*args)

def check(*args):
    r"""check() -> int"""
    return _fltk.check(*args)

def ready(*args):
    r"""ready() -> int"""
    return _fltk.ready(*args)

def run(*args):
    r"""run() -> int"""
    return _fltk.run(*args)

def program_should_quit(*args):
    r"""
    program_should_quit() -> int
    program_should_quit(int should_i)
    """
    return _fltk.program_should_quit(*args)

def hide_all_windows(*args):
    r"""hide_all_windows()"""
    return _fltk.hide_all_windows(*args)

def readqueue(*args):
    r"""readqueue() -> Fl_Widget"""
    return _fltk.readqueue(*args)

def has_timeout(*args):
    r"""has_timeout(Fl_Timeout_Handler cb, void * data=None) -> int"""
    return _fltk.has_timeout(*args)

def remove_next_timeout(*args):
    r"""remove_next_timeout(Fl_Timeout_Handler cb, void * data=None, void ** data_return=None) -> int"""
    return _fltk.remove_next_timeout(*args)
class TimeoutData(object):
    r"""Proxy of C++ Fl::TimeoutData class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(TimeoutData self) -> TimeoutData"""
        _fltk.TimeoutData_swiginit(self, _fltk.new_TimeoutData(*args))
    __swig_destroy__ = _fltk.delete_TimeoutData

# Register TimeoutData in _fltk:
_fltk.TimeoutData_swigregister(TimeoutData)

def timeout_list(*args):
    r"""timeout_list() -> std::vector< Fl::TimeoutData >"""
    return _fltk.timeout_list(*args)

def now(*args):
    r"""now(double offset=0) -> Fl_Timestamp"""
    return _fltk.now(*args)

def seconds_since(*args):
    r"""seconds_since(Fl_Timestamp & then) -> double"""
    return _fltk.seconds_since(*args)

def seconds_between(*args):
    r"""seconds_between(Fl_Timestamp & back, Fl_Timestamp & further_back) -> double"""
    return _fltk.seconds_between(*args)

def ticks_since(*args):
    r"""ticks_since(Fl_Timestamp & then) -> long"""
    return _fltk.ticks_since(*args)

def ticks_between(*args):
    r"""ticks_between(Fl_Timestamp & back, Fl_Timestamp & further_back) -> long"""
    return _fltk.ticks_between(*args)

def has_idle(*args):
    r"""has_idle(Fl_Idle_Handler cb, void * data=None) -> int"""
    return _fltk.has_idle(*args)

def remove_idle(*args):
    r"""remove_idle(Fl_Idle_Handler cb, void * data=None)"""
    return _fltk.remove_idle(*args)

def add_idle(*args):
    r"""
    add_idle(Fl_Idle_Handler cb, void * data=None)
    add_idle(Fl_Old_Idle_Handler cb)
    """
    return _fltk.add_idle(*args)

def damage(*args):
    r"""
    damage(int d)
    damage() -> int
    """
    return _fltk.damage(*args)

def redraw(*args):
    r"""redraw()"""
    return _fltk.redraw(*args)

def flush(*args):
    r"""flush()"""
    return _fltk.flush(*args)

def first_window(*args):
    r"""
    first_window() -> Fl_Window
    first_window(Fl_Window arg1)
    """
    return _fltk.first_window(*args)

def next_window(*args):
    r"""next_window(Fl_Window arg1) -> Fl_Window"""
    return _fltk.next_window(*args)

def modal(*args):
    r"""modal() -> Fl_Window"""
    return _fltk.modal(*args)

def grab(*args):
    r"""
    grab() -> Fl_Window
    grab(Fl_Window arg1)
    """
    return _fltk.grab(*args)

def copy(*args):
    r"""copy(char const * stuff, int len, int destination=0, char const * type=Fl::clipboard_plain_text)"""
    return _fltk.copy(*args)

def selection_to_clipboard(*args):
    r"""
    selection_to_clipboard(int mode)
    selection_to_clipboard() -> int
    """
    return _fltk.selection_to_clipboard(*args)

def add_clipboard_notify(*args):
    r"""add_clipboard_notify(Fl_Clipboard_Notify_Handler h, void * data=None)"""
    return _fltk.add_clipboard_notify(*args)

def remove_clipboard_notify(*args):
    r"""remove_clipboard_notify(Fl_Clipboard_Notify_Handler h)"""
    return _fltk.remove_clipboard_notify(*args)

def clipboard_contains(*args):
    r"""clipboard_contains(char const * type) -> int"""
    return _fltk.clipboard_contains(*args)

def dnd(*args):
    r"""dnd() -> int"""
    return _fltk.dnd(*args)

def selection_owner(*args):
    r"""
    selection_owner() -> Fl_Widget
    selection_owner(Fl_Widget arg1)
    """
    return _fltk.selection_owner(*args)

def selection(*args):
    r"""selection(Fl_Widget owner, char const * arg2, int len)"""
    return _fltk.selection(*args)

def paste(*args):
    r"""
    paste(Fl_Widget receiver, int source, char const * type=Fl::clipboard_plain_text)
    paste(Fl_Widget receiver)
    """
    return _fltk.paste(*args)

def x(*args):
    r"""x() -> int"""
    return _fltk.x(*args)

def y(*args):
    r"""y() -> int"""
    return _fltk.y(*args)

def w(*args):
    r"""w() -> int"""
    return _fltk.w(*args)

def h(*args):
    r"""h() -> int"""
    return _fltk.h(*args)

def screen_count(*args):
    r"""screen_count() -> int"""
    return _fltk.screen_count(*args)

def screen_xywh(*args):
    r"""
    screen_xywh()
    screen_xywh(int mx, int my)
    screen_xywh(int n)
    screen_xywh(int mx, int my, int mw, int mh)
    """
    return _fltk.screen_xywh(*args)

def screen_num(*args):
    r"""
    screen_num(int x, int y) -> int
    screen_num(int x, int y, int w, int h) -> int
    """
    return _fltk.screen_num(*args)

def screen_dpi(*args):
    r"""screen_dpi(float & h, float & v, int n=0)"""
    return _fltk.screen_dpi(*args)

def screen_work_area(*args):
    r"""
    screen_work_area(int mx, int my)
    screen_work_area(int n)
    screen_work_area()
    """
    return _fltk.screen_work_area(*args)

def screen_scale(*args):
    r"""
    screen_scale(int n) -> float
    screen_scale(int n, float factor)
    """
    return _fltk.screen_scale(*args)

def screen_scaling_supported(*args):
    r"""screen_scaling_supported() -> int"""
    return _fltk.screen_scaling_supported(*args)

def keyboard_screen_scaling(*args):
    r"""keyboard_screen_scaling(int value)"""
    return _fltk.keyboard_screen_scaling(*args)

def set_color(*args):
    r"""
    set_color(Fl_Color arg1, uchar arg2, uchar arg3, uchar arg4)
    set_color(Fl_Color arg1, uchar arg2, uchar arg3, uchar arg4, uchar arg5)
    set_color(Fl_Color i, unsigned int c)
    """
    return _fltk.set_color(*args)

def get_color(*args):
    r"""
    get_color(Fl_Color i)
    get_color(Fl_Color i)
    """
    return _fltk.get_color(*args)

def free_color(*args):
    r"""free_color(Fl_Color i, int overlay=0)"""
    return _fltk.free_color(*args)

def get_font(*args):
    r"""get_font(Fl_Font arg1) -> char const *"""
    return _fltk.get_font(*args)

def get_font_name(*args):
    r"""get_font_name(Fl_Font arg1) -> char const *"""
    return _fltk.get_font_name(*args)

def set_font(*args):
    r"""
    set_font(Fl_Font arg1, char const * arg2)
    set_font(Fl_Font arg1, Fl_Font arg2)
    """
    return _fltk.set_font(*args)

def set_fonts(*args):
    r"""set_fonts(char const * arg1=None) -> Fl_Font"""
    return _fltk.set_fonts(*args)

def set_labeltype(*args):
    r"""set_labeltype(Fl_Labeltype arg1, Fl_Label_Draw_F * arg2, Fl_Label_Measure_F * arg3)"""
    return _fltk.set_labeltype(*args)

def get_boxtype(*args):
    r"""get_boxtype(Fl_Boxtype arg1) -> Fl_Box_Draw_F *"""
    return _fltk.get_boxtype(*args)

def set_boxtype(*args):
    r"""
    set_boxtype(Fl_Boxtype arg1, Fl_Box_Draw_F * arg2, uchar arg3, uchar arg4, uchar arg5, uchar arg6, Fl_Box_Draw_Focus_F * arg7=None)
    set_boxtype(Fl_Boxtype arg1, Fl_Boxtype _from)
    """
    return _fltk.set_boxtype(*args)

def box_dx(*args):
    r"""box_dx(Fl_Boxtype arg1) -> int"""
    return _fltk.box_dx(*args)

def box_dy(*args):
    r"""box_dy(Fl_Boxtype arg1) -> int"""
    return _fltk.box_dy(*args)

def box_dw(*args):
    r"""box_dw(Fl_Boxtype arg1) -> int"""
    return _fltk.box_dw(*args)

def box_dh(*args):
    r"""box_dh(Fl_Boxtype arg1) -> int"""
    return _fltk.box_dh(*args)

def draw_box_active(*args):
    r"""draw_box_active() -> int"""
    return _fltk.draw_box_active(*args)

def box_color(*args):
    r"""box_color(Fl_Color arg1) -> Fl_Color"""
    return _fltk.box_color(*args)

def set_box_color(*args):
    r"""set_box_color(Fl_Color arg1)"""
    return _fltk.set_box_color(*args)

def set_abort(*args):
    r"""set_abort(Fl_Abort_Handler f)"""
    return _fltk.set_abort(*args)

def default_atclose(*args):
    r"""default_atclose(Fl_Window arg1, void * arg2)"""
    return _fltk.default_atclose(*args)

def set_atclose(*args):
    r"""set_atclose(Fl_Atclose_Handler f)"""
    return _fltk.set_atclose(*args)

def use_high_res_VK(*args):
    r"""
    use_high_res_VK(int val)
    use_high_res_VK() -> int
    """
    return _fltk.use_high_res_VK(*args)

def lock(*args):
    r"""lock() -> int"""
    return _fltk.lock(*args)

def unlock(*args):
    r"""unlock()"""
    return _fltk.unlock(*args)

def awake(*args):
    r"""
    awake()
    awake(void * message)
    awake(Fl_Awake_Handler handler, void * user_data=None) -> int
    """
    return _fltk.awake(*args)

def awake_once(*args):
    r"""awake_once(Fl_Awake_Handler handler, void * user_data=None) -> int"""
    return _fltk.awake_once(*args)

def thread_message(*args):
    r"""thread_message() -> void *"""
    return _fltk.thread_message(*args)

def use_high_res_GL(*args):
    r"""
    use_high_res_GL(int val)
    use_high_res_GL() -> int
    """
    return _fltk.use_high_res_GL(*args)

def draw_GL_text_with_textures(*args):
    r"""
    draw_GL_text_with_textures(int val)
    draw_GL_text_with_textures() -> int
    """
    return _fltk.draw_GL_text_with_textures(*args)

def system(*args):
    r"""system(char const * command) -> int"""
    return _fltk.system(*args)

def args_to_utf8(*args):
    r"""args_to_utf8(int argc, char **& argv) -> int"""
    return _fltk.args_to_utf8(*args)

def pyFLTK_controlIdleCallbacks(*args):
    r"""pyFLTK_controlIdleCallbacks(int enable)"""
    return _fltk.pyFLTK_controlIdleCallbacks(*args)

def Fl_mt_run(window):
    import time
    while window.visible():
        time.sleep(0.1)
        Fl.check()

_fltk.mt_run = staticmethod(Fl_mt_run)

FL_PATH_MAX = _fltk.FL_PATH_MAX


def fl_filename_name(*args):
    r"""fl_filename_name(char const * filename) -> char const *"""
    return _fltk.fl_filename_name(*args)

def fl_filename_ext(*args):
    r"""fl_filename_ext(char const * buf) -> char const *"""
    return _fltk.fl_filename_ext(*args)

def fl_filename_match(*args):
    r"""fl_filename_match(char const * name, char const * pattern) -> int"""
    return _fltk.fl_filename_match(*args)

def fl_filename_isdir(*args):
    r"""fl_filename_isdir(char const * name) -> int"""
    return _fltk.fl_filename_isdir(*args)

def fl_filename_name_str(*args):
    r"""fl_filename_name_str(std::string const & filename) -> std::string"""
    return _fltk.fl_filename_name_str(*args)

def fl_filename_path_str(*args):
    r"""fl_filename_path_str(std::string const & filename) -> std::string"""
    return _fltk.fl_filename_path_str(*args)

def fl_filename_ext_str(*args):
    r"""fl_filename_ext_str(std::string const & filename) -> std::string"""
    return _fltk.fl_filename_ext_str(*args)

def fl_filename_setext_str(*args):
    r"""fl_filename_setext_str(std::string const & filename, std::string const & new_extension) -> std::string"""
    return _fltk.fl_filename_setext_str(*args)

def fl_filename_expand_str(*args):
    r"""fl_filename_expand_str(std::string const & _from) -> std::string"""
    return _fltk.fl_filename_expand_str(*args)

def fl_filename_absolute_str(*args):
    r"""
    fl_filename_absolute_str(std::string const & _from) -> std::string
    fl_filename_absolute_str(std::string const & _from, std::string const & base) -> std::string
    """
    return _fltk.fl_filename_absolute_str(*args)

def fl_filename_relative_str(*args):
    r"""
    fl_filename_relative_str(std::string const & _from) -> std::string
    fl_filename_relative_str(std::string const & _from, std::string const & base) -> std::string
    """
    return _fltk.fl_filename_relative_str(*args)

def fl_getcwd_str(*args):
    r"""fl_getcwd_str() -> std::string"""
    return _fltk.fl_getcwd_str(*args)

def fl_filename_setext(*args):
    r"""
    fl_filename_setext(char * to, int tolen, char const * ext) -> char
    fl_filename_setext(char * to, char const * ext) -> char *
    """
    return _fltk.fl_filename_setext(*args)

def fl_filename_expand(*args):
    r"""
    fl_filename_expand(char * to, int tolen, char const * _from) -> int
    fl_filename_expand(char * to, char const * _from) -> int
    """
    return _fltk.fl_filename_expand(*args)

def fl_filename_absolute(*args):
    r"""
    fl_filename_absolute(char * to, int tolen, char const * _from) -> int
    fl_filename_absolute(char * to, int tolen, char const * _from, char const * cwd) -> int
    fl_filename_absolute(char * to, char const * _from) -> int
    """
    return _fltk.fl_filename_absolute(*args)

def fl_filename_relative(*args):
    r"""
    fl_filename_relative(char * to, int tolen, char const * _from) -> int
    fl_filename_relative(char * to, int tolen, char const * _from, char const * cwd) -> int
    fl_filename_relative(char * to, char const * _from) -> int
    """
    return _fltk.fl_filename_relative(*args)

def fl_filename_free_list(*args):
    r"""fl_filename_free_list(dirent *** l, int n)"""
    return _fltk.fl_filename_free_list(*args)

def fl_open_uri(*args):
    r"""fl_open_uri(char const * uri, char * msg=(char *) 0, int msglen=0) -> int"""
    return _fltk.fl_open_uri(*args)

def fl_decode_uri(*args):
    r"""fl_decode_uri(char * uri)"""
    return _fltk.fl_decode_uri(*args)
class Fl_Valuator(Fl_Widget):
    r"""

    The Fl_Valuator class controls a single floating-point value and provides 
    a consistent interface to set the value, range, and step, and insures that 
    callbacks are done the same for every object.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Valuator self, int X, int Y, int W, int H, char const * L) -> Fl_Valuator"""
        if self.__class__ == Fl_Valuator:
            _self = None
        else:
            _self = self
        _fltk.Fl_Valuator_swiginit(self, _fltk.new_Fl_Valuator(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Valuator")
        #print("Adding type: ", Fl_Valuator)



    __swig_destroy__ = _fltk.delete_Fl_Valuator

    def bounds(self, *args):
        r"""bounds(Fl_Valuator self, double a, double b)"""
        return _fltk.Fl_Valuator_bounds(self, *args)

    def minimum(self, *args):
        r"""
        minimum(Fl_Valuator self) -> double
        minimum(Fl_Valuator self, double a)
        """
        return _fltk.Fl_Valuator_minimum(self, *args)

    def maximum(self, *args):
        r"""
        maximum(Fl_Valuator self) -> double
        maximum(Fl_Valuator self, double a)
        """
        return _fltk.Fl_Valuator_maximum(self, *args)

    def range(self, *args):
        r"""range(Fl_Valuator self, double a, double b)"""
        return _fltk.Fl_Valuator_range(self, *args)

    def step(self, *args):
        r"""
        step(Fl_Valuator self, int a)
        step(Fl_Valuator self, double a, int b)
        step(Fl_Valuator self, double s)
        step(Fl_Valuator self) -> double
        """
        return _fltk.Fl_Valuator_step(self, *args)

    def precision(self, *args):
        r"""precision(Fl_Valuator self, int arg2)"""
        return _fltk.Fl_Valuator_precision(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Valuator self) -> double
        value(Fl_Valuator self, double arg2) -> int
        """
        return _fltk.Fl_Valuator_value(self, *args)

    def format(self, *args):
        r"""format(Fl_Valuator self, char * format_string) -> int"""
        return _fltk.Fl_Valuator_format(self, *args)

    def round(self, *args):
        r"""round(Fl_Valuator self, double arg2) -> double"""
        return _fltk.Fl_Valuator_round(self, *args)

    def clamp(self, *args):
        r"""clamp(Fl_Valuator self, double arg2) -> double"""
        return _fltk.Fl_Valuator_clamp(self, *args)

    def increment(self, *args):
        r"""increment(Fl_Valuator self, double arg2, int arg3) -> double"""
        return _fltk.Fl_Valuator_increment(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Valuator self, char * Fl_Valuator)"""
        return _fltk.Fl_Valuator_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Valuator(self)
        return weakref.proxy(self)

# Register Fl_Valuator in _fltk:
_fltk.Fl_Valuator_swigregister(Fl_Valuator)
pyFLTK_registerDoIdle = _fltk.pyFLTK_registerDoIdle
Fl_add_timeout = _fltk.Fl_add_timeout
Fl_repeat_timeout = _fltk.Fl_repeat_timeout
Fl_remove_timeout = _fltk.Fl_remove_timeout
Fl_add_fd = _fltk.Fl_add_fd
Fl_remove_fd = _fltk.Fl_remove_fd
Fl_add_handler = _fltk.Fl_add_handler
Fl_remove_handler = _fltk.Fl_remove_handler
Fl_add_check = _fltk.Fl_add_check
Fl_remove_check = _fltk.Fl_remove_check
Fl_get_font_sizes_tmp = _fltk.Fl_get_font_sizes_tmp


FL_VERTICAL=0
FL_HORIZONTAL=1

class Fl_Adjuster(Fl_Valuator):
    r"""

    The Fl_Adjuster widget has proven to be very useful for values that need a 
    was stolen from Prisms, and large dynamic range.
    When you press a button and drag to the right the value increases. When you 
    drag to the left it decreases. The largest button adjusts by 100 * step(), 
    the next by 10 * step() and that smallest button by step(). Clicking on the 
    buttons increments by 10 times the amount dragging by a pixel does. 
    Shift + click decrements by 10 times the amount. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Adjuster self)"""
        return _fltk.Fl_Adjuster_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Adjuster self, int arg0) -> int"""
        return _fltk.Fl_Adjuster_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Adjuster self, int X, int Y, int W, int H, char const * l=None) -> Fl_Adjuster"""
        if self.__class__ == Fl_Adjuster:
            _self = None
        else:
            _self = self
        _fltk.Fl_Adjuster_swiginit(self, _fltk.new_Fl_Adjuster(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Adjuster")
        #print("Adding type: ", Fl_Adjuster)




    def soft(self, *args):
        r"""
        soft(Fl_Adjuster self, int s)
        soft(Fl_Adjuster self) -> int
        """
        return _fltk.Fl_Adjuster_soft(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Adjuster self, char * Fl_Adjuster)"""
        return _fltk.Fl_Adjuster_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Adjuster
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Adjuster(self)
        return weakref.proxy(self)

# Register Fl_Adjuster in _fltk:
_fltk.Fl_Adjuster_swigregister(Fl_Adjuster)
FLTK_INCLUDE_FL_ASK = _fltk.FLTK_INCLUDE_FL_ASK

FL_BEEP_DEFAULT = _fltk.FL_BEEP_DEFAULT

FL_BEEP_MESSAGE = _fltk.FL_BEEP_MESSAGE

FL_BEEP_ERROR = _fltk.FL_BEEP_ERROR

FL_BEEP_QUESTION = _fltk.FL_BEEP_QUESTION

FL_BEEP_PASSWORD = _fltk.FL_BEEP_PASSWORD

FL_BEEP_NOTIFICATION = _fltk.FL_BEEP_NOTIFICATION


def fl_beep(*args):
    r"""fl_beep(int type=FL_BEEP_DEFAULT)"""
    return _fltk.fl_beep(*args)

def fl_message(*args):
    r"""fl_message(char const * arg1)"""
    return _fltk.fl_message(*args)

def fl_alert(*args):
    r"""fl_alert(char const * arg1)"""
    return _fltk.fl_alert(*args)

def fl_ask(*args):
    r"""fl_ask(char const * arg1) -> int"""
    return _fltk.fl_ask(*args)

def fl_choice(*args):
    r"""fl_choice(char const * q, char const * b0, char const * b1, char const * b2) -> int"""
    return _fltk.fl_choice(*args)

def fl_choice_n(*args):
    r"""fl_choice_n(char const * q, char const * b0, char const * b1, char const * b2) -> int"""
    return _fltk.fl_choice_n(*args)

def fl_message_icon(*args):
    r"""fl_message_icon() -> Fl_Widget"""
    return _fltk.fl_message_icon(*args)

def fl_message_font(*args):
    r"""fl_message_font(Fl_Font f, Fl_Fontsize s)"""
    return _fltk.fl_message_font(*args)

def fl_message_hotspot(*args):
    r"""
    fl_message_hotspot(int enable)
    fl_message_hotspot() -> int
    """
    return _fltk.fl_message_hotspot(*args)

def fl_message_position(*args):
    r"""
    fl_message_position(int const x, int const y, int const center=0)
    fl_message_position(Fl_Widget widget)
    fl_message_position(int * x=None, int * y=None) -> int
    fl_message_position(Fl_Widget widget)
    """
    return _fltk.fl_message_position(*args)

def fl_message_title(*args):
    r"""fl_message_title(char const * title)"""
    return _fltk.fl_message_title(*args)

def fl_message_title_default(*args):
    r"""fl_message_title_default(char const * title)"""
    return _fltk.fl_message_title_default(*args)

def fl_message_icon_label(*args):
    r"""fl_message_icon_label(char const * str)"""
    return _fltk.fl_message_icon_label(*args)

def fl_input(*args):
    r"""fl_input(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_input(*args)

def fl_password(*args):
    r"""fl_password(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_password(*args)

def fl_no_get(*args):
    r"""fl_no_get() -> char const *"""
    return _fltk.fl_no_get(*args)

def fl_yes_get(*args):
    r"""fl_yes_get() -> char const *"""
    return _fltk.fl_yes_get(*args)

def fl_ok_get(*args):
    r"""fl_ok_get() -> char const *"""
    return _fltk.fl_ok_get(*args)

def fl_cancel_get(*args):
    r"""fl_cancel_get() -> char const *"""
    return _fltk.fl_cancel_get(*args)

def fl_close_get(*args):
    r"""fl_close_get() -> char const *"""
    return _fltk.fl_close_get(*args)

def fl_no_set(*args):
    r"""fl_no_set(char const * value)"""
    return _fltk.fl_no_set(*args)

def fl_yes_set(*args):
    r"""fl_yes_set(char const * value)"""
    return _fltk.fl_yes_set(*args)

def fl_ok_set(*args):
    r"""fl_ok_set(char const * value)"""
    return _fltk.fl_ok_set(*args)

def fl_cancel_set(*args):
    r"""fl_cancel_set(char const * value)"""
    return _fltk.fl_cancel_set(*args)

def fl_close_set(*args):
    r"""fl_close_set(char const * value)"""
    return _fltk.fl_close_set(*args)

def fl_mt_message(*args):
    r"""fl_mt_message(char const * text)"""
    return _fltk.fl_mt_message(*args)

def fl_mt_alert(*args):
    r"""fl_mt_alert(char const * text)"""
    return _fltk.fl_mt_alert(*args)

def fl_mt_choice(*args):
    r"""fl_mt_choice(char const * q, char const * b0, char const * b1, char const * b2) -> int"""
    return _fltk.fl_mt_choice(*args)

def fl_mt_input(*args):
    r"""fl_mt_input(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_mt_input(*args)

def fl_mt_password(*args):
    r"""fl_mt_password(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_mt_password(*args)
class Fl_Bitmap(Fl_Image):
    r"""

    The Fl_Bitmap class supports caching and drawing of mono-color 
    (bitmap) images. Images are drawn using the current color.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_Bitmap self, uchar const * bits, int W, int H) -> Fl_Bitmap
        __init__(Fl_Bitmap self, uchar const * bits, int bits_length, int W, int H) -> Fl_Bitmap
        __init__(Fl_Bitmap self, char const * bits, int bits_length, int W, int H) -> Fl_Bitmap
        """
        if self.__class__ == Fl_Bitmap:
            _self = None
        else:
            _self = self
        _fltk.Fl_Bitmap_swiginit(self, _fltk.new_Fl_Bitmap(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Bitmap

    def copy(self, *args):
        r"""
        copy(Fl_Bitmap self, int W, int H) -> Fl_Image
        copy(Fl_Bitmap self) -> Fl_Image
        """
        return _fltk.Fl_Bitmap_copy(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_Bitmap self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Bitmap self, int X, int Y)
        """
        return _fltk.Fl_Bitmap_draw(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Bitmap self, Fl_Widget w)
        label(Fl_Bitmap self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Bitmap_label(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_Bitmap self)"""
        return _fltk.Fl_Bitmap_uncache(self, *args)

    def cache_w(self, *args):
        r"""cache_w(Fl_Bitmap self) -> int"""
        return _fltk.Fl_Bitmap_cache_w(self, *args)

    def cache_h(self, *args):
        r"""cache_h(Fl_Bitmap self) -> int"""
        return _fltk.Fl_Bitmap_cache_h(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Bitmap(self)
        return weakref.proxy(self)

# Register Fl_Bitmap in _fltk:
_fltk.Fl_Bitmap_swigregister(Fl_Bitmap)
class Fl_BMP_Image(Fl_RGB_Image):
    r"""

    The Fl_BMP_Image class supports loading, caching, and drawing of 
    Windows Bitmap (BMP) image files.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_BMP_Image self, char const * filename) -> Fl_BMP_Image
        __init__(Fl_BMP_Image self, char const * imagename, unsigned char const * data, long const length=-1) -> Fl_BMP_Image
        """
        if self.__class__ == Fl_BMP_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_BMP_Image_swiginit(self, _fltk.new_Fl_BMP_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_BMP_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_BMP_Image(self)
        return weakref.proxy(self)

# Register Fl_BMP_Image in _fltk:
_fltk.Fl_BMP_Image_swigregister(Fl_BMP_Image)
class Fl_Box(Fl_Widget):
    r"""

    This widget simply draws its box, and possibly it's label. 
    Putting it before some other widgets and making it big enough 
    to surround them will let you draw a frame around them.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Box self)"""
        return _fltk.Fl_Box_draw(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Box self, int X, int Y, int W, int H, char const * L=None) -> Fl_Box
        __init__(Fl_Box self, Fl_Boxtype B, int X, int Y, int W, int H, char const * L) -> Fl_Box
        """
        if self.__class__ == Fl_Box:
            _self = None
        else:
            _self = self
        _fltk.Fl_Box_swiginit(self, _fltk.new_Fl_Box(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Box")
        #print("Adding type: ", Fl_Box)




    def handle(self, *args):
        r"""handle(Fl_Box self, int arg0) -> int"""
        return _fltk.Fl_Box_handle(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Box self, char * Fl_Box)"""
        return _fltk.Fl_Box_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Box
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Box(self)
        return weakref.proxy(self)

# Register Fl_Box in _fltk:
_fltk.Fl_Box_swigregister(Fl_Box)
FL_NORMAL_BUTTON = _fltk.FL_NORMAL_BUTTON

FL_TOGGLE_BUTTON = _fltk.FL_TOGGLE_BUTTON

FL_RADIO_BUTTON = _fltk.FL_RADIO_BUTTON

FL_HIDDEN_BUTTON = _fltk.FL_HIDDEN_BUTTON

class Fl_Button(Fl_Widget):
    r"""

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type()  and when().

    Buttons can also generate callbacks in response to FL_SHORTCUT events. The 
    button can either have an explicit shortcut() value or a letter shortcut 
    can be indicated in the label() with an '&' character before it. For the 
    label shortcut it does not matter if Alt is held down, but if you have an 
    input field in the same window, the user will have to hold down the Alt key 
    so that the input field does not eat the event first as an FL_KEYBOARD event. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Button self)"""
        return _fltk.Fl_Button_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Button self, int arg0) -> int"""
        return _fltk.Fl_Button_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Button"""
        if self.__class__ == Fl_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Button_swiginit(self, _fltk.new_Fl_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Button")
        #print("Adding type: ", Fl_Button)




    def value(self, *args):
        r"""
        value(Fl_Button self, int v) -> int
        value(Fl_Button self) -> char
        """
        return _fltk.Fl_Button_value(self, *args)

    def set(self, *args):
        r"""set(Fl_Button self) -> int"""
        return _fltk.Fl_Button_set(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Button self) -> int"""
        return _fltk.Fl_Button_clear(self, *args)

    def setonly(self, *args):
        r"""setonly(Fl_Button self)"""
        return _fltk.Fl_Button_setonly(self, *args)

    def down_box(self, *args):
        r"""
        down_box(Fl_Button self) -> Fl_Boxtype
        down_box(Fl_Button self, Fl_Boxtype b)
        """
        return _fltk.Fl_Button_down_box(self, *args)

    def shortcut(self, *args):
        r"""
        shortcut(Fl_Button self) -> int
        shortcut(Fl_Button self, int s)
        shortcut(Fl_Button self, char const * s)
        """
        return _fltk.Fl_Button_shortcut(self, *args)

    def down_color(self, *args):
        r"""
        down_color(Fl_Button self) -> Fl_Color
        down_color(Fl_Button self, unsigned int c)
        """
        return _fltk.Fl_Button_down_color(self, *args)

    def compact(self, *args):
        r"""
        compact(Fl_Button self, uchar v)
        compact(Fl_Button self) -> uchar
        """
        return _fltk.Fl_Button_compact(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Button self, char * Fl_Button)"""
        return _fltk.Fl_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Button(self)
        return weakref.proxy(self)

# Register Fl_Button in _fltk:
_fltk.Fl_Button_swigregister(Fl_Button)
class Fl_Shortcut_Button(Fl_Button):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Shortcut_Button self, int arg0) -> int"""
        return _fltk.Fl_Shortcut_Button_handle(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Shortcut_Button self)"""
        return _fltk.Fl_Shortcut_Button_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Shortcut_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Shortcut_Button"""
        if self.__class__ == Fl_Shortcut_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Shortcut_Button_swiginit(self, _fltk.new_Fl_Shortcut_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Shortcut_Button")
        #print("Adding type: ", Fl_Shortcut_Button)




    def value(self, *args):
        r"""
        value(Fl_Shortcut_Button self, Fl_Shortcut shortcut)
        value(Fl_Shortcut_Button self) -> Fl_Shortcut
        """
        return _fltk.Fl_Shortcut_Button_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Shortcut_Button self, char * Fl_Shortcut_Button)"""
        return _fltk.Fl_Shortcut_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Shortcut_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Shortcut_Button(self)
        return weakref.proxy(self)

# Register Fl_Shortcut_Button in _fltk:
_fltk.Fl_Shortcut_Button_swigregister(Fl_Shortcut_Button)
FL_BAR_CHART = _fltk.FL_BAR_CHART

FL_HORBAR_CHART = _fltk.FL_HORBAR_CHART

FL_LINE_CHART = _fltk.FL_LINE_CHART

FL_FILL_CHART = _fltk.FL_FILL_CHART

FL_SPIKE_CHART = _fltk.FL_SPIKE_CHART

FL_PIE_CHART = _fltk.FL_PIE_CHART

FL_SPECIALPIE_CHART = _fltk.FL_SPECIALPIE_CHART

FL_FILLED_CHART = _fltk.FL_FILLED_CHART

FL_CHART_MAX = _fltk.FL_CHART_MAX

FL_CHART_LABEL_MAX = _fltk.FL_CHART_LABEL_MAX

class FL_CHART_ENTRY(object):
    r"""Proxy of C++ FL_CHART_ENTRY class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(FL_CHART_ENTRY self) -> FL_CHART_ENTRY"""
        _fltk.FL_CHART_ENTRY_swiginit(self, _fltk.new_FL_CHART_ENTRY(*args))
    __swig_destroy__ = _fltk.delete_FL_CHART_ENTRY

# Register FL_CHART_ENTRY in _fltk:
_fltk.FL_CHART_ENTRY_swigregister(FL_CHART_ENTRY)
class Fl_Chart(Fl_Widget):
    r"""

    This widget displays simple charts and is provided for Forms compatibility.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Chart self)"""
        return _fltk.Fl_Chart_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Chart self, int X, int Y, int W, int H, char const * L=None) -> Fl_Chart"""
        if self.__class__ == Fl_Chart:
            _self = None
        else:
            _self = self
        _fltk.Fl_Chart_swiginit(self, _fltk.new_Fl_Chart(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Chart")
        #print("Adding type: ", Fl_Chart)



    __swig_destroy__ = _fltk.delete_Fl_Chart

    def clear(self, *args):
        r"""clear(Fl_Chart self)"""
        return _fltk.Fl_Chart_clear(self, *args)

    def add(self, *args):
        r"""add(Fl_Chart self, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_add(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Chart self, int ind, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_insert(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Chart self, int ind, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_replace(self, *args)

    def bounds(self, *args):
        r"""
        bounds(Fl_Chart self, double * a, double * b)
        bounds(Fl_Chart self, double a, double b)
        """
        return _fltk.Fl_Chart_bounds(self, *args)

    def size(self, *args):
        r"""
        size(Fl_Chart self) -> int
        size(Fl_Chart self, int W, int H)
        """
        return _fltk.Fl_Chart_size(self, *args)

    def maxsize(self, *args):
        r"""
        maxsize(Fl_Chart self) -> int
        maxsize(Fl_Chart self, int m)
        """
        return _fltk.Fl_Chart_maxsize(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Chart self) -> Fl_Font
        textfont(Fl_Chart self, Fl_Font s)
        """
        return _fltk.Fl_Chart_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Chart self) -> Fl_Fontsize
        textsize(Fl_Chart self, Fl_Fontsize s)
        """
        return _fltk.Fl_Chart_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Chart self) -> Fl_Color
        textcolor(Fl_Chart self, Fl_Color n)
        """
        return _fltk.Fl_Chart_textcolor(self, *args)

    def autosize(self, *args):
        r"""
        autosize(Fl_Chart self) -> uchar
        autosize(Fl_Chart self, uchar n)
        """
        return _fltk.Fl_Chart_autosize(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Chart self, char * Fl_Chart)"""
        return _fltk.Fl_Chart_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Chart(self)
        return weakref.proxy(self)

# Register Fl_Chart in _fltk:
_fltk.Fl_Chart_swigregister(Fl_Chart)
class Fl_Check_Browser(Fl_Browser_):
    r"""

    The Fl_Check_Browser widget displays a scrolling list of text lines that may be selected and/or checked by the user.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def item_first(self, *args):
        r"""item_first(Fl_Check_Browser self) -> void *"""
        return _fltk.Fl_Check_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Check_Browser self, void * arg0) -> void *"""
        return _fltk.Fl_Check_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Check_Browser self, void * arg0) -> void *"""
        return _fltk.Fl_Check_Browser_item_prev(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Check_Browser self, void * arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Check_Browser self, void * arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_width(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Check_Browser self, void * arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Check_Browser_item_draw(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Check_Browser self, void * arg0, int arg1)"""
        return _fltk.Fl_Check_Browser_item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Check_Browser self, void * arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_selected(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Check_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Check_Browser_item_text(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Check_Browser self, int index) -> void *"""
        return _fltk.Fl_Check_Browser_item_at(self, *args)

    def item_swap(self, *args):
        r"""
        item_swap(Fl_Check_Browser self, int ia, int ib)
        item_swap(Fl_Check_Browser self, void * a, void * b)
        """
        return _fltk.Fl_Check_Browser_item_swap(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Check_Browser self, int x, int y, int w, int h, char const * l=None) -> Fl_Check_Browser"""
        if self.__class__ == Fl_Check_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Check_Browser_swiginit(self, _fltk.new_Fl_Check_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Check_Browser")
        #print("Adding type: ", Fl_Check_Browser)



    __swig_destroy__ = _fltk.delete_Fl_Check_Browser

    def remove(self, *args):
        r"""remove(Fl_Check_Browser self, int item) -> int"""
        val = _fltk.Fl_Check_Browser_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def add(self, *args):
        r"""
        add(Fl_Check_Browser self, char const * s) -> int
        add(Fl_Check_Browser self, char const * s, int b) -> int
        """
        val = _fltk.Fl_Check_Browser_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args):
        r"""clear(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_clear(self, *args)

    def nitems(self, *args):
        r"""nitems(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_nitems(self, *args)

    def nchecked(self, *args):
        r"""nchecked(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_nchecked(self, *args)

    def checked(self, *args):
        r"""
        checked(Fl_Check_Browser self, int item) -> int
        checked(Fl_Check_Browser self, int item, int b)
        """
        return _fltk.Fl_Check_Browser_checked(self, *args)

    def set_checked(self, *args):
        r"""set_checked(Fl_Check_Browser self, int item)"""
        return _fltk.Fl_Check_Browser_set_checked(self, *args)

    def check_all(self, *args):
        r"""check_all(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_check_all(self, *args)

    def check_none(self, *args):
        r"""check_none(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_check_none(self, *args)

    def value(self, *args):
        r"""value(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_value(self, *args)

    def text(self, *args):
        r"""text(Fl_Check_Browser self, int item) -> char *"""
        return _fltk.Fl_Check_Browser_text(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Check_Browser self, int arg0) -> int"""
        return _fltk.Fl_Check_Browser_handle(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Check_Browser self, char * Fl_Check_Browser)"""
        return _fltk.Fl_Check_Browser_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_draw(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Check_Browser self) -> void *"""
        return _fltk.Fl_Check_Browser_item_last(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Check_Browser self, void * item) -> int"""
        return _fltk.Fl_Check_Browser_item_quick_height(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_incr_height(self, *args)

# Register Fl_Check_Browser in _fltk:
_fltk.Fl_Check_Browser_swigregister(Fl_Check_Browser)
class Fl_Light_Button(Fl_Button):
    r"""

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Light_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_YELLOW.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Light_Button self)"""
        return _fltk.Fl_Light_Button_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Light_Button self, int arg0) -> int"""
        return _fltk.Fl_Light_Button_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Light_Button self, int x, int y, int w, int h, char const * l=None) -> Fl_Light_Button"""
        if self.__class__ == Fl_Light_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Light_Button_swiginit(self, _fltk.new_Fl_Light_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Light_Button")
        #print("Adding type: ", Fl_Light_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Light_Button self, char * Fl_Light_Button)"""
        return _fltk.Fl_Light_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Light_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Light_Button(self)
        return weakref.proxy(self)

# Register Fl_Light_Button in _fltk:
_fltk.Fl_Light_Button_swigregister(Fl_Light_Button)
class Fl_Check_Button(Fl_Light_Button):
    r"""

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Check_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set to 
    FL_DIAMOND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Check_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Check_Button"""
        if self.__class__ == Fl_Check_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Check_Button_swiginit(self, _fltk.new_Fl_Check_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Check_Button")
        #print("Adding type: ", Fl_Check_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Check_Button self, char * Fl_Check_Button)"""
        return _fltk.Fl_Check_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Check_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Check_Button self)"""
        return _fltk.Fl_Check_Button_draw(self, *args)

# Register Fl_Check_Button in _fltk:
_fltk.Fl_Check_Button_swigregister(Fl_Check_Button)
class Fl_Menu_(Fl_Widget):
    r"""

    All widgets that have a menu in FLTK are subclassed off of this class. 
    Currently FLTK provides you with Fl_Menu_Button, Fl_Menu_Bar, and Fl_Choice .

    The class contains a pointer to an array of structures of type Fl_Menu_Item. 
    The array may either be supplied directly by the user program, or it may be 
    'private': a dynamically allocated array managed by the Fl_Menu_. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Menu_ self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Menu_"""
        if self.__class__ == Fl_Menu_:
            _self = None
        else:
            _self = self
        _fltk.Fl_Menu__swiginit(self, _fltk.new_Fl_Menu_(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Menu_")
        #print("Adding type: ", Fl_Menu_)



    __swig_destroy__ = _fltk.delete_Fl_Menu_

    def item_pathname(self, *args):
        r"""item_pathname(Fl_Menu_ self, char * name, int namelen, Fl_Menu_Item finditem=None) -> int"""
        return _fltk.Fl_Menu__item_pathname(self, *args)

    def picked(self, *args):
        r"""picked(Fl_Menu_ self, Fl_Menu_Item arg2) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__picked(self, *args)

    def find_item(self, *args):
        r"""
        find_item(Fl_Menu_ self, char const * name) -> Fl_Menu_Item
        find_item(Fl_Menu_ self, Fl_Callback * arg2) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu__find_item(self, *args)

    def find_item_with_user_data(self, *args):
        r"""find_item_with_user_data(Fl_Menu_ self, void * arg2) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__find_item_with_user_data(self, *args)

    def find_item_with_argument(self, *args):
        r"""find_item_with_argument(Fl_Menu_ self, long arg2) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__find_item_with_argument(self, *args)

    def find_index(self, *args):
        r"""
        find_index(Fl_Menu_ self, char const * name) -> int
        find_index(Fl_Menu_ self, Fl_Menu_Item item) -> int
        find_index(Fl_Menu_ self, Fl_Callback * cb) -> int
        """
        return _fltk.Fl_Menu__find_index(self, *args)

    def test_shortcut(self, *args):
        r"""test_shortcut(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__test_shortcut(self, *args)

    def menu_end(self, *args):
        r"""menu_end(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__menu_end(self, *args)

    def insert(self, *args):
        r"""
        insert(Fl_Menu_ self, int index, char const * arg3, int shortcut, Fl_Callback * arg5, void * arg6=None, int arg7=0) -> int
        insert(Fl_Menu_ self, int index, char const * a, char const * b, Fl_Callback * c, void * d=None, int e=0) -> int
        """
        return _fltk.Fl_Menu__insert(self, *args)

    def size(self, *args):
        r"""
        size(Fl_Menu_ self) -> int
        size(Fl_Menu_ self, int W, int H)
        """
        return _fltk.Fl_Menu__size(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Menu_ self)"""
        return _fltk.Fl_Menu__clear(self, *args)

    def clear_submenu(self, *args):
        r"""clear_submenu(Fl_Menu_ self, int index) -> int"""
        return _fltk.Fl_Menu__clear_submenu(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Menu_ self, int arg2, char const * arg3)"""
        return _fltk.Fl_Menu__replace(self, *args)

    def remove(self, *args):
        r"""remove(Fl_Menu_ self, int arg2)"""
        return _fltk.Fl_Menu__remove(self, *args)

    def shortcut(self, *args):
        r"""shortcut(Fl_Menu_ self, int i, int s)"""
        return _fltk.Fl_Menu__shortcut(self, *args)

    def mode(self, *args):
        r"""
        mode(Fl_Menu_ self, int i, int fl)
        mode(Fl_Menu_ self, int i) -> int
        """
        return _fltk.Fl_Menu__mode(self, *args)

    def mvalue(self, *args):
        r"""mvalue(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__mvalue(self, *args)

    def prev_mvalue(self, *args):
        r"""prev_mvalue(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__prev_mvalue(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Menu_ self) -> int
        value(Fl_Menu_ self, int i) -> int
        """
        return _fltk.Fl_Menu__value(self, *args)

    def text(self, *args):
        r"""
        text(Fl_Menu_ self) -> char const
        text(Fl_Menu_ self, int i) -> char const *
        """
        return _fltk.Fl_Menu__text(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Menu_ self) -> Fl_Font
        textfont(Fl_Menu_ self, Fl_Font c)
        """
        return _fltk.Fl_Menu__textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Menu_ self) -> Fl_Fontsize
        textsize(Fl_Menu_ self, Fl_Fontsize c)
        """
        return _fltk.Fl_Menu__textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Menu_ self) -> Fl_Color
        textcolor(Fl_Menu_ self, Fl_Color c)
        """
        return _fltk.Fl_Menu__textcolor(self, *args)

    def down_box(self, *args):
        r"""
        down_box(Fl_Menu_ self) -> Fl_Boxtype
        down_box(Fl_Menu_ self, Fl_Boxtype b)
        """
        return _fltk.Fl_Menu__down_box(self, *args)

    def menu_box(self, *args):
        r"""
        menu_box(Fl_Menu_ self) -> Fl_Boxtype
        menu_box(Fl_Menu_ self, Fl_Boxtype b)
        """
        return _fltk.Fl_Menu__menu_box(self, *args)

    def down_color(self, *args):
        r"""
        down_color(Fl_Menu_ self) -> Fl_Color
        down_color(Fl_Menu_ self, unsigned int c)
        """
        return _fltk.Fl_Menu__down_color(self, *args)

    def setonly(self, *args):
        r"""setonly(Fl_Menu_ self, Fl_Menu_Item item)"""
        return _fltk.Fl_Menu__setonly(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Menu_ self, char * Fl_Menu_)"""
        return _fltk.Fl_Menu__init_type(self, *args)

    def copy(self, *args):
        r"""
        copy(Fl_Menu_ self, Fl_Menu_Item m, void * user_data=None)
        copy(Fl_Menu_ self, PyObject * args, PyObject * user_data=None)
        """
        return _fltk.Fl_Menu__copy(self, *args)

    def add(self, *args):
        r"""
        add(Fl_Menu_ self, char const * arg2, int shortcut, Fl_Callback * arg4, void * arg5=None, int arg6=0) -> int
        add(Fl_Menu_ self, char const * arg2) -> int
        add(Fl_Menu_ self, PyObject * lObj, PyObject * sObj, PyObject * cObj, PyObject * uObj=None, PyObject * fObj=None) -> int
        """
        return _fltk.Fl_Menu__add(self, *args)

    def menu(self, *args):
        r"""
        menu(Fl_Menu_ self) -> Fl_Menu_Item
        menu(Fl_Menu_ self, PyObject * args)
        menu(Fl_Menu_ self) -> PyObject *
        """
        return _fltk.Fl_Menu__menu(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_(self)
        return weakref.proxy(self)

# Register Fl_Menu_ in _fltk:
_fltk.Fl_Menu__swigregister(Fl_Menu_)
class Fl_Choice(Fl_Menu_):
    r"""

    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects. Motif calls this an OptionButton.

    The only difference between this and a Fl_Menu_Button is that the name of 
    the most recent chosen menu item is displayed inside the box, while the 
    label is displayed outside the box. However, since the use of this is most 
    often to control a single variable rather than do individual callbacks, some 
    of the Fl_Menu_Button methods are redescribed here in those terms.

    When the user picks an item off the menu the value() is set to that item and 
    then the item's callback is done with the menu_button as the Fl_Widget 
    argument. If the item does not have a callback the menu_button's callback is 
    done instead.

    All three mouse buttons pop up the menu. The Forms behavior of the first two 
    buttons to increment/decrement the choice is not implemented. This could be 
    added with a subclass, however.

    The menu will also pop up in response to shortcuts indicated by putting a '&' 
    character in the label(). See Fl_Button for a description of this.

    Typing the shortcut() of any of the items will do exactly the same as when 
    you pick the item with the mouse. The '&' character in item names are only 
    looked at when the menu is popped up, however. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Choice self)"""
        return _fltk.Fl_Choice_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Choice self, int arg0) -> int"""
        return _fltk.Fl_Choice_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Choice self, int X, int Y, int W, int H, char const * L=None) -> Fl_Choice"""
        if self.__class__ == Fl_Choice:
            _self = None
        else:
            _self = self
        _fltk.Fl_Choice_swiginit(self, _fltk.new_Fl_Choice(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Choice")
        #print("Adding type: ", Fl_Choice)




    def value(self, *args):
        r"""
        value(Fl_Choice self) -> int
        value(Fl_Choice self, int v) -> int
        """
        return _fltk.Fl_Choice_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Choice self, char * Fl_Choice)"""
        return _fltk.Fl_Choice_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Choice
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Choice(self)
        return weakref.proxy(self)

# Register Fl_Choice in _fltk:
_fltk.Fl_Choice_swigregister(Fl_Choice)
class Fl_Copy_Surface(Fl_Widget_Surface):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Copy_Surface self, int w, int h) -> Fl_Copy_Surface"""
        _fltk.Fl_Copy_Surface_swiginit(self, _fltk.new_Fl_Copy_Surface(*args))
    __swig_destroy__ = _fltk.delete_Fl_Copy_Surface

    def set_current(self, *args):
        r"""set_current(Fl_Copy_Surface self)"""
        return _fltk.Fl_Copy_Surface_set_current(self, *args)

    def is_current(self, *args):
        r"""is_current(Fl_Copy_Surface self) -> bool"""
        return _fltk.Fl_Copy_Surface_is_current(self, *args)

    def w(self, *args):
        r"""w(Fl_Copy_Surface self) -> int"""
        return _fltk.Fl_Copy_Surface_w(self, *args)

    def h(self, *args):
        r"""h(Fl_Copy_Surface self) -> int"""
        return _fltk.Fl_Copy_Surface_h(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_Copy_Surface self, int * x, int * y)
        origin(Fl_Copy_Surface self, int x, int y)
        """
        return _fltk.Fl_Copy_Surface_origin(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_Copy_Surface self, int * w, int * h) -> int"""
        return _fltk.Fl_Copy_Surface_printable_rect(self, *args)

# Register Fl_Copy_Surface in _fltk:
_fltk.Fl_Copy_Surface_swigregister(Fl_Copy_Surface)
class Fl_Copy_Surface_Driver(Fl_Widget_Surface):
    r"""Proxy of C++ Fl_Copy_Surface_Driver class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

# Register Fl_Copy_Surface_Driver in _fltk:
_fltk.Fl_Copy_Surface_Driver_swigregister(Fl_Copy_Surface_Driver)
FL_SQUARE_CLOCK = _fltk.FL_SQUARE_CLOCK

FL_ROUND_CLOCK = _fltk.FL_ROUND_CLOCK

FL_ANALOG_CLOCK = _fltk.FL_ANALOG_CLOCK

FL_DIGITAL_CLOCK = _fltk.FL_DIGITAL_CLOCK

class Fl_Clock_Output(Fl_Widget):
    r"""Proxy of C++ Fl_Clock_Output class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Clock_Output self)"""
        return _fltk.Fl_Clock_Output_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Clock_Output self, int X, int Y, int W, int H, char const * L=None) -> Fl_Clock_Output"""
        if self.__class__ == Fl_Clock_Output:
            _self = None
        else:
            _self = self
        _fltk.Fl_Clock_Output_swiginit(self, _fltk.new_Fl_Clock_Output(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Clock_Output")
        #print("Adding type: ", Fl_Clock_Output)




    def value(self, *args):
        r"""
        value(Fl_Clock_Output self, ulong v)
        value(Fl_Clock_Output self, int H, int m, int s)
        value(Fl_Clock_Output self) -> ulong
        """
        return _fltk.Fl_Clock_Output_value(self, *args)

    def hour(self, *args):
        r"""hour(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_hour(self, *args)

    def minute(self, *args):
        r"""minute(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_minute(self, *args)

    def second(self, *args):
        r"""second(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_second(self, *args)

    def shadow(self, *args):
        r"""
        shadow(Fl_Clock_Output self) -> int
        shadow(Fl_Clock_Output self, int mode)
        """
        return _fltk.Fl_Clock_Output_shadow(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Clock_Output self, char * Fl_Clock_Output)"""
        return _fltk.Fl_Clock_Output_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Clock_Output
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock_Output(self)
        return weakref.proxy(self)

# Register Fl_Clock_Output in _fltk:
_fltk.Fl_Clock_Output_swigregister(Fl_Clock_Output)
class Fl_Clock(Fl_Clock_Output):
    r"""

    This widget provides a round analog clock display and is provided for Forms 
    compatibility. It installs a 1-second timeout callback using Fl.add_timeout().

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Clock self, int arg0) -> int"""
        return _fltk.Fl_Clock_handle(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Clock self, int X, int Y, int W, int H, char const * L=None) -> Fl_Clock
        __init__(Fl_Clock self, uchar t, int X, int Y, int W, int H, char const * L) -> Fl_Clock
        """
        if self.__class__ == Fl_Clock:
            _self = None
        else:
            _self = self
        _fltk.Fl_Clock_swiginit(self, _fltk.new_Fl_Clock(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Clock")
        #print("Adding type: ", Fl_Clock)



    __swig_destroy__ = _fltk.delete_Fl_Clock

    def init_type(self, *args):
        r"""init_type(Fl_Clock self, char * Fl_Clock)"""
        return _fltk.Fl_Clock_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Clock self)"""
        return _fltk.Fl_Clock_draw(self, *args)

# Register Fl_Clock in _fltk:
_fltk.Fl_Clock_swigregister(Fl_Clock)
class Fl_Value_Input(Fl_Valuator):
    r"""

    The Fl_Value_Input widget displays a numeric value. The user can click in 
    the text field and edit it - there is in fact a hidden Fl_Input widget with 
    type(FL_FLOAT_INPUT) or type(FL_INT_INPUT) in there - and when they hit 
    return or tab the value updates to what they typed and the callback is done.

    If step() is non-zero, the user can also drag the mouse across the object 
    and thus slide the value. The left button moves one step() per pixel, the 
    middle by 10 * step(), and the right button by 100 * step(). It is therefore 
    impossible to select text by dragging across it, although clicking can still 
    move the insertion cursor.

    If step() is non-zero and integral, then the range of numbers are limited 
    to integers instead of floating point values. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Value_Input self, int arg0) -> int"""
        return _fltk.Fl_Value_Input_handle(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Value_Input self)"""
        return _fltk.Fl_Value_Input_draw(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Value_Input self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Value_Input_resize(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Value_Input self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Input"""
        if self.__class__ == Fl_Value_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Value_Input_swiginit(self, _fltk.new_Fl_Value_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Value_Input")
        #print("Adding type: ", Fl_Value_Input)



    __swig_destroy__ = _fltk.delete_Fl_Value_Input

    def soft(self, *args):
        r"""
        soft(Fl_Value_Input self, char s)
        soft(Fl_Value_Input self) -> char
        """
        return _fltk.Fl_Value_Input_soft(self, *args)

    def shortcut(self, *args):
        r"""
        shortcut(Fl_Value_Input self) -> int
        shortcut(Fl_Value_Input self, int s)
        """
        return _fltk.Fl_Value_Input_shortcut(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Value_Input self) -> Fl_Font
        textfont(Fl_Value_Input self, Fl_Font s)
        """
        return _fltk.Fl_Value_Input_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Value_Input self) -> Fl_Fontsize
        textsize(Fl_Value_Input self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Input_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Value_Input self) -> Fl_Color
        textcolor(Fl_Value_Input self, Fl_Color n)
        """
        return _fltk.Fl_Value_Input_textcolor(self, *args)

    def cursor_color(self, *args):
        r"""
        cursor_color(Fl_Value_Input self) -> Fl_Color
        cursor_color(Fl_Value_Input self, Fl_Color n)
        """
        return _fltk.Fl_Value_Input_cursor_color(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Value_Input self, char * Fl_Value_Input)"""
        return _fltk.Fl_Value_Input_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Input(self)
        return weakref.proxy(self)

# Register Fl_Value_Input in _fltk:
_fltk.Fl_Value_Input_swigregister(Fl_Value_Input)
class Flcc_HueBox(Fl_Widget):
    r"""Proxy of C++ Flcc_HueBox class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Flcc_HueBox self)"""
        return _fltk.Flcc_HueBox_draw(self, *args)

    def handle(self, *args):
        r"""handle(Flcc_HueBox self, int arg0) -> int"""
        return _fltk.Flcc_HueBox_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Flcc_HueBox self, int X, int Y, int W, int H) -> Flcc_HueBox"""
        if self.__class__ == Flcc_HueBox:
            _self = None
        else:
            _self = self
        _fltk.Flcc_HueBox_swiginit(self, _fltk.new_Flcc_HueBox(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Flcc_HueBox")
        #print("Adding type: ", Flcc_HueBox)




    def init_type(self, *args):
        r"""init_type(Flcc_HueBox self, char * Flcc_HueBox)"""
        return _fltk.Flcc_HueBox_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Flcc_HueBox
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_HueBox(self)
        return weakref.proxy(self)

# Register Flcc_HueBox in _fltk:
_fltk.Flcc_HueBox_swigregister(Flcc_HueBox)
class Flcc_ValueBox(Fl_Widget):
    r"""Proxy of C++ Flcc_ValueBox class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Flcc_ValueBox self)"""
        return _fltk.Flcc_ValueBox_draw(self, *args)

    def handle(self, *args):
        r"""handle(Flcc_ValueBox self, int arg0) -> int"""
        return _fltk.Flcc_ValueBox_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Flcc_ValueBox self, int X, int Y, int W, int H) -> Flcc_ValueBox"""
        if self.__class__ == Flcc_ValueBox:
            _self = None
        else:
            _self = self
        _fltk.Flcc_ValueBox_swiginit(self, _fltk.new_Flcc_ValueBox(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Flcc_ValueBox")
        #print("Adding type: ", Flcc_ValueBox)




    def init_type(self, *args):
        r"""init_type(Flcc_ValueBox self, char * Flcc_ValueBox)"""
        return _fltk.Flcc_ValueBox_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Flcc_ValueBox
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_ValueBox(self)
        return weakref.proxy(self)

# Register Flcc_ValueBox in _fltk:
_fltk.Flcc_ValueBox_swigregister(Flcc_ValueBox)
class Flcc_Value_Input(Fl_Value_Input):
    r"""Proxy of C++ Flcc_Value_Input class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def format(self, *args):
        r"""format(Flcc_Value_Input self, char * arg0) -> int"""
        return _fltk.Flcc_Value_Input_format(self, *args)

    def __init__(self, *args):
        r"""__init__(Flcc_Value_Input self, int X, int Y, int W, int H) -> Flcc_Value_Input"""
        if self.__class__ == Flcc_Value_Input:
            _self = None
        else:
            _self = self
        _fltk.Flcc_Value_Input_swiginit(self, _fltk.new_Flcc_Value_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Flcc_Value_Input")
        #print("Adding type: ", Flcc_Value_Input)




    def init_type(self, *args):
        r"""init_type(Flcc_Value_Input self, char * Flcc_Value_Input)"""
        return _fltk.Flcc_Value_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Flcc_Value_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_Value_Input(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Flcc_Value_Input self)"""
        return _fltk.Flcc_Value_Input_draw(self, *args)

# Register Flcc_Value_Input in _fltk:
_fltk.Flcc_Value_Input_swigregister(Flcc_Value_Input)
class Fl_Color_Chooser(Fl_Group):
    r"""

    The Fl_Color_Chooser widget provides a standard RGB color chooser. You can 
    place any number of these into a panel of your own design. This widget 
    contains the hue box, value slider, and rgb input fields from the above 
    diagram (it does not have the color chips or the Cancel or OK buttons). The 
    callback is done every time the user changes the rgb value. It is not done 
    if they move the hue control in a way that produces the same rgb value, such 
    as when saturation or value is zero.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Color_Chooser self, int e) -> int"""
        return _fltk.Fl_Color_Chooser_handle(self, *args)

    def mode(self, *args):
        r"""
        mode(Fl_Color_Chooser self) -> int
        mode(Fl_Color_Chooser self, int newMode)
        """
        return _fltk.Fl_Color_Chooser_mode(self, *args)

    def hue(self, *args):
        r"""hue(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_hue(self, *args)

    def saturation(self, *args):
        r"""saturation(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_saturation(self, *args)

    def value(self, *args):
        r"""value(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_value(self, *args)

    def r(self, *args):
        r"""r(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_r(self, *args)

    def g(self, *args):
        r"""g(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_g(self, *args)

    def b(self, *args):
        r"""b(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_b(self, *args)

    def hsv(self, *args):
        r"""hsv(Fl_Color_Chooser self, double H, double S, double V) -> int"""
        return _fltk.Fl_Color_Chooser_hsv(self, *args)

    def rgb(self, *args):
        r"""rgb(Fl_Color_Chooser self, double R, double G, double B) -> int"""
        return _fltk.Fl_Color_Chooser_rgb(self, *args)

    @staticmethod
    def hsv2rgb(*args):
        r"""hsv2rgb(double H, double S, double V, double & R, double & G, double & B)"""
        return _fltk.Fl_Color_Chooser_hsv2rgb(*args)

    @staticmethod
    def rgb2hsv(*args):
        r"""rgb2hsv(double R, double G, double B, double & H, double & S, double & V)"""
        return _fltk.Fl_Color_Chooser_rgb2hsv(*args)

    def __init__(self, *args):
        r"""__init__(Fl_Color_Chooser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Color_Chooser"""
        if self.__class__ == Fl_Color_Chooser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Color_Chooser_swiginit(self, _fltk.new_Fl_Color_Chooser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Color_Chooser")
        #print("Adding type: ", Fl_Color_Chooser)




    def init_type(self, *args):
        r"""init_type(Fl_Color_Chooser self, char * Fl_Color_Chooser)"""
        return _fltk.Fl_Color_Chooser_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Color_Chooser
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Color_Chooser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Color_Chooser self)"""
        return _fltk.Fl_Color_Chooser_draw(self, *args)

# Register Fl_Color_Chooser in _fltk:
_fltk.Fl_Color_Chooser_swigregister(Fl_Color_Chooser)

def fl_color_chooser(*args):
    r"""
    fl_color_chooser(char const * name, double & r, double & g, double & b, int m=-1) -> int
    fl_color_chooser(char const * name, uchar & r, uchar & g, uchar & b, int m=-1) -> int
    """
    return _fltk.fl_color_chooser(*args)
FL_NORMAL_COUNTER = _fltk.FL_NORMAL_COUNTER

FL_SIMPLE_COUNTER = _fltk.FL_SIMPLE_COUNTER

class Fl_Counter(Fl_Valuator):
    r"""

    The Fl_Counter widget is provided for forms compatibility. It controls a 
    single floating point value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Counter self)"""
        return _fltk.Fl_Counter_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Counter self, int arg0) -> int"""
        return _fltk.Fl_Counter_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Counter self, int X, int Y, int W, int H, char const * L=None) -> Fl_Counter"""
        if self.__class__ == Fl_Counter:
            _self = None
        else:
            _self = self
        _fltk.Fl_Counter_swiginit(self, _fltk.new_Fl_Counter(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Counter")
        #print("Adding type: ", Fl_Counter)



    __swig_destroy__ = _fltk.delete_Fl_Counter

    def lstep(self, *args):
        r"""lstep(Fl_Counter self, double a)"""
        return _fltk.Fl_Counter_lstep(self, *args)

    def step(self, *args):
        r"""
        step(Fl_Counter self, double a, double b)
        step(Fl_Counter self, double a)
        step(Fl_Counter self) -> double
        """
        return _fltk.Fl_Counter_step(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Counter self) -> Fl_Font
        textfont(Fl_Counter self, Fl_Font s)
        """
        return _fltk.Fl_Counter_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Counter self) -> Fl_Fontsize
        textsize(Fl_Counter self, Fl_Fontsize s)
        """
        return _fltk.Fl_Counter_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Counter self) -> Fl_Color
        textcolor(Fl_Counter self, Fl_Color s)
        """
        return _fltk.Fl_Counter_textcolor(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Counter self, char * Fl_Counter)"""
        return _fltk.Fl_Counter_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Counter(self)
        return weakref.proxy(self)

# Register Fl_Counter in _fltk:
_fltk.Fl_Counter_swigregister(Fl_Counter)
class Fl_Plugin(object):
    r"""

    Fl_Plugin allows link-time and run-time integration of binary modules.

    Fl_Plugin and Fl_Plugin_Manager provide a small and simple solution for
    linking C++ classes at run-time, or optionally linking modules at compile
    time without the need to change the main application.

    Fl_Plugin_Manager uses static initialisation to create the plugin interface
    early during startup. Plugins are stored in a temporary database, organized
    in classes.

    Plugins should derive a new class from Fl_Plugin as a base:
    \code
    class My_Plugin : public Fl_Plugin {
    public:
      My_Plugin() : Fl_Plugin('effects', 'blur') { }
      void do_something(...);
    };
    My_Plugin blur_plugin();
    ndcode

    Plugins can be put into modules and either linked befor distribution, or loaded
    from dynamically linkable files. An Fl_Plugin_Manager is used to list and 
    access all currently loaded plugins.
    \code
    Fl_Plugin_Manager mgr('effects');
    int i, n = mgr.plugins();
    for (i=0; i<n; i++) {
      My_Plugin *pin = (My_Plugin*)mgr.plugin(i);
      pin->do_something();
    }
    ndcode

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Plugin self, char const * klass, char const * name) -> Fl_Plugin"""
        if self.__class__ == Fl_Plugin:
            _self = None
        else:
            _self = self
        _fltk.Fl_Plugin_swiginit(self, _fltk.new_Fl_Plugin(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Plugin
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Plugin(self)
        return weakref.proxy(self)

# Register Fl_Plugin in _fltk:
_fltk.Fl_Plugin_swigregister(Fl_Plugin)
class Fl_Plugin_Manager(object):
    r"""Proxy of C++ Fl_Plugin_Manager class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Plugin_Manager self, char const * klass) -> Fl_Plugin_Manager"""
        _fltk.Fl_Plugin_Manager_swiginit(self, _fltk.new_Fl_Plugin_Manager(*args))
    __swig_destroy__ = _fltk.delete_Fl_Plugin_Manager

    def plugins(self, *args):
        r"""plugins(Fl_Plugin_Manager self) -> int"""
        return _fltk.Fl_Plugin_Manager_plugins(self, *args)

    def plugin(self, *args):
        r"""
        plugin(Fl_Plugin_Manager self, int index) -> Fl_Plugin
        plugin(Fl_Plugin_Manager self, char const * name) -> Fl_Plugin
        """
        return _fltk.Fl_Plugin_Manager_plugin(self, *args)

    def addPlugin(self, *args):
        r"""addPlugin(Fl_Plugin_Manager self, char const * name, Fl_Plugin plugin) -> Fl_Preferences::ID"""
        return _fltk.Fl_Plugin_Manager_addPlugin(self, *args)

    @staticmethod
    def removePlugin(*args):
        r"""removePlugin(Fl_Preferences::ID id)"""
        return _fltk.Fl_Plugin_Manager_removePlugin(*args)

    @staticmethod
    def load(*args):
        r"""load(char const * filename) -> int"""
        return _fltk.Fl_Plugin_Manager_load(*args)

    @staticmethod
    def loadAll(*args):
        r"""loadAll(char const * dirpath, char const * pattern=None) -> int"""
        return _fltk.Fl_Plugin_Manager_loadAll(*args)

# Register Fl_Plugin_Manager in _fltk:
_fltk.Fl_Plugin_Manager_swigregister(Fl_Plugin_Manager)
class Fl_Surface_Device(object):
    r"""Proxy of C++ Fl_Surface_Device class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def end_current(self, *args):
        r"""end_current(Fl_Surface_Device self)"""
        return _fltk.Fl_Surface_Device_end_current(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Surface_Device self, Fl_Graphics_Driver * graphics_driver) -> Fl_Surface_Device"""
        if self.__class__ == Fl_Surface_Device:
            _self = None
        else:
            _self = self
        _fltk.Fl_Surface_Device_swiginit(self, _fltk.new_Fl_Surface_Device(_self, *args))

    def set_current(self, *args):
        r"""set_current(Fl_Surface_Device self)"""
        return _fltk.Fl_Surface_Device_set_current(self, *args)

    def is_current(self, *args):
        r"""is_current(Fl_Surface_Device self) -> bool"""
        return _fltk.Fl_Surface_Device_is_current(self, *args)

    def driver(self, *args):
        r"""driver(Fl_Surface_Device self) -> Fl_Graphics_Driver *"""
        return _fltk.Fl_Surface_Device_driver(self, *args)

    @staticmethod
    def surface(*args):
        r"""surface() -> Fl_Surface_Device"""
        return _fltk.Fl_Surface_Device_surface(*args)
    __swig_destroy__ = _fltk.delete_Fl_Surface_Device

    @staticmethod
    def push_current(*args):
        r"""push_current(Fl_Surface_Device new_current)"""
        return _fltk.Fl_Surface_Device_push_current(*args)

    @staticmethod
    def pop_current(*args):
        r"""pop_current() -> Fl_Surface_Device"""
        return _fltk.Fl_Surface_Device_pop_current(*args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Surface_Device(self)
        return weakref.proxy(self)

# Register Fl_Surface_Device in _fltk:
_fltk.Fl_Surface_Device_swigregister(Fl_Surface_Device)
class Fl_Display_Device(Fl_Surface_Device):
    r"""Proxy of C++ Fl_Display_Device class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def display_device(*args):
        r"""display_device() -> Fl_Display_Device"""
        return _fltk.Fl_Display_Device_display_device(*args)
    __swig_destroy__ = _fltk.delete_Fl_Display_Device
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Display_Device(self)
        return weakref.proxy(self)

    def end_current(self, *args):
        r"""end_current(Fl_Display_Device self)"""
        return _fltk.Fl_Display_Device_end_current(self, *args)

# Register Fl_Display_Device in _fltk:
_fltk.Fl_Display_Device_swigregister(Fl_Display_Device)
class Fl_Device_Plugin(Fl_Plugin):
    r"""Proxy of C++ Fl_Device_Plugin class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Device_Plugin self, char const * pluginName) -> Fl_Device_Plugin"""
        if self.__class__ == Fl_Device_Plugin:
            _self = None
        else:
            _self = self
        _fltk.Fl_Device_Plugin_swiginit(self, _fltk.new_Fl_Device_Plugin(_self, *args))

    def klass(self, *args):
        r"""klass(Fl_Device_Plugin self) -> char const *"""
        return _fltk.Fl_Device_Plugin_klass(self, *args)

    def name(self, *args):
        r"""name(Fl_Device_Plugin self) -> char const *"""
        return _fltk.Fl_Device_Plugin_name(self, *args)

    def _print(self, *args):
        r"""_print(Fl_Device_Plugin self, Fl_Widget w) -> int"""
        return _fltk.Fl_Device_Plugin__print(self, *args)

    def rectangle_capture(self, *args):
        r"""rectangle_capture(Fl_Device_Plugin self, Fl_Widget widget, int x, int y, int w, int h) -> Fl_RGB_Image"""
        return _fltk.Fl_Device_Plugin_rectangle_capture(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Device_Plugin
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Device_Plugin(self)
        return weakref.proxy(self)

# Register Fl_Device_Plugin in _fltk:
_fltk.Fl_Device_Plugin_swigregister(Fl_Device_Plugin)
FL_NORMAL_DIAL = _fltk.FL_NORMAL_DIAL

FL_LINE_DIAL = _fltk.FL_LINE_DIAL

FL_FILL_DIAL = _fltk.FL_FILL_DIAL

class Fl_Dial(Fl_Valuator):
    r"""

    The Fl_Dial widget provides a circular dial to control a single floating 
    point value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Dial self)"""
        return _fltk.Fl_Dial_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Dial self, int arg0) -> int"""
        return _fltk.Fl_Dial_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Dial self, int x, int y, int w, int h, char const * l=None) -> Fl_Dial"""
        if self.__class__ == Fl_Dial:
            _self = None
        else:
            _self = self
        _fltk.Fl_Dial_swiginit(self, _fltk.new_Fl_Dial(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Dial")
        #print("Adding type: ", Fl_Dial)




    def angle1(self, *args):
        r"""
        angle1(Fl_Dial self) -> short
        angle1(Fl_Dial self, short a)
        """
        return _fltk.Fl_Dial_angle1(self, *args)

    def angle2(self, *args):
        r"""
        angle2(Fl_Dial self) -> short
        angle2(Fl_Dial self, short a)
        """
        return _fltk.Fl_Dial_angle2(self, *args)

    def angles(self, *args):
        r"""angles(Fl_Dial self, short a, short b)"""
        return _fltk.Fl_Dial_angles(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Dial self, char * Fl_Dial)"""
        return _fltk.Fl_Dial_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Dial
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Dial(self)
        return weakref.proxy(self)

# Register Fl_Dial in _fltk:
_fltk.Fl_Dial_swigregister(Fl_Dial)
FL_WINDOW = _fltk.FL_WINDOW

FL_DOUBLE_WINDOW = _fltk.FL_DOUBLE_WINDOW

class Fl_Window(Fl_Group):
    r"""

    This widget produces an actual window. This can either be a main window, 
    with a border and title and all the window management controls, or a 
    'subwindow' inside a window. This is controlled by whether or not the 
    window has a parent().

    Once you create a window, you usually add children Fl_Widget 's to it by 
    using window->add(child) for each new widget. See Fl_Group for more 
    information on how to add and remove children.

    There are several subclasses of Fl_Window that provide double-buffering, 
    overlay, menu, and OpenGL support.

    The window's callback is done if the user tries to close a window using 
    the window manager and Fl.modal() is zero or equal to the window. Fl_Window 
    has a default callback that calls Fl_Window.hide(). 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Window self)"""
        return _fltk.Fl_Window_draw(self, *args)

    def flush(self, *args):
        r"""flush(Fl_Window self)"""
        return _fltk.Fl_Window_flush(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Window self, int w, int h, char const * title=None) -> Fl_Window
        __init__(Fl_Window self, int x, int y, int w, int h, char const * title=None) -> Fl_Window
        """
        if self.__class__ == Fl_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Window_swiginit(self, _fltk.new_Fl_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Window")
        #print("Adding type: ", Fl_Window)



    __swig_destroy__ = _fltk.delete_Fl_Window

    def handle(self, *args):
        r"""handle(Fl_Window self, int arg0) -> int"""
        return _fltk.Fl_Window_handle(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Window self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Window_resize(self, *args)

    def clear_border(self, *args):
        r"""clear_border(Fl_Window self)"""
        return _fltk.Fl_Window_clear_border(self, *args)

    def border(self, *args):
        r"""
        border(Fl_Window self, int b)
        border(Fl_Window self) -> unsigned int
        """
        return _fltk.Fl_Window_border(self, *args)

    def set_override(self, *args):
        r"""set_override(Fl_Window self)"""
        return _fltk.Fl_Window_set_override(self, *args)

    def override(self, *args):
        r"""override(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_override(self, *args)

    def set_modal(self, *args):
        r"""set_modal(Fl_Window self)"""
        return _fltk.Fl_Window_set_modal(self, *args)

    def modal(self, *args):
        r"""modal(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_modal(self, *args)

    def set_non_modal(self, *args):
        r"""set_non_modal(Fl_Window self)"""
        return _fltk.Fl_Window_set_non_modal(self, *args)

    def non_modal(self, *args):
        r"""non_modal(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_non_modal(self, *args)

    def clear_modal_states(self, *args):
        r"""clear_modal_states(Fl_Window self)"""
        return _fltk.Fl_Window_clear_modal_states(self, *args)

    def set_menu_window(self, *args):
        r"""set_menu_window(Fl_Window self)"""
        return _fltk.Fl_Window_set_menu_window(self, *args)

    def menu_window(self, *args):
        r"""menu_window(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_menu_window(self, *args)

    def set_tooltip_window(self, *args):
        r"""set_tooltip_window(Fl_Window self)"""
        return _fltk.Fl_Window_set_tooltip_window(self, *args)

    def tooltip_window(self, *args):
        r"""tooltip_window(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_tooltip_window(self, *args)

    def hotspot(self, *args):
        r"""
        hotspot(Fl_Window self, int x, int y, int offscreen=0)
        hotspot(Fl_Window self, Fl_Widget arg2, int offscreen=0)
        """
        return _fltk.Fl_Window_hotspot(self, *args)

    def free_position(self, *args):
        r"""free_position(Fl_Window self)"""
        return _fltk.Fl_Window_free_position(self, *args)

    def size_range(self, *args):
        r"""size_range(Fl_Window self, int minw, int minh, int maxw=0, int maxh=0, int dw=0, int dh=0, int aspect=0)"""
        return _fltk.Fl_Window_size_range(self, *args)

    def get_size_range(self, *args):
        r"""get_size_range(Fl_Window self, int * minw, int * minh, int * maxw=None, int * maxh=None, int * dw=None, int * dh=None, int * aspect=None) -> uchar"""
        return _fltk.Fl_Window_get_size_range(self, *args)

    def iconlabel(self, *args):
        r"""
        iconlabel(Fl_Window self) -> char const
        iconlabel(Fl_Window self, char const * arg2)
        """
        return _fltk.Fl_Window_iconlabel(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Window self) -> char const
        label(Fl_Window self, char const * arg2)
        label(Fl_Window self, char const * label, char const * iconlabel)
        """
        val = _fltk.Fl_Window_label(self, *args)

        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val


    def copy_label(self, *args):
        r"""copy_label(Fl_Window self, char const * a)"""
        return _fltk.Fl_Window_copy_label(self, *args)

    @staticmethod
    def default_xclass(*args):
        r"""
        default_xclass(char const * arg1)
        default_xclass() -> char const *
        """
        return _fltk.Fl_Window_default_xclass(*args)

    def xclass(self, *args):
        r"""
        xclass(Fl_Window self) -> char const
        xclass(Fl_Window self, char const * c)
        """
        return _fltk.Fl_Window_xclass(self, *args)

    @staticmethod
    def default_icon(*args):
        r"""default_icon(Fl_RGB_Image arg1)"""
        return _fltk.Fl_Window_default_icon(*args)

    @staticmethod
    def default_icons(*args):
        r"""default_icons(Fl_RGB_Image const *[] arg1, int arg2)"""
        return _fltk.Fl_Window_default_icons(*args)

    def icons(self, *args):
        r"""icons(Fl_Window self, Fl_RGB_Image const *[] arg2, int arg3)"""
        return _fltk.Fl_Window_icons(self, *args)

    def icon(self, *args):
        r"""
        icon(Fl_Window self, Fl_RGB_Image arg2)
        icon(Fl_Window self) -> void const
        icon(Fl_Window self, void const * ic)
        """
        return _fltk.Fl_Window_icon(self, *args)

    def shown(self, *args):
        r"""shown(Fl_Window self) -> int"""
        return _fltk.Fl_Window_shown(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Window self)"""
        return _fltk.Fl_Window_hide(self, *args)

    def wait_for_expose(self, *args):
        r"""wait_for_expose(Fl_Window self)"""
        return _fltk.Fl_Window_wait_for_expose(self, *args)

    def fullscreen(self, *args):
        r"""fullscreen(Fl_Window self)"""
        return _fltk.Fl_Window_fullscreen(self, *args)

    def fullscreen_off(self, *args):
        r"""
        fullscreen_off(Fl_Window self)
        fullscreen_off(Fl_Window self, int X, int Y, int W, int H)
        """
        return _fltk.Fl_Window_fullscreen_off(self, *args)

    def fullscreen_active(self, *args):
        r"""fullscreen_active(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_fullscreen_active(self, *args)

    def fullscreen_screens(self, *args):
        r"""fullscreen_screens(Fl_Window self, int top, int bottom, int left, int right)"""
        return _fltk.Fl_Window_fullscreen_screens(self, *args)

    def maximize(self, *args):
        r"""maximize(Fl_Window self)"""
        return _fltk.Fl_Window_maximize(self, *args)

    def un_maximize(self, *args):
        r"""un_maximize(Fl_Window self)"""
        return _fltk.Fl_Window_un_maximize(self, *args)

    def maximize_active(self, *args):
        r"""maximize_active(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_maximize_active(self, *args)

    def iconize(self, *args):
        r"""iconize(Fl_Window self)"""
        return _fltk.Fl_Window_iconize(self, *args)

    def x_root(self, *args):
        r"""x_root(Fl_Window self) -> int"""
        return _fltk.Fl_Window_x_root(self, *args)

    def y_root(self, *args):
        r"""y_root(Fl_Window self) -> int"""
        return _fltk.Fl_Window_y_root(self, *args)

    @staticmethod
    def current(*args):
        r"""current() -> Fl_Window"""
        return _fltk.Fl_Window_current(*args)

    def make_current(self, *args):
        r"""make_current(Fl_Window self)"""
        return _fltk.Fl_Window_make_current(self, *args)

    def cursor(self, *args):
        r"""
        cursor(Fl_Window self, Fl_Cursor arg2)
        cursor(Fl_Window self, Fl_RGB_Image arg2, int arg3, int arg4)
        cursor(Fl_Window self, Fl_Cursor c, Fl_Color arg3, Fl_Color arg4=)
        """
        return _fltk.Fl_Window_cursor(self, *args)

    def default_cursor(self, *args):
        r"""
        default_cursor(Fl_Window self, Fl_Cursor arg2)
        default_cursor(Fl_Window self, Fl_Cursor c, Fl_Color arg3, Fl_Color arg4=)
        """
        return _fltk.Fl_Window_default_cursor(self, *args)

    @staticmethod
    def default_callback(*args):
        r"""default_callback(Fl_Window arg1, void * v)"""
        return _fltk.Fl_Window_default_callback(*args)

    def decorated_w(self, *args):
        r"""decorated_w(Fl_Window self) -> int"""
        return _fltk.Fl_Window_decorated_w(self, *args)

    def decorated_h(self, *args):
        r"""decorated_h(Fl_Window self) -> int"""
        return _fltk.Fl_Window_decorated_h(self, *args)

    def as_window(self, *args):
        r"""
        as_window(Fl_Window self) -> Fl_Window
        as_window(Fl_Window self) -> Fl_Window
        """
        return _fltk.Fl_Window_as_window(self, *args)

    def as_overlay_window(self, *args):
        r"""as_overlay_window(Fl_Window self) -> Fl_Overlay_Window"""
        return _fltk.Fl_Window_as_overlay_window(self, *args)

    def as_double_window(self, *args):
        r"""as_double_window(Fl_Window self) -> Fl_Double_Window"""
        return _fltk.Fl_Window_as_double_window(self, *args)

    def shape(self, *args):
        r"""
        shape(Fl_Window self, Fl_Image img)
        shape(Fl_Window self, Fl_Image b)
        shape(Fl_Window self) -> Fl_Image
        """
        return _fltk.Fl_Window_shape(self, *args)

    def draw_backdrop(self, *args):
        r"""draw_backdrop(Fl_Window self)"""
        return _fltk.Fl_Window_draw_backdrop(self, *args)

    def screen_num(self, *args):
        r"""
        screen_num(Fl_Window self) -> int
        screen_num(Fl_Window self, int screen_num)
        """
        return _fltk.Fl_Window_screen_num(self, *args)

    @staticmethod
    def is_a_rescale(*args):
        r"""is_a_rescale() -> bool"""
        return _fltk.Fl_Window_is_a_rescale(*args)

    def os_id(self, *args):
        r"""os_id(Fl_Window self) -> fl_uintptr_t"""
        return _fltk.Fl_Window_os_id(self, *args)

    @staticmethod
    def show_next_window_iconic(*args):
        r"""
        show_next_window_iconic(char stat)
        show_next_window_iconic() -> char
        """
        return _fltk.Fl_Window_show_next_window_iconic(*args)

    def allow_expand_outside_parent(self, *args):
        r"""allow_expand_outside_parent(Fl_Window self)"""
        return _fltk.Fl_Window_allow_expand_outside_parent(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Window self, char * Fl_Window)"""
        return _fltk.Fl_Window_init_type(self, *args)

    def show(self, *args):
        r"""show(Fl_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Window_show(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Window(self)
        return weakref.proxy(self)

# Register Fl_Window in _fltk:
_fltk.Fl_Window_swigregister(Fl_Window)
class Fl_Double_Window(Fl_Window):
    r"""

    The Fl_Double_Window class provides a double-buffered window. If possible 
    this will use the X double buffering extension (Xdbe). If not, it will draw 
    the window data into an off-screen pixmap, and then copy it to the on-screen 
    window.

    It is highly recommended that you put the following code before the first 
    show() of any window in your program:

          Fl.visual(FL_DOUBLE|FL_INDEX)

    This makes sure you can use Xdbe on servers where double buffering does not 
    exist for every visual.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def as_double_window(self, *args):
        r"""as_double_window(Fl_Double_Window self) -> Fl_Double_Window"""
        return _fltk.Fl_Double_Window_as_double_window(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Double_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Double_Window_resize(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_hide(self, *args)

    def flush(self, *args):
        r"""flush(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_flush(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Double_Window

    def __init__(self, *args):
        r"""
        __init__(Fl_Double_Window self, int W, int H, char const * l=None) -> Fl_Double_Window
        __init__(Fl_Double_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Double_Window
        """
        if self.__class__ == Fl_Double_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Double_Window_swiginit(self, _fltk.new_Fl_Double_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Double_Window")
        #print("Adding type: ", Fl_Double_Window)




    def init_type(self, *args):
        r"""init_type(Fl_Double_Window self, char * Fl_Double_Window)"""
        return _fltk.Fl_Double_Window_init_type(self, *args)

    def show(self, *args):
        r"""show(Fl_Double_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Double_Window_show(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Double_Window(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_draw(self, *args)

# Register Fl_Double_Window in _fltk:
_fltk.Fl_Double_Window_swigregister(Fl_Double_Window)

def fl_color(*args):
    r"""
    fl_color(Fl_Color c)
    fl_color(uchar r, uchar g, uchar b)
    fl_color() -> Fl_Color
    """
    return _fltk.fl_color(*args)

def fl_push_clip(*args):
    r"""fl_push_clip(int x, int y, int w, int h)"""
    return _fltk.fl_push_clip(*args)

def fl_push_no_clip(*args):
    r"""fl_push_no_clip()"""
    return _fltk.fl_push_no_clip(*args)

def fl_pop_clip(*args):
    r"""fl_pop_clip()"""
    return _fltk.fl_pop_clip(*args)

def fl_not_clipped(*args):
    r"""fl_not_clipped(int x, int y, int w, int h) -> int"""
    return _fltk.fl_not_clipped(*args)

def fl_clip_box(*args):
    r"""fl_clip_box(int x, int y, int w, int h) -> int"""
    return _fltk.fl_clip_box(*args)

def fl_restore_clip(*args):
    r"""fl_restore_clip()"""
    return _fltk.fl_restore_clip(*args)

def fl_clip_region(*args):
    r"""
    fl_clip_region(Fl_Region r)
    fl_clip_region() -> Fl_Region
    """
    return _fltk.fl_clip_region(*args)

def fl_point(*args):
    r"""fl_point(int x, int y)"""
    return _fltk.fl_point(*args)

def fl_line_style(*args):
    r"""fl_line_style(int style, int width=0, char * dashes=None)"""
    return _fltk.fl_line_style(*args)
FL_SOLID = _fltk.FL_SOLID

FL_DASH = _fltk.FL_DASH

FL_DOT = _fltk.FL_DOT

FL_DASHDOT = _fltk.FL_DASHDOT

FL_DASHDOTDOT = _fltk.FL_DASHDOTDOT

FL_CAP_FLAT = _fltk.FL_CAP_FLAT

FL_CAP_ROUND = _fltk.FL_CAP_ROUND

FL_CAP_SQUARE = _fltk.FL_CAP_SQUARE

FL_JOIN_MITER = _fltk.FL_JOIN_MITER

FL_JOIN_ROUND = _fltk.FL_JOIN_ROUND

FL_JOIN_BEVEL = _fltk.FL_JOIN_BEVEL

FL_UNIFORM_WIDTH = _fltk.FL_UNIFORM_WIDTH


def fl_antialias(*args):
    r"""
    fl_antialias(int state)
    fl_antialias() -> int
    """
    return _fltk.fl_antialias(*args)

def fl_rounded_rect(*args):
    r"""fl_rounded_rect(int x, int y, int w, int h, int r)"""
    return _fltk.fl_rounded_rect(*args)

def fl_focus_rect(*args):
    r"""fl_focus_rect(int x, int y, int w, int h)"""
    return _fltk.fl_focus_rect(*args)

def fl_rect(*args):
    r"""
    fl_rect(int x, int y, int w, int h)
    fl_rect(Fl_Rect r)
    fl_rect(int x, int y, int w, int h, Fl_Color c)
    """
    return _fltk.fl_rect(*args)

def fl_rounded_rectf(*args):
    r"""fl_rounded_rectf(int x, int y, int w, int h, int r)"""
    return _fltk.fl_rounded_rectf(*args)

def fl_rectf(*args):
    r"""
    fl_rectf(int x, int y, int w, int h)
    fl_rectf(int x, int y, int w, int h, Fl_Color c)
    fl_rectf(Fl_Rect r)
    fl_rectf(Fl_Rect r, Fl_Color c)
    fl_rectf(int x, int y, int w, int h, uchar r, uchar g, uchar b)
    fl_rectf(Fl_Rect bb, uchar r, uchar g, uchar b)
    """
    return _fltk.fl_rectf(*args)

def fl_line(*args):
    r"""
    fl_line(int x, int y, int x1, int y1)
    fl_line(int x, int y, int x1, int y1, int x2, int y2)
    """
    return _fltk.fl_line(*args)

def fl_loop(*args):
    r"""
    fl_loop(int x, int y, int x1, int y1, int x2, int y2)
    fl_loop(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3)
    """
    return _fltk.fl_loop(*args)

def fl_polygon(*args):
    r"""
    fl_polygon(int x, int y, int x1, int y1, int x2, int y2)
    fl_polygon(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3)
    """
    return _fltk.fl_polygon(*args)

def fl_xyline(*args):
    r"""
    fl_xyline(int x, int y, int x1)
    fl_xyline(int x, int y, int x1, int y2)
    fl_xyline(int x, int y, int x1, int y2, int x3)
    """
    return _fltk.fl_xyline(*args)

def fl_yxline(*args):
    r"""
    fl_yxline(int x, int y, int y1)
    fl_yxline(int x, int y, int y1, int x2)
    fl_yxline(int x, int y, int y1, int x2, int y3)
    """
    return _fltk.fl_yxline(*args)

def fl_pie(*args):
    r"""fl_pie(int x, int y, int w, int h, double a1, double a2)"""
    return _fltk.fl_pie(*args)

def fl_push_matrix(*args):
    r"""fl_push_matrix()"""
    return _fltk.fl_push_matrix(*args)

def fl_pop_matrix(*args):
    r"""fl_pop_matrix()"""
    return _fltk.fl_pop_matrix(*args)

def fl_scale(*args):
    r"""
    fl_scale(double x, double y)
    fl_scale(double x)
    """
    return _fltk.fl_scale(*args)

def fl_translate(*args):
    r"""fl_translate(double x, double y)"""
    return _fltk.fl_translate(*args)

def fl_rotate(*args):
    r"""fl_rotate(double d)"""
    return _fltk.fl_rotate(*args)

def fl_load_identity(*args):
    r"""fl_load_identity()"""
    return _fltk.fl_load_identity(*args)

def fl_load_matrix(*args):
    r"""fl_load_matrix(double a, double b, double c, double d, double x, double y)"""
    return _fltk.fl_load_matrix(*args)

def fl_mult_matrix(*args):
    r"""fl_mult_matrix(double a, double b, double c, double d, double x, double y)"""
    return _fltk.fl_mult_matrix(*args)

def fl_begin_points(*args):
    r"""fl_begin_points()"""
    return _fltk.fl_begin_points(*args)

def fl_begin_line(*args):
    r"""fl_begin_line()"""
    return _fltk.fl_begin_line(*args)

def fl_begin_loop(*args):
    r"""fl_begin_loop()"""
    return _fltk.fl_begin_loop(*args)

def fl_begin_polygon(*args):
    r"""fl_begin_polygon()"""
    return _fltk.fl_begin_polygon(*args)

def fl_vertex(*args):
    r"""fl_vertex(double x, double y)"""
    return _fltk.fl_vertex(*args)

def fl_curve(*args):
    r"""fl_curve(double X0, double Y0, double X1, double Y1, double X2, double Y2, double X3, double Y3)"""
    return _fltk.fl_curve(*args)

def fl_arc(*args):
    r"""
    fl_arc(int x, int y, int w, int h, double a1, double a2)
    fl_arc(double x, double y, double r, double start, double end)
    """
    return _fltk.fl_arc(*args)

def fl_circle(*args):
    r"""fl_circle(double x, double y, double r)"""
    return _fltk.fl_circle(*args)

def fl_end_points(*args):
    r"""fl_end_points()"""
    return _fltk.fl_end_points(*args)

def fl_end_line(*args):
    r"""fl_end_line()"""
    return _fltk.fl_end_line(*args)

def fl_end_loop(*args):
    r"""fl_end_loop()"""
    return _fltk.fl_end_loop(*args)

def fl_end_polygon(*args):
    r"""fl_end_polygon()"""
    return _fltk.fl_end_polygon(*args)

def fl_begin_complex_polygon(*args):
    r"""fl_begin_complex_polygon()"""
    return _fltk.fl_begin_complex_polygon(*args)

def fl_gap(*args):
    r"""fl_gap()"""
    return _fltk.fl_gap(*args)

def fl_end_complex_polygon(*args):
    r"""fl_end_complex_polygon()"""
    return _fltk.fl_end_complex_polygon(*args)

def fl_transform_x(*args):
    r"""fl_transform_x(double x, double y) -> double"""
    return _fltk.fl_transform_x(*args)

def fl_transform_y(*args):
    r"""fl_transform_y(double x, double y) -> double"""
    return _fltk.fl_transform_y(*args)

def fl_transform_dx(*args):
    r"""fl_transform_dx(double x, double y) -> double"""
    return _fltk.fl_transform_dx(*args)

def fl_transform_dy(*args):
    r"""fl_transform_dy(double x, double y) -> double"""
    return _fltk.fl_transform_dy(*args)

def fl_transformed_vertex(*args):
    r"""fl_transformed_vertex(double xf, double yf)"""
    return _fltk.fl_transformed_vertex(*args)

def fl_copy_offscreen(*args):
    r"""fl_copy_offscreen(int x, int y, int w, int h, Fl_Offscreen pixmap, int srcx, int srcy)"""
    return _fltk.fl_copy_offscreen(*args)

def fl_create_offscreen(*args):
    r"""fl_create_offscreen(int w, int h) -> Fl_Offscreen"""
    return _fltk.fl_create_offscreen(*args)

def fl_begin_offscreen(*args):
    r"""fl_begin_offscreen(Fl_Offscreen b)"""
    return _fltk.fl_begin_offscreen(*args)

def fl_end_offscreen(*args):
    r"""fl_end_offscreen()"""
    return _fltk.fl_end_offscreen(*args)

def fl_delete_offscreen(*args):
    r"""fl_delete_offscreen(Fl_Offscreen bitmap)"""
    return _fltk.fl_delete_offscreen(*args)

def fl_rescale_offscreen(*args):
    r"""fl_rescale_offscreen(Fl_Offscreen & ctx)"""
    return _fltk.fl_rescale_offscreen(*args)

def fl_font(*args):
    r"""
    fl_font(Fl_Font face, Fl_Fontsize fsize)
    fl_font() -> Fl_Font
    """
    return _fltk.fl_font(*args)

def fl_size(*args):
    r"""fl_size() -> Fl_Fontsize"""
    return _fltk.fl_size(*args)

def fl_height(*args):
    r"""
    fl_height() -> int
    fl_height(int font, int size) -> int
    """
    return _fltk.fl_height(*args)

def fl_descent(*args):
    r"""fl_descent() -> int"""
    return _fltk.fl_descent(*args)

def fl_width(*args):
    r"""
    fl_width(char const * txt) -> double
    fl_width(char const * txt, int n) -> double
    fl_width(unsigned int c) -> double
    """
    return _fltk.fl_width(*args)

def fl_text_extents(*args):
    r"""
    fl_text_extents(char const * arg1)
    fl_text_extents(char const * t, int n)
    """
    return _fltk.fl_text_extents(*args)

def fl_latin1_to_local(*args):
    r"""fl_latin1_to_local(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_latin1_to_local(*args)

def fl_local_to_latin1(*args):
    r"""fl_local_to_latin1(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_local_to_latin1(*args)

def fl_mac_roman_to_local(*args):
    r"""fl_mac_roman_to_local(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_mac_roman_to_local(*args)

def fl_local_to_mac_roman(*args):
    r"""fl_local_to_mac_roman(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_local_to_mac_roman(*args)

def fl_override_scale(*args):
    r"""fl_override_scale() -> float"""
    return _fltk.fl_override_scale(*args)

def fl_restore_scale(*args):
    r"""fl_restore_scale(float s)"""
    return _fltk.fl_restore_scale(*args)

def fl_rtl_draw(*args):
    r"""fl_rtl_draw(char const * str, int n, int x, int y)"""
    return _fltk.fl_rtl_draw(*args)

def fl_draw(*args):
    r"""
    fl_draw(char const * str, int x, int y)
    fl_draw(int angle, char const * str, int x, int y)
    fl_draw(char const * str, int n, int x, int y)
    fl_draw(int angle, char const * str, int n, int x, int y)
    fl_draw(char const * str, int x, int y, int w, int h, Fl_Align align, Fl_Image img=None, int draw_symbols=1, int spacing=0)
    fl_draw(char const * str, int x, int y, int w, int h, Fl_Align align, void (*)(char const *,int,int,int) callthis, Fl_Image img=None, int draw_symbols=1, int spacing=0)
    """
    return _fltk.fl_draw(*args)

def fl_frame(*args):
    r"""
    fl_frame(Fl_Boxtype b) -> Fl_Boxtype
    fl_frame(char const * s, int x, int y, int w, int h)
    """
    return _fltk.fl_frame(*args)

def fl_frame2(*args):
    r"""fl_frame2(char const * s, int x, int y, int w, int h)"""
    return _fltk.fl_frame2(*args)

def fl_draw_box(*args):
    r"""fl_draw_box(Fl_Boxtype arg1, int x, int y, int w, int h, Fl_Color arg6)"""
    return _fltk.fl_draw_box(*args)

def fl_draw_box_focus(*args):
    r"""fl_draw_box_focus(Fl_Boxtype arg1, int x, int y, int w, int h, Fl_Color arg6, Fl_Color arg7)"""
    return _fltk.fl_draw_box_focus(*args)

def fl_draw_arrow(*args):
    r"""fl_draw_arrow(Fl_Rect bb, Fl_Arrow_Type t, Fl_Orientation o, Fl_Color color)"""
    return _fltk.fl_draw_arrow(*args)

def fl_draw_circle(*args):
    r"""fl_draw_circle(int x, int y, int d, Fl_Color color)"""
    return _fltk.fl_draw_circle(*args)

def fl_draw_radio(*args):
    r"""fl_draw_radio(int x, int y, int d, Fl_Color color)"""
    return _fltk.fl_draw_radio(*args)

def fl_draw_image(*args):
    r"""fl_draw_image(uchar const * buf, int X, int Y, int W, int H, int D=3, int L=0)"""
    return _fltk.fl_draw_image(*args)

def fl_draw_image_mono(*args):
    r"""fl_draw_image_mono(uchar const * buf, int X, int Y, int W, int H, int D=1, int L=0)"""
    return _fltk.fl_draw_image_mono(*args)

def fl_can_do_alpha_blending(*args):
    r"""fl_can_do_alpha_blending() -> char"""
    return _fltk.fl_can_do_alpha_blending(*args)

def fl_capture_window(*args):
    r"""fl_capture_window(Fl_Window win, int x, int y, int w, int h) -> Fl_RGB_Image"""
    return _fltk.fl_capture_window(*args)

def fl_draw_pixmap(*args):
    r"""fl_draw_pixmap(char *const * data, int x, int y, Fl_Color bg=) -> int"""
    return _fltk.fl_draw_pixmap(*args)

def fl_measure_pixmap(*args):
    r"""fl_measure_pixmap(char *const * data) -> int"""
    return _fltk.fl_measure_pixmap(*args)

def fl_scroll(*args):
    r"""fl_scroll(int X, int Y, int W, int H, int dx, int dy, void (*)(void *,int,int,int,int) draw_area, void * data)"""
    return _fltk.fl_scroll(*args)

def fl_shortcut_label(*args):
    r"""
    fl_shortcut_label(unsigned int shortcut) -> char const
    fl_shortcut_label(unsigned int shortcut, char const ** eom) -> char const *
    """
    return _fltk.fl_shortcut_label(*args)

def fl_old_shortcut(*args):
    r"""fl_old_shortcut(char const * s) -> unsigned int"""
    return _fltk.fl_old_shortcut(*args)

def fl_overlay_rect(*args):
    r"""fl_overlay_rect(int x, int y, int w, int h)"""
    return _fltk.fl_overlay_rect(*args)

def fl_overlay_clear(*args):
    r"""fl_overlay_clear()"""
    return _fltk.fl_overlay_clear(*args)

def fl_cursor(*args):
    r"""
    fl_cursor(Fl_Cursor arg1)
    fl_cursor(Fl_Cursor arg1, Fl_Color fg, Fl_Color bg=)
    """
    return _fltk.fl_cursor(*args)

def fl_expand_text(*args):
    r"""fl_expand_text(char const * _from, char * buf, int maxbuf, double maxw, double & width, int wrap, int draw_symbols=0) -> char const *"""
    return _fltk.fl_expand_text(*args)

def fl_set_status(*args):
    r"""fl_set_status(int X, int Y, int W, int H)"""
    return _fltk.fl_set_status(*args)

def fl_set_spot(*args):
    r"""fl_set_spot(int font, int size, int X, int Y, int W, int H, Fl_Window win=None)"""
    return _fltk.fl_set_spot(*args)

def fl_reset_spot(*args):
    r"""fl_reset_spot()"""
    return _fltk.fl_reset_spot(*args)

def fl_draw_symbol(*args):
    r"""fl_draw_symbol(char const * label, int x, int y, int w, int h, Fl_Color arg6) -> int"""
    return _fltk.fl_draw_symbol(*args)

def fl_add_symbol(*args):
    r"""fl_add_symbol(char const * name, void (*)(Fl_Color) drawit, int scalable) -> int"""
    return _fltk.fl_add_symbol(*args)

def fl_measure(*args):
    r"""fl_measure(char const * str, int draw_symbols=1)"""
    return _fltk.fl_measure(*args)
FL_NORMAL_INPUT = _fltk.FL_NORMAL_INPUT

FL_FLOAT_INPUT = _fltk.FL_FLOAT_INPUT

FL_INT_INPUT = _fltk.FL_INT_INPUT

FL_HIDDEN_INPUT = _fltk.FL_HIDDEN_INPUT

FL_MULTILINE_INPUT = _fltk.FL_MULTILINE_INPUT

FL_SECRET_INPUT = _fltk.FL_SECRET_INPUT

FL_INPUT_TYPE = _fltk.FL_INPUT_TYPE

FL_INPUT_READONLY = _fltk.FL_INPUT_READONLY

FL_NORMAL_OUTPUT = _fltk.FL_NORMAL_OUTPUT

FL_MULTILINE_OUTPUT = _fltk.FL_MULTILINE_OUTPUT

FL_INPUT_WRAP = _fltk.FL_INPUT_WRAP

FL_MULTILINE_INPUT_WRAP = _fltk.FL_MULTILINE_INPUT_WRAP

FL_MULTILINE_OUTPUT_WRAP = _fltk.FL_MULTILINE_OUTPUT_WRAP

class Fl_Input_(Fl_Widget):
    r"""

    This is a virtual base class below Fl_Input. It has all the same interfaces, 
    but lacks the handle() and draw() method. You may want to subclass it if you 
    are one of those people who likes to change how the editing keys work.

    This can act like any of the subclasses of Fl_Input, by setting type() to one 
    of the following values:

          FL_NORMAL_INPUT		0
          FL_FLOAT_INPUT		1
          FL_INT_INPUT		2
          FL_MULTILINE_INPUT	4
          FL_SECRET_INPUT		5
          FL_INPUT_TYPE		7
          FL_INPUT_READONLY		8
          FL_NORMAL_OUTPUT		(FL_NORMAL_INPUT | FL_INPUT_READONLY)
          FL_MULTILINE_OUTPUT	(FL_MULTILINE_INPUT | FL_INPUT_READONLY)
          FL_INPUT_WRAP		16
          FL_MULTILINE_INPUT_WRAP	(FL_MULTILINE_INPUT | FL_INPUT_WRAP)
          FL_MULTILINE_OUTPUT_WRAP 	(FL_MULTILINE_INPUT | FL_INPUT_READONLY | FL_INPUT_WRAP)


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def resize(self, *args):
        r"""resize(Fl_Input_ self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Input__resize(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Input_ self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Input_"""
        if self.__class__ == Fl_Input_:
            _self = None
        else:
            _self = self
        _fltk.Fl_Input__swiginit(self, _fltk.new_Fl_Input_(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Input_")
        #print("Adding type: ", Fl_Input_)



    __swig_destroy__ = _fltk.delete_Fl_Input_

    def static_value(self, *args):
        r"""
        static_value(Fl_Input_ self, char const * arg2) -> int
        static_value(Fl_Input_ self, char const * arg2, int arg3) -> int
        """
        return _fltk.Fl_Input__static_value(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Input_ self, char const * arg2) -> int
        value(Fl_Input_ self, char const * arg2, int arg3) -> int
        value(Fl_Input_ self, int value) -> int
        value(Fl_Input_ self, double value) -> int
        value(Fl_Input_ self) -> char const *
        """
        return _fltk.Fl_Input__value(self, *args)

    def ivalue(self, *args):
        r"""ivalue(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__ivalue(self, *args)

    def dvalue(self, *args):
        r"""dvalue(Fl_Input_ self) -> double"""
        return _fltk.Fl_Input__dvalue(self, *args)

    def index(self, *args):
        r"""index(Fl_Input_ self, int i) -> unsigned int"""
        return _fltk.Fl_Input__index(self, *args)

    def size(self, *args):
        r"""
        size(Fl_Input_ self) -> int
        size(Fl_Input_ self, int W, int H)
        """
        return _fltk.Fl_Input__size(self, *args)

    def maximum_size(self, *args):
        r"""
        maximum_size(Fl_Input_ self) -> int
        maximum_size(Fl_Input_ self, int m)
        """
        return _fltk.Fl_Input__maximum_size(self, *args)

    def insert_position(self, *args):
        r"""
        insert_position(Fl_Input_ self) -> int
        insert_position(Fl_Input_ self, int p, int m) -> int
        insert_position(Fl_Input_ self, int p) -> int
        """
        return _fltk.Fl_Input__insert_position(self, *args)

    def mark(self, *args):
        r"""
        mark(Fl_Input_ self) -> int
        mark(Fl_Input_ self, int m) -> int
        """
        return _fltk.Fl_Input__mark(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Input_ self, int b, int e, char const * text, int ilen=0) -> int"""
        return _fltk.Fl_Input__replace(self, *args)

    def cut(self, *args):
        r"""
        cut(Fl_Input_ self) -> int
        cut(Fl_Input_ self, int n) -> int
        cut(Fl_Input_ self, int a, int b) -> int
        """
        return _fltk.Fl_Input__cut(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Input_ self, char const * t, int l=0) -> int"""
        return _fltk.Fl_Input__insert(self, *args)

    def append(self, *args):
        r"""append(Fl_Input_ self, char const * t, int l=0, char keep_selection=0) -> int"""
        return _fltk.Fl_Input__append(self, *args)

    def copy(self, *args):
        r"""copy(Fl_Input_ self, int clipboard) -> int"""
        return _fltk.Fl_Input__copy(self, *args)

    def undo(self, *args):
        r"""undo(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__undo(self, *args)

    def can_undo(self, *args):
        r"""can_undo(Fl_Input_ self) -> bool"""
        return _fltk.Fl_Input__can_undo(self, *args)

    def redo(self, *args):
        r"""redo(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__redo(self, *args)

    def can_redo(self, *args):
        r"""can_redo(Fl_Input_ self) -> bool"""
        return _fltk.Fl_Input__can_redo(self, *args)

    def copy_cuts(self, *args):
        r"""copy_cuts(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__copy_cuts(self, *args)

    def shortcut(self, *args):
        r"""
        shortcut(Fl_Input_ self) -> int
        shortcut(Fl_Input_ self, int s)
        """
        return _fltk.Fl_Input__shortcut(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Input_ self) -> Fl_Font
        textfont(Fl_Input_ self, Fl_Font s)
        """
        return _fltk.Fl_Input__textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Input_ self) -> Fl_Fontsize
        textsize(Fl_Input_ self, Fl_Fontsize s)
        """
        return _fltk.Fl_Input__textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Input_ self) -> Fl_Color
        textcolor(Fl_Input_ self, Fl_Color n)
        """
        return _fltk.Fl_Input__textcolor(self, *args)

    def cursor_color(self, *args):
        r"""
        cursor_color(Fl_Input_ self) -> Fl_Color
        cursor_color(Fl_Input_ self, Fl_Color n)
        """
        return _fltk.Fl_Input__cursor_color(self, *args)

    def input_type(self, *args):
        r"""
        input_type(Fl_Input_ self) -> int
        input_type(Fl_Input_ self, int t)
        """
        return _fltk.Fl_Input__input_type(self, *args)

    def readonly(self, *args):
        r"""
        readonly(Fl_Input_ self) -> int
        readonly(Fl_Input_ self, int b)
        """
        return _fltk.Fl_Input__readonly(self, *args)

    def wrap(self, *args):
        r"""
        wrap(Fl_Input_ self) -> int
        wrap(Fl_Input_ self, int b)
        """
        return _fltk.Fl_Input__wrap(self, *args)

    def tab_nav(self, *args):
        r"""
        tab_nav(Fl_Input_ self, int val)
        tab_nav(Fl_Input_ self) -> int
        """
        return _fltk.Fl_Input__tab_nav(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Input_ self, char * Fl_Input_)"""
        return _fltk.Fl_Input__init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_(self)
        return weakref.proxy(self)

# Register Fl_Input_ in _fltk:
_fltk.Fl_Input__swigregister(Fl_Input_)
class Fl_Input(Fl_Input_):
    r"""

    This is the FLTK text input widget. It displays a single line of text and 
    lets the user edit it. Normally it is drawn with an inset box and a white 
    background. The text may contain any characters (even 0), and will correctly 
    display anything, using ^X notation for unprintable control characters 
    and 
    nn notation for unprintable characters with the high bit set. It 
    assumes the font can draw any characters in the ISO-8859-1 character set.
    Mouse button 1	Moves the cursor to this point. Drag selects characters. 
    Double click selects words. Triple click selects all text. Shift+click 
    extends the selection. When you select text it is automatically copied 
    to the clipboard.
    Mouse button 2	Insert the clipboard at the point clicked. You can also 
    select a region and replace it with the clipboard by selecting the region 
    with mouse button 2.
    Mouse button 3	Currently acts like button 1.
    Backspace	Deletes one character to the left, or deletes the selected 
    region.
    Enter	May cause the callback, see when().
    ^A or Home	Go to start of line.
    ^B or Left	Move left
    ^C	Copy the selection to the clipboard
    ^D or Delete	Deletes one character to the right or deletes the selected 
    region.
    ^E or End	Go to the end of line.
    ^F or Right	Move right
    ^K	Delete to the end of line (next 
     character) or deletes a single 

    character. These deletions are all concatenated into the clipboard.
    ^N or Down	Move down (for Fl_Multiline_Input only, otherwise it moves
    to the next input field).
    ^P or Up	Move up (for Fl_Multiline_Input only, otherwise it moves to 
    the previous input field).
    ^U	Delete everything.
    ^V or ^Y	Paste the clipboard
    ^X or ^W	Copy the region to the clipboard and delete it.
    ^Z or ^_	Undo. This is a single-level undo mechanism, but all adjacent 
    deletions and insertions are concatenated into a single 'undo'. Often this 
    will undo a lot more than you expected.
    Shift+move	Move the cursor but also extend the selection.
    RightCtrl or
    Compose	Start a compose-character sequence. The next one or two keys typed 
    define the character to insert (see table that follows.)

    The character 'nbsp' (non-breaking space) is typed by using [compose][space].

    The single-character sequences may be followed by a space if necessary to 
    remove ambiguity. 

    The same key may be used to 'quote' control characters into the text. If you 
    need a ^Q character you can get one by typing [compose][Control+Q].

    X may have a key on the keyboard defined as XK_Multi_key. If so this key 
    may be used as well as the right-hand control key. You can set this up 
    with the program xmodmap.

    If your keyboard is set to support a foreign language you should also be 
    able to type 'dead key' prefix characters. On X you will actually be able 
    to see what dead key you typed, and if you then move the cursor without 
    completing the sequence the accent will remain inserted. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Input self)"""
        return _fltk.Fl_Input_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Input self, int arg0) -> int"""
        return _fltk.Fl_Input_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Input self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Input"""
        if self.__class__ == Fl_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Input_swiginit(self, _fltk.new_Fl_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Input")
        #print("Adding type: ", Fl_Input)




    def init_type(self, *args):
        r"""init_type(Fl_Input self, char * Fl_Input)"""
        return _fltk.Fl_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input(self)
        return weakref.proxy(self)

# Register Fl_Input in _fltk:
_fltk.Fl_Input_swigregister(Fl_Input)
class Fl_File_Input(Fl_Input):
    r"""

    This widget displays a pathname in a text input field. A navigation bar 
    located above the input field allows the user to navigate upward in the 
    directory tree.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_File_Input self, int X, int Y, int W, int H, char const * L=None) -> Fl_File_Input"""
        if self.__class__ == Fl_File_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_File_Input_swiginit(self, _fltk.new_Fl_File_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_File_Input")
        #print("Adding type: ", Fl_File_Input)




    def handle(self, *args):
        r"""handle(Fl_File_Input self, int event) -> int"""
        return _fltk.Fl_File_Input_handle(self, *args)

    def draw(self, *args):
        r"""draw(Fl_File_Input self)"""
        return _fltk.Fl_File_Input_draw(self, *args)

    def down_box(self, *args):
        r"""
        down_box(Fl_File_Input self) -> Fl_Boxtype
        down_box(Fl_File_Input self, Fl_Boxtype b)
        """
        return _fltk.Fl_File_Input_down_box(self, *args)

    def errorcolor(self, *args):
        r"""
        errorcolor(Fl_File_Input self) -> Fl_Color
        errorcolor(Fl_File_Input self, Fl_Color c)
        """
        return _fltk.Fl_File_Input_errorcolor(self, *args)

    def value(self, *args):
        r"""
        value(Fl_File_Input self, char const * str) -> int
        value(Fl_File_Input self, char const * str, int len) -> int
        value(Fl_File_Input self) -> char const *
        """
        return _fltk.Fl_File_Input_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_File_Input self, char * Fl_File_Input)"""
        return _fltk.Fl_File_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_File_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Input(self)
        return weakref.proxy(self)

# Register Fl_File_Input in _fltk:
_fltk.Fl_File_Input_swigregister(Fl_File_Input)
class Fl_Fill_Dial(Fl_Dial):
    r"""

    The Fl_Fill_Dial widget provides a filled, circular dial to control a single 
    floating point value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Fill_Dial self, int X, int Y, int W, int H, char const * L=None) -> Fl_Fill_Dial"""
        if self.__class__ == Fl_Fill_Dial:
            _self = None
        else:
            _self = self
        _fltk.Fl_Fill_Dial_swiginit(self, _fltk.new_Fl_Fill_Dial(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Fill_Dial")
        #print("Adding type: ", Fl_Fill_Dial)




    def init_type(self, *args):
        r"""init_type(Fl_Fill_Dial self, char * Fl_Fill_Dial)"""
        return _fltk.Fl_Fill_Dial_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Fill_Dial
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Dial(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Fill_Dial self)"""
        return _fltk.Fl_Fill_Dial_draw(self, *args)

# Register Fl_Fill_Dial in _fltk:
_fltk.Fl_Fill_Dial_swigregister(Fl_Fill_Dial)
FL_VERT_SLIDER = _fltk.FL_VERT_SLIDER

FL_HOR_SLIDER = _fltk.FL_HOR_SLIDER

FL_VERT_FILL_SLIDER = _fltk.FL_VERT_FILL_SLIDER

FL_HOR_FILL_SLIDER = _fltk.FL_HOR_FILL_SLIDER

FL_VERT_NICE_SLIDER = _fltk.FL_VERT_NICE_SLIDER

FL_HOR_NICE_SLIDER = _fltk.FL_HOR_NICE_SLIDER

class Fl_Slider(Fl_Valuator):
    r"""

    The Fl_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it 
    to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    TICKS_NONE = _fltk.Fl_Slider_TICKS_NONE
    
    TICKS_BELOW = _fltk.Fl_Slider_TICKS_BELOW
    
    TICKS_ABOVE = _fltk.Fl_Slider_TICKS_ABOVE
    
    TICKS_LEFT = _fltk.Fl_Slider_TICKS_LEFT
    
    TICKS_RIGHT = _fltk.Fl_Slider_TICKS_RIGHT
    
    LINEAR_SCALE = _fltk.Fl_Slider_LINEAR_SCALE
    
    LOG_SCALE = _fltk.Fl_Slider_LOG_SCALE
    

    def draw(self, *args):
        r"""draw(Fl_Slider self)"""
        return _fltk.Fl_Slider_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Slider self, int arg0) -> int"""
        return _fltk.Fl_Slider_handle(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Slider
        __init__(Fl_Slider self, uchar t, int X, int Y, int W, int H, char const * L) -> Fl_Slider
        """
        if self.__class__ == Fl_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Slider_swiginit(self, _fltk.new_Fl_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Slider")
        #print("Adding type: ", Fl_Slider)




    def scrollvalue(self, *args):
        r"""scrollvalue(Fl_Slider self, int pos, int size, int first, int total) -> int"""
        return _fltk.Fl_Slider_scrollvalue(self, *args)

    def bounds(self, *args):
        r"""bounds(Fl_Slider self, double a, double b)"""
        return _fltk.Fl_Slider_bounds(self, *args)

    def slider_size(self, *args):
        r"""
        slider_size(Fl_Slider self) -> float
        slider_size(Fl_Slider self, double v)
        """
        return _fltk.Fl_Slider_slider_size(self, *args)

    def slider(self, *args):
        r"""
        slider(Fl_Slider self) -> Fl_Boxtype
        slider(Fl_Slider self, Fl_Boxtype c)
        """
        return _fltk.Fl_Slider_slider(self, *args)

    def scale(self, *args):
        r"""
        scale(Fl_Slider self) -> Fl_Slider::Scale_Type
        scale(Fl_Slider self, Fl_Slider::Scale_Type s)
        """
        return _fltk.Fl_Slider_scale(self, *args)

    def num_ticks(self, *args):
        r"""num_ticks(Fl_Slider self) -> uchar"""
        return _fltk.Fl_Slider_num_ticks(self, *args)

    def ticks(self, *args):
        r"""
        ticks(Fl_Slider self) -> uchar
        ticks(Fl_Slider self, uchar t, uchar num_ticks=11)
        """
        return _fltk.Fl_Slider_ticks(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Slider self, char * Fl_Slider)"""
        return _fltk.Fl_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Slider(self)
        return weakref.proxy(self)

# Register Fl_Slider in _fltk:
_fltk.Fl_Slider_swigregister(Fl_Slider)
class Fl_Fill_Slider(Fl_Slider):
    r"""

    The Fl_Fill_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it to 
    the minimum(), and to the bottom/right to the maximum(). The minimum() may 
    be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Fill_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Fill_Slider"""
        if self.__class__ == Fl_Fill_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Fill_Slider_swiginit(self, _fltk.new_Fl_Fill_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Fill_Slider")
        #print("Adding type: ", Fl_Fill_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Fill_Slider self, char * Fl_Fill_Slider)"""
        return _fltk.Fl_Fill_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Fill_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Fill_Slider self)"""
        return _fltk.Fl_Fill_Slider_draw(self, *args)

# Register Fl_Fill_Slider in _fltk:
_fltk.Fl_Fill_Slider_swigregister(Fl_Fill_Slider)
class Fl_Flex(Fl_Group):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    VERTICAL = _fltk.Fl_Flex_VERTICAL
    
    HORIZONTAL = _fltk.Fl_Flex_HORIZONTAL
    
    COLUMN = _fltk.Fl_Flex_COLUMN
    
    ROW = _fltk.Fl_Flex_ROW
    

    def __init__(self, *args):
        r"""
        __init__(Fl_Flex self, int X, int Y, int W, int H, char const * L=None) -> Fl_Flex
        __init__(Fl_Flex self, int direction) -> Fl_Flex
        __init__(Fl_Flex self, int w, int h, int direction) -> Fl_Flex
        __init__(Fl_Flex self, int x, int y, int w, int h, int direction) -> Fl_Flex
        """
        if self.__class__ == Fl_Flex:
            _self = None
        else:
            _self = self
        _fltk.Fl_Flex_swiginit(self, _fltk.new_Fl_Flex(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Flex")
        #print("Adding type: ", Fl_Flex)



    __swig_destroy__ = _fltk.delete_Fl_Flex

    def end(self, *args):
        r"""end(Fl_Flex self)"""
        return _fltk.Fl_Flex_end(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Flex self, int x, int y, int w, int h)"""
        return _fltk.Fl_Flex_resize(self, *args)

    def fixed(self, *args):
        r"""
        fixed(Fl_Flex self, Fl_Widget w, int size)
        fixed(Fl_Flex self, Fl_Widget w, int size)
        fixed(Fl_Flex self, Fl_Widget w) -> int
        """
        return _fltk.Fl_Flex_fixed(self, *args)

    def alloc_size(self, *args):
        r"""alloc_size(Fl_Flex self, int size) -> int"""
        return _fltk.Fl_Flex_alloc_size(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Flex self)"""
        return _fltk.Fl_Flex_draw(self, *args)

    def need_layout(self, *args):
        r"""
        need_layout(Fl_Flex self, int set)
        need_layout(Fl_Flex self) -> bool
        """
        return _fltk.Fl_Flex_need_layout(self, *args)

    def margin(self, *args):
        r"""
        margin(Fl_Flex self) -> int
        margin(Fl_Flex self, int * left, int * top, int * right, int * bottom) -> int
        margin(Fl_Flex self, int m, int g=-1)
        margin(Fl_Flex self, int left, int top, int right, int bottom)
        """
        return _fltk.Fl_Flex_margin(self, *args)

    def gap(self, *args):
        r"""
        gap(Fl_Flex self) -> int
        gap(Fl_Flex self, int g)
        """
        return _fltk.Fl_Flex_gap(self, *args)

    def horizontal(self, *args):
        r"""horizontal(Fl_Flex self) -> int"""
        return _fltk.Fl_Flex_horizontal(self, *args)

    def layout(self, *args):
        r"""layout(Fl_Flex self)"""
        return _fltk.Fl_Flex_layout(self, *args)

    def spacing(self, *args):
        r"""
        spacing(Fl_Flex self) -> int
        spacing(Fl_Flex self, int i)
        """
        return _fltk.Fl_Flex_spacing(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Flex self, char * Fl_Flex)"""
        return _fltk.Fl_Flex_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Flex(self)
        return weakref.proxy(self)

# Register Fl_Flex in _fltk:
_fltk.Fl_Flex_swigregister(Fl_Flex)
class Fl_Float_Input(Fl_Input):
    r"""

    The Fl_Float_Input class is a subclass of Fl_Input  that only allows the 
    user to type floating point numbers (sign, digits, decimal point, more 
    digits, 'E' or 'e', sign, digits).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Float_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Float_Input"""
        if self.__class__ == Fl_Float_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Float_Input_swiginit(self, _fltk.new_Fl_Float_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Float_Input")
        #print("Adding type: ", Fl_Float_Input)




    def init_type(self, *args):
        r"""init_type(Fl_Float_Input self, char * Fl_Float_Input)"""
        return _fltk.Fl_Float_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Float_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Float_Input(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Float_Input self)"""
        return _fltk.Fl_Float_Input_draw(self, *args)

# Register Fl_Float_Input in _fltk:
_fltk.Fl_Float_Input_swigregister(Fl_Float_Input)
class Fl_Pixmap(Fl_Image):
    r"""

    The Fl_Pixmap class supports caching and drawing of colormap (pixmap) images, including transparency.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Pixmap self, char const *const * D) -> Fl_Pixmap"""
        if self.__class__ == Fl_Pixmap:
            _self = None
        else:
            _self = self
        _fltk.Fl_Pixmap_swiginit(self, _fltk.new_Fl_Pixmap(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Pixmap

    def copy(self, *args):
        r"""
        copy(Fl_Pixmap self, int W, int H) -> Fl_Image
        copy(Fl_Pixmap self) -> Fl_Image
        """
        return _fltk.Fl_Pixmap_copy(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_Pixmap self, Fl_Color c, float i)"""
        return _fltk.Fl_Pixmap_color_average(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_Pixmap self)"""
        return _fltk.Fl_Pixmap_desaturate(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_Pixmap self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Pixmap self, int X, int Y)
        """
        return _fltk.Fl_Pixmap_draw(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Pixmap self, Fl_Widget w)
        label(Fl_Pixmap self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Pixmap_label(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_Pixmap self)"""
        return _fltk.Fl_Pixmap_uncache(self, *args)

    def cache_w(self, *args):
        r"""cache_w(Fl_Pixmap self) -> int"""
        return _fltk.Fl_Pixmap_cache_w(self, *args)

    def cache_h(self, *args):
        r"""cache_h(Fl_Pixmap self) -> int"""
        return _fltk.Fl_Pixmap_cache_h(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pixmap(self)
        return weakref.proxy(self)

# Register Fl_Pixmap in _fltk:
_fltk.Fl_Pixmap_swigregister(Fl_Pixmap)
class Fl_Grid(Fl_Group):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Grid self, int X, int Y, int W, int H, char const * L=None) -> Fl_Grid"""
        if self.__class__ == Fl_Grid:
            _self = None
        else:
            _self = self
        _fltk.Fl_Grid_swiginit(self, _fltk.new_Fl_Grid(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Grid")
        #print("Adding type: ", Fl_Grid)



    __swig_destroy__ = _fltk.delete_Fl_Grid

    def layout(self, *args):
        r"""
        layout(Fl_Grid self, int rows, int cols, int margin=-1, int gap=-1)
        layout(Fl_Grid self)
        """
        return _fltk.Fl_Grid_layout(self, *args)

    def clear_layout(self, *args):
        r"""clear_layout(Fl_Grid self)"""
        return _fltk.Fl_Grid_clear_layout(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Grid self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Grid_resize(self, *args)

    def rows(self, *args):
        r"""rows(Fl_Grid self) -> short"""
        return _fltk.Fl_Grid_rows(self, *args)

    def cols(self, *args):
        r"""cols(Fl_Grid self) -> short"""
        return _fltk.Fl_Grid_cols(self, *args)

    def need_layout(self, *args):
        r"""
        need_layout(Fl_Grid self, int set)
        need_layout(Fl_Grid self) -> bool
        """
        return _fltk.Fl_Grid_need_layout(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Grid self)"""
        return _fltk.Fl_Grid_draw(self, *args)

    def draw_grid(self, *args):
        r"""draw_grid(Fl_Grid self)"""
        return _fltk.Fl_Grid_draw_grid(self, *args)

    def margin(self, *args):
        r"""
        margin(Fl_Grid self, int left, int top=-1, int right=-1, int bottom=-1)
        margin(Fl_Grid self, int * left, int * top, int * right, int * bottom) -> int
        """
        return _fltk.Fl_Grid_margin(self, *args)

    def gap(self, *args):
        r"""
        gap(Fl_Grid self, int row_gap, int col_gap=-1)
        gap(Fl_Grid self, int * row_gap, int * col_gap)
        """
        return _fltk.Fl_Grid_gap(self, *args)

    def cell(self, *args):
        r"""
        cell(Fl_Grid self, int row, int col) -> Fl_Grid::Cell
        cell(Fl_Grid self, Fl_Widget widget) -> Fl_Grid::Cell *
        """
        return _fltk.Fl_Grid_cell(self, *args)

    def widget(self, *args):
        r"""
        widget(Fl_Grid self, Fl_Widget wi, int row, int col, Fl_Grid_Align align=) -> Fl_Grid::Cell
        widget(Fl_Grid self, Fl_Widget wi, int row, int col, int rowspan, int colspan, Fl_Grid_Align align=) -> Fl_Grid::Cell *
        """
        return _fltk.Fl_Grid_widget(self, *args)

    def col_width(self, *args):
        r"""
        col_width(Fl_Grid self, int col, int value)
        col_width(Fl_Grid self, int const * value)
        col_width(Fl_Grid self, int col) -> int
        """
        return _fltk.Fl_Grid_col_width(self, *args)

    def col_weight(self, *args):
        r"""
        col_weight(Fl_Grid self, int col, int value)
        col_weight(Fl_Grid self, int const * value)
        col_weight(Fl_Grid self, int col) -> int
        """
        return _fltk.Fl_Grid_col_weight(self, *args)

    def col_gap(self, *args):
        r"""
        col_gap(Fl_Grid self, int col, int value)
        col_gap(Fl_Grid self, int const * value)
        col_gap(Fl_Grid self, int col) -> int
        """
        return _fltk.Fl_Grid_col_gap(self, *args)

    def row_height(self, *args):
        r"""
        row_height(Fl_Grid self, int row, int value)
        row_height(Fl_Grid self, int const * value)
        row_height(Fl_Grid self, int row) -> int
        """
        return _fltk.Fl_Grid_row_height(self, *args)

    def row_weight(self, *args):
        r"""
        row_weight(Fl_Grid self, int row, int value)
        row_weight(Fl_Grid self, int const * value)
        row_weight(Fl_Grid self, int row) -> int
        """
        return _fltk.Fl_Grid_row_weight(self, *args)

    def row_gap(self, *args):
        r"""
        row_gap(Fl_Grid self, int row, int value)
        row_gap(Fl_Grid self, int const * value)
        row_gap(Fl_Grid self, int row) -> int
        """
        return _fltk.Fl_Grid_row_gap(self, *args)

    def computed_col_width(self, *args):
        r"""computed_col_width(Fl_Grid self, int col) -> int"""
        return _fltk.Fl_Grid_computed_col_width(self, *args)

    def computed_row_height(self, *args):
        r"""computed_row_height(Fl_Grid self, int row) -> int"""
        return _fltk.Fl_Grid_computed_row_height(self, *args)

    def show_grid(self, *args):
        r"""
        show_grid(Fl_Grid self, int set)
        show_grid(Fl_Grid self, int set, Fl_Color col)
        """
        return _fltk.Fl_Grid_show_grid(self, *args)

    def debug(self, *args):
        r"""debug(Fl_Grid self, int level=127)"""
        return _fltk.Fl_Grid_debug(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Grid self, char * Fl_Grid)"""
        return _fltk.Fl_Grid_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Grid(self)
        return weakref.proxy(self)

# Register Fl_Grid in _fltk:
_fltk.Fl_Grid_swigregister(Fl_Grid)
class Fl_GIF_Image(Fl_Pixmap):
    r"""

    The Fl_GIF_Image class supports loading, caching, and drawing of Compuserve 
    GIF images. The class loads the first image and supports transparency.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def is_animated(*args):
        r"""is_animated(char const * name_) -> bool"""
        return _fltk.Fl_GIF_Image_is_animated(*args)

    def __init__(self, *args):
        r"""
        __init__(Fl_GIF_Image self, char const * filename) -> Fl_GIF_Image
        __init__(Fl_GIF_Image self, char const * imagename, unsigned char const * data) -> Fl_GIF_Image
        __init__(Fl_GIF_Image self, char const * imagename, unsigned char const * data, size_t const length) -> Fl_GIF_Image
        __init__(Fl_GIF_Image self, char const * filename, bool anim) -> Fl_GIF_Image
        __init__(Fl_GIF_Image self, char const * imagename, unsigned char const * data, size_t const length, bool anim) -> Fl_GIF_Image
        __init__(Fl_GIF_Image self) -> Fl_GIF_Image
        """
        if self.__class__ == Fl_GIF_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_GIF_Image_swiginit(self, _fltk.new_Fl_GIF_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_GIF_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_GIF_Image(self)
        return weakref.proxy(self)

# Register Fl_GIF_Image in _fltk:
_fltk.Fl_GIF_Image_swigregister(Fl_GIF_Image)
class Fl_Anim_GIF_Image(Fl_GIF_Image):
    r"""Proxy of C++ Fl_Anim_GIF_Image class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    DONT_START = _fltk.Fl_Anim_GIF_Image_DONT_START
    
    DONT_RESIZE_CANVAS = _fltk.Fl_Anim_GIF_Image_DONT_RESIZE_CANVAS
    
    DONT_SET_AS_IMAGE = _fltk.Fl_Anim_GIF_Image_DONT_SET_AS_IMAGE
    
    OPTIMIZE_MEMORY = _fltk.Fl_Anim_GIF_Image_OPTIMIZE_MEMORY
    
    LOG_FLAG = _fltk.Fl_Anim_GIF_Image_LOG_FLAG
    
    DEBUG_FLAG = _fltk.Fl_Anim_GIF_Image_DEBUG_FLAG
    

    def __init__(self, *args):
        r"""
        __init__(Fl_Anim_GIF_Image self, char const * filename, Fl_Widget canvas=None, unsigned short flags=0) -> Fl_Anim_GIF_Image
        __init__(Fl_Anim_GIF_Image self, char const * imagename, unsigned char const * data, size_t const length, Fl_Widget canvas=None, unsigned short flags=0) -> Fl_Anim_GIF_Image
        __init__(Fl_Anim_GIF_Image self) -> Fl_Anim_GIF_Image
        """
        if self.__class__ == Fl_Anim_GIF_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_Anim_GIF_Image_swiginit(self, _fltk.new_Fl_Anim_GIF_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Anim_GIF_Image

    def load(self, *args):
        r"""load(Fl_Anim_GIF_Image self, char const * name, unsigned char const * imgdata=None, size_t imglength=0) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_load(self, *args)

    def valid(self, *args):
        r"""valid(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_valid(self, *args)

    def frame_uncache(self, *args):
        r"""
        frame_uncache(Fl_Anim_GIF_Image self, bool uncache)
        frame_uncache(Fl_Anim_GIF_Image self) -> bool
        """
        return _fltk.Fl_Anim_GIF_Image_frame_uncache(self, *args)

    def delay(self, *args):
        r"""
        delay(Fl_Anim_GIF_Image self, int frame_) -> double
        delay(Fl_Anim_GIF_Image self, int frame, double delay)
        """
        return _fltk.Fl_Anim_GIF_Image_delay(self, *args)

    def canvas(self, *args):
        r"""
        canvas(Fl_Anim_GIF_Image self, Fl_Widget canvas, unsigned short flags=0)
        canvas(Fl_Anim_GIF_Image self) -> Fl_Widget
        """
        return _fltk.Fl_Anim_GIF_Image_canvas(self, *args)

    def canvas_w(self, *args):
        r"""canvas_w(Fl_Anim_GIF_Image self) -> int"""
        return _fltk.Fl_Anim_GIF_Image_canvas_w(self, *args)

    def canvas_h(self, *args):
        r"""canvas_h(Fl_Anim_GIF_Image self) -> int"""
        return _fltk.Fl_Anim_GIF_Image_canvas_h(self, *args)

    def is_animated(self, *args):
        r"""is_animated(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_is_animated(self, *args)

    def name(self, *args):
        r"""name(Fl_Anim_GIF_Image self) -> char const *"""
        return _fltk.Fl_Anim_GIF_Image_name(self, *args)

    def speed(self, *args):
        r"""
        speed(Fl_Anim_GIF_Image self, double speed)
        speed(Fl_Anim_GIF_Image self) -> double
        """
        return _fltk.Fl_Anim_GIF_Image_speed(self, *args)

    def frames(self, *args):
        r"""frames(Fl_Anim_GIF_Image self) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frames(self, *args)

    def frame(self, *args):
        r"""
        frame(Fl_Anim_GIF_Image self, int frame)
        frame(Fl_Anim_GIF_Image self) -> int
        """
        return _fltk.Fl_Anim_GIF_Image_frame(self, *args)

    def image(self, *args):
        r"""
        image(Fl_Anim_GIF_Image self) -> Fl_Image
        image(Fl_Anim_GIF_Image self, int frame) -> Fl_Image
        """
        return _fltk.Fl_Anim_GIF_Image_image(self, *args)

    def start(self, *args):
        r"""start(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_start(self, *args)

    def stop(self, *args):
        r"""stop(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_stop(self, *args)

    def next(self, *args):
        r"""next(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_next(self, *args)

    def playing(self, *args):
        r"""playing(Fl_Anim_GIF_Image self) -> bool"""
        return _fltk.Fl_Anim_GIF_Image_playing(self, *args)

    def resize(self, *args):
        r"""
        resize(Fl_Anim_GIF_Image self, int w, int h) -> Fl_Anim_GIF_Image
        resize(Fl_Anim_GIF_Image self, double scale) -> Fl_Anim_GIF_Image
        """
        return _fltk.Fl_Anim_GIF_Image_resize(self, *args)

    def frame_x(self, *args):
        r"""frame_x(Fl_Anim_GIF_Image self, int frame) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frame_x(self, *args)

    def frame_y(self, *args):
        r"""frame_y(Fl_Anim_GIF_Image self, int frame) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frame_y(self, *args)

    def frame_w(self, *args):
        r"""frame_w(Fl_Anim_GIF_Image self, int frame) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frame_w(self, *args)

    def frame_h(self, *args):
        r"""frame_h(Fl_Anim_GIF_Image self, int frame) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frame_h(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_Anim_GIF_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Anim_GIF_Image_color_average(self, *args)

    def copy(self, *args):
        r"""
        copy(Fl_Anim_GIF_Image self, int W, int H) -> Fl_Image
        copy(Fl_Anim_GIF_Image self) -> Fl_Image
        """
        return _fltk.Fl_Anim_GIF_Image_copy(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_Anim_GIF_Image self)"""
        return _fltk.Fl_Anim_GIF_Image_desaturate(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Anim_GIF_Image self, int x, int y, int w, int h, int cx=0, int cy=0)"""
        return _fltk.Fl_Anim_GIF_Image_draw(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_Anim_GIF_Image self)"""
        return _fltk.Fl_Anim_GIF_Image_uncache(self, *args)

    def debug(self, *args):
        r"""debug(Fl_Anim_GIF_Image self) -> int"""
        return _fltk.Fl_Anim_GIF_Image_debug(self, *args)

    @staticmethod
    def frame_count(*args):
        r"""frame_count(char const * name, unsigned char const * imgdata=None, size_t imglength=0) -> int"""
        return _fltk.Fl_Anim_GIF_Image_frame_count(*args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Anim_GIF_Image(self)
        return weakref.proxy(self)

# Register Fl_Anim_GIF_Image in _fltk:
_fltk.Fl_Anim_GIF_Image_swigregister(Fl_Anim_GIF_Image)
class Fl_ICO_Image(Fl_BMP_Image):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_ICO_Image self, char const * filename, int id=-1, unsigned char const * data=None, size_t const datasize=0) -> Fl_ICO_Image"""
        if self.__class__ == Fl_ICO_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_ICO_Image_swiginit(self, _fltk.new_Fl_ICO_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_ICO_Image

    def idcount(self, *args):
        r"""idcount(Fl_ICO_Image self) -> int"""
        return _fltk.Fl_ICO_Image_idcount(self, *args)

    def icondirentry(self, *args):
        r"""icondirentry(Fl_ICO_Image self) -> Fl_ICO_Image::IconDirEntry const *"""
        return _fltk.Fl_ICO_Image_icondirentry(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_ICO_Image(self)
        return weakref.proxy(self)

# Register Fl_ICO_Image in _fltk:
_fltk.Fl_ICO_Image_swigregister(Fl_ICO_Image)
class Fl_Image_Surface(Fl_Widget_Surface):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Image_Surface self, int w, int h, int high_res=0, Fl_Offscreen off=0) -> Fl_Image_Surface"""
        _fltk.Fl_Image_Surface_swiginit(self, _fltk.new_Fl_Image_Surface(*args))
    __swig_destroy__ = _fltk.delete_Fl_Image_Surface

    def set_current(self, *args):
        r"""set_current(Fl_Image_Surface self)"""
        return _fltk.Fl_Image_Surface_set_current(self, *args)

    def is_current(self, *args):
        r"""is_current(Fl_Image_Surface self) -> bool"""
        return _fltk.Fl_Image_Surface_is_current(self, *args)

    def image(self, *args):
        r"""image(Fl_Image_Surface self) -> Fl_RGB_Image"""
        return _fltk.Fl_Image_Surface_image(self, *args)

    def highres_image(self, *args):
        r"""highres_image(Fl_Image_Surface self) -> Fl_Shared_Image"""
        return _fltk.Fl_Image_Surface_highres_image(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_Image_Surface self, int * x, int * y)
        origin(Fl_Image_Surface self, int x, int y)
        """
        return _fltk.Fl_Image_Surface_origin(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_Image_Surface self, int * w, int * h) -> int"""
        return _fltk.Fl_Image_Surface_printable_rect(self, *args)

    def offscreen(self, *args):
        r"""offscreen(Fl_Image_Surface self) -> Fl_Offscreen"""
        return _fltk.Fl_Image_Surface_offscreen(self, *args)

    def rescale(self, *args):
        r"""rescale(Fl_Image_Surface self)"""
        return _fltk.Fl_Image_Surface_rescale(self, *args)

    def mask(self, *args):
        r"""mask(Fl_Image_Surface self, Fl_RGB_Image arg2)"""
        return _fltk.Fl_Image_Surface_mask(self, *args)

# Register Fl_Image_Surface in _fltk:
_fltk.Fl_Image_Surface_swigregister(Fl_Image_Surface)

def fl_strdup(*args):
    r"""fl_strdup(char const * s) -> char *"""
    return _fltk.fl_strdup(*args)

def fl_strlcpy(*args):
    r"""fl_strlcpy(char * arg1, char const * arg2, size_t arg3) -> size_t"""
    return _fltk.fl_strlcpy(*args)
class Fl_Gl_Window(Fl_Window):
    r"""

    The Fl_Gl_Window widget sets things up so OpenGL works, and also keeps an 
    OpenGL 'context' for that window, so that changes to the lighting and 
    projection may be reused between redraws. Fl_Gl_Window also flushes the 
    OpenGL streams and swaps buffers after draw()  returns.

    OpenGL hardware typically provides some overlay bit planes, which are very 
    useful for drawing UI controls atop your 3D graphics. If the overlay hardware 
    is not provided, FLTK tries to simulate the overlay, This works pretty well 
    if your graphics are double buffered, but not very well for single-buffered. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_draw(self, *args)

    def flush(self, *args):
        r"""flush(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_flush(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_hide(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Gl_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Gl_Window_resize(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Gl_Window self, int arg0) -> int"""
        return _fltk.Fl_Gl_Window_handle(self, *args)

    def valid(self, *args):
        r"""
        valid(Fl_Gl_Window self) -> char
        valid(Fl_Gl_Window self, char v)
        """
        return _fltk.Fl_Gl_Window_valid(self, *args)

    def invalidate(self, *args):
        r"""invalidate(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_invalidate(self, *args)

    def context_valid(self, *args):
        r"""
        context_valid(Fl_Gl_Window self) -> char
        context_valid(Fl_Gl_Window self, char v)
        """
        return _fltk.Fl_Gl_Window_context_valid(self, *args)

    def can_do(self, *args):
        r"""
        can_do(Fl_Gl_Window self, int m) -> int
        can_do(Fl_Gl_Window self, int const * m) -> int
        can_do(Fl_Gl_Window self) -> int
        """
        return _fltk.Fl_Gl_Window_can_do(self, *args)

    def mode(self, *args):
        r"""
        mode(Fl_Gl_Window self) -> Fl_Mode
        mode(Fl_Gl_Window self, int a) -> int
        mode(Fl_Gl_Window self, int const * a) -> int
        """
        return _fltk.Fl_Gl_Window_mode(self, *args)

    def context(self, *args):
        r"""
        context(Fl_Gl_Window self) -> GLContext
        context(Fl_Gl_Window self, GLContext arg2, int destroy_flag=0)
        """
        return _fltk.Fl_Gl_Window_context(self, *args)

    def make_current(self, *args):
        r"""make_current(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_make_current(self, *args)

    def swap_buffers(self, *args):
        r"""swap_buffers(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_swap_buffers(self, *args)

    def swap_interval(self, *args):
        r"""
        swap_interval(Fl_Gl_Window self, int arg2)
        swap_interval(Fl_Gl_Window self) -> int
        """
        return _fltk.Fl_Gl_Window_swap_interval(self, *args)

    def ortho(self, *args):
        r"""ortho(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_ortho(self, *args)

    def can_do_overlay(self, *args):
        r"""can_do_overlay(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_can_do_overlay(self, *args)

    def redraw_overlay(self, *args):
        r"""redraw_overlay(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_redraw_overlay(self, *args)

    def hide_overlay(self, *args):
        r"""hide_overlay(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_hide_overlay(self, *args)

    def make_overlay_current(self, *args):
        r"""make_overlay_current(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_make_overlay_current(self, *args)

    def as_gl_window(self, *args):
        r"""
        as_gl_window(Fl_Gl_Window self) -> Fl_Gl_Window
        as_gl_window(Fl_Gl_Window self) -> Fl_Gl_Window
        """
        return _fltk.Fl_Gl_Window_as_gl_window(self, *args)

    def pixels_per_unit(self, *args):
        r"""pixels_per_unit(Fl_Gl_Window self) -> float"""
        return _fltk.Fl_Gl_Window_pixels_per_unit(self, *args)

    def pixel_w(self, *args):
        r"""pixel_w(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_pixel_w(self, *args)

    def pixel_h(self, *args):
        r"""pixel_h(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_pixel_h(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Gl_Window

    def __init__(self, *args):
        r"""
        __init__(Fl_Gl_Window self, int W, int H, char const * l=None) -> Fl_Gl_Window
        __init__(Fl_Gl_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Gl_Window
        """
        if self.__class__ == Fl_Gl_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Gl_Window_swiginit(self, _fltk.new_Fl_Gl_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Gl_Window")
        #print("Adding type: ", Fl_Gl_Window)




    def init_type(self, *args):
        r"""init_type(Fl_Gl_Window self, char * Fl_Gl_Window)"""
        return _fltk.Fl_Gl_Window_init_type(self, *args)

    def show(self, *args):
        r"""show(Fl_Gl_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Gl_Window_show(self, *args)

    def drawPixels(self, *args):
        r"""
        drawPixels(Fl_Gl_Window self, PyObject * rgb_py)
        Writes a raw RGB string to the canvas.

        Arguments:
            - rgb - a string of width * height * 3 bytes, comprising
              the raw image in RGB format

        """
        return _fltk.Fl_Gl_Window_drawPixels(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Gl_Window(self)
        return weakref.proxy(self)

# Register Fl_Gl_Window in _fltk:
_fltk.Fl_Gl_Window_swigregister(Fl_Gl_Window)

def gl_start(*args):
    r"""gl_start()"""
    return _fltk.gl_start(*args)

def gl_finish(*args):
    r"""gl_finish()"""
    return _fltk.gl_finish(*args)

def gl_color(*args):
    r"""
    gl_color(Fl_Color i)
    gl_color(int c)
    """
    return _fltk.gl_color(*args)

def gl_rect(*args):
    r"""gl_rect(int x, int y, int w, int h)"""
    return _fltk.gl_rect(*args)

def gl_rectf(*args):
    r"""gl_rectf(int x, int y, int w, int h)"""
    return _fltk.gl_rectf(*args)

def gl_font(*args):
    r"""gl_font(int fontid, int size)"""
    return _fltk.gl_font(*args)

def gl_height(*args):
    r"""gl_height() -> int"""
    return _fltk.gl_height(*args)

def gl_descent(*args):
    r"""gl_descent() -> int"""
    return _fltk.gl_descent(*args)

def gl_width(*args):
    r"""
    gl_width(char const * arg1) -> double
    gl_width(char const * arg1, int n) -> double
    gl_width(uchar arg1) -> double
    """
    return _fltk.gl_width(*args)

def gl_draw(*args):
    r"""
    gl_draw(char const * arg1)
    gl_draw(char const * arg1, int n)
    gl_draw(char const * arg1, int x, int y)
    gl_draw(char const * arg1, float x, float y)
    gl_draw(char const * arg1, int n, int x, int y)
    gl_draw(char const * arg1, int n, float x, float y)
    gl_draw(char const * arg1, int x, int y, int w, int h, Fl_Align arg6)
    """
    return _fltk.gl_draw(*args)

def gl_measure(*args):
    r"""gl_measure(char const * arg1)"""
    return _fltk.gl_measure(*args)

def gl_texture_pile_height(*args):
    r"""
    gl_texture_pile_height(int max)
    gl_texture_pile_height() -> int
    """
    return _fltk.gl_texture_pile_height(*args)

def gl_texture_reset(*args):
    r"""gl_texture_reset()"""
    return _fltk.gl_texture_reset(*args)

def gl_draw_image(*args):
    r"""gl_draw_image(uchar const * arg1, int x, int y, int w, int h, int d=3, int ld=0)"""
    return _fltk.gl_draw_image(*args)
class Fl_Help_Dialog(object):
    r"""

    The Fl_Help_Dialog widget displays a standard help dialog window using the 
    Fl_Help_View widget.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Help_Dialog self) -> Fl_Help_Dialog"""
        _fltk.Fl_Help_Dialog_swiginit(self, _fltk.new_Fl_Help_Dialog(*args))
    __swig_destroy__ = _fltk.delete_Fl_Help_Dialog

    def h(self, *args):
        r"""h(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_h(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Help_Dialog self)"""
        return _fltk.Fl_Help_Dialog_hide(self, *args)

    def load(self, *args):
        r"""load(Fl_Help_Dialog self, char const * f) -> int"""
        return _fltk.Fl_Help_Dialog_load(self, *args)

    def position(self, *args):
        r"""position(Fl_Help_Dialog self, int xx, int yy)"""
        return _fltk.Fl_Help_Dialog_position(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Help_Dialog self, int xx, int yy, int ww, int hh)"""
        return _fltk.Fl_Help_Dialog_resize(self, *args)

    def show(self, *args):
        r"""
        show(Fl_Help_Dialog self)
        show(Fl_Help_Dialog self, int argc, char ** argv)
        """
        return _fltk.Fl_Help_Dialog_show(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Help_Dialog self, Fl_Fontsize s)
        textsize(Fl_Help_Dialog self) -> Fl_Fontsize
        """
        return _fltk.Fl_Help_Dialog_textsize(self, *args)

    def topline(self, *args):
        r"""
        topline(Fl_Help_Dialog self, char const * n)
        topline(Fl_Help_Dialog self, int n)
        """
        return _fltk.Fl_Help_Dialog_topline(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Help_Dialog self, char const * f)
        value(Fl_Help_Dialog self) -> char const *
        """
        return _fltk.Fl_Help_Dialog_value(self, *args)

    def visible(self, *args):
        r"""visible(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_visible(self, *args)

    def w(self, *args):
        r"""w(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_w(self, *args)

    def x(self, *args):
        r"""x(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_x(self, *args)

    def y(self, *args):
        r"""y(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_y(self, *args)

# Register Fl_Help_Dialog in _fltk:
_fltk.Fl_Help_Dialog_swigregister(Fl_Help_Dialog)
class Fl_Help_View(Fl_Group):
    r"""

    The Fl_Help_View widget displays HTML text. Most HTML 2.0 elements are 
    supported, as well as a primitive implementation of tables. GIF, JPEG, 
    and PNG images are displayed inline.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Help_View self, int xx, int yy, int ww, int hh, char const * l=None) -> Fl_Help_View"""
        if self.__class__ == Fl_Help_View:
            _self = None
        else:
            _self = self
        _fltk.Fl_Help_View_swiginit(self, _fltk.new_Fl_Help_View(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Help_View")
        #print("Adding type: ", Fl_Help_View)



    __swig_destroy__ = _fltk.delete_Fl_Help_View

    def handle(self, *args):
        r"""handle(Fl_Help_View self, int arg0) -> int"""
        return _fltk.Fl_Help_View_handle(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Help_View self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Help_View_resize(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Help_View self, char const * val)
        value(Fl_Help_View self) -> char const *
        """
        return _fltk.Fl_Help_View_value(self, *args)

    def load(self, *args):
        r"""load(Fl_Help_View self, char const * f) -> int"""
        return _fltk.Fl_Help_View_load(self, *args)

    def find(self, *args):
        r"""find(Fl_Help_View self, char const * s, int p=0) -> int"""
        return _fltk.Fl_Help_View_find(self, *args)

    def filename(self, *args):
        r"""filename(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_filename(self, *args)

    def directory(self, *args):
        r"""directory(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_directory(self, *args)

    def title(self, *args):
        r"""title(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_title(self, *args)

    def size(self, *args):
        r"""
        size(Fl_Help_View self, int W, int H)
        size(Fl_Help_View self) -> int
        """
        return _fltk.Fl_Help_View_size(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Help_View self, Fl_Color c)
        textcolor(Fl_Help_View self) -> Fl_Color
        """
        return _fltk.Fl_Help_View_textcolor(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Help_View self, Fl_Font f)
        textfont(Fl_Help_View self) -> Fl_Font
        """
        return _fltk.Fl_Help_View_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Help_View self, Fl_Fontsize s)
        textsize(Fl_Help_View self) -> Fl_Fontsize
        """
        return _fltk.Fl_Help_View_textsize(self, *args)

    def topline(self, *args):
        r"""
        topline(Fl_Help_View self, char const * n)
        topline(Fl_Help_View self, int arg2)
        topline(Fl_Help_View self) -> int
        """
        return _fltk.Fl_Help_View_topline(self, *args)

    def leftline(self, *args):
        r"""
        leftline(Fl_Help_View self, int arg2)
        leftline(Fl_Help_View self) -> int
        """
        return _fltk.Fl_Help_View_leftline(self, *args)

    def clear_selection(self, *args):
        r"""clear_selection(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_clear_selection(self, *args)

    def select_all(self, *args):
        r"""select_all(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_select_all(self, *args)

    def text_selected(self, *args):
        r"""text_selected(Fl_Help_View self) -> int"""
        return _fltk.Fl_Help_View_text_selected(self, *args)

    def copy(self, *args):
        r"""copy(Fl_Help_View self, int clipboard=1) -> int"""
        return _fltk.Fl_Help_View_copy(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Help_View self) -> int
        scrollbar_size(Fl_Help_View self, int newSize)
        """
        return _fltk.Fl_Help_View_scrollbar_size(self, *args)

    def scrollbar(self, *args):
        r"""scrollbar(Fl_Help_View self) -> Fl_Scrollbar"""
        return _fltk.Fl_Help_View_scrollbar(self, *args)

    def hscrollbar(self, *args):
        r"""hscrollbar(Fl_Help_View self) -> Fl_Scrollbar"""
        return _fltk.Fl_Help_View_hscrollbar(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Help_View self, char * Fl_Help_View)"""
        return _fltk.Fl_Help_View_init_type(self, *args)

    def link(self, *args):
        r"""
        link(Fl_Help_View self, Fl_Help_Func * fn)
        link(Fl_Help_View self, PyObject * PyFunc, PyObject * PyWidget)
        """
        return _fltk.Fl_Help_View_link(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Help_View(self)
        return weakref.proxy(self)

# Register Fl_Help_View in _fltk:
_fltk.Fl_Help_View_swigregister(Fl_Help_View)
class Fl_Hold_Browser(Fl_Browser):
    r"""

    The Fl_Hold_Browser class is a subclass of Fl_Browser  which lets the user 
    select a single item, or no items by clicking on the empty space. As long 
    as the mouse button is held down the item pointed to by it is highlighted, 
    and this highlighting remains on when the mouse button is released. Normally 
    the callback is done when the user releases the mouse, but you can change 
    this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Hold_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hold_Browser"""
        if self.__class__ == Fl_Hold_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Hold_Browser_swiginit(self, _fltk.new_Fl_Hold_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Hold_Browser")
        #print("Adding type: ", Fl_Hold_Browser)




    def init_type(self, *args):
        r"""init_type(Fl_Hold_Browser self, char * Fl_Hold_Browser)"""
        return _fltk.Fl_Hold_Browser_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Hold_Browser
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hold_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Hold_Browser self)"""
        return _fltk.Fl_Hold_Browser_draw(self, *args)

    def item_first(self, *args):
        r"""item_first(Fl_Hold_Browser self) -> void *"""
        return _fltk.Fl_Hold_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Hold_Browser self, void * item) -> void *"""
        return _fltk.Fl_Hold_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Hold_Browser self, void * item) -> void *"""
        return _fltk.Fl_Hold_Browser_item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Hold_Browser self) -> void *"""
        return _fltk.Fl_Hold_Browser_item_last(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Hold_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Hold_Browser_item_draw(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Hold_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Hold_Browser_item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_Hold_Browser self, void * a, void * b)"""
        return _fltk.Fl_Hold_Browser_item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Hold_Browser self, int line) -> void *"""
        return _fltk.Fl_Hold_Browser_item_at(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_incr_height(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Hold_Browser self, void * item, int val)"""
        return _fltk.Fl_Hold_Browser_item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_selected(self, *args)

# Register Fl_Hold_Browser in _fltk:
_fltk.Fl_Hold_Browser_swigregister(Fl_Hold_Browser)
class Fl_Hor_Fill_Slider(Fl_Slider):
    r"""

    The Fl_Hor_Fill_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Hor_Fill_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hor_Fill_Slider"""
        if self.__class__ == Fl_Hor_Fill_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Hor_Fill_Slider_swiginit(self, _fltk.new_Fl_Hor_Fill_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Hor_Fill_Slider")
        #print("Adding type: ", Fl_Hor_Fill_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Hor_Fill_Slider self, char * Fl_Hor_Fill_Slider)"""
        return _fltk.Fl_Hor_Fill_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Hor_Fill_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Fill_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Hor_Fill_Slider self)"""
        return _fltk.Fl_Hor_Fill_Slider_draw(self, *args)

# Register Fl_Hor_Fill_Slider in _fltk:
_fltk.Fl_Hor_Fill_Slider_swigregister(Fl_Hor_Fill_Slider)
class Fl_Hor_Nice_Slider(Fl_Slider):
    r"""

    The Fl_Hor_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Hor_Nice_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hor_Nice_Slider"""
        if self.__class__ == Fl_Hor_Nice_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Hor_Nice_Slider_swiginit(self, _fltk.new_Fl_Hor_Nice_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Hor_Nice_Slider")
        #print("Adding type: ", Fl_Hor_Nice_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Hor_Nice_Slider self, char * Fl_Hor_Nice_Slider)"""
        return _fltk.Fl_Hor_Nice_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Hor_Nice_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Nice_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Hor_Nice_Slider self)"""
        return _fltk.Fl_Hor_Nice_Slider_draw(self, *args)

# Register Fl_Hor_Nice_Slider in _fltk:
_fltk.Fl_Hor_Nice_Slider_swigregister(Fl_Hor_Nice_Slider)
class Fl_Hor_Slider(Fl_Slider):
    r"""

    The Fl_Hor_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Hor_Slider self, int X, int Y, int W, int H, char const * l=None) -> Fl_Hor_Slider"""
        if self.__class__ == Fl_Hor_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Hor_Slider_swiginit(self, _fltk.new_Fl_Hor_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Hor_Slider")
        #print("Adding type: ", Fl_Hor_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Hor_Slider self, char * Fl_Hor_Slider)"""
        return _fltk.Fl_Hor_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Hor_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Hor_Slider self)"""
        return _fltk.Fl_Hor_Slider_draw(self, *args)

# Register Fl_Hor_Slider in _fltk:
_fltk.Fl_Hor_Slider_swigregister(Fl_Hor_Slider)
class Fl_Value_Slider(Fl_Slider):
    r"""

    The Fl_Value_Slider widget is a Fl_Slider widget with a box displaying 
    the current value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Value_Slider self)"""
        return _fltk.Fl_Value_Slider_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Value_Slider self, int arg0) -> int"""
        return _fltk.Fl_Value_Slider_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Value_Slider self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Slider"""
        if self.__class__ == Fl_Value_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Value_Slider_swiginit(self, _fltk.new_Fl_Value_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Value_Slider")
        #print("Adding type: ", Fl_Value_Slider)




    def textfont(self, *args):
        r"""
        textfont(Fl_Value_Slider self) -> Fl_Font
        textfont(Fl_Value_Slider self, Fl_Font s)
        """
        return _fltk.Fl_Value_Slider_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Value_Slider self) -> Fl_Fontsize
        textsize(Fl_Value_Slider self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Slider_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Value_Slider self) -> Fl_Color
        textcolor(Fl_Value_Slider self, Fl_Color s)
        """
        return _fltk.Fl_Value_Slider_textcolor(self, *args)

    def value_width(self, *args):
        r"""
        value_width(Fl_Value_Slider self, int s)
        value_width(Fl_Value_Slider self) -> int
        """
        return _fltk.Fl_Value_Slider_value_width(self, *args)

    def value_height(self, *args):
        r"""
        value_height(Fl_Value_Slider self, int s)
        value_height(Fl_Value_Slider self) -> int
        """
        return _fltk.Fl_Value_Slider_value_height(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Value_Slider self, char * Fl_Value_Slider)"""
        return _fltk.Fl_Value_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Value_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Slider(self)
        return weakref.proxy(self)

# Register Fl_Value_Slider in _fltk:
_fltk.Fl_Value_Slider_swigregister(Fl_Value_Slider)
class Fl_Hor_Value_Slider(Fl_Value_Slider):
    r"""

    The Fl_Hor_Value_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Hor_Value_Slider self, int X, int Y, int W, int H, char const * l=None) -> Fl_Hor_Value_Slider"""
        if self.__class__ == Fl_Hor_Value_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Hor_Value_Slider_swiginit(self, _fltk.new_Fl_Hor_Value_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Hor_Value_Slider")
        #print("Adding type: ", Fl_Hor_Value_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Hor_Value_Slider self, char * Fl_Hor_Value_Slider)"""
        return _fltk.Fl_Hor_Value_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Hor_Value_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Value_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Hor_Value_Slider self)"""
        return _fltk.Fl_Hor_Value_Slider_draw(self, *args)

# Register Fl_Hor_Value_Slider in _fltk:
_fltk.Fl_Hor_Value_Slider_swigregister(Fl_Hor_Value_Slider)
class Fl_Int_Input(Fl_Input):
    r"""

    The Fl_Int_Input class is a subclass of Fl_Input  that only allows the user 
    to type decimal digits (or hex numbers of the form 0xaef).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Int_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Int_Input"""
        if self.__class__ == Fl_Int_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Int_Input_swiginit(self, _fltk.new_Fl_Int_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Int_Input")
        #print("Adding type: ", Fl_Int_Input)




    def init_type(self, *args):
        r"""init_type(Fl_Int_Input self, char * Fl_Int_Input)"""
        return _fltk.Fl_Int_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Int_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Int_Input(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Int_Input self)"""
        return _fltk.Fl_Int_Input_draw(self, *args)

# Register Fl_Int_Input in _fltk:
_fltk.Fl_Int_Input_swigregister(Fl_Int_Input)
class Fl_Input_Choice(Fl_Group):
    r"""

    A combination of the input widget and a menu button. The user can either 
    type into the input area, or use the menu button chooser on the right, 
    which loads the input area with predefined text. Normally it is drawn with 
    an inset box and a white background.

    The application can directly access both the input and menu widgets directly, 
    using the menubutton() and input() accessor methods. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def inp_x(self, *args):
        r"""inp_x(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_inp_x(self, *args)

    def inp_y(self, *args):
        r"""inp_y(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_inp_y(self, *args)

    def inp_w(self, *args):
        r"""inp_w(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_inp_w(self, *args)

    def inp_h(self, *args):
        r"""inp_h(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_inp_h(self, *args)

    def menu_x(self, *args):
        r"""menu_x(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_menu_x(self, *args)

    def menu_y(self, *args):
        r"""menu_y(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_menu_y(self, *args)

    def menu_w(self, *args):
        r"""menu_w(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_menu_w(self, *args)

    def menu_h(self, *args):
        r"""menu_h(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_menu_h(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Input_Choice self, int X, int Y, int W, int H, char const * L=None) -> Fl_Input_Choice"""
        if self.__class__ == Fl_Input_Choice:
            _self = None
        else:
            _self = self
        _fltk.Fl_Input_Choice_swiginit(self, _fltk.new_Fl_Input_Choice(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Input_Choice")
        #print("Adding type: ", Fl_Input_Choice)




    def resize(self, *args):
        r"""resize(Fl_Input_Choice self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Input_Choice_resize(self, *args)

    def add(self, *args):
        r"""add(Fl_Input_Choice self, char const * s)"""
        val = _fltk.Fl_Input_Choice_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def changed(self, *args):
        r"""changed(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_changed(self, *args)

    def clear_changed(self, *args):
        r"""clear_changed(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_clear_changed(self, *args)

    def set_changed(self, *args):
        r"""set_changed(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_set_changed(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_clear(self, *args)

    def down_box(self, *args):
        r"""
        down_box(Fl_Input_Choice self) -> Fl_Boxtype
        down_box(Fl_Input_Choice self, Fl_Boxtype b)
        """
        return _fltk.Fl_Input_Choice_down_box(self, *args)

    def menu(self, *args):
        r"""
        menu(Fl_Input_Choice self) -> Fl_Menu_Item
        menu(Fl_Input_Choice self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Input_Choice_menu(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Input_Choice self) -> Fl_Color
        textcolor(Fl_Input_Choice self, Fl_Color c)
        """
        return _fltk.Fl_Input_Choice_textcolor(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Input_Choice self) -> Fl_Font
        textfont(Fl_Input_Choice self, Fl_Font f)
        """
        return _fltk.Fl_Input_Choice_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Input_Choice self) -> Fl_Fontsize
        textsize(Fl_Input_Choice self, Fl_Fontsize s)
        """
        return _fltk.Fl_Input_Choice_textsize(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Input_Choice self) -> char const
        value(Fl_Input_Choice self, char const * val)
        value(Fl_Input_Choice self, int val)
        """
        return _fltk.Fl_Input_Choice_value(self, *args)

    def update_menubutton(self, *args):
        r"""update_menubutton(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_update_menubutton(self, *args)

    def menubutton(self, *args):
        r"""menubutton(Fl_Input_Choice self) -> Fl_Menu_Button"""
        return _fltk.Fl_Input_Choice_menubutton(self, *args)

    def input(self, *args):
        r"""input(Fl_Input_Choice self) -> Fl_Input"""
        return _fltk.Fl_Input_Choice_input(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Input_Choice self, char * Fl_Input_Choice)"""
        return _fltk.Fl_Input_Choice_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Input_Choice
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_Choice(self)
        return weakref.proxy(self)

# Register Fl_Input_Choice in _fltk:
_fltk.Fl_Input_Choice_swigregister(Fl_Input_Choice)
class Fl_JPEG_Image(Fl_RGB_Image):
    r"""

    The Fl_JPEG_Image class supports loading, caching, and drawing of Joint 
    Photographic Experts Group (JPEG) File Interchange Format (JFIF) images. 
    The class supports grayscale and color (RGB) JPEG image files.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_JPEG_Image self, char const * filename) -> Fl_JPEG_Image
        __init__(Fl_JPEG_Image self, char const * name, unsigned char const * data, int data_length=-1) -> Fl_JPEG_Image
        """
        if self.__class__ == Fl_JPEG_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_JPEG_Image_swiginit(self, _fltk.new_Fl_JPEG_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_JPEG_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_JPEG_Image(self)
        return weakref.proxy(self)

# Register Fl_JPEG_Image in _fltk:
_fltk.Fl_JPEG_Image_swigregister(Fl_JPEG_Image)
class Fl_Line_Dial(Fl_Dial):
    r"""

    The Fl_Line_Dial widget provides a circular dial to control a single 
    floating point value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Line_Dial self, int X, int Y, int W, int H, char const * L=None) -> Fl_Line_Dial"""
        if self.__class__ == Fl_Line_Dial:
            _self = None
        else:
            _self = self
        _fltk.Fl_Line_Dial_swiginit(self, _fltk.new_Fl_Line_Dial(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Line_Dial")
        #print("Adding type: ", Fl_Line_Dial)




    def init_type(self, *args):
        r"""init_type(Fl_Line_Dial self, char * Fl_Line_Dial)"""
        return _fltk.Fl_Line_Dial_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Line_Dial
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Line_Dial(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Line_Dial self)"""
        return _fltk.Fl_Line_Dial_draw(self, *args)

# Register Fl_Line_Dial in _fltk:
_fltk.Fl_Line_Dial_swigregister(Fl_Line_Dial)
class Fl_Menu_Bar(Fl_Menu_):
    r"""

    This widget provides a standard menubar interface. Usually you will put 
    this widget along the top edge of your window. The height of the widget 
    should be 30 for the menu titles to draw correctly with the default font.

    The items on the bar and the menus they bring up are defined by a single 
    Fl_Menu_Item array. Because a Fl_Menu_Item array defines a hierarchy, the 
    top level menu defines the items in the menubar, while the submenus define 
    the pull-down menus. Sub-sub menus and lower pop up to the right of the 
    submenus.

    If there is an item in the top menu that is not a title of a submenu, then 
    it acts like a 'button' in the menubar. Clicking on it will pick it.

    When the user picks an item off the menu, the item's callback is done with 
    the menubar as the Fl_Widget* argument. If the item does not have a callback 
    the menubar's callback is done instead.

    Submenus will also pop up in response to shortcuts indicated by putting 
    a '&' character in the name field of the menu item. If you put a '&' 
    character in a top-level 'button' then the shortcut picks it. The '&' 
    character in submenus is ignored until the menu is popped up.

    Typing the shortcut() of any of the menu items will cause callbacks 
    exactly the same as when you pick the item with the mouse. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Menu_Bar self)"""
        return _fltk.Fl_Menu_Bar_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Menu_Bar self, int arg0) -> int"""
        return _fltk.Fl_Menu_Bar_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Menu_Bar self, int X, int Y, int W, int H, char const * l=None) -> Fl_Menu_Bar"""
        if self.__class__ == Fl_Menu_Bar:
            _self = None
        else:
            _self = self
        _fltk.Fl_Menu_Bar_swiginit(self, _fltk.new_Fl_Menu_Bar(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Menu_Bar")
        #print("Adding type: ", Fl_Menu_Bar)




    def update(self, *args):
        r"""update(Fl_Menu_Bar self)"""
        return _fltk.Fl_Menu_Bar_update(self, *args)

    def play_menu(self, *args):
        r"""play_menu(Fl_Menu_Bar self, Fl_Menu_Item item)"""
        return _fltk.Fl_Menu_Bar_play_menu(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Menu_Bar self, char * Fl_Menu_Bar)"""
        return _fltk.Fl_Menu_Bar_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Menu_Bar
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Bar(self)
        return weakref.proxy(self)

# Register Fl_Menu_Bar in _fltk:
_fltk.Fl_Menu_Bar_swigregister(Fl_Menu_Bar)
class Fl_Menu_Button(Fl_Menu_):
    r"""

    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects.

    Fl_Menu_Button widget.

    Normally any mouse button will pop up a menu and it is lined up below the 
    button as shown in the picture. However an Fl_Menu_Button may also control 
    a pop-up menu. This is done by setting the type() , see below.

    The menu will also pop up in response to shortcuts indicated by putting 
    a '&' character in the label().

    Typing the shortcut() of any of the menu items will cause callbacks exactly 
    the same as when you pick the item with the mouse. The '&' character in menu 
    item names are only looked at when the menu is popped up, however.

    When the user picks an item off the menu, the item's callback is done with 
    the menu_button as the Fl_Widget* argument. If the item does not have a 
    callback the menu_button's callback is done instead. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Menu_Button self)"""
        return _fltk.Fl_Menu_Button_draw(self, *args)
    POPUP1 = _fltk.Fl_Menu_Button_POPUP1
    
    POPUP2 = _fltk.Fl_Menu_Button_POPUP2
    
    POPUP12 = _fltk.Fl_Menu_Button_POPUP12
    
    POPUP3 = _fltk.Fl_Menu_Button_POPUP3
    
    POPUP13 = _fltk.Fl_Menu_Button_POPUP13
    
    POPUP23 = _fltk.Fl_Menu_Button_POPUP23
    
    POPUP123 = _fltk.Fl_Menu_Button_POPUP123
    

    def handle(self, *args):
        r"""handle(Fl_Menu_Button self, int arg0) -> int"""
        return _fltk.Fl_Menu_Button_handle(self, *args)

    def popup(self, *args):
        r"""popup(Fl_Menu_Button self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Button_popup(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Menu_Button self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Menu_Button"""
        if self.__class__ == Fl_Menu_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Menu_Button_swiginit(self, _fltk.new_Fl_Menu_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Menu_Button")
        #print("Adding type: ", Fl_Menu_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Menu_Button self, char * Fl_Menu_Button)"""
        return _fltk.Fl_Menu_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Menu_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Button(self)
        return weakref.proxy(self)

# Register Fl_Menu_Button in _fltk:
_fltk.Fl_Menu_Button_swigregister(Fl_Menu_Button)
FL_MENU_INACTIVE = _fltk.FL_MENU_INACTIVE

FL_MENU_TOGGLE = _fltk.FL_MENU_TOGGLE

FL_MENU_VALUE = _fltk.FL_MENU_VALUE

FL_MENU_RADIO = _fltk.FL_MENU_RADIO

FL_MENU_INVISIBLE = _fltk.FL_MENU_INVISIBLE

FL_SUBMENU_POINTER = _fltk.FL_SUBMENU_POINTER

FL_SUBMENU = _fltk.FL_SUBMENU

FL_MENU_DIVIDER = _fltk.FL_MENU_DIVIDER

FL_MENU_HORIZONTAL = _fltk.FL_MENU_HORIZONTAL

FL_MENU_CHATTY = _fltk.FL_MENU_CHATTY

FL_MENU_HEADLINE = _fltk.FL_MENU_HEADLINE

class Fl_Menu_Item(object):
    r"""

    The Fl_Menu_Item structure defines a single menu item that is used by the 
    Fl_Menu_ class. This structure is defined as

          Fl_Menu_Item :
            text 		-> character array # label()
            shortcut_ 	-> unsigned long
            callback_	-> Fl_Callback
            user_data_	
            flags		-> int
            labeltype_	-> unsigned character
            labelfont_	-> unsigned character
            labelsize_	-> unsigned character
            labelcolor_	-> unsigned character


          enum: # values for flags:
            FL_MENU_INACTIVE	= 1,
            FL_MENU_TOGGLE		= 2,
            FL_MENU_VALUE		= 4,
            FL_MENU_RADIO		= 8,
            FL_MENU_INVISIBLE	= 0x10,
            FL_SUBMENU_POINTER	= 0x20,
            FL_SUBMENU		= 0x40,
            FL_MENU_DIVIDER		= 0x80,
            FL_MENU_HORIZONTAL	= 0x100


    Typically menu items are statically defined; for example:

          MenuTable = (
            ('&alpha',   FL_ALT+ord('a'), the_cb, 1),
            ('&beta',    FL_ALT+ord('b'), the_cb, 2),
            ('gamma',    FL_ALT+ord('c'), the_cb, 3, FL_MENU_DIVIDER),
            ('&strange',  0,   strange_cb),
            ('&charm',    0,   charm_cb),
            ('&truth',    0,   truth_cb),
            ('b&eauty',   0,   beauty_cb),
            ('sub&menu',	0,   0, 0, FL_SUBMENU),
              ('one'),
              ('two'),
              ('three'),
            (None,),
            ('inactive', FL_ALT+'i', 0, 0, FL_MENU_INACTIVE|FL_MENU_DIVIDER),
            ('invisible',FL_ALT+'i', 0, 0, FL_MENU_INVISIBLE),
            ('check',    FL_ALT+'i', 0, 0, FL_MENU_TOGGLE|FL_MENU_VALUE),
            ('box',      FL_ALT+'i', 0, 0, FL_MENU_TOGGLE),
          (None,);

    A submenu title is identified by the bit FL_SUBMENU in the flags field, 
    and ends with a label() that is NULL. You can nest menus to any depth. A 
    pointer to the first item in the submenu can be treated as an Fl_Menu array 
    itself. It is also possible to make seperate submenu arrays with 
    FL_SUBMENU_POINTER flags.

    You should use the method functions to access structure members and not 
    access them directly to avoid compatibility problems with future releases 
    of FLTK. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def next(self, *args):
        r"""
        next(Fl_Menu_Item self, int arg2=1) -> Fl_Menu_Item
        next(Fl_Menu_Item self, int i=1) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_next(self, *args)

    def first(self, *args):
        r"""
        first(Fl_Menu_Item self) -> Fl_Menu_Item
        first(Fl_Menu_Item self) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_first(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Menu_Item self) -> char const
        label(Fl_Menu_Item self, char const * a)
        label(Fl_Menu_Item self, Fl_Labeltype a, char const * b)
        """
        return _fltk.Fl_Menu_Item_label(self, *args)

    def multi_label(self, *args):
        r"""multi_label(Fl_Menu_Item self, Fl_Multi_Label ml)"""
        return _fltk.Fl_Menu_Item_multi_label(self, *args)

    def image_label(self, *args):
        r"""image_label(Fl_Menu_Item self, Fl_Image image)"""
        return _fltk.Fl_Menu_Item_image_label(self, *args)

    def labeltype(self, *args):
        r"""
        labeltype(Fl_Menu_Item self) -> Fl_Labeltype
        labeltype(Fl_Menu_Item self, Fl_Labeltype a)
        """
        return _fltk.Fl_Menu_Item_labeltype(self, *args)

    def labelcolor(self, *args):
        r"""
        labelcolor(Fl_Menu_Item self) -> Fl_Color
        labelcolor(Fl_Menu_Item self, Fl_Color a)
        """
        return _fltk.Fl_Menu_Item_labelcolor(self, *args)

    def labelfont(self, *args):
        r"""
        labelfont(Fl_Menu_Item self) -> Fl_Font
        labelfont(Fl_Menu_Item self, Fl_Font a)
        """
        return _fltk.Fl_Menu_Item_labelfont(self, *args)

    def labelsize(self, *args):
        r"""
        labelsize(Fl_Menu_Item self) -> Fl_Fontsize
        labelsize(Fl_Menu_Item self, Fl_Fontsize a)
        """
        return _fltk.Fl_Menu_Item_labelsize(self, *args)

    def argument(self, *args):
        r"""
        argument(Fl_Menu_Item self) -> long
        argument(Fl_Menu_Item self, long v)
        """
        return _fltk.Fl_Menu_Item_argument(self, *args)

    def shortcut(self, *args):
        r"""
        shortcut(Fl_Menu_Item self) -> int
        shortcut(Fl_Menu_Item self, int s)
        """
        return _fltk.Fl_Menu_Item_shortcut(self, *args)

    def submenu(self, *args):
        r"""submenu(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_submenu(self, *args)

    def checkbox(self, *args):
        r"""checkbox(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_checkbox(self, *args)

    def radio(self, *args):
        r"""radio(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_radio(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Menu_Item self) -> int
        value(Fl_Menu_Item self, int v)
        """
        return _fltk.Fl_Menu_Item_value(self, *args)

    def set(self, *args):
        r"""set(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_set(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_clear(self, *args)

    def setonly(self, *args):
        r"""
        setonly(Fl_Menu_Item self)
        setonly(Fl_Menu_Item self, Fl_Menu_Item first)
        """
        return _fltk.Fl_Menu_Item_setonly(self, *args)

    def visible(self, *args):
        r"""visible(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_visible(self, *args)

    def show(self, *args):
        r"""show(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_show(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_hide(self, *args)

    def active(self, *args):
        r"""active(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_active(self, *args)

    def activate(self, *args):
        r"""activate(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_activate(self, *args)

    def deactivate(self, *args):
        r"""deactivate(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_deactivate(self, *args)

    def activevisible(self, *args):
        r"""activevisible(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_activevisible(self, *args)

    def selectable(self, *args):
        r"""selectable(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_selectable(self, *args)

    def headline(self, *args):
        r"""
        headline(Fl_Menu_Item self, bool yes)
        headline(Fl_Menu_Item self) -> int
        """
        return _fltk.Fl_Menu_Item_headline(self, *args)

    def image(self, *args):
        r"""
        image(Fl_Menu_Item self, Fl_Image image)
        image(Fl_Menu_Item self, Fl_Image image)
        """
        val = _fltk.Fl_Menu_Item_image(self, *args)

        if len(args) > 0:
        #delegate ownership to C++
            self.my_image = args[0]
            args[0].this.disown()


        return val


    def measure(self, *args):
        r"""measure(Fl_Menu_Item self, int * h, Fl_Menu_ arg3) -> int"""
        return _fltk.Fl_Menu_Item_measure(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Menu_Item self, int x, int y, int w, int h, Fl_Menu_ arg6, int t=0)"""
        return _fltk.Fl_Menu_Item_draw(self, *args)

    def popup(self, *args):
        r"""popup(Fl_Menu_Item self, int X, int Y, char const * title=None, Fl_Menu_Item picked=None, Fl_Menu_ arg6=None) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_popup(self, *args)

    def pulldown(self, *args):
        r"""pulldown(Fl_Menu_Item self, int X, int Y, int W, int H, Fl_Menu_Item picked=None, Fl_Menu_ arg7=None, Fl_Menu_Item title=None, int menubar=0) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_pulldown(self, *args)

    def test_shortcut(self, *args):
        r"""test_shortcut(Fl_Menu_Item self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_test_shortcut(self, *args)

    def find_shortcut(self, *args):
        r"""find_shortcut(Fl_Menu_Item self, int * ip=None, bool const require_alt=False) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_find_shortcut(self, *args)

    def do_callback(self, *args):
        r"""
        do_callback(Fl_Menu_Item self, Fl_Widget o, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        do_callback(Fl_Menu_Item self, Fl_Widget o, void * arg, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        do_callback(Fl_Menu_Item self, Fl_Widget o, long arg, Fl_Callback_Reason reason=FL_REASON_UNKNOWN)
        """
        return _fltk.Fl_Menu_Item_do_callback(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Menu_Item self, int arg2, char const * arg3, int arg4, Fl_Callback * arg5, void * arg6=None, int arg7=0) -> int"""
        return _fltk.Fl_Menu_Item_insert(self, *args)

    def add(self, *args):
        r"""
        add(Fl_Menu_Item self, char const * arg2, int shortcut, Fl_Callback * arg4, void * arg5=None, int arg6=0) -> int
        add(Fl_Menu_Item self, char const * a, char const * b, Fl_Callback * c, void * d=None, int e=0) -> int
        """
        return _fltk.Fl_Menu_Item_add(self, *args)

    def size(self, *args):
        r"""size(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_size(self, *args)

    def callback(self, *args):
        r"""
        callback(Fl_Menu_Item self, Fl_Callback * c, void * p)
        callback(Fl_Menu_Item self, Fl_Callback * c)
        callback(Fl_Menu_Item self, Fl_Callback0 * c)
        callback(Fl_Menu_Item self, Fl_Callback1 * c, long p=0)
        callback(Fl_Menu_Item self) -> PyObject *
        """
        return _fltk.Fl_Menu_Item_callback(self, *args)

    def user_data(self, *args):
        r"""user_data(Fl_Menu_Item self) -> PyObject *"""
        return _fltk.Fl_Menu_Item_user_data(self, *args)

    def add_multi_label(self, *args):
        r"""add_multi_label(Fl_Menu_Item self, Fl_Pixmap pixmap)"""
        val = _fltk.Fl_Menu_Item_add_multi_label(self, *args)

        if len(args) > 0:
            args[0].this.disown()


        return val


    def __init__(self, *args):
        r"""__init__(Fl_Menu_Item self) -> Fl_Menu_Item"""
        _fltk.Fl_Menu_Item_swiginit(self, _fltk.new_Fl_Menu_Item(*args))
    __swig_destroy__ = _fltk.delete_Fl_Menu_Item

# Register Fl_Menu_Item in _fltk:
_fltk.Fl_Menu_Item_swigregister(Fl_Menu_Item)
FL_PUP_NONE = _fltk.FL_PUP_NONE

FL_PUP_GREY = _fltk.FL_PUP_GREY

FL_PUP_GRAY = _fltk.FL_PUP_GRAY

FL_MENU_BOX = _fltk.FL_MENU_BOX

FL_PUP_BOX = _fltk.FL_PUP_BOX

FL_MENU_CHECK = _fltk.FL_MENU_CHECK

FL_PUP_CHECK = _fltk.FL_PUP_CHECK

FL_PUP_RADIO = _fltk.FL_PUP_RADIO

FL_PUP_INVISIBLE = _fltk.FL_PUP_INVISIBLE

FL_PUP_SUBMENU = _fltk.FL_PUP_SUBMENU

class Fl_Single_Window(Fl_Window):
    r"""

    This is the same as Fl_Window. However, it is possible that some 
    implementations will provide double-buffered windows by default. This 
    subclass can be used to force single-buffering. This may be useful for 
    modifying existing programs that use incremental update, or for some 
    types of image data, such as a movie flipbook.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_Single_Window self, int W, int H, char const * l=None) -> Fl_Single_Window
        __init__(Fl_Single_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Single_Window
        """
        if self.__class__ == Fl_Single_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Single_Window_swiginit(self, _fltk.new_Fl_Single_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Single_Window")
        #print("Adding type: ", Fl_Single_Window)




    def flush(self, *args):
        r"""flush(Fl_Single_Window self)"""
        return _fltk.Fl_Single_Window_flush(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Single_Window self, char * Fl_Single_Window)"""
        return _fltk.Fl_Single_Window_init_type(self, *args)

    def show(self, *args):
        r"""show(Fl_Single_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Single_Window_show(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Single_Window
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Single_Window(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Single_Window self)"""
        return _fltk.Fl_Single_Window_draw(self, *args)

# Register Fl_Single_Window in _fltk:
_fltk.Fl_Single_Window_swigregister(Fl_Single_Window)
class Fl_Menu_Window(Fl_Single_Window):
    r"""

    The Fl_Menu_Window widget is a window type used for menus. By default the 
    window is drawn in the hardware overlay planes if they are available so that 
    the menu don't force the rest of the window to redraw.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _fltk.delete_Fl_Menu_Window

    def __init__(self, *args):
        r"""
        __init__(Fl_Menu_Window self, int W, int H, char const * l=None) -> Fl_Menu_Window
        __init__(Fl_Menu_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Menu_Window
        """
        if self.__class__ == Fl_Menu_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Menu_Window_swiginit(self, _fltk.new_Fl_Menu_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Menu_Window")
        #print("Adding type: ", Fl_Menu_Window)




    def init_type(self, *args):
        r"""init_type(Fl_Menu_Window self, char * Fl_Menu_Window)"""
        return _fltk.Fl_Menu_Window_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Window(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_draw(self, *args)

# Register Fl_Menu_Window in _fltk:
_fltk.Fl_Menu_Window_swigregister(Fl_Menu_Window)
class Fl_Multiline_Input(Fl_Input):
    r"""

    This input field displays '
    ' characters as new lines rather than ^J, and 
    accepts the Return, Tab, and up and down arrow keys. This is for editing 
    multiline text.

    This is far from the nirvana of text editors, and is probably only good for 
    small bits of text, 10 lines at most. I think FLTK can be used to write a 
    powerful text editor, but it is not going to be a built-in feature. Powerful 
    text editors in a toolkit are a big source of bloat. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Multiline_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Multiline_Input"""
        if self.__class__ == Fl_Multiline_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Multiline_Input_swiginit(self, _fltk.new_Fl_Multiline_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Multiline_Input")
        #print("Adding type: ", Fl_Multiline_Input)




    def init_type(self, *args):
        r"""init_type(Fl_Multiline_Input self, char * Fl_Multiline_Input)"""
        return _fltk.Fl_Multiline_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Multiline_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Input(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Multiline_Input self)"""
        return _fltk.Fl_Multiline_Input_draw(self, *args)

# Register Fl_Multiline_Input in _fltk:
_fltk.Fl_Multiline_Input_swigregister(Fl_Multiline_Input)
class Fl_Output(Fl_Input):
    r"""

    This widget displays a piece of text. When you set the value() , Fl_Output 
    does a strcpy() to it's own storage, which is useful for program-generated 
    values. The user may select portions of the text using the mouse and paste 
    the contents into other fields or programs.

    There is a single subclass, Fl_Multiline_Output, which allows you to 
    display multiple lines of text.

    The text may contain any characters except 
    #else
    swig::SwigVar_PyObject swig_method_name = SWIG_Python_str_FromChar("as_vk_window");
    swig::SwigVar_PyObject result = PyObject_CallMethodObjArgs(swig_get_self(), (PyObject *) swig_method_name, NULL
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Output self, int X, int Y, int W, int H, char const * l=None) -> Fl_Output"""
        if self.__class__ == Fl_Output:
            _self = None
        else:
            _self = self
        _fltk.Fl_Output_swiginit(self, _fltk.new_Fl_Output(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Output")
        #print("Adding type: ", Fl_Output)




    def init_type(self, *args):
        r"""init_type(Fl_Output self, char * Fl_Output)"""
        return _fltk.Fl_Output_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Output
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Output(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Output self)"""
        return _fltk.Fl_Output_draw(self, *args)

# Register Fl_Output in _fltk:
_fltk.Fl_Output_swigregister(Fl_Output)
class Fl_Multiline_Output(Fl_Output):
    r"""

    This widget is a subclass of Fl_Output that displays multiple lines of text. 
    It also displays tab characters as whitespace to the next column.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Multiline_Output self, int X, int Y, int W, int H, char const * l=None) -> Fl_Multiline_Output"""
        if self.__class__ == Fl_Multiline_Output:
            _self = None
        else:
            _self = self
        _fltk.Fl_Multiline_Output_swiginit(self, _fltk.new_Fl_Multiline_Output(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Multiline_Output")
        #print("Adding type: ", Fl_Multiline_Output)




    def init_type(self, *args):
        r"""init_type(Fl_Multiline_Output self, char * Fl_Multiline_Output)"""
        return _fltk.Fl_Multiline_Output_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Multiline_Output
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Output(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Multiline_Output self)"""
        return _fltk.Fl_Multiline_Output_draw(self, *args)

# Register Fl_Multiline_Output in _fltk:
_fltk.Fl_Multiline_Output_swigregister(Fl_Multiline_Output)
class Fl_Multi_Browser(Fl_Browser):
    r"""

    The Fl_Multi_Browser class is a subclass of Fl_Browser  which lets the user 
    select any set of the lines. The user interface is Macintosh style: clicking 
    an item turns off all the others and selects that one, dragging selects all 
    the items the mouse moves over, and shift + click toggles the items. This 
    is different then how forms did it. Normally the callback is done when the 
    user releases the mouse, but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Multi_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Multi_Browser"""
        if self.__class__ == Fl_Multi_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Multi_Browser_swiginit(self, _fltk.new_Fl_Multi_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Multi_Browser")
        #print("Adding type: ", Fl_Multi_Browser)




    def init_type(self, *args):
        r"""init_type(Fl_Multi_Browser self, char * Fl_Multi_Browser)"""
        return _fltk.Fl_Multi_Browser_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Multi_Browser
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multi_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Multi_Browser self)"""
        return _fltk.Fl_Multi_Browser_draw(self, *args)

    def item_first(self, *args):
        r"""item_first(Fl_Multi_Browser self) -> void *"""
        return _fltk.Fl_Multi_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Multi_Browser self, void * item) -> void *"""
        return _fltk.Fl_Multi_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Multi_Browser self, void * item) -> void *"""
        return _fltk.Fl_Multi_Browser_item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Multi_Browser self) -> void *"""
        return _fltk.Fl_Multi_Browser_item_last(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Multi_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Multi_Browser_item_draw(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Multi_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Multi_Browser_item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_Multi_Browser self, void * a, void * b)"""
        return _fltk.Fl_Multi_Browser_item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Multi_Browser self, int line) -> void *"""
        return _fltk.Fl_Multi_Browser_item_at(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_incr_height(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Multi_Browser self, void * item, int val)"""
        return _fltk.Fl_Multi_Browser_item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_selected(self, *args)

# Register Fl_Multi_Browser in _fltk:
_fltk.Fl_Multi_Browser_swigregister(Fl_Multi_Browser)
class Fl_Multi_Label(object):
    r"""Proxy of C++ Fl_Multi_Label class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def label(self, *args):
        r"""
        label(Fl_Multi_Label self, Fl_Widget arg2)
        label(Fl_Multi_Label self, Fl_Menu_Item arg2)
        """
        return _fltk.Fl_Multi_Label_label(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Multi_Label self) -> Fl_Multi_Label"""
        _fltk.Fl_Multi_Label_swiginit(self, _fltk.new_Fl_Multi_Label(*args))
    __swig_destroy__ = _fltk.delete_Fl_Multi_Label

# Register Fl_Multi_Label in _fltk:
_fltk.Fl_Multi_Label_swigregister(Fl_Multi_Label)
class Fl_Nice_Slider(Fl_Slider):
    r"""

    The Fl_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Nice_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Nice_Slider"""
        if self.__class__ == Fl_Nice_Slider:
            _self = None
        else:
            _self = self
        _fltk.Fl_Nice_Slider_swiginit(self, _fltk.new_Fl_Nice_Slider(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Nice_Slider")
        #print("Adding type: ", Fl_Nice_Slider)




    def init_type(self, *args):
        r"""init_type(Fl_Nice_Slider self, char * Fl_Nice_Slider)"""
        return _fltk.Fl_Nice_Slider_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Nice_Slider
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Nice_Slider(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Nice_Slider self)"""
        return _fltk.Fl_Nice_Slider_draw(self, *args)

# Register Fl_Nice_Slider in _fltk:
_fltk.Fl_Nice_Slider_swigregister(Fl_Nice_Slider)
class Fl_Native_File_Chooser(object):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    BROWSE_FILE = _fltk.Fl_Native_File_Chooser_BROWSE_FILE
    
    BROWSE_DIRECTORY = _fltk.Fl_Native_File_Chooser_BROWSE_DIRECTORY
    
    BROWSE_MULTI_FILE = _fltk.Fl_Native_File_Chooser_BROWSE_MULTI_FILE
    
    BROWSE_MULTI_DIRECTORY = _fltk.Fl_Native_File_Chooser_BROWSE_MULTI_DIRECTORY
    
    BROWSE_SAVE_FILE = _fltk.Fl_Native_File_Chooser_BROWSE_SAVE_FILE
    
    BROWSE_SAVE_DIRECTORY = _fltk.Fl_Native_File_Chooser_BROWSE_SAVE_DIRECTORY
    
    NO_OPTIONS = _fltk.Fl_Native_File_Chooser_NO_OPTIONS
    
    SAVEAS_CONFIRM = _fltk.Fl_Native_File_Chooser_SAVEAS_CONFIRM
    
    NEW_FOLDER = _fltk.Fl_Native_File_Chooser_NEW_FOLDER
    
    PREVIEW = _fltk.Fl_Native_File_Chooser_PREVIEW
    
    USE_FILTER_EXT = _fltk.Fl_Native_File_Chooser_USE_FILTER_EXT
    

    def __init__(self, *args):
        r"""__init__(Fl_Native_File_Chooser self, int val=BROWSE_FILE) -> Fl_Native_File_Chooser"""
        _fltk.Fl_Native_File_Chooser_swiginit(self, _fltk.new_Fl_Native_File_Chooser(*args))
    __swig_destroy__ = _fltk.delete_Fl_Native_File_Chooser

    def type(self, *args):
        r"""
        type(Fl_Native_File_Chooser self, int t)
        type(Fl_Native_File_Chooser self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_type(self, *args)

    def options(self, *args):
        r"""
        options(Fl_Native_File_Chooser self, int o)
        options(Fl_Native_File_Chooser self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_options(self, *args)

    def count(self, *args):
        r"""count(Fl_Native_File_Chooser self) -> int"""
        return _fltk.Fl_Native_File_Chooser_count(self, *args)

    def filename(self, *args):
        r"""
        filename(Fl_Native_File_Chooser self) -> char const
        filename(Fl_Native_File_Chooser self, int i) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_filename(self, *args)

    def directory(self, *args):
        r"""
        directory(Fl_Native_File_Chooser self, char const * val)
        directory(Fl_Native_File_Chooser self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_directory(self, *args)

    def title(self, *args):
        r"""
        title(Fl_Native_File_Chooser self, char const * t)
        title(Fl_Native_File_Chooser self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_title(self, *args)

    def filter(self, *args):
        r"""
        filter(Fl_Native_File_Chooser self) -> char const
        filter(Fl_Native_File_Chooser self, char const * f)
        """
        return _fltk.Fl_Native_File_Chooser_filter(self, *args)

    def filters(self, *args):
        r"""filters(Fl_Native_File_Chooser self) -> int"""
        return _fltk.Fl_Native_File_Chooser_filters(self, *args)

    def filter_value(self, *args):
        r"""
        filter_value(Fl_Native_File_Chooser self, int i)
        filter_value(Fl_Native_File_Chooser self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_filter_value(self, *args)

    def preset_file(self, *args):
        r"""
        preset_file(Fl_Native_File_Chooser self, char const * f)
        preset_file(Fl_Native_File_Chooser self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_preset_file(self, *args)

    def errmsg(self, *args):
        r"""errmsg(Fl_Native_File_Chooser self) -> char const *"""
        return _fltk.Fl_Native_File_Chooser_errmsg(self, *args)

    def show(self, *args):
        r"""show(Fl_Native_File_Chooser self) -> int"""
        return _fltk.Fl_Native_File_Chooser_show(self, *args)

# Register Fl_Native_File_Chooser in _fltk:
_fltk.Fl_Native_File_Chooser_swigregister(Fl_Native_File_Chooser)
class Fl_Native_File_Chooser_Driver(object):
    r"""Proxy of C++ Fl_Native_File_Chooser_Driver class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Native_File_Chooser_Driver self, int arg2) -> Fl_Native_File_Chooser_Driver"""
        if self.__class__ == Fl_Native_File_Chooser_Driver:
            _self = None
        else:
            _self = self
        _fltk.Fl_Native_File_Chooser_Driver_swiginit(self, _fltk.new_Fl_Native_File_Chooser_Driver(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Native_File_Chooser_Driver

    def type(self, *args):
        r"""
        type(Fl_Native_File_Chooser_Driver self, int arg0)
        type(Fl_Native_File_Chooser_Driver self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_Driver_type(self, *args)

    def options(self, *args):
        r"""
        options(Fl_Native_File_Chooser_Driver self, int arg0)
        options(Fl_Native_File_Chooser_Driver self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_Driver_options(self, *args)

    def count(self, *args):
        r"""count(Fl_Native_File_Chooser_Driver self) -> int"""
        return _fltk.Fl_Native_File_Chooser_Driver_count(self, *args)

    def filename(self, *args):
        r"""
        filename(Fl_Native_File_Chooser_Driver self) -> char const
        filename(Fl_Native_File_Chooser_Driver self, int arg0) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_Driver_filename(self, *args)

    def directory(self, *args):
        r"""
        directory(Fl_Native_File_Chooser_Driver self, char const * arg0)
        directory(Fl_Native_File_Chooser_Driver self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_Driver_directory(self, *args)

    def title(self, *args):
        r"""
        title(Fl_Native_File_Chooser_Driver self, char const * arg0)
        title(Fl_Native_File_Chooser_Driver self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_Driver_title(self, *args)

    def filter(self, *args):
        r"""
        filter(Fl_Native_File_Chooser_Driver self) -> char const
        filter(Fl_Native_File_Chooser_Driver self, char const * arg0)
        """
        return _fltk.Fl_Native_File_Chooser_Driver_filter(self, *args)

    def filters(self, *args):
        r"""filters(Fl_Native_File_Chooser_Driver self) -> int"""
        return _fltk.Fl_Native_File_Chooser_Driver_filters(self, *args)

    def filter_value(self, *args):
        r"""
        filter_value(Fl_Native_File_Chooser_Driver self, int arg0)
        filter_value(Fl_Native_File_Chooser_Driver self) -> int
        """
        return _fltk.Fl_Native_File_Chooser_Driver_filter_value(self, *args)

    def preset_file(self, *args):
        r"""
        preset_file(Fl_Native_File_Chooser_Driver self, char const * arg0)
        preset_file(Fl_Native_File_Chooser_Driver self) -> char const *
        """
        return _fltk.Fl_Native_File_Chooser_Driver_preset_file(self, *args)

    def errmsg(self, *args):
        r"""errmsg(Fl_Native_File_Chooser_Driver self) -> char const *"""
        return _fltk.Fl_Native_File_Chooser_Driver_errmsg(self, *args)

    def show(self, *args):
        r"""show(Fl_Native_File_Chooser_Driver self) -> int"""
        return _fltk.Fl_Native_File_Chooser_Driver_show(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Native_File_Chooser_Driver(self)
        return weakref.proxy(self)

# Register Fl_Native_File_Chooser_Driver in _fltk:
_fltk.Fl_Native_File_Chooser_Driver_swigregister(Fl_Native_File_Chooser_Driver)
class Fl_Overlay_Window(Fl_Double_Window):
    r"""

    This window provides double buffering and also the ability to draw the 
    'overlay' which is another picture placed on top of the main image. The 
    overlay is designed to be a rapidly-changing but simple graphic such as 
    a mouse selection box. Fl_Overlay_Window uses the overlay planes provided 
    by your graphics hardware if they are available.

    If no hardware support is found the overlay is simulated by drawing directly 
    into the on-screen copy of the double-buffered window, and 'erased' by 
    copying the backbuffer over it again. This means the overlay will blink if 
    you change the image in the window. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw_overlay(self, *args):
        r"""draw_overlay(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_draw_overlay(self, *args)

    def hide(self, *args):
        r"""hide(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_hide(self, *args)

    def flush(self, *args):
        r"""flush(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_flush(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Overlay_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Overlay_Window_resize(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Overlay_Window

    def can_do_overlay(self, *args):
        r"""can_do_overlay(Fl_Overlay_Window self) -> int"""
        return _fltk.Fl_Overlay_Window_can_do_overlay(self, *args)

    def redraw_overlay(self, *args):
        r"""redraw_overlay(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_redraw_overlay(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Overlay_Window self, int W, int H, char const * l=None) -> Fl_Overlay_Window
        __init__(Fl_Overlay_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Overlay_Window
        """
        if self.__class__ == Fl_Overlay_Window:
            _self = None
        else:
            _self = self
        _fltk.Fl_Overlay_Window_swiginit(self, _fltk.new_Fl_Overlay_Window(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Overlay_Window")
        #print("Adding type: ", Fl_Overlay_Window)




    def as_overlay_window(self, *args):
        r"""as_overlay_window(Fl_Overlay_Window self) -> Fl_Overlay_Window"""
        return _fltk.Fl_Overlay_Window_as_overlay_window(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Overlay_Window self, char * Fl_Overlay_Window)"""
        return _fltk.Fl_Overlay_Window_init_type(self, *args)

    def show(self, *args):
        r"""show(Fl_Overlay_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Overlay_Window_show(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Overlay_Window(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_draw(self, *args)

# Register Fl_Overlay_Window in _fltk:
_fltk.Fl_Overlay_Window_swigregister(Fl_Overlay_Window)
class Fl_Pack(Fl_Group):
    r"""

    This widget was designed to add the functionality of compressing and 
    aligning widgets.

    If type() is FL_HORIZONTAL all the children are resized to the height of 
    the Fl_Pack, and are moved next to each other horizontally. If type() is 
    not FL_HORIZONTAL then the children are resized to the width and are stacked 
    below each other. Then the Fl_Pack resizes itself to surround the child 
    widgets.

    This widget is needed for the Fl_Tabs. In addition you may want to put the 
    Fl_Pack inside an Fl_Scroll. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    VERTICAL = _fltk.Fl_Pack_VERTICAL
    
    HORIZONTAL = _fltk.Fl_Pack_HORIZONTAL
    

    def draw(self, *args):
        r"""draw(Fl_Pack self)"""
        return _fltk.Fl_Pack_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Pack self, int X, int Y, int W, int H, char const * L=None) -> Fl_Pack"""
        if self.__class__ == Fl_Pack:
            _self = None
        else:
            _self = self
        _fltk.Fl_Pack_swiginit(self, _fltk.new_Fl_Pack(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Pack")
        #print("Adding type: ", Fl_Pack)




    def spacing(self, *args):
        r"""
        spacing(Fl_Pack self) -> int
        spacing(Fl_Pack self, int i)
        """
        return _fltk.Fl_Pack_spacing(self, *args)

    def horizontal(self, *args):
        r"""horizontal(Fl_Pack self) -> uchar"""
        return _fltk.Fl_Pack_horizontal(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Pack self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Pack_resize(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Pack self)"""
        return _fltk.Fl_Pack_clear(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Pack self, char * Fl_Pack)"""
        return _fltk.Fl_Pack_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Pack
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pack(self)
        return weakref.proxy(self)

# Register Fl_Pack in _fltk:
_fltk.Fl_Pack_swigregister(Fl_Pack)
class Fl_PNG_Image(Fl_RGB_Image):
    r"""

    The Fl_PNG_Image class supports loading, caching, and drawing of Portable 
    Network Graphics (PNG) image files. The class loads colormapped and 
    full-color images and handles color- and alpha-based transparency.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_PNG_Image self, char const * filename) -> Fl_PNG_Image
        __init__(Fl_PNG_Image self, char const * name_png, unsigned char const * buffer, int datasize) -> Fl_PNG_Image
        """
        if self.__class__ == Fl_PNG_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_PNG_Image_swiginit(self, _fltk.new_Fl_PNG_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_PNG_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNG_Image(self)
        return weakref.proxy(self)

# Register Fl_PNG_Image in _fltk:
_fltk.Fl_PNG_Image_swigregister(Fl_PNG_Image)

def fl_write_png(*args):
    r"""
    fl_write_png(char const * filename, Fl_RGB_Image img) -> int
    fl_write_png(char const * filename, char const * pixels, int w, int h, int d=3, int ld=0) -> int
    fl_write_png(char const * filename, unsigned char const * pixels, int w, int h, int d=3, int ld=0) -> int
    """
    return _fltk.fl_write_png(*args)
class Fl_PNM_Image(Fl_RGB_Image):
    r"""

    The Fl_PNM_Image class supports loading, caching, and drawing of Portable 
    Anymap (PNM, PBM, PGM, PPM) image files. The class loads bitmap, grayscale, 
    and full-color images in both ASCII and binary formats.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_PNM_Image self, char const * filename) -> Fl_PNM_Image"""
        if self.__class__ == Fl_PNM_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_PNM_Image_swiginit(self, _fltk.new_Fl_PNM_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_PNM_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNM_Image(self)
        return weakref.proxy(self)

# Register Fl_PNM_Image in _fltk:
_fltk.Fl_PNM_Image_swigregister(Fl_PNM_Image)
class Fl_Positioner(Fl_Widget):
    r"""

    This class is provided for Forms compatibility. It provides 2D input. It 
    would be useful if this could be put atop another widget so that the 
    crosshairs are on top, but this is not implemented. The color of the 
    crosshairs is selection_color().

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Positioner self)"""
        return _fltk.Fl_Positioner_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Positioner self, int arg0) -> int"""
        return _fltk.Fl_Positioner_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Positioner self, int x, int y, int w, int h, char const * l=None) -> Fl_Positioner"""
        if self.__class__ == Fl_Positioner:
            _self = None
        else:
            _self = self
        _fltk.Fl_Positioner_swiginit(self, _fltk.new_Fl_Positioner(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Positioner")
        #print("Adding type: ", Fl_Positioner)




    def xvalue(self, *args):
        r"""
        xvalue(Fl_Positioner self) -> double
        xvalue(Fl_Positioner self, double arg2) -> int
        """
        return _fltk.Fl_Positioner_xvalue(self, *args)

    def yvalue(self, *args):
        r"""
        yvalue(Fl_Positioner self) -> double
        yvalue(Fl_Positioner self, double arg2) -> int
        """
        return _fltk.Fl_Positioner_yvalue(self, *args)

    def value(self, *args):
        r"""value(Fl_Positioner self, double arg2, double arg3) -> int"""
        return _fltk.Fl_Positioner_value(self, *args)

    def xbounds(self, *args):
        r"""xbounds(Fl_Positioner self, double arg2, double arg3)"""
        return _fltk.Fl_Positioner_xbounds(self, *args)

    def xminimum(self, *args):
        r"""
        xminimum(Fl_Positioner self) -> double
        xminimum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_xminimum(self, *args)

    def xmaximum(self, *args):
        r"""
        xmaximum(Fl_Positioner self) -> double
        xmaximum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_xmaximum(self, *args)

    def ybounds(self, *args):
        r"""ybounds(Fl_Positioner self, double arg2, double arg3)"""
        return _fltk.Fl_Positioner_ybounds(self, *args)

    def yminimum(self, *args):
        r"""
        yminimum(Fl_Positioner self) -> double
        yminimum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_yminimum(self, *args)

    def ymaximum(self, *args):
        r"""
        ymaximum(Fl_Positioner self) -> double
        ymaximum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_ymaximum(self, *args)

    def xstep(self, *args):
        r"""xstep(Fl_Positioner self, double a)"""
        return _fltk.Fl_Positioner_xstep(self, *args)

    def ystep(self, *args):
        r"""ystep(Fl_Positioner self, double a)"""
        return _fltk.Fl_Positioner_ystep(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Positioner self, char * Fl_Positioner)"""
        return _fltk.Fl_Positioner_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Positioner
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Positioner(self)
        return weakref.proxy(self)

# Register Fl_Positioner in _fltk:
_fltk.Fl_Positioner_swigregister(Fl_Positioner)
class Fl_Preferences(object):
    r"""

    Fl_Preferences provides methods to store user setting between application 
    starts. It is similar to the Registry on WIN32 and Preferences on MacOS, 
    and provides a simple configuration mechanism for UNIX.

    Fl_Preferences uses a hierarchy to store data. It bundles similar data into 
    groups and manages entries into those groups as name/value pairs.

    Preferences are stored in text files that can be edited manually. The file 
    format is easy to read and relatively forgiving. Preferences files are the 
    same on all platforms. User comments in preference files are preserved. 
    Filenames are unique for each application by using a vendor/application 
    naming scheme. The user must provide default values for all entries to 
    ensure proper operation should preferences be corrupted or not yet exist.

    Entries can be of any length. However, the size of each preferences file 
    should be kept under 100k for performance reasons. One application can 
    have multiple preferences files. Extensive binary data however should be 
    stored in seperate files; see the getUserdataPath() method. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SYSTEM = _fltk.Fl_Preferences_SYSTEM
    
    USER = _fltk.Fl_Preferences_USER
    

    def __init__(self, *args):
        r"""
        __init__(Fl_Preferences self, Fl_Preferences::Root root, char const * vendor, char const * application) -> Fl_Preferences
        __init__(Fl_Preferences self, Fl_Preferences arg2, char const * group) -> Fl_Preferences
        """
        _fltk.Fl_Preferences_swiginit(self, _fltk.new_Fl_Preferences(*args))
    __swig_destroy__ = _fltk.delete_Fl_Preferences

    def groups(self, *args):
        r"""groups(Fl_Preferences self) -> int"""
        return _fltk.Fl_Preferences_groups(self, *args)

    def group(self, *args):
        r"""group(Fl_Preferences self, int arg2) -> char const *"""
        return _fltk.Fl_Preferences_group(self, *args)

    def groupExists(self, *args):
        r"""groupExists(Fl_Preferences self, char const * group) -> char"""
        return _fltk.Fl_Preferences_groupExists(self, *args)

    def deleteGroup(self, *args):
        r"""deleteGroup(Fl_Preferences self, char const * group) -> char"""
        return _fltk.Fl_Preferences_deleteGroup(self, *args)

    def entries(self, *args):
        r"""entries(Fl_Preferences self) -> int"""
        return _fltk.Fl_Preferences_entries(self, *args)

    def entry(self, *args):
        r"""entry(Fl_Preferences self, int arg2) -> char const *"""
        return _fltk.Fl_Preferences_entry(self, *args)

    def entryExists(self, *args):
        r"""entryExists(Fl_Preferences self, char const * entry) -> char"""
        return _fltk.Fl_Preferences_entryExists(self, *args)

    def deleteEntry(self, *args):
        r"""deleteEntry(Fl_Preferences self, char const * entry) -> char"""
        return _fltk.Fl_Preferences_deleteEntry(self, *args)

    def set(self, *args):
        r"""
        set(Fl_Preferences self, char const * entry, int value) -> char
        set(Fl_Preferences self, char const * entry, float value, int precision) -> char
        set(Fl_Preferences self, char const * entry, double value) -> char
        set(Fl_Preferences self, char const * entry, double value, int precision) -> char
        set(Fl_Preferences self, char const * entry, char const * cvalue) -> char
        set(Fl_Preferences self, char const * entry, void const * cvalue, int size) -> char
        """
        return _fltk.Fl_Preferences_set(self, *args)

    def get(self, *args):
        r"""
        get(Fl_Preferences self, char const * entry, int defaultValue) -> char
        get(Fl_Preferences self, char const * entry, float defaultValue) -> char
        get(Fl_Preferences self, char const * entry, double defaultValue) -> char
        get(Fl_Preferences self, char const * entry, char const * defaultValue, int maxSize) -> char
        get(Fl_Preferences self, char const * entry, void * value, void const * defaultValue, int defaultSize, int maxSize) -> char
        """
        return _fltk.Fl_Preferences_get(self, *args)

    def size(self, *args):
        r"""size(Fl_Preferences self, char const * entry) -> int"""
        return _fltk.Fl_Preferences_size(self, *args)

    def getUserdataPath(self, *args):
        r"""getUserdataPath(Fl_Preferences self, char * path) -> char"""
        return _fltk.Fl_Preferences_getUserdataPath(self, *args)

    def flush(self, *args):
        r"""flush(Fl_Preferences self)"""
        return _fltk.Fl_Preferences_flush(self, *args)

# Register Fl_Preferences in _fltk:
_fltk.Fl_Preferences_swigregister(Fl_Preferences)
class Fl_Progress(Fl_Widget):
    r"""

    The Fl_Progress widget displays a progress bar for the user.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Progress self)"""
        return _fltk.Fl_Progress_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Progress self, int x, int y, int w, int h, char const * l=None) -> Fl_Progress"""
        if self.__class__ == Fl_Progress:
            _self = None
        else:
            _self = self
        _fltk.Fl_Progress_swiginit(self, _fltk.new_Fl_Progress(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Progress")
        #print("Adding type: ", Fl_Progress)




    def maximum(self, *args):
        r"""
        maximum(Fl_Progress self, float v)
        maximum(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_maximum(self, *args)

    def minimum(self, *args):
        r"""
        minimum(Fl_Progress self, float v)
        minimum(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_minimum(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Progress self, float v)
        value(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Progress self, char * Fl_Progress)"""
        return _fltk.Fl_Progress_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Progress
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Progress(self)
        return weakref.proxy(self)

# Register Fl_Progress in _fltk:
_fltk.Fl_Progress_swigregister(Fl_Progress)
class Fl_Radio_Button(Fl_Button):
    r"""Proxy of C++ Fl_Radio_Button class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Radio_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Radio_Button"""
        if self.__class__ == Fl_Radio_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Radio_Button_swiginit(self, _fltk.new_Fl_Radio_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Radio_Button")
        #print("Adding type: ", Fl_Radio_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Radio_Button self, char * Fl_Radio_Button)"""
        return _fltk.Fl_Radio_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Radio_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Radio_Button self)"""
        return _fltk.Fl_Radio_Button_draw(self, *args)

# Register Fl_Radio_Button in _fltk:
_fltk.Fl_Radio_Button_swigregister(Fl_Radio_Button)
class Fl_Radio_Light_Button(Fl_Light_Button):
    r"""Proxy of C++ Fl_Radio_Light_Button class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Radio_Light_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Radio_Light_Button"""
        if self.__class__ == Fl_Radio_Light_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Radio_Light_Button_swiginit(self, _fltk.new_Fl_Radio_Light_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Radio_Light_Button")
        #print("Adding type: ", Fl_Radio_Light_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Radio_Light_Button self, char * Fl_Radio_Light_Button)"""
        return _fltk.Fl_Radio_Light_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Radio_Light_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Light_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Radio_Light_Button self)"""
        return _fltk.Fl_Radio_Light_Button_draw(self, *args)

# Register Fl_Radio_Light_Button in _fltk:
_fltk.Fl_Radio_Light_Button_swigregister(Fl_Radio_Light_Button)
class Fl_Round_Button(Fl_Light_Button):
    r"""

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Round_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_ROUND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Round_Button self, int x, int y, int w, int h, char const * l=None) -> Fl_Round_Button"""
        if self.__class__ == Fl_Round_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Round_Button_swiginit(self, _fltk.new_Fl_Round_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Round_Button")
        #print("Adding type: ", Fl_Round_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Round_Button self, char * Fl_Round_Button)"""
        return _fltk.Fl_Round_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Round_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Round_Button self)"""
        return _fltk.Fl_Round_Button_draw(self, *args)

# Register Fl_Round_Button in _fltk:
_fltk.Fl_Round_Button_swigregister(Fl_Round_Button)
class Fl_Radio_Round_Button(Fl_Round_Button):
    r"""Proxy of C++ Fl_Radio_Round_Button class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Radio_Round_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Radio_Round_Button"""
        if self.__class__ == Fl_Radio_Round_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Radio_Round_Button_swiginit(self, _fltk.new_Fl_Radio_Round_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Radio_Round_Button")
        #print("Adding type: ", Fl_Radio_Round_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Radio_Round_Button self, char * Fl_Radio_Round_Button)"""
        return _fltk.Fl_Radio_Round_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Radio_Round_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Round_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Radio_Round_Button self)"""
        return _fltk.Fl_Radio_Round_Button_draw(self, *args)

# Register Fl_Radio_Round_Button in _fltk:
_fltk.Fl_Radio_Round_Button_swigregister(Fl_Radio_Round_Button)
class Fl_Repeat_Button(Fl_Button):
    r"""

    The Fl_Repeat_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed and then repeatedly generates callbacks as long as it 
    is held down. The speed of the repeat is fixed and depends on the 
    implementation.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Repeat_Button self, int arg0) -> int"""
        return _fltk.Fl_Repeat_Button_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Repeat_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Repeat_Button"""
        if self.__class__ == Fl_Repeat_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Repeat_Button_swiginit(self, _fltk.new_Fl_Repeat_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Repeat_Button")
        #print("Adding type: ", Fl_Repeat_Button)




    def deactivate(self, *args):
        r"""deactivate(Fl_Repeat_Button self)"""
        return _fltk.Fl_Repeat_Button_deactivate(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Repeat_Button self, char * Fl_Repeat_Button)"""
        return _fltk.Fl_Repeat_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Repeat_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Repeat_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Repeat_Button self)"""
        return _fltk.Fl_Repeat_Button_draw(self, *args)

# Register Fl_Repeat_Button in _fltk:
_fltk.Fl_Repeat_Button_swigregister(Fl_Repeat_Button)
class Fl_Return_Button(Fl_Button):
    r"""

    The Fl_Return_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed or when the user presses the Enter key. A carriage-return 
    symbol is drawn next to the button label.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Return_Button self)"""
        return _fltk.Fl_Return_Button_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Return_Button self, int arg0) -> int"""
        return _fltk.Fl_Return_Button_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Return_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Return_Button"""
        if self.__class__ == Fl_Return_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Return_Button_swiginit(self, _fltk.new_Fl_Return_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Return_Button")
        #print("Adding type: ", Fl_Return_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Return_Button self, char * Fl_Return_Button)"""
        return _fltk.Fl_Return_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Return_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Return_Button(self)
        return weakref.proxy(self)

# Register Fl_Return_Button in _fltk:
_fltk.Fl_Return_Button_swigregister(Fl_Return_Button)
class Fl_Rect(object):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_Rect self) -> Fl_Rect
        __init__(Fl_Rect self, int W, int H) -> Fl_Rect
        __init__(Fl_Rect self, int X, int Y, int W, int H) -> Fl_Rect
        __init__(Fl_Rect self, int X, int Y, int W, int H, Fl_Boxtype bt) -> Fl_Rect
        __init__(Fl_Rect self, Fl_Widget widget) -> Fl_Rect
        __init__(Fl_Rect self, Fl_Widget widget) -> Fl_Rect
        """
        _fltk.Fl_Rect_swiginit(self, _fltk.new_Fl_Rect(*args))

    def x(self, *args):
        r"""
        x(Fl_Rect self) -> int
        x(Fl_Rect self, int X)
        """
        return _fltk.Fl_Rect_x(self, *args)

    def y(self, *args):
        r"""
        y(Fl_Rect self) -> int
        y(Fl_Rect self, int Y)
        """
        return _fltk.Fl_Rect_y(self, *args)

    def w(self, *args):
        r"""
        w(Fl_Rect self) -> int
        w(Fl_Rect self, int W)
        """
        return _fltk.Fl_Rect_w(self, *args)

    def h(self, *args):
        r"""
        h(Fl_Rect self) -> int
        h(Fl_Rect self, int H)
        """
        return _fltk.Fl_Rect_h(self, *args)

    def r(self, *args):
        r"""
        r(Fl_Rect self) -> int
        r(Fl_Rect self, int R)
        """
        return _fltk.Fl_Rect_r(self, *args)

    def b(self, *args):
        r"""
        b(Fl_Rect self) -> int
        b(Fl_Rect self, int B)
        """
        return _fltk.Fl_Rect_b(self, *args)

    def inset(self, *args):
        r"""
        inset(Fl_Rect self, int d)
        inset(Fl_Rect self, Fl_Boxtype bt)
        inset(Fl_Rect self, int left, int top, int right, int bottom)
        """
        return _fltk.Fl_Rect_inset(self, *args)

    def contains(self, *args):
        r"""contains(Fl_Rect self, int X, int Y) -> bool"""
        return _fltk.Fl_Rect_contains(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Rect

# Register Fl_Rect in _fltk:
_fltk.Fl_Rect_swigregister(Fl_Rect)
class Fl_SVG_Image(Fl_RGB_Image):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_SVG_Image self, char const * filename) -> Fl_SVG_Image
        __init__(Fl_SVG_Image self, char const * sharedname, char const * svg_data) -> Fl_SVG_Image
        __init__(Fl_SVG_Image self, char const * sharedname, unsigned char const * svg_data, size_t length) -> Fl_SVG_Image
        """
        if self.__class__ == Fl_SVG_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_SVG_Image_swiginit(self, _fltk.new_Fl_SVG_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_SVG_Image

    def copy(self, *args):
        r"""
        copy(Fl_SVG_Image self, int W, int H) -> Fl_Image
        copy(Fl_SVG_Image self) -> Fl_Image
        """
        return _fltk.Fl_SVG_Image_copy(self, *args)

    def resize(self, *args):
        r"""resize(Fl_SVG_Image self, int width, int height)"""
        return _fltk.Fl_SVG_Image_resize(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_SVG_Image self)"""
        return _fltk.Fl_SVG_Image_desaturate(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_SVG_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_SVG_Image_color_average(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_SVG_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_SVG_Image self, int X, int Y)
        """
        return _fltk.Fl_SVG_Image_draw(self, *args)

    def as_svg_image(self, *args):
        r"""as_svg_image(Fl_SVG_Image self) -> Fl_SVG_Image"""
        return _fltk.Fl_SVG_Image_as_svg_image(self, *args)

    def normalize(self, *args):
        r"""normalize(Fl_SVG_Image self)"""
        return _fltk.Fl_SVG_Image_normalize(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_SVG_Image(self)
        return weakref.proxy(self)

# Register Fl_SVG_Image in _fltk:
_fltk.Fl_SVG_Image_swigregister(Fl_SVG_Image)
class Fl_SVG_File_Surface(Fl_Widget_Surface):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_SVG_File_Surface self, int width, int height, FILE * svg, int (*)(FILE *) closef=None) -> Fl_SVG_File_Surface"""
        _fltk.Fl_SVG_File_Surface_swiginit(self, _fltk.new_Fl_SVG_File_Surface(*args))
    __swig_destroy__ = _fltk.delete_Fl_SVG_File_Surface

    def file(self, *args):
        r"""file(Fl_SVG_File_Surface self) -> FILE *"""
        return _fltk.Fl_SVG_File_Surface_file(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_SVG_File_Surface self, int x, int y)
        origin(Fl_SVG_File_Surface self, int * x, int * y)
        """
        return _fltk.Fl_SVG_File_Surface_origin(self, *args)

    def translate(self, *args):
        r"""translate(Fl_SVG_File_Surface self, int x, int y)"""
        return _fltk.Fl_SVG_File_Surface_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_SVG_File_Surface self)"""
        return _fltk.Fl_SVG_File_Surface_untranslate(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_SVG_File_Surface self, int * w, int * h) -> int"""
        return _fltk.Fl_SVG_File_Surface_printable_rect(self, *args)

    def close(self, *args):
        r"""close(Fl_SVG_File_Surface self) -> int"""
        return _fltk.Fl_SVG_File_Surface_close(self, *args)

# Register Fl_SVG_File_Surface in _fltk:
_fltk.Fl_SVG_File_Surface_swigregister(Fl_SVG_File_Surface)
class Fl_Roller(Fl_Valuator):
    r"""

    The Fl_Roller widget is a 'dolly' control commonly used to move 3D objects.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Roller self)"""
        return _fltk.Fl_Roller_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Roller self, int arg0) -> int"""
        return _fltk.Fl_Roller_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Roller self, int X, int Y, int W, int H, char const * L=None) -> Fl_Roller"""
        if self.__class__ == Fl_Roller:
            _self = None
        else:
            _self = self
        _fltk.Fl_Roller_swiginit(self, _fltk.new_Fl_Roller(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Roller")
        #print("Adding type: ", Fl_Roller)




    def init_type(self, *args):
        r"""init_type(Fl_Roller self, char * Fl_Roller)"""
        return _fltk.Fl_Roller_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Roller
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Roller(self)
        return weakref.proxy(self)

# Register Fl_Roller in _fltk:
_fltk.Fl_Roller_swigregister(Fl_Roller)
class Fl_Round_Clock(Fl_Clock):
    r"""

    This widget provides a round analog clock display and is provided for 
    Forms compatibility. It installs a 1-second timeout callback using 
    Fl::add_timeout().

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Round_Clock self, int X, int Y, int W, int H, char const * L=None) -> Fl_Round_Clock"""
        if self.__class__ == Fl_Round_Clock:
            _self = None
        else:
            _self = self
        _fltk.Fl_Round_Clock_swiginit(self, _fltk.new_Fl_Round_Clock(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Round_Clock")
        #print("Adding type: ", Fl_Round_Clock)




    def init_type(self, *args):
        r"""init_type(Fl_Round_Clock self, char * Fl_Round_Clock)"""
        return _fltk.Fl_Round_Clock_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Round_Clock
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Clock(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Round_Clock self)"""
        return _fltk.Fl_Round_Clock_draw(self, *args)

# Register Fl_Round_Clock in _fltk:
_fltk.Fl_Round_Clock_swigregister(Fl_Round_Clock)
class Fl_Scroll(Fl_Group):
    r"""

    This container widget lets you maneuver around a set of widgets much larger 
    than your window. If the child widgets are larger than the size of this 
    object then scrollbars will appear so that you can scroll over to them:

    If all of the child widgets are packed together into a solid rectangle then 
    you want to set box() to FL_NO_BOX or one of the _FRAME types. This will 
    result in the best output. However, if the child widgets are a sparse 
    arrangment you must set box() to a real _BOX type. This can result in some 
    blinking during redrawing, but that can be solved by using a Fl_Double_Window.

    This widget can also be used to pan around a single child widget 'canvas'. 
    This child widget should be of your own class, with a draw() method that 
    draws the contents. The scrolling is done by changing the x() and y() of 
    the widget, so this child must use the x() and y() to position it's drawing. 
    To speed up drawing it should test fl_push_clip() .

    Another very useful child is a single Fl_Pack, which is itself a group that 
    packs it's children together and changes size to surround them. Filling the 
    Fl_Pack with Fl_Tabs groups (and then putting normal widgets inside those) 
    gives you a very powerful scrolling list of individually-openable panels.

    Fluid lets you create these, but you can only lay out objects that fit 
    inside the Fl_Scroll without scrolling. Be sure to leave space for the 
    scrollbars, as Fluid won't show these either.

    You cannot use Fl_Window as a child of this since the clipping is not 
    conveyed to it when drawn, and it will draw over the scrollbars and 
    neighboring objects.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Scroll self)"""
        return _fltk.Fl_Scroll_draw(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Scroll self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Scroll_resize(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Scroll self, int arg0) -> int"""
        return _fltk.Fl_Scroll_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Scroll self, int X, int Y, int W, int H, char const * L=None) -> Fl_Scroll"""
        if self.__class__ == Fl_Scroll:
            _self = None
        else:
            _self = self
        _fltk.Fl_Scroll_swiginit(self, _fltk.new_Fl_Scroll(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Scroll")
        #print("Adding type: ", Fl_Scroll)



    __swig_destroy__ = _fltk.delete_Fl_Scroll
    HORIZONTAL = _fltk.Fl_Scroll_HORIZONTAL
    
    VERTICAL = _fltk.Fl_Scroll_VERTICAL
    
    BOTH = _fltk.Fl_Scroll_BOTH
    
    ALWAYS_ON = _fltk.Fl_Scroll_ALWAYS_ON
    
    HORIZONTAL_ALWAYS = _fltk.Fl_Scroll_HORIZONTAL_ALWAYS
    
    VERTICAL_ALWAYS = _fltk.Fl_Scroll_VERTICAL_ALWAYS
    
    BOTH_ALWAYS = _fltk.Fl_Scroll_BOTH_ALWAYS
    

    def xposition(self, *args):
        r"""xposition(Fl_Scroll self) -> int"""
        return _fltk.Fl_Scroll_xposition(self, *args)

    def yposition(self, *args):
        r"""yposition(Fl_Scroll self) -> int"""
        return _fltk.Fl_Scroll_yposition(self, *args)

    def scroll_to(self, *args):
        r"""scroll_to(Fl_Scroll self, int arg2, int arg3)"""
        return _fltk.Fl_Scroll_scroll_to(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Scroll self)"""
        return _fltk.Fl_Scroll_clear(self, *args)

    def delete_child(self, *args):
        r"""delete_child(Fl_Scroll self, int n) -> int"""
        return _fltk.Fl_Scroll_delete_child(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Scroll self) -> int
        scrollbar_size(Fl_Scroll self, int newSize)
        """
        return _fltk.Fl_Scroll_scrollbar_size(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Scroll self, char * Fl_Scroll)"""
        return _fltk.Fl_Scroll_init_type(self, *args)

    def getScrollbar(self, *args):
        r"""getScrollbar(Fl_Scroll self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getScrollbar(self, *args)

    def getHScrollbar(self, *args):
        r"""getHScrollbar(Fl_Scroll self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getHScrollbar(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scroll(self)
        return weakref.proxy(self)

# Register Fl_Scroll in _fltk:
_fltk.Fl_Scroll_swigregister(Fl_Scroll)
class Fl_Scheme_Choice(Fl_Choice):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Scheme_Choice self, int X, int Y, int W, int H, char const * L=None) -> Fl_Scheme_Choice"""
        if self.__class__ == Fl_Scheme_Choice:
            _self = None
        else:
            _self = self
        _fltk.Fl_Scheme_Choice_swiginit(self, _fltk.new_Fl_Scheme_Choice(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Scheme_Choice")
        #print("Adding type: ", Fl_Scheme_Choice)




    def handle(self, *args):
        r"""handle(Fl_Scheme_Choice self, int event) -> int"""
        return _fltk.Fl_Scheme_Choice_handle(self, *args)

    def init_value(self, *args):
        r"""init_value(Fl_Scheme_Choice self)"""
        return _fltk.Fl_Scheme_Choice_init_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Scheme_Choice self, char * Fl_Scheme_Choice)"""
        return _fltk.Fl_Scheme_Choice_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Scheme_Choice
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scheme_Choice(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Scheme_Choice self)"""
        return _fltk.Fl_Scheme_Choice_draw(self, *args)

# Register Fl_Scheme_Choice in _fltk:
_fltk.Fl_Scheme_Choice_swigregister(Fl_Scheme_Choice)
class Fl_Scrollbar(Fl_Slider):
    r"""

    The Fl_Scrollbar widget displays a slider with arrow buttons at the ends 
    of the scrollbar. Clicking on the arrows move up/left and down/right by 
    linesize(). Scrollbars also accept FL_SHORTCUT events: the arrows move by 
    linesize(), and vertical scrollbars take Page Up/Down (they move by the 
    page size minus linesize()) and Home/End (they jump to the top or bottom).

    Scrollbars have step(1) preset (they always return integers). If desired 
    you can set the step() to non-integer values. You will then have to use 
    casts to get at the floating-point versions of value() from Fl_Slider. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Scrollbar self)"""
        return _fltk.Fl_Scrollbar_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Scrollbar self, int X, int Y, int W, int H, char const * L=None) -> Fl_Scrollbar"""
        if self.__class__ == Fl_Scrollbar:
            _self = None
        else:
            _self = self
        _fltk.Fl_Scrollbar_swiginit(self, _fltk.new_Fl_Scrollbar(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Scrollbar")
        #print("Adding type: ", Fl_Scrollbar)



    __swig_destroy__ = _fltk.delete_Fl_Scrollbar

    def handle(self, *args):
        r"""handle(Fl_Scrollbar self, int arg0) -> int"""
        return _fltk.Fl_Scrollbar_handle(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Scrollbar self) -> int
        value(Fl_Scrollbar self, int p) -> int
        value(Fl_Scrollbar self, int pos, int windowSize, int first_line, int total_lines) -> int
        """
        return _fltk.Fl_Scrollbar_value(self, *args)

    def linesize(self, *args):
        r"""
        linesize(Fl_Scrollbar self) -> int
        linesize(Fl_Scrollbar self, int i)
        """
        return _fltk.Fl_Scrollbar_linesize(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Scrollbar self, char * Fl_Scrollbar)"""
        return _fltk.Fl_Scrollbar_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scrollbar(self)
        return weakref.proxy(self)

# Register Fl_Scrollbar in _fltk:
_fltk.Fl_Scrollbar_swigregister(Fl_Scrollbar)
class Fl_Secret_Input(Fl_Input):
    r"""

    The Fl_Secret_Input class is a subclass of Fl_Input  that displays its input 
    as a string of asterisks. This subclass is usually used to receive passwords 
    and other 'secret' information.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Secret_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Secret_Input"""
        if self.__class__ == Fl_Secret_Input:
            _self = None
        else:
            _self = self
        _fltk.Fl_Secret_Input_swiginit(self, _fltk.new_Fl_Secret_Input(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Secret_Input")
        #print("Adding type: ", Fl_Secret_Input)




    def handle(self, *args):
        r"""handle(Fl_Secret_Input self, int arg0) -> int"""
        return _fltk.Fl_Secret_Input_handle(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Secret_Input self, char * Fl_Secret_Input)"""
        return _fltk.Fl_Secret_Input_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Secret_Input
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Secret_Input(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Secret_Input self)"""
        return _fltk.Fl_Secret_Input_draw(self, *args)

# Register Fl_Secret_Input in _fltk:
_fltk.Fl_Secret_Input_swigregister(Fl_Secret_Input)
class Fl_Select_Browser(Fl_Browser):
    r"""

    The Fl_Select_Browser class is a subclass of Fl_Browser  which lets the 
    user select a single item, or no items by clicking on the empty space. As 
    long as the mouse button is held down the item pointed to by it is 
    highlighted. Normally the callback is done when the user presses the mouse, 
    but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Select_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Select_Browser"""
        if self.__class__ == Fl_Select_Browser:
            _self = None
        else:
            _self = self
        _fltk.Fl_Select_Browser_swiginit(self, _fltk.new_Fl_Select_Browser(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Select_Browser")
        #print("Adding type: ", Fl_Select_Browser)




    def init_type(self, *args):
        r"""init_type(Fl_Select_Browser self, char * Fl_Select_Browser)"""
        return _fltk.Fl_Select_Browser_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Select_Browser
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Select_Browser(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Select_Browser self)"""
        return _fltk.Fl_Select_Browser_draw(self, *args)

    def item_first(self, *args):
        r"""item_first(Fl_Select_Browser self) -> void *"""
        return _fltk.Fl_Select_Browser_item_first(self, *args)

    def item_next(self, *args):
        r"""item_next(Fl_Select_Browser self, void * item) -> void *"""
        return _fltk.Fl_Select_Browser_item_next(self, *args)

    def item_prev(self, *args):
        r"""item_prev(Fl_Select_Browser self, void * item) -> void *"""
        return _fltk.Fl_Select_Browser_item_prev(self, *args)

    def item_last(self, *args):
        r"""item_last(Fl_Select_Browser self) -> void *"""
        return _fltk.Fl_Select_Browser_item_last(self, *args)

    def item_height(self, *args):
        r"""item_height(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_height(self, *args)

    def item_width(self, *args):
        r"""item_width(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        r"""item_quick_height(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        r"""item_draw(Fl_Select_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Select_Browser_item_draw(self, *args)

    def item_text(self, *args):
        r"""item_text(Fl_Select_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Select_Browser_item_text(self, *args)

    def item_swap(self, *args):
        r"""item_swap(Fl_Select_Browser self, void * a, void * b)"""
        return _fltk.Fl_Select_Browser_item_swap(self, *args)

    def item_at(self, *args):
        r"""item_at(Fl_Select_Browser self, int line) -> void *"""
        return _fltk.Fl_Select_Browser_item_at(self, *args)

    def full_width(self, *args):
        r"""full_width(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_full_width(self, *args)

    def full_height(self, *args):
        r"""full_height(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_full_height(self, *args)

    def incr_height(self, *args):
        r"""incr_height(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_incr_height(self, *args)

    def item_select(self, *args):
        r"""item_select(Fl_Select_Browser self, void * item, int val)"""
        return _fltk.Fl_Select_Browser_item_select(self, *args)

    def item_selected(self, *args):
        r"""item_selected(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_selected(self, *args)

# Register Fl_Select_Browser in _fltk:
_fltk.Fl_Select_Browser_swigregister(Fl_Select_Browser)
class Fl_Shared_Image(Fl_Image):
    r"""

    The Fl_Shared_Image class supports caching, loading, and drawing of image 
    files. Most applications will also want to link against the fltk_images 
    library and call the fl_register_images() function to support standard image 
    formats such as BMP, GIF, JPEG, and PNG.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Fl_Shared_Image self) -> Fl_Shared_Image
        __init__(Fl_Shared_Image self, char const * n, Fl_Image img=None) -> Fl_Shared_Image
        """
        if self.__class__ == Fl_Shared_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_Shared_Image_swiginit(self, _fltk.new_Fl_Shared_Image(_self, *args))

    def name(self, *args):
        r"""name(Fl_Shared_Image self) -> char const *"""
        return _fltk.Fl_Shared_Image_name(self, *args)

    def refcount(self, *args):
        r"""refcount(Fl_Shared_Image self) -> int"""
        return _fltk.Fl_Shared_Image_refcount(self, *args)

    def original(self, *args):
        r"""original(Fl_Shared_Image self) -> int"""
        return _fltk.Fl_Shared_Image_original(self, *args)

    def release(self, *args):
        r"""release(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_release(self, *args)

    def reload(self, *args):
        r"""reload(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_reload(self, *args)

    def as_shared_image(self, *args):
        r"""as_shared_image(Fl_Shared_Image self) -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_as_shared_image(self, *args)

    def copy(self, *args):
        r"""
        copy(Fl_Shared_Image self, int W, int H) -> Fl_Image
        copy(Fl_Shared_Image self) -> Fl_Image
        copy(Fl_Shared_Image self) -> Fl_Image
        """
        return _fltk.Fl_Shared_Image_copy(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_Shared_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Shared_Image_color_average(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_desaturate(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_Shared_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Shared_Image self, int X, int Y)
        """
        return _fltk.Fl_Shared_Image_draw(self, *args)

    def uncache(self, *args):
        r"""uncache(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_uncache(self, *args)

    @staticmethod
    def find(*args):
        r"""find(char const * name, int W=0, int H=0) -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_find(*args)

    @staticmethod
    def get(*args):
        r"""
        get(char const * name, int W=0, int H=0) -> Fl_Shared_Image
        get(Fl_RGB_Image rgb, int own_it=1) -> Fl_Shared_Image
        """
        return _fltk.Fl_Shared_Image_get(*args)

    @staticmethod
    def images(*args):
        r"""images() -> Fl_Shared_Image **"""
        return _fltk.Fl_Shared_Image_images(*args)

    @staticmethod
    def num_images(*args):
        r"""num_images() -> int"""
        return _fltk.Fl_Shared_Image_num_images(*args)

    @staticmethod
    def add_handler(*args):
        r"""add_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_add_handler(*args)

    @staticmethod
    def remove_handler(*args):
        r"""remove_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_remove_handler(*args)

    def image(self, *args):
        r"""image(Fl_Shared_Image self) -> Fl_Image"""
        return _fltk.Fl_Shared_Image_image(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Shared_Image(self)
        return weakref.proxy(self)

# Register Fl_Shared_Image in _fltk:
_fltk.Fl_Shared_Image_swigregister(Fl_Shared_Image)

def fl_register_images(*args):
    r"""fl_register_images()"""
    return _fltk.fl_register_images(*args)
class Fl_Spinner(Fl_Group):
    r"""

    The Fl_Spinner widget is a combination of the input widget and repeat 
    buttons. The user can either type into the input area or use the buttons 
    to change the value.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Spinner self)"""
        return _fltk.Fl_Spinner_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Spinner self, int X, int Y, int W, int H, char const * L=None) -> Fl_Spinner"""
        if self.__class__ == Fl_Spinner:
            _self = None
        else:
            _self = self
        _fltk.Fl_Spinner_swiginit(self, _fltk.new_Fl_Spinner(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Spinner")
        #print("Adding type: ", Fl_Spinner)




    def handle(self, *args):
        r"""handle(Fl_Spinner self, int event) -> int"""
        return _fltk.Fl_Spinner_handle(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Spinner self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Spinner_resize(self, *args)

    def format(self, *args):
        r"""
        format(Fl_Spinner self) -> char const
        format(Fl_Spinner self, char const * f)
        """
        return _fltk.Fl_Spinner_format(self, *args)

    def range(self, *args):
        r"""range(Fl_Spinner self, double a, double b)"""
        return _fltk.Fl_Spinner_range(self, *args)

    def step(self, *args):
        r"""
        step(Fl_Spinner self, double s)
        step(Fl_Spinner self) -> double
        """
        return _fltk.Fl_Spinner_step(self, *args)

    def wrap(self, *args):
        r"""
        wrap(Fl_Spinner self, int set)
        wrap(Fl_Spinner self) -> int
        """
        return _fltk.Fl_Spinner_wrap(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Spinner self) -> Fl_Color
        textcolor(Fl_Spinner self, Fl_Color c)
        """
        return _fltk.Fl_Spinner_textcolor(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Spinner self) -> Fl_Font
        textfont(Fl_Spinner self, Fl_Font f)
        """
        return _fltk.Fl_Spinner_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Spinner self) -> Fl_Fontsize
        textsize(Fl_Spinner self, Fl_Fontsize s)
        """
        return _fltk.Fl_Spinner_textsize(self, *args)

    def type(self, *args):
        r"""
        type(Fl_Spinner self, uchar v)
        type(Fl_Spinner self) -> uchar
        """
        return _fltk.Fl_Spinner_type(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Spinner self) -> double
        value(Fl_Spinner self, double v)
        """
        return _fltk.Fl_Spinner_value(self, *args)

    def color(self, *args):
        r"""
        color(Fl_Spinner self, Fl_Color v)
        color(Fl_Spinner self) -> Fl_Color
        """
        return _fltk.Fl_Spinner_color(self, *args)

    def selection_color(self, *args):
        r"""
        selection_color(Fl_Spinner self, Fl_Color val)
        selection_color(Fl_Spinner self) -> Fl_Color
        """
        return _fltk.Fl_Spinner_selection_color(self, *args)

    def maximum_size(self, *args):
        r"""
        maximum_size(Fl_Spinner self, int m)
        maximum_size(Fl_Spinner self) -> int
        """
        return _fltk.Fl_Spinner_maximum_size(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Spinner self, char * Fl_Spinner)"""
        return _fltk.Fl_Spinner_init_type(self, *args)

    def minimum(self, *args):
        r"""
        minimum(Fl_Spinner self, double m)
        minimum(Fl_Spinner self) -> double
        """
        return _fltk.Fl_Spinner_minimum(self, *args)

    def maximum(self, *args):
        r"""
        maximum(Fl_Spinner self, double m)
        maximum(Fl_Spinner self) -> double
        """
        return _fltk.Fl_Spinner_maximum(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Spinner
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Spinner(self)
        return weakref.proxy(self)

# Register Fl_Spinner in _fltk:
_fltk.Fl_Spinner_swigregister(Fl_Spinner)

def fl_show_colormap(*args):
    r"""fl_show_colormap(Fl_Color oldcol) -> Fl_Color"""
    return _fltk.fl_show_colormap(*args)
class Fl_Simple_Counter(Fl_Counter):
    r"""Proxy of C++ Fl_Simple_Counter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Simple_Counter self, int X, int Y, int W, int H, char const * L=None) -> Fl_Simple_Counter"""
        if self.__class__ == Fl_Simple_Counter:
            _self = None
        else:
            _self = self
        _fltk.Fl_Simple_Counter_swiginit(self, _fltk.new_Fl_Simple_Counter(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Simple_Counter")
        #print("Adding type: ", Fl_Simple_Counter)




    def init_type(self, *args):
        r"""init_type(Fl_Simple_Counter self, char * Fl_Simple_Counter)"""
        return _fltk.Fl_Simple_Counter_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Simple_Counter
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Simple_Counter(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Simple_Counter self)"""
        return _fltk.Fl_Simple_Counter_draw(self, *args)

# Register Fl_Simple_Counter in _fltk:
_fltk.Fl_Simple_Counter_swigregister(Fl_Simple_Counter)
class Fl_Sys_Menu_Bar(Fl_Menu_Bar):
    r"""Proxy of C++ Fl_Sys_Menu_Bar class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Sys_Menu_Bar self)"""
        return _fltk.Fl_Sys_Menu_Bar_draw(self, *args)
    no_window_menu = _fltk.Fl_Sys_Menu_Bar_no_window_menu
    
    tabbing_mode_none = _fltk.Fl_Sys_Menu_Bar_tabbing_mode_none
    
    tabbing_mode_automatic = _fltk.Fl_Sys_Menu_Bar_tabbing_mode_automatic
    
    tabbing_mode_preferred = _fltk.Fl_Sys_Menu_Bar_tabbing_mode_preferred
    

    def __init__(self, *args):
        r"""__init__(Fl_Sys_Menu_Bar self, int x, int y, int w, int h, char const * l=None) -> Fl_Sys_Menu_Bar"""
        if self.__class__ == Fl_Sys_Menu_Bar:
            _self = None
        else:
            _self = self
        _fltk.Fl_Sys_Menu_Bar_swiginit(self, _fltk.new_Fl_Sys_Menu_Bar(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Sys_Menu_Bar")
        #print("Adding type: ", Fl_Sys_Menu_Bar)



    __swig_destroy__ = _fltk.delete_Fl_Sys_Menu_Bar

    def menu(self, *args):
        r"""menu(Fl_Sys_Menu_Bar self) -> Fl_Menu_Item"""
        return _fltk.Fl_Sys_Menu_Bar_menu(self, *args)

    def update(self, *args):
        r"""update(Fl_Sys_Menu_Bar self)"""
        return _fltk.Fl_Sys_Menu_Bar_update(self, *args)

    def play_menu(self, *args):
        r"""play_menu(Fl_Sys_Menu_Bar self, Fl_Menu_Item arg0)"""
        return _fltk.Fl_Sys_Menu_Bar_play_menu(self, *args)

    def add(self, *args):
        r"""
        add(Fl_Sys_Menu_Bar self, char const * label, int shortcut, Fl_Callback * arg4, void * user_data=None, int flags=0) -> int
        add(Fl_Sys_Menu_Bar self, char const * str) -> int
        """
        return _fltk.Fl_Sys_Menu_Bar_add(self, *args)

    def insert(self, *args):
        r"""
        insert(Fl_Sys_Menu_Bar self, int index, char const * label, int shortcut, Fl_Callback * cb, void * user_data=None, int flags=0) -> int
        insert(Fl_Sys_Menu_Bar self, int index, char const * label, char const * shortcut, Fl_Callback * cb, void * user_data=None, int flags=0) -> int
        """
        return _fltk.Fl_Sys_Menu_Bar_insert(self, *args)

    def remove(self, *args):
        r"""remove(Fl_Sys_Menu_Bar self, int n)"""
        return _fltk.Fl_Sys_Menu_Bar_remove(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Sys_Menu_Bar self, int index, char const * name)"""
        return _fltk.Fl_Sys_Menu_Bar_replace(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Sys_Menu_Bar self)"""
        return _fltk.Fl_Sys_Menu_Bar_clear(self, *args)

    def clear_submenu(self, *args):
        r"""clear_submenu(Fl_Sys_Menu_Bar self, int index) -> int"""
        return _fltk.Fl_Sys_Menu_Bar_clear_submenu(self, *args)

    def mode(self, *args):
        r"""
        mode(Fl_Sys_Menu_Bar self, int i, int fl)
        mode(Fl_Sys_Menu_Bar self, int i) -> int
        """
        return _fltk.Fl_Sys_Menu_Bar_mode(self, *args)

    def shortcut(self, *args):
        r"""shortcut(Fl_Sys_Menu_Bar self, int i, int s)"""
        return _fltk.Fl_Sys_Menu_Bar_shortcut(self, *args)

    def setonly(self, *args):
        r"""setonly(Fl_Sys_Menu_Bar self, Fl_Menu_Item item)"""
        return _fltk.Fl_Sys_Menu_Bar_setonly(self, *args)

    @staticmethod
    def about(*args):
        r"""about(Fl_Callback * cb, void * data)"""
        return _fltk.Fl_Sys_Menu_Bar_about(*args)

    @staticmethod
    def window_menu_style(*args):
        r"""
        window_menu_style() -> Fl_Sys_Menu_Bar::window_menu_style_enum
        window_menu_style(Fl_Sys_Menu_Bar::window_menu_style_enum style)
        """
        return _fltk.Fl_Sys_Menu_Bar_window_menu_style(*args)

    @staticmethod
    def create_window_menu(*args):
        r"""create_window_menu()"""
        return _fltk.Fl_Sys_Menu_Bar_create_window_menu(*args)

    def init_type(self, *args):
        r"""init_type(Fl_Sys_Menu_Bar self, char * Fl_Sys_Menu_Bar)"""
        return _fltk.Fl_Sys_Menu_Bar_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Sys_Menu_Bar(self)
        return weakref.proxy(self)

# Register Fl_Sys_Menu_Bar in _fltk:
_fltk.Fl_Sys_Menu_Bar_swigregister(Fl_Sys_Menu_Bar)
class Fl_Table(Fl_Group):
    r"""

    This is the base class for table widgets. (eg. Fl_Table_Row). To be useful it must be subclassed and several virtual functions defined. Normally applications use widgets derived from this widget, and do not use this widget directly; this widget is usually too low level to be used directly by applications.

    This widget does not handle the data in the table. The draw_cell() method must be overridden by a subclass to manage drawing the contents of the cells.

    This widget can be used in several ways:

        * As a custom widget; see testtablerow.cxx. Very optimal for even extremely large tables.

        * As a table made up of a single FLTK widget instanced all over the table; see singleinput.cxx. Very optimal for even extremely large tables;

        * As a regular container of FLTK widgets, one widget per cell. See widgettable.cxx. Not recommended for large tables.

    When acting as part of a custom widget, events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the setting for Fl_Table::when().

    When acting as a container for FLTK widgets, the FLTK widgets maintain themselves. Although the draw_cell() method must be overridden, its contents can be very simple. See the draw_cell() code in widgettable.cxx. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    CONTEXT_NONE = _fltk.Fl_Table_CONTEXT_NONE
    
    CONTEXT_STARTPAGE = _fltk.Fl_Table_CONTEXT_STARTPAGE
    
    CONTEXT_ENDPAGE = _fltk.Fl_Table_CONTEXT_ENDPAGE
    
    CONTEXT_ROW_HEADER = _fltk.Fl_Table_CONTEXT_ROW_HEADER
    
    CONTEXT_COL_HEADER = _fltk.Fl_Table_CONTEXT_COL_HEADER
    
    CONTEXT_CELL = _fltk.Fl_Table_CONTEXT_CELL
    
    CONTEXT_TABLE = _fltk.Fl_Table_CONTEXT_TABLE
    
    CONTEXT_RC_RESIZE = _fltk.Fl_Table_CONTEXT_RC_RESIZE
    

    def handle(self, *args):
        r"""handle(Fl_Table self, int e) -> int"""
        return _fltk.Fl_Table_handle(self, *args)

    def draw_cell(self, *args):
        r"""draw_cell(Fl_Table self, Fl_Table::TableContext context, int R=0, int C=0, int X=0, int Y=0, int W=0, int H=0)"""
        return _fltk.Fl_Table_draw_cell(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Table self)"""
        return _fltk.Fl_Table_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Table self, int X, int Y, int W, int H, char const * l=None) -> Fl_Table"""
        if self.__class__ == Fl_Table:
            _self = None
        else:
            _self = self
        _fltk.Fl_Table_swiginit(self, _fltk.new_Fl_Table(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Table")
        #print("Adding type: ", Fl_Table)



    __swig_destroy__ = _fltk.delete_Fl_Table

    def clear(self, *args):
        r"""clear(Fl_Table self)"""
        return _fltk.Fl_Table_clear(self, *args)

    def table_box(self, *args):
        r"""
        table_box(Fl_Table self, Fl_Boxtype val)
        table_box(Fl_Table self) -> Fl_Boxtype
        """
        return _fltk.Fl_Table_table_box(self, *args)

    def rows(self, *args):
        r"""
        rows(Fl_Table self, int val)
        rows(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_rows(self, *args)

    def cols(self, *args):
        r"""
        cols(Fl_Table self, int val)
        cols(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_cols(self, *args)

    def visible_cells(self, *args):
        r"""visible_cells(Fl_Table self)"""
        return _fltk.Fl_Table_visible_cells(self, *args)

    def is_interactive_resize(self, *args):
        r"""is_interactive_resize(Fl_Table self) -> int"""
        return _fltk.Fl_Table_is_interactive_resize(self, *args)

    def row_resize(self, *args):
        r"""
        row_resize(Fl_Table self) -> int
        row_resize(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_row_resize(self, *args)

    def col_resize(self, *args):
        r"""
        col_resize(Fl_Table self) -> int
        col_resize(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_col_resize(self, *args)

    def col_resize_min(self, *args):
        r"""
        col_resize_min(Fl_Table self) -> int
        col_resize_min(Fl_Table self, int val)
        """
        return _fltk.Fl_Table_col_resize_min(self, *args)

    def row_resize_min(self, *args):
        r"""
        row_resize_min(Fl_Table self) -> int
        row_resize_min(Fl_Table self, int val)
        """
        return _fltk.Fl_Table_row_resize_min(self, *args)

    def row_header(self, *args):
        r"""
        row_header(Fl_Table self) -> int
        row_header(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_row_header(self, *args)

    def col_header(self, *args):
        r"""
        col_header(Fl_Table self) -> int
        col_header(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_col_header(self, *args)

    def col_header_height(self, *args):
        r"""
        col_header_height(Fl_Table self, int height)
        col_header_height(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_col_header_height(self, *args)

    def row_header_width(self, *args):
        r"""
        row_header_width(Fl_Table self, int width)
        row_header_width(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_row_header_width(self, *args)

    def row_header_color(self, *args):
        r"""
        row_header_color(Fl_Table self, Fl_Color val)
        row_header_color(Fl_Table self) -> Fl_Color
        """
        return _fltk.Fl_Table_row_header_color(self, *args)

    def col_header_color(self, *args):
        r"""
        col_header_color(Fl_Table self, Fl_Color val)
        col_header_color(Fl_Table self) -> Fl_Color
        """
        return _fltk.Fl_Table_col_header_color(self, *args)

    def row_height(self, *args):
        r"""
        row_height(Fl_Table self, int row, int height)
        row_height(Fl_Table self, int row) -> int
        """
        return _fltk.Fl_Table_row_height(self, *args)

    def col_width(self, *args):
        r"""
        col_width(Fl_Table self, int col, int width)
        col_width(Fl_Table self, int col) -> int
        """
        return _fltk.Fl_Table_col_width(self, *args)

    def row_height_all(self, *args):
        r"""row_height_all(Fl_Table self, int height)"""
        return _fltk.Fl_Table_row_height_all(self, *args)

    def col_width_all(self, *args):
        r"""col_width_all(Fl_Table self, int width)"""
        return _fltk.Fl_Table_col_width_all(self, *args)

    def row_position(self, *args):
        r"""
        row_position(Fl_Table self, int row)
        row_position(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_row_position(self, *args)

    def col_position(self, *args):
        r"""
        col_position(Fl_Table self, int col)
        col_position(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_col_position(self, *args)

    def top_row(self, *args):
        r"""
        top_row(Fl_Table self, int row)
        top_row(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_top_row(self, *args)

    def is_selected(self, *args):
        r"""is_selected(Fl_Table self, int r, int c) -> int"""
        return _fltk.Fl_Table_is_selected(self, *args)

    def get_selection(self, *args):
        r"""get_selection(Fl_Table self)"""
        return _fltk.Fl_Table_get_selection(self, *args)

    def set_selection(self, *args):
        r"""set_selection(Fl_Table self, int row_top, int col_left, int row_bot, int col_right)"""
        return _fltk.Fl_Table_set_selection(self, *args)

    def move_cursor(self, *args):
        r"""
        move_cursor(Fl_Table self, int R, int C, int shiftselect) -> int
        move_cursor(Fl_Table self, int R, int C) -> int
        """
        return _fltk.Fl_Table_move_cursor(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Table self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Table_resize(self, *args)

    def init_sizes(self, *args):
        r"""init_sizes(Fl_Table self)"""
        return _fltk.Fl_Table_init_sizes(self, *args)

    def add(self, *args):
        r"""add(Fl_Table self, Fl_Widget wgt)"""
        val = _fltk.Fl_Table_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args):
        r"""insert(Fl_Table self, Fl_Widget wgt, int n)"""
        return _fltk.Fl_Table_insert(self, *args)

    def insert_before(self, *args):
        r"""insert_before(Fl_Table self, Fl_Widget wgt, Fl_Widget w2)"""
        return _fltk.Fl_Table_insert_before(self, *args)

    def begin(self, *args):
        r"""begin(Fl_Table self)"""
        return _fltk.Fl_Table_begin(self, *args)

    def end(self, *args):
        r"""end(Fl_Table self)"""
        return _fltk.Fl_Table_end(self, *args)

    def child(self, *args):
        r"""child(Fl_Table self, int n) -> Fl_Widget"""
        return _fltk.Fl_Table_child(self, *args)

    def children(self, *args):
        r"""children(Fl_Table self) -> int"""
        return _fltk.Fl_Table_children(self, *args)

    def find(self, *args):
        r"""find(Fl_Table self, Fl_Widget wgt) -> int"""
        return _fltk.Fl_Table_find(self, *args)

    def callback_row(self, *args):
        r"""callback_row(Fl_Table self) -> int"""
        return _fltk.Fl_Table_callback_row(self, *args)

    def callback_col(self, *args):
        r"""callback_col(Fl_Table self) -> int"""
        return _fltk.Fl_Table_callback_col(self, *args)

    def callback_context(self, *args):
        r"""callback_context(Fl_Table self) -> Fl_Table::TableContext"""
        return _fltk.Fl_Table_callback_context(self, *args)

    def do_callback(self, *args):
        r"""do_callback(Fl_Table self, Fl_Table::TableContext context, int row, int col)"""
        return _fltk.Fl_Table_do_callback(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Table self) -> int
        scrollbar_size(Fl_Table self, int newSize)
        """
        return _fltk.Fl_Table_scrollbar_size(self, *args)

    def tab_cell_nav(self, *args):
        r"""
        tab_cell_nav(Fl_Table self, int val)
        tab_cell_nav(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_tab_cell_nav(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Table self, char * Fl_Table)"""
        return _fltk.Fl_Table_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table(self)
        return weakref.proxy(self)

# Register Fl_Table in _fltk:
_fltk.Fl_Table_swigregister(Fl_Table)
class Fl_Table_Row(Fl_Table):
    r"""

    This class implements a simple table of rows and columns that specializes in the selection of rows. This widget is similar in behavior to a 'mail subject browser', similar to that found in mozilla, netscape and outlook mail browsers.

    Most methods of importance will be found in the Fl_Table widget, such as rows() and cols().

    To be useful it must be subclassed and at minimum the draw_cell() method must be overridden to provide the content of the cells. This widget does not manage the cell's data content; it is up to the parent class's draw_cell() method override to provide this.

    Events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the values you supply for when(). 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SELECT_NONE = _fltk.Fl_Table_Row_SELECT_NONE
    
    SELECT_SINGLE = _fltk.Fl_Table_Row_SELECT_SINGLE
    
    SELECT_MULTI = _fltk.Fl_Table_Row_SELECT_MULTI
    

    def handle(self, *args):
        r"""handle(Fl_Table_Row self, int event) -> int"""
        return _fltk.Fl_Table_Row_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Table_Row self, int X, int Y, int W, int H, char const * l=None) -> Fl_Table_Row"""
        if self.__class__ == Fl_Table_Row:
            _self = None
        else:
            _self = self
        _fltk.Fl_Table_Row_swiginit(self, _fltk.new_Fl_Table_Row(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Table_Row")
        #print("Adding type: ", Fl_Table_Row)



    __swig_destroy__ = _fltk.delete_Fl_Table_Row

    def rows(self, *args):
        r"""
        rows(Fl_Table_Row self, int val)
        rows(Fl_Table_Row self) -> int
        """
        return _fltk.Fl_Table_Row_rows(self, *args)

    def type(self, *args):
        r"""
        type(Fl_Table_Row self, Fl_Table_Row::TableRowSelectMode val)
        type(Fl_Table_Row self) -> Fl_Table_Row::TableRowSelectMode
        """
        return _fltk.Fl_Table_Row_type(self, *args)

    def row_selected(self, *args):
        r"""row_selected(Fl_Table_Row self, int row) -> int"""
        return _fltk.Fl_Table_Row_row_selected(self, *args)

    def select_row(self, *args):
        r"""select_row(Fl_Table_Row self, int row, int flag=1) -> int"""
        return _fltk.Fl_Table_Row_select_row(self, *args)

    def select_all_rows(self, *args):
        r"""select_all_rows(Fl_Table_Row self, int flag=1)"""
        return _fltk.Fl_Table_Row_select_all_rows(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Table_Row self)"""
        return _fltk.Fl_Table_Row_clear(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Table_Row self, char * Fl_Table_Row)"""
        return _fltk.Fl_Table_Row_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table_Row(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Table_Row self)"""
        return _fltk.Fl_Table_Row_draw(self, *args)

    def draw_cell(self, *args):
        r"""draw_cell(Fl_Table_Row self, Fl_Table::TableContext context, int R=0, int C=0, int X=0, int Y=0, int W=0, int H=0)"""
        return _fltk.Fl_Table_Row_draw_cell(self, *args)

# Register Fl_Table_Row in _fltk:
_fltk.Fl_Table_Row_swigregister(Fl_Table_Row)
class Fl_Tabs(Fl_Group):
    r"""

    The Fl_Tabs widget is the 'file card tabs' interface that allows you to 
    put lots and lots of buttons and switches in a panel, as popularized by 
    many toolkits.

    Clicking the tab makes a child visible() by calling show() on it, and 
    all other children are made invisible by calling hide() on them. Usually 
    the children are Fl_Group widgets containing several widgets themselves.

    Each child makes a card, and it's label() is printed on the card tab, 
    including the label font and style. The selection color of that child 
    is used to color the tab, while the color of the child determines the 
    background color of the pane.

    The size of the tabs is controlled by the bounding box of the children 
    (there should be some space between the children and the edge of the Fl_Tabs), 
    and the tabs may be placed 'inverted' on the bottom, this is determined 
    by which gap is larger. It is easiest to lay this out in fluid, using the 
    fluid browser to select each child group and resize them until the tabs 
    look the way you want them to. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def redraw_tabs(self, *args):
        r"""redraw_tabs(Fl_Tabs self)"""
        return _fltk.Fl_Tabs_redraw_tabs(self, *args)

    def tab_positions(self, *args):
        r"""tab_positions(Fl_Tabs self) -> int"""
        return _fltk.Fl_Tabs_tab_positions(self, *args)

    def clear_tab_positions(self, *args):
        r"""clear_tab_positions(Fl_Tabs self)"""
        return _fltk.Fl_Tabs_clear_tab_positions(self, *args)

    def draw_tab(self, *args):
        r"""draw_tab(Fl_Tabs self, int x1, int x2, int W, int H, Fl_Widget o, int flags, int sel)"""
        return _fltk.Fl_Tabs_draw_tab(self, *args)

    def tab_height(self, *args):
        r"""tab_height(Fl_Tabs self) -> int"""
        return _fltk.Fl_Tabs_tab_height(self, *args)

    def hit_close(self, *args):
        r"""hit_close(Fl_Tabs self, Fl_Widget o, int event_x, int event_y) -> int"""
        return _fltk.Fl_Tabs_hit_close(self, *args)

    def hit_overflow_menu(self, *args):
        r"""hit_overflow_menu(Fl_Tabs self, int event_x, int event_y) -> int"""
        return _fltk.Fl_Tabs_hit_overflow_menu(self, *args)

    def hit_tabs_area(self, *args):
        r"""hit_tabs_area(Fl_Tabs self, int event_x, int event_y) -> int"""
        return _fltk.Fl_Tabs_hit_tabs_area(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Tabs self)"""
        return _fltk.Fl_Tabs_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Tabs self, int X, int Y, int W, int H, char const * L=None) -> Fl_Tabs"""
        if self.__class__ == Fl_Tabs:
            _self = None
        else:
            _self = self
        _fltk.Fl_Tabs_swiginit(self, _fltk.new_Fl_Tabs(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Tabs")
        #print("Adding type: ", Fl_Tabs)



    __swig_destroy__ = _fltk.delete_Fl_Tabs

    def resize(self, *args):
        r"""resize(Fl_Tabs self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Tabs_resize(self, *args)

    def show(self, *args):
        r"""show(Fl_Tabs self)"""
        return _fltk.Fl_Tabs_show(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Tabs self, int arg0) -> int"""
        return _fltk.Fl_Tabs_handle(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Tabs self) -> Fl_Widget
        value(Fl_Tabs self, Fl_Widget arg2) -> int
        """
        return _fltk.Fl_Tabs_value(self, *args)

    def push(self, *args):
        r"""
        push(Fl_Tabs self) -> Fl_Widget
        push(Fl_Tabs self, Fl_Widget arg2) -> int
        """
        return _fltk.Fl_Tabs_push(self, *args)

    def which(self, *args):
        r"""which(Fl_Tabs self, int event_x, int event_y) -> Fl_Widget"""
        return _fltk.Fl_Tabs_which(self, *args)

    def client_area(self, *args):
        r"""client_area(Fl_Tabs self, int tabh=0)"""
        return _fltk.Fl_Tabs_client_area(self, *args)

    def tab_align(self, *args):
        r"""
        tab_align(Fl_Tabs self, Fl_Align a)
        tab_align(Fl_Tabs self) -> Fl_Align
        """
        return _fltk.Fl_Tabs_tab_align(self, *args)
    OVERFLOW_COMPRESS = _fltk.Fl_Tabs_OVERFLOW_COMPRESS
    
    OVERFLOW_CLIP = _fltk.Fl_Tabs_OVERFLOW_CLIP
    
    OVERFLOW_PULLDOWN = _fltk.Fl_Tabs_OVERFLOW_PULLDOWN
    
    OVERFLOW_DRAG = _fltk.Fl_Tabs_OVERFLOW_DRAG
    

    def handle_overflow(self, *args):
        r"""handle_overflow(Fl_Tabs self, int ov)"""
        return _fltk.Fl_Tabs_handle_overflow(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Tabs self, char * Fl_Tabs)"""
        return _fltk.Fl_Tabs_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tabs(self)
        return weakref.proxy(self)

# Register Fl_Tabs in _fltk:
_fltk.Fl_Tabs_swigregister(Fl_Tabs)
class Fl_Terminal(Fl_Group):
    r"""



    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    NO_REDRAW = _fltk.Fl_Terminal_NO_REDRAW
    
    RATE_LIMITED = _fltk.Fl_Terminal_RATE_LIMITED
    
    PER_WRITE = _fltk.Fl_Terminal_PER_WRITE
    
    NORMAL = _fltk.Fl_Terminal_NORMAL
    
    BOLD = _fltk.Fl_Terminal_BOLD
    
    DIM = _fltk.Fl_Terminal_DIM
    
    ITALIC = _fltk.Fl_Terminal_ITALIC
    
    UNDERLINE = _fltk.Fl_Terminal_UNDERLINE
    
    _RESERVED_1 = _fltk.Fl_Terminal__RESERVED_1
    
    INVERSE = _fltk.Fl_Terminal_INVERSE
    
    _RESERVED_2 = _fltk.Fl_Terminal__RESERVED_2
    
    STRIKEOUT = _fltk.Fl_Terminal_STRIKEOUT
    
    FG_XTERM = _fltk.Fl_Terminal_FG_XTERM
    
    BG_XTERM = _fltk.Fl_Terminal_BG_XTERM
    
    EOL = _fltk.Fl_Terminal_EOL
    
    RESV_A = _fltk.Fl_Terminal_RESV_A
    
    RESV_B = _fltk.Fl_Terminal_RESV_B
    
    RESV_C = _fltk.Fl_Terminal_RESV_C
    
    RESV_D = _fltk.Fl_Terminal_RESV_D
    
    RESV_E = _fltk.Fl_Terminal_RESV_E
    
    COLORMASK = _fltk.Fl_Terminal_COLORMASK
    
    OFF = _fltk.Fl_Terminal_OFF
    
    CR_TO_LF = _fltk.Fl_Terminal_CR_TO_LF
    
    LF_TO_CR = _fltk.Fl_Terminal_LF_TO_CR
    
    LF_TO_CRLF = _fltk.Fl_Terminal_LF_TO_CRLF
    
    SCROLLBAR_OFF = _fltk.Fl_Terminal_SCROLLBAR_OFF
    
    SCROLLBAR_AUTO = _fltk.Fl_Terminal_SCROLLBAR_AUTO
    
    SCROLLBAR_ON = _fltk.Fl_Terminal_SCROLLBAR_ON
    

    def selection_text_len(self, *args):
        r"""selection_text_len(Fl_Terminal self) -> int"""
        return _fltk.Fl_Terminal_selection_text_len(self, *args)

    def selection_text(self, *args):
        r"""selection_text(Fl_Terminal self) -> char const *"""
        return _fltk.Fl_Terminal_selection_text(self, *args)

    def clear(self, *args):
        r"""
        clear(Fl_Terminal self)
        clear(Fl_Terminal self, Fl_Color val)
        """
        return _fltk.Fl_Terminal_clear(self, *args)

    def clear_screen(self, *args):
        r"""clear_screen(Fl_Terminal self, bool scroll_to_hist=True)"""
        return _fltk.Fl_Terminal_clear_screen(self, *args)

    def clear_screen_home(self, *args):
        r"""clear_screen_home(Fl_Terminal self, bool scroll_to_hist=True)"""
        return _fltk.Fl_Terminal_clear_screen_home(self, *args)

    def clear_history(self, *args):
        r"""clear_history(Fl_Terminal self)"""
        return _fltk.Fl_Terminal_clear_history(self, *args)

    def reset_terminal(self, *args):
        r"""reset_terminal(Fl_Terminal self)"""
        return _fltk.Fl_Terminal_reset_terminal(self, *args)

    def cursor_home(self, *args):
        r"""cursor_home(Fl_Terminal self)"""
        return _fltk.Fl_Terminal_cursor_home(self, *args)

    def cursorfgcolor(self, *args):
        r"""
        cursorfgcolor(Fl_Terminal self, Fl_Color val)
        cursorfgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_cursorfgcolor(self, *args)

    def cursorbgcolor(self, *args):
        r"""
        cursorbgcolor(Fl_Terminal self, Fl_Color val)
        cursorbgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_cursorbgcolor(self, *args)

    def cursor_row(self, *args):
        r"""cursor_row(Fl_Terminal self) -> int"""
        return _fltk.Fl_Terminal_cursor_row(self, *args)

    def cursor_col(self, *args):
        r"""cursor_col(Fl_Terminal self) -> int"""
        return _fltk.Fl_Terminal_cursor_col(self, *args)

    def output_translate(self, *args):
        r"""
        output_translate(Fl_Terminal self, Fl_Terminal::OutFlags val)
        output_translate(Fl_Terminal self) -> Fl_Terminal::OutFlags
        """
        return _fltk.Fl_Terminal_output_translate(self, *args)

    def plot_char(self, *args):
        r"""
        plot_char(Fl_Terminal self, char const * text, int len, int drow, int dcol)
        plot_char(Fl_Terminal self, char c, int drow, int dcol)
        """
        return _fltk.Fl_Terminal_plot_char(self, *args)

    def print_char(self, *args):
        r"""
        print_char(Fl_Terminal self, char const * text, int len=-1)
        print_char(Fl_Terminal self, char c)
        """
        return _fltk.Fl_Terminal_print_char(self, *args)

    def append_utf8(self, *args):
        r"""append_utf8(Fl_Terminal self, char const * buf, int len=-1)"""
        return _fltk.Fl_Terminal_append_utf8(self, *args)

    def append_ascii(self, *args):
        r"""append_ascii(Fl_Terminal self, char const * s)"""
        return _fltk.Fl_Terminal_append_ascii(self, *args)

    def append(self, *args):
        r"""append(Fl_Terminal self, char const * s, int len=-1)"""
        return _fltk.Fl_Terminal_append(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Terminal self)"""
        return _fltk.Fl_Terminal_draw(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Terminal self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Terminal_resize(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Terminal self, int e) -> int"""
        return _fltk.Fl_Terminal_handle(self, *args)

    def text(self, *args):
        r"""text(Fl_Terminal self, bool lines_below_cursor=False) -> char const *"""
        return _fltk.Fl_Terminal_text(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Terminal self) -> int
        scrollbar_size(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_scrollbar_size(self, *args)

    def scrollbar_actual_size(self, *args):
        r"""scrollbar_actual_size(Fl_Terminal self) -> int"""
        return _fltk.Fl_Terminal_scrollbar_actual_size(self, *args)

    def hscrollbar_style(self, *args):
        r"""
        hscrollbar_style(Fl_Terminal self, Fl_Terminal::ScrollbarStyle val)
        hscrollbar_style(Fl_Terminal self) -> Fl_Terminal::ScrollbarStyle
        """
        return _fltk.Fl_Terminal_hscrollbar_style(self, *args)

    def history_rows(self, *args):
        r"""
        history_rows(Fl_Terminal self) -> int
        history_rows(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_history_rows(self, *args)

    def history_use(self, *args):
        r"""history_use(Fl_Terminal self) -> int"""
        return _fltk.Fl_Terminal_history_use(self, *args)

    def display_rows(self, *args):
        r"""
        display_rows(Fl_Terminal self) -> int
        display_rows(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_display_rows(self, *args)

    def display_columns(self, *args):
        r"""
        display_columns(Fl_Terminal self) -> int
        display_columns(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_display_columns(self, *args)

    def box(self, *args):
        r"""
        box(Fl_Terminal self, Fl_Boxtype val)
        box(Fl_Terminal self) -> Fl_Boxtype
        """
        return _fltk.Fl_Terminal_box(self, *args)

    def margin_left(self, *args):
        r"""
        margin_left(Fl_Terminal self) -> int
        margin_left(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_margin_left(self, *args)

    def margin_right(self, *args):
        r"""
        margin_right(Fl_Terminal self) -> int
        margin_right(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_margin_right(self, *args)

    def margin_top(self, *args):
        r"""
        margin_top(Fl_Terminal self) -> int
        margin_top(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_margin_top(self, *args)

    def margin_bottom(self, *args):
        r"""
        margin_bottom(Fl_Terminal self) -> int
        margin_bottom(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_margin_bottom(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Terminal self, Fl_Font val)
        textfont(Fl_Terminal self) -> Fl_Font
        """
        return _fltk.Fl_Terminal_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Terminal self, Fl_Fontsize val)
        textsize(Fl_Terminal self) -> Fl_Fontsize
        """
        return _fltk.Fl_Terminal_textsize(self, *args)

    def color(self, *args):
        r"""
        color(Fl_Terminal self, Fl_Color val)
        color(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_color(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Terminal self, Fl_Color val)
        textcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_textcolor(self, *args)

    def textfgcolor(self, *args):
        r"""
        textfgcolor(Fl_Terminal self, Fl_Color val)
        textfgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_textfgcolor(self, *args)

    def textbgcolor(self, *args):
        r"""
        textbgcolor(Fl_Terminal self, Fl_Color val)
        textbgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_textbgcolor(self, *args)

    def textfgcolor_default(self, *args):
        r"""
        textfgcolor_default(Fl_Terminal self, Fl_Color val)
        textfgcolor_default(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_textfgcolor_default(self, *args)

    def textbgcolor_default(self, *args):
        r"""
        textbgcolor_default(Fl_Terminal self, Fl_Color val)
        textbgcolor_default(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_textbgcolor_default(self, *args)

    def textfgcolor_xterm(self, *args):
        r"""textfgcolor_xterm(Fl_Terminal self, uchar val)"""
        return _fltk.Fl_Terminal_textfgcolor_xterm(self, *args)

    def textbgcolor_xterm(self, *args):
        r"""textbgcolor_xterm(Fl_Terminal self, uchar val)"""
        return _fltk.Fl_Terminal_textbgcolor_xterm(self, *args)

    def selectionfgcolor(self, *args):
        r"""
        selectionfgcolor(Fl_Terminal self, Fl_Color val)
        selectionfgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_selectionfgcolor(self, *args)

    def selectionbgcolor(self, *args):
        r"""
        selectionbgcolor(Fl_Terminal self, Fl_Color val)
        selectionbgcolor(Fl_Terminal self) -> Fl_Color
        """
        return _fltk.Fl_Terminal_selectionbgcolor(self, *args)

    def textattrib(self, *args):
        r"""
        textattrib(Fl_Terminal self, uchar val)
        textattrib(Fl_Terminal self) -> uchar
        """
        return _fltk.Fl_Terminal_textattrib(self, *args)

    def redraw_style(self, *args):
        r"""
        redraw_style(Fl_Terminal self) -> Fl_Terminal::RedrawStyle
        redraw_style(Fl_Terminal self, Fl_Terminal::RedrawStyle val)
        """
        return _fltk.Fl_Terminal_redraw_style(self, *args)

    def redraw_rate(self, *args):
        r"""
        redraw_rate(Fl_Terminal self) -> float
        redraw_rate(Fl_Terminal self, float val)
        """
        return _fltk.Fl_Terminal_redraw_rate(self, *args)

    def show_unknown(self, *args):
        r"""
        show_unknown(Fl_Terminal self) -> bool
        show_unknown(Fl_Terminal self, bool val)
        """
        return _fltk.Fl_Terminal_show_unknown(self, *args)

    def error_char(self, *args):
        r"""
        error_char(Fl_Terminal self, char const * val)
        error_char(Fl_Terminal self) -> char const *
        """
        return _fltk.Fl_Terminal_error_char(self, *args)

    def ansi(self, *args):
        r"""
        ansi(Fl_Terminal self) -> bool
        ansi(Fl_Terminal self, bool val)
        """
        return _fltk.Fl_Terminal_ansi(self, *args)

    def history_lines(self, *args):
        r"""
        history_lines(Fl_Terminal self) -> int
        history_lines(Fl_Terminal self, int val)
        """
        return _fltk.Fl_Terminal_history_lines(self, *args)

    def printf(self, *args):
        r"""printf(Fl_Terminal self, char const * fmt)"""
        return _fltk.Fl_Terminal_printf(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Fl_Terminal self, int X, int Y, int W, int H, char const * L=None) -> Fl_Terminal
        __init__(Fl_Terminal self, int X, int Y, int W, int H, char const * L, int rows, int cols, int hist) -> Fl_Terminal
        """
        if self.__class__ == Fl_Terminal:
            _self = None
        else:
            _self = self
        _fltk.Fl_Terminal_swiginit(self, _fltk.new_Fl_Terminal(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Terminal")
        #print("Adding type: ", Fl_Terminal)



    __swig_destroy__ = _fltk.delete_Fl_Terminal

    def init_type(self, *args):
        r"""init_type(Fl_Terminal self, char * Fl_Terminal)"""
        return _fltk.Fl_Terminal_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Terminal(self)
        return weakref.proxy(self)

# Register Fl_Terminal in _fltk:
_fltk.Fl_Terminal_swigregister(Fl_Terminal)
FL_TEXT_MAX_EXP_CHAR_LEN = _fltk.FL_TEXT_MAX_EXP_CHAR_LEN

class Fl_Text_Selection(object):
    r"""Proxy of C++ Fl_Text_Selection class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def set(self, *args):
        r"""set(Fl_Text_Selection self, int startpos, int endpos)"""
        return _fltk.Fl_Text_Selection_set(self, *args)

    def update(self, *args):
        r"""update(Fl_Text_Selection self, int pos, int nDeleted, int nInserted)"""
        return _fltk.Fl_Text_Selection_update(self, *args)

    def start(self, *args):
        r"""start(Fl_Text_Selection self) -> int"""
        return _fltk.Fl_Text_Selection_start(self, *args)

    def end(self, *args):
        r"""end(Fl_Text_Selection self) -> int"""
        return _fltk.Fl_Text_Selection_end(self, *args)

    def length(self, *args):
        r"""length(Fl_Text_Selection self) -> int"""
        return _fltk.Fl_Text_Selection_length(self, *args)

    def includes(self, *args):
        r"""includes(Fl_Text_Selection self, int pos) -> int"""
        return _fltk.Fl_Text_Selection_includes(self, *args)

    def selected(self, *args):
        r"""
        selected(Fl_Text_Selection self) -> bool
        selected(Fl_Text_Selection self, bool b)
        selected(Fl_Text_Selection self, int * startpos, int * endpos) -> int
        """
        return _fltk.Fl_Text_Selection_selected(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Text_Selection self) -> Fl_Text_Selection"""
        _fltk.Fl_Text_Selection_swiginit(self, _fltk.new_Fl_Text_Selection(*args))
    __swig_destroy__ = _fltk.delete_Fl_Text_Selection

# Register Fl_Text_Selection in _fltk:
_fltk.Fl_Text_Selection_swigregister(Fl_Text_Selection)
class Fl_Text_Buffer(object):
    r"""

    The Fl_Text_Buffer class is used by the Fl_Text_Display and Fl_Text_Editor 
    to manage complex text data and is based upon the excellent NEdit text 
    editor engine - see http://www.nedit.org/.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Text_Buffer self, int requestedSize=0, int preferredGapSize=1024) -> Fl_Text_Buffer"""
        _fltk.Fl_Text_Buffer_swiginit(self, _fltk.new_Fl_Text_Buffer(*args))
    __swig_destroy__ = _fltk.delete_Fl_Text_Buffer

    def length(self, *args):
        r"""length(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_length(self, *args)

    def text_str(self, *args):
        r"""text_str(Fl_Text_Buffer self) -> std::string"""
        return _fltk.Fl_Text_Buffer_text_str(self, *args)

    def text(self, *args):
        r"""
        text(Fl_Text_Buffer self) -> char
        text(Fl_Text_Buffer self, char const * text)
        """
        return _fltk.Fl_Text_Buffer_text(self, *args)

    def text_range(self, *args):
        r"""text_range(Fl_Text_Buffer self, int start, int end) -> char *"""
        return _fltk.Fl_Text_Buffer_text_range(self, *args)

    def char_at(self, *args):
        r"""char_at(Fl_Text_Buffer self, int pos) -> unsigned int"""
        return _fltk.Fl_Text_Buffer_char_at(self, *args)

    def byte_at(self, *args):
        r"""byte_at(Fl_Text_Buffer self, int pos) -> char"""
        return _fltk.Fl_Text_Buffer_byte_at(self, *args)

    def address(self, *args):
        r"""
        address(Fl_Text_Buffer self, int pos) -> char const
        address(Fl_Text_Buffer self, int pos) -> char *
        """
        return _fltk.Fl_Text_Buffer_address(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Text_Buffer self, int pos, char const * text, int insertedLength=-1)"""
        return _fltk.Fl_Text_Buffer_insert(self, *args)

    def append(self, *args):
        r"""append(Fl_Text_Buffer self, char const * t, int addedLength=-1)"""
        return _fltk.Fl_Text_Buffer_append(self, *args)

    def printf(self, *args):
        r"""printf(Fl_Text_Buffer self, char const * fmt)"""
        return _fltk.Fl_Text_Buffer_printf(self, *args)

    def remove(self, *args):
        r"""remove(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_remove(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Text_Buffer self, int start, int end, char const * text, int insertedLength=-1)"""
        return _fltk.Fl_Text_Buffer_replace(self, *args)

    def copy(self, *args):
        r"""copy(Fl_Text_Buffer self, Fl_Text_Buffer fromBuf, int fromStart, int fromEnd, int toPos)"""
        return _fltk.Fl_Text_Buffer_copy(self, *args)

    def undo(self, *args):
        r"""undo(Fl_Text_Buffer self, int * cp=None) -> int"""
        return _fltk.Fl_Text_Buffer_undo(self, *args)

    def can_undo(self, *args):
        r"""can_undo(Fl_Text_Buffer self) -> bool"""
        return _fltk.Fl_Text_Buffer_can_undo(self, *args)

    def redo(self, *args):
        r"""redo(Fl_Text_Buffer self, int * cp=None) -> int"""
        return _fltk.Fl_Text_Buffer_redo(self, *args)

    def can_redo(self, *args):
        r"""can_redo(Fl_Text_Buffer self) -> bool"""
        return _fltk.Fl_Text_Buffer_can_redo(self, *args)

    def canUndo(self, *args):
        r"""canUndo(Fl_Text_Buffer self, char flag=1)"""
        return _fltk.Fl_Text_Buffer_canUndo(self, *args)

    def insertfile(self, *args):
        r"""insertfile(Fl_Text_Buffer self, char const * file, int pos, int buflen=128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_insertfile(self, *args)

    def appendfile(self, *args):
        r"""appendfile(Fl_Text_Buffer self, char const * file, int buflen=128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_appendfile(self, *args)

    def loadfile(self, *args):
        r"""loadfile(Fl_Text_Buffer self, char const * file, int buflen=128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_loadfile(self, *args)

    def outputfile(self, *args):
        r"""outputfile(Fl_Text_Buffer self, char const * file, int start, int end, int buflen=128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_outputfile(self, *args)

    def savefile(self, *args):
        r"""savefile(Fl_Text_Buffer self, char const * file, int buflen=128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_savefile(self, *args)

    def tab_distance(self, *args):
        r"""
        tab_distance(Fl_Text_Buffer self) -> int
        tab_distance(Fl_Text_Buffer self, int tabDist)
        """
        return _fltk.Fl_Text_Buffer_tab_distance(self, *args)

    def select(self, *args):
        r"""select(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_select(self, *args)

    def selected(self, *args):
        r"""selected(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_selected(self, *args)

    def unselect(self, *args):
        r"""unselect(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_unselect(self, *args)

    def selection_position(self, *args):
        r"""selection_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_selection_position(self, *args)

    def selection_text(self, *args):
        r"""selection_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_selection_text(self, *args)

    def remove_selection(self, *args):
        r"""remove_selection(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_remove_selection(self, *args)

    def replace_selection(self, *args):
        r"""replace_selection(Fl_Text_Buffer self, char const * text)"""
        return _fltk.Fl_Text_Buffer_replace_selection(self, *args)

    def secondary_select(self, *args):
        r"""secondary_select(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_secondary_select(self, *args)

    def secondary_selected(self, *args):
        r"""secondary_selected(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_secondary_selected(self, *args)

    def secondary_unselect(self, *args):
        r"""secondary_unselect(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_secondary_unselect(self, *args)

    def secondary_selection_position(self, *args):
        r"""secondary_selection_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_secondary_selection_position(self, *args)

    def secondary_selection_text(self, *args):
        r"""secondary_selection_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_secondary_selection_text(self, *args)

    def remove_secondary_selection(self, *args):
        r"""remove_secondary_selection(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_remove_secondary_selection(self, *args)

    def replace_secondary_selection(self, *args):
        r"""replace_secondary_selection(Fl_Text_Buffer self, char const * text)"""
        return _fltk.Fl_Text_Buffer_replace_secondary_selection(self, *args)

    def highlight(self, *args):
        r"""
        highlight(Fl_Text_Buffer self, int start, int end)
        highlight(Fl_Text_Buffer self) -> int
        """
        return _fltk.Fl_Text_Buffer_highlight(self, *args)

    def unhighlight(self, *args):
        r"""unhighlight(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_unhighlight(self, *args)

    def highlight_position(self, *args):
        r"""highlight_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_highlight_position(self, *args)

    def highlight_text(self, *args):
        r"""highlight_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_highlight_text(self, *args)

    def call_modify_callbacks(self, *args):
        r"""call_modify_callbacks(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_call_modify_callbacks(self, *args)

    def add_predelete_callback(self, *args):
        r"""add_predelete_callback(Fl_Text_Buffer self, Fl_Text_Predelete_Cb bufPredelCB, void * cbArg)"""
        return _fltk.Fl_Text_Buffer_add_predelete_callback(self, *args)

    def remove_predelete_callback(self, *args):
        r"""remove_predelete_callback(Fl_Text_Buffer self, Fl_Text_Predelete_Cb predelCB, void * cbArg)"""
        return _fltk.Fl_Text_Buffer_remove_predelete_callback(self, *args)

    def call_predelete_callbacks(self, *args):
        r"""call_predelete_callbacks(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_call_predelete_callbacks(self, *args)

    def line_text(self, *args):
        r"""line_text(Fl_Text_Buffer self, int pos) -> char *"""
        return _fltk.Fl_Text_Buffer_line_text(self, *args)

    def line_start(self, *args):
        r"""line_start(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_start(self, *args)

    def line_end(self, *args):
        r"""line_end(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_end(self, *args)

    def word_start(self, *args):
        r"""word_start(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_start(self, *args)

    def word_end(self, *args):
        r"""word_end(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_end(self, *args)

    def count_displayed_characters(self, *args):
        r"""count_displayed_characters(Fl_Text_Buffer self, int lineStartPos, int targetPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_displayed_characters(self, *args)

    def skip_displayed_characters(self, *args):
        r"""skip_displayed_characters(Fl_Text_Buffer self, int lineStartPos, int nChars) -> int"""
        return _fltk.Fl_Text_Buffer_skip_displayed_characters(self, *args)

    def count_lines(self, *args):
        r"""count_lines(Fl_Text_Buffer self, int startPos, int endPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_lines(self, *args)

    def estimate_lines(self, *args):
        r"""estimate_lines(Fl_Text_Buffer self, int startPos, int endPos, int lineLen) -> int"""
        return _fltk.Fl_Text_Buffer_estimate_lines(self, *args)

    def skip_lines(self, *args):
        r"""skip_lines(Fl_Text_Buffer self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_skip_lines(self, *args)

    def rewind_lines(self, *args):
        r"""rewind_lines(Fl_Text_Buffer self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_rewind_lines(self, *args)

    def findchar_forward(self, *args):
        r"""findchar_forward(Fl_Text_Buffer self, int startPos, unsigned int searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_forward(self, *args)

    def findchar_backward(self, *args):
        r"""findchar_backward(Fl_Text_Buffer self, int startPos, unsigned int searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_backward(self, *args)

    def search_forward(self, *args):
        r"""search_forward(Fl_Text_Buffer self, int startPos, char const * searchString, int matchCase=0) -> int"""
        return _fltk.Fl_Text_Buffer_search_forward(self, *args)

    def search_backward(self, *args):
        r"""search_backward(Fl_Text_Buffer self, int startPos, char const * searchString, int matchCase=0) -> int"""
        return _fltk.Fl_Text_Buffer_search_backward(self, *args)

    def primary_selection(self, *args):
        r"""
        primary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection
        primary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection
        """
        return _fltk.Fl_Text_Buffer_primary_selection(self, *args)

    def secondary_selection(self, *args):
        r"""secondary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_secondary_selection(self, *args)

    def highlight_selection(self, *args):
        r"""highlight_selection(Fl_Text_Buffer self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_highlight_selection(self, *args)

    def prev_char(self, *args):
        r"""prev_char(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_prev_char(self, *args)

    def prev_char_clipped(self, *args):
        r"""prev_char_clipped(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_prev_char_clipped(self, *args)

    def next_char(self, *args):
        r"""next_char(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_next_char(self, *args)

    def next_char_clipped(self, *args):
        r"""next_char_clipped(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_next_char_clipped(self, *args)

    def utf8_align(self, *args):
        r"""utf8_align(Fl_Text_Buffer self, int arg2) -> int"""
        return _fltk.Fl_Text_Buffer_utf8_align(self, *args)

    def is_word_separator(self, *args):
        r"""is_word_separator(Fl_Text_Buffer self, int pos) -> bool"""
        return _fltk.Fl_Text_Buffer_is_word_separator(self, *args)

    def add_modify_callback(self, *args):
        r"""
        add_modify_callback(Fl_Text_Buffer self, Fl_Text_Modify_Cb bufModifiedCB, void * cbArg)
        add_modify_callback(Fl_Text_Buffer self, PyObject * PyFunc, PyObject * PyTarget=None)
        """
        return _fltk.Fl_Text_Buffer_add_modify_callback(self, *args)

    def remove_modify_callback(self, *args):
        r"""
        remove_modify_callback(Fl_Text_Buffer self, Fl_Text_Modify_Cb bufModifiedCB, void * cbArg)
        remove_modify_callback(Fl_Text_Buffer self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyTarget)
        """
        return _fltk.Fl_Text_Buffer_remove_modify_callback(self, *args)

# Register Fl_Text_Buffer in _fltk:
_fltk.Fl_Text_Buffer_swigregister(Fl_Text_Buffer)
class Style_Table_Entry(object):
    r"""Proxy of C++ Style_Table_Entry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Style_Table_Entry self) -> Style_Table_Entry"""
        _fltk.Style_Table_Entry_swiginit(self, _fltk.new_Style_Table_Entry(*args))
    __swig_destroy__ = _fltk.delete_Style_Table_Entry

# Register Style_Table_Entry in _fltk:
_fltk.Style_Table_Entry_swigregister(Style_Table_Entry)
class Fl_Text_Display(Fl_Group):
    r"""

    This is the FLTK text display widget. It allows the user to view multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    NORMAL_CURSOR = _fltk.Fl_Text_Display_NORMAL_CURSOR
    
    CARET_CURSOR = _fltk.Fl_Text_Display_CARET_CURSOR
    
    DIM_CURSOR = _fltk.Fl_Text_Display_DIM_CURSOR
    
    BLOCK_CURSOR = _fltk.Fl_Text_Display_BLOCK_CURSOR
    
    HEAVY_CURSOR = _fltk.Fl_Text_Display_HEAVY_CURSOR
    
    SIMPLE_CURSOR = _fltk.Fl_Text_Display_SIMPLE_CURSOR
    
    CURSOR_POS = _fltk.Fl_Text_Display_CURSOR_POS
    
    CHARACTER_POS = _fltk.Fl_Text_Display_CHARACTER_POS
    
    DRAG_NONE = _fltk.Fl_Text_Display_DRAG_NONE
    
    DRAG_START_DND = _fltk.Fl_Text_Display_DRAG_START_DND
    
    DRAG_CHAR = _fltk.Fl_Text_Display_DRAG_CHAR
    
    DRAG_WORD = _fltk.Fl_Text_Display_DRAG_WORD
    
    DRAG_LINE = _fltk.Fl_Text_Display_DRAG_LINE
    
    WRAP_NONE = _fltk.Fl_Text_Display_WRAP_NONE
    
    WRAP_AT_COLUMN = _fltk.Fl_Text_Display_WRAP_AT_COLUMN
    
    WRAP_AT_PIXEL = _fltk.Fl_Text_Display_WRAP_AT_PIXEL
    
    WRAP_AT_BOUNDS = _fltk.Fl_Text_Display_WRAP_AT_BOUNDS
    
    ATTR_BGCOLOR = _fltk.Fl_Text_Display_ATTR_BGCOLOR
    
    ATTR_BGCOLOR_EXT_ = _fltk.Fl_Text_Display_ATTR_BGCOLOR_EXT_
    
    ATTR_BGCOLOR_EXT = _fltk.Fl_Text_Display_ATTR_BGCOLOR_EXT
    
    ATTR_UNDERLINE = _fltk.Fl_Text_Display_ATTR_UNDERLINE
    
    ATTR_GRAMMAR = _fltk.Fl_Text_Display_ATTR_GRAMMAR
    
    ATTR_SPELLING = _fltk.Fl_Text_Display_ATTR_SPELLING
    
    ATTR_STRIKE_THROUGH = _fltk.Fl_Text_Display_ATTR_STRIKE_THROUGH
    
    ATTR_LINES_MASK = _fltk.Fl_Text_Display_ATTR_LINES_MASK
    

    def __init__(self, *args):
        r"""__init__(Fl_Text_Display self, int X, int Y, int W, int H, char const * l=None) -> Fl_Text_Display"""
        if self.__class__ == Fl_Text_Display:
            _self = None
        else:
            _self = self
        _fltk.Fl_Text_Display_swiginit(self, _fltk.new_Fl_Text_Display(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Text_Display")
        #print("Adding type: ", Fl_Text_Display)



    __swig_destroy__ = _fltk.delete_Fl_Text_Display

    def handle(self, *args):
        r"""handle(Fl_Text_Display self, int e) -> int"""
        return _fltk.Fl_Text_Display_handle(self, *args)

    def buffer(self, *args):
        r"""
        buffer(Fl_Text_Display self, Fl_Text_Buffer buf)
        buffer(Fl_Text_Display self) -> Fl_Text_Buffer
        """
        val = _fltk.Fl_Text_Display_buffer(self, *args)

        if len(args) > 0 and args[0] != None:
        #delegate ownership to C++
            args[0].this.disown()


        return val


    def style_buffer(self, *args):
        r"""style_buffer(Fl_Text_Display self) -> Fl_Text_Buffer"""
        return _fltk.Fl_Text_Display_style_buffer(self, *args)

    def redisplay_range(self, *args):
        r"""redisplay_range(Fl_Text_Display self, int start, int end)"""
        return _fltk.Fl_Text_Display_redisplay_range(self, *args)

    def scroll(self, *args):
        r"""scroll(Fl_Text_Display self, int topLineNum, int horizOffset)"""
        return _fltk.Fl_Text_Display_scroll(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Text_Display self, char const * text)"""
        return _fltk.Fl_Text_Display_insert(self, *args)

    def overstrike(self, *args):
        r"""overstrike(Fl_Text_Display self, char const * text)"""
        return _fltk.Fl_Text_Display_overstrike(self, *args)

    def insert_position(self, *args):
        r"""
        insert_position(Fl_Text_Display self, int newPos)
        insert_position(Fl_Text_Display self) -> int
        """
        return _fltk.Fl_Text_Display_insert_position(self, *args)

    def position_to_xy(self, *args):
        r"""position_to_xy(Fl_Text_Display self, int pos, int * x, int * y) -> int"""
        return _fltk.Fl_Text_Display_position_to_xy(self, *args)

    def in_selection(self, *args):
        r"""in_selection(Fl_Text_Display self, int x, int y) -> int"""
        return _fltk.Fl_Text_Display_in_selection(self, *args)

    def show_insert_position(self, *args):
        r"""show_insert_position(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_show_insert_position(self, *args)

    def move_right(self, *args):
        r"""move_right(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_right(self, *args)

    def move_left(self, *args):
        r"""move_left(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_left(self, *args)

    def move_up(self, *args):
        r"""move_up(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_up(self, *args)

    def move_down(self, *args):
        r"""move_down(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_down(self, *args)

    def count_lines(self, *args):
        r"""count_lines(Fl_Text_Display self, int start, int end, bool start_pos_is_line_start) -> int"""
        return _fltk.Fl_Text_Display_count_lines(self, *args)

    def line_start(self, *args):
        r"""line_start(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_line_start(self, *args)

    def line_end(self, *args):
        r"""line_end(Fl_Text_Display self, int startPos, bool startPosIsLineStart) -> int"""
        return _fltk.Fl_Text_Display_line_end(self, *args)

    def skip_lines(self, *args):
        r"""skip_lines(Fl_Text_Display self, int startPos, int nLines, bool startPosIsLineStart) -> int"""
        return _fltk.Fl_Text_Display_skip_lines(self, *args)

    def rewind_lines(self, *args):
        r"""rewind_lines(Fl_Text_Display self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Display_rewind_lines(self, *args)

    def next_word(self, *args):
        r"""next_word(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_next_word(self, *args)

    def previous_word(self, *args):
        r"""previous_word(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_previous_word(self, *args)

    def show_cursor(self, *args):
        r"""show_cursor(Fl_Text_Display self, int b=1)"""
        return _fltk.Fl_Text_Display_show_cursor(self, *args)

    def hide_cursor(self, *args):
        r"""hide_cursor(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_hide_cursor(self, *args)

    def cursor_style(self, *args):
        r"""
        cursor_style(Fl_Text_Display self, int style)
        cursor_style(Fl_Text_Display self) -> int
        """
        return _fltk.Fl_Text_Display_cursor_style(self, *args)

    def cursor_color(self, *args):
        r"""
        cursor_color(Fl_Text_Display self) -> Fl_Color
        cursor_color(Fl_Text_Display self, Fl_Color n)
        """
        return _fltk.Fl_Text_Display_cursor_color(self, *args)

    def scrollbar_width(self, *args):
        r"""
        scrollbar_width(Fl_Text_Display self) -> int
        scrollbar_width(Fl_Text_Display self, int width)
        """
        return _fltk.Fl_Text_Display_scrollbar_width(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Text_Display self) -> int
        scrollbar_size(Fl_Text_Display self, int newSize)
        """
        return _fltk.Fl_Text_Display_scrollbar_size(self, *args)

    def scrollbar_align(self, *args):
        r"""
        scrollbar_align(Fl_Text_Display self) -> Fl_Align
        scrollbar_align(Fl_Text_Display self, Fl_Align a)
        """
        return _fltk.Fl_Text_Display_scrollbar_align(self, *args)

    def word_start(self, *args):
        r"""word_start(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_start(self, *args)

    def word_end(self, *args):
        r"""word_end(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_end(self, *args)

    def position_style(self, *args):
        r"""position_style(Fl_Text_Display self, int lineStartPos, int lineLen, int lineIndex) -> int"""
        return _fltk.Fl_Text_Display_position_style(self, *args)

    def shortcut(self, *args):
        r"""
        shortcut(Fl_Text_Display self) -> int
        shortcut(Fl_Text_Display self, int s)
        """
        return _fltk.Fl_Text_Display_shortcut(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Text_Display self) -> Fl_Font
        textfont(Fl_Text_Display self, Fl_Font s)
        """
        return _fltk.Fl_Text_Display_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Text_Display self) -> Fl_Fontsize
        textsize(Fl_Text_Display self, Fl_Fontsize s)
        """
        return _fltk.Fl_Text_Display_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Text_Display self) -> Fl_Color
        textcolor(Fl_Text_Display self, Fl_Color n)
        """
        return _fltk.Fl_Text_Display_textcolor(self, *args)

    def grammar_underline_color(self, *args):
        r"""
        grammar_underline_color(Fl_Text_Display self, Fl_Color color)
        grammar_underline_color(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_grammar_underline_color(self, *args)

    def spelling_underline_color(self, *args):
        r"""
        spelling_underline_color(Fl_Text_Display self, Fl_Color color)
        spelling_underline_color(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_spelling_underline_color(self, *args)

    def secondary_selection_color(self, *args):
        r"""
        secondary_selection_color(Fl_Text_Display self, Fl_Color color)
        secondary_selection_color(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_secondary_selection_color(self, *args)

    def wrapped_column(self, *args):
        r"""wrapped_column(Fl_Text_Display self, int row, int column) -> int"""
        return _fltk.Fl_Text_Display_wrapped_column(self, *args)

    def wrapped_row(self, *args):
        r"""wrapped_row(Fl_Text_Display self, int row) -> int"""
        return _fltk.Fl_Text_Display_wrapped_row(self, *args)

    def wrap_mode(self, *args):
        r"""wrap_mode(Fl_Text_Display self, int wrap, int wrap_margin)"""
        return _fltk.Fl_Text_Display_wrap_mode(self, *args)

    def recalc_display(self, *args):
        r"""recalc_display(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_recalc_display(self, *args)

    def display_needs_recalc(self, *args):
        r"""display_needs_recalc(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_display_needs_recalc(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Text_Display self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Text_Display_resize(self, *args)

    def x_to_col(self, *args):
        r"""x_to_col(Fl_Text_Display self, double x) -> double"""
        return _fltk.Fl_Text_Display_x_to_col(self, *args)

    def col_to_x(self, *args):
        r"""col_to_x(Fl_Text_Display self, double col) -> double"""
        return _fltk.Fl_Text_Display_col_to_x(self, *args)

    def linenumber_width(self, *args):
        r"""
        linenumber_width(Fl_Text_Display self, int width)
        linenumber_width(Fl_Text_Display self) -> int
        """
        return _fltk.Fl_Text_Display_linenumber_width(self, *args)

    def linenumber_font(self, *args):
        r"""
        linenumber_font(Fl_Text_Display self, Fl_Font val)
        linenumber_font(Fl_Text_Display self) -> Fl_Font
        """
        return _fltk.Fl_Text_Display_linenumber_font(self, *args)

    def linenumber_size(self, *args):
        r"""
        linenumber_size(Fl_Text_Display self, Fl_Fontsize val)
        linenumber_size(Fl_Text_Display self) -> Fl_Fontsize
        """
        return _fltk.Fl_Text_Display_linenumber_size(self, *args)

    def linenumber_fgcolor(self, *args):
        r"""
        linenumber_fgcolor(Fl_Text_Display self, Fl_Color val)
        linenumber_fgcolor(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_linenumber_fgcolor(self, *args)

    def linenumber_bgcolor(self, *args):
        r"""
        linenumber_bgcolor(Fl_Text_Display self, Fl_Color val)
        linenumber_bgcolor(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_linenumber_bgcolor(self, *args)

    def linenumber_align(self, *args):
        r"""
        linenumber_align(Fl_Text_Display self, Fl_Align val)
        linenumber_align(Fl_Text_Display self) -> Fl_Align
        """
        return _fltk.Fl_Text_Display_linenumber_align(self, *args)

    def linenumber_format(self, *args):
        r"""
        linenumber_format(Fl_Text_Display self, char const * val)
        linenumber_format(Fl_Text_Display self) -> char const *
        """
        return _fltk.Fl_Text_Display_linenumber_format(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_draw(self, *args)

    def get_absolute_top_line_number(self, *args):
        r"""get_absolute_top_line_number(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_get_absolute_top_line_number(self, *args)

    def scroll_row(self, *args):
        r"""scroll_row(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_scroll_row(self, *args)

    def scroll_col(self, *args):
        r"""scroll_col(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_scroll_col(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Text_Display self, char * Fl_Text_Display)"""
        return _fltk.Fl_Text_Display_init_type(self, *args)

    def highlight_data(self, *args):
        r"""highlight_data(Fl_Text_Display self, Fl_Text_Buffer styleBuffer, Fl_Text_Display::Style_Table_Entry const * styleTable, int nStyles, char unfinishedStyle, PyObject * func, PyObject * cbArg)"""
        return _fltk.Fl_Text_Display_highlight_data(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Display(self)
        return weakref.proxy(self)

# Register Fl_Text_Display in _fltk:
_fltk.Fl_Text_Display_swigregister(Fl_Text_Display)
FL_TEXT_EDITOR_ANY_STATE = _fltk.FL_TEXT_EDITOR_ANY_STATE

class Fl_Text_Editor(Fl_Text_Display):
    r"""

    This is the FLTK text editor widget. It allows the user to edit multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Text_Editor self, int X, int Y, int W, int H, char const * l=None) -> Fl_Text_Editor"""
        if self.__class__ == Fl_Text_Editor:
            _self = None
        else:
            _self = self
        _fltk.Fl_Text_Editor_swiginit(self, _fltk.new_Fl_Text_Editor(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Text_Editor")
        #print("Adding type: ", Fl_Text_Editor)



    __swig_destroy__ = _fltk.delete_Fl_Text_Editor

    def handle(self, *args):
        r"""handle(Fl_Text_Editor self, int e) -> int"""
        return _fltk.Fl_Text_Editor_handle(self, *args)

    def insert_mode(self, *args):
        r"""
        insert_mode(Fl_Text_Editor self, int b)
        insert_mode(Fl_Text_Editor self) -> int
        """
        return _fltk.Fl_Text_Editor_insert_mode(self, *args)

    def tab_nav(self, *args):
        r"""
        tab_nav(Fl_Text_Editor self, int val)
        tab_nav(Fl_Text_Editor self) -> int
        """
        return _fltk.Fl_Text_Editor_tab_nav(self, *args)

    def add_key_binding(self, *args):
        r"""add_key_binding(Fl_Text_Editor self, int key, int state, Fl_Text_Editor::Key_Func f)"""
        return _fltk.Fl_Text_Editor_add_key_binding(self, *args)

    def remove_key_binding(self, *args):
        r"""remove_key_binding(Fl_Text_Editor self, int key, int state)"""
        return _fltk.Fl_Text_Editor_remove_key_binding(self, *args)

    def remove_all_key_bindings(self, *args):
        r"""remove_all_key_bindings(Fl_Text_Editor self)"""
        return _fltk.Fl_Text_Editor_remove_all_key_bindings(self, *args)

    def bound_key_function(self, *args):
        r"""
        bound_key_function(Fl_Text_Editor self, int key, int state, Fl_Text_Editor::Key_Binding * list) -> Fl_Text_Editor::Key_Func
        bound_key_function(Fl_Text_Editor self, int key, int state) -> Fl_Text_Editor::Key_Func
        """
        return _fltk.Fl_Text_Editor_bound_key_function(self, *args)

    def default_key_function(self, *args):
        r"""default_key_function(Fl_Text_Editor self, Fl_Text_Editor::Key_Func f)"""
        return _fltk.Fl_Text_Editor_default_key_function(self, *args)

    @staticmethod
    def kf_default(*args):
        r"""kf_default(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_default(*args)

    @staticmethod
    def kf_ignore(*args):
        r"""kf_ignore(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ignore(*args)

    @staticmethod
    def kf_backspace(*args):
        r"""kf_backspace(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_backspace(*args)

    @staticmethod
    def kf_enter(*args):
        r"""kf_enter(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_enter(*args)

    @staticmethod
    def kf_move(*args):
        r"""kf_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_move(*args)

    @staticmethod
    def kf_shift_move(*args):
        r"""kf_shift_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_shift_move(*args)

    @staticmethod
    def kf_ctrl_move(*args):
        r"""kf_ctrl_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ctrl_move(*args)

    @staticmethod
    def kf_c_s_move(*args):
        r"""kf_c_s_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_c_s_move(*args)

    @staticmethod
    def kf_meta_move(*args):
        r"""kf_meta_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_meta_move(*args)

    @staticmethod
    def kf_m_s_move(*args):
        r"""kf_m_s_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_m_s_move(*args)

    @staticmethod
    def kf_home(*args):
        r"""kf_home(int arg1, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_home(*args)

    @staticmethod
    def kf_end(*args):
        r"""kf_end(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_end(*args)

    @staticmethod
    def kf_left(*args):
        r"""kf_left(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_left(*args)

    @staticmethod
    def kf_up(*args):
        r"""kf_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_up(*args)

    @staticmethod
    def kf_right(*args):
        r"""kf_right(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_right(*args)

    @staticmethod
    def kf_down(*args):
        r"""kf_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_down(*args)

    @staticmethod
    def kf_page_up(*args):
        r"""kf_page_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_up(*args)

    @staticmethod
    def kf_page_down(*args):
        r"""kf_page_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_down(*args)

    @staticmethod
    def kf_insert(*args):
        r"""kf_insert(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_insert(*args)

    @staticmethod
    def kf_delete(*args):
        r"""kf_delete(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_delete(*args)

    @staticmethod
    def kf_copy(*args):
        r"""kf_copy(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_copy(*args)

    @staticmethod
    def kf_cut(*args):
        r"""kf_cut(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_cut(*args)

    @staticmethod
    def kf_paste(*args):
        r"""kf_paste(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_paste(*args)

    @staticmethod
    def kf_select_all(*args):
        r"""kf_select_all(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_select_all(*args)

    @staticmethod
    def kf_undo(*args):
        r"""kf_undo(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_undo(*args)

    @staticmethod
    def kf_redo(*args):
        r"""kf_redo(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_redo(*args)

    def init_type(self, *args):
        r"""init_type(Fl_Text_Editor self, char * Fl_Text_Editor)"""
        return _fltk.Fl_Text_Editor_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Editor(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Text_Editor self)"""
        return _fltk.Fl_Text_Editor_draw(self, *args)

# Register Fl_Text_Editor in _fltk:
_fltk.Fl_Text_Editor_swigregister(Fl_Text_Editor)
class Fl_Tile(Fl_Group):
    r"""

    The Fl_Tile class lets you resize the children by dragging the border between 
    them:

    Fl_Tile allows objects to be resized to zero dimensions. To prevent this you 
    can use the resizable() to limit where corners can be dragged to.

    Even though objects can be resized to zero sizes, they must initially have 
    non-zero sizes so the Fl_Tile can figure out their layout. If desired, call 
    position() after creating the children but before displaying the window to 
    set the borders where you want.

    The 'borders' are part of the children - Fl_Tile does not draw any graphics 
    of its own. In the example above, all of the children have FL_DOWN_BOX types, 
    and the 'ridges' you see are actually two adjacent FL_DOWN_BOX's drawn next 
    to each other. All neighboring widgets share the same edge - the widget's 
    thick borders make it appear as though the widgets aren't actually touching, 
    but they are. If the edges of adjacent widgets do not touch, then it will be 
    impossible to drag the corresponding edges.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def handle(self, *args):
        r"""handle(Fl_Tile self, int event) -> int"""
        return _fltk.Fl_Tile_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Tile self, int X, int Y, int W, int H, char const * L=None) -> Fl_Tile"""
        if self.__class__ == Fl_Tile:
            _self = None
        else:
            _self = self
        _fltk.Fl_Tile_swiginit(self, _fltk.new_Fl_Tile(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Tile")
        #print("Adding type: ", Fl_Tile)



    __swig_destroy__ = _fltk.delete_Fl_Tile

    def resize(self, *args):
        r"""resize(Fl_Tile self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Tile_resize(self, *args)

    def move_intersection(self, *args):
        r"""move_intersection(Fl_Tile self, int oldx, int oldy, int newx, int newy)"""
        return _fltk.Fl_Tile_move_intersection(self, *args)

    def drag_intersection(self, *args):
        r"""drag_intersection(Fl_Tile self, int oldx, int oldy, int newx, int newy)"""
        return _fltk.Fl_Tile_drag_intersection(self, *args)

    def size_range(self, *args):
        r"""
        size_range(Fl_Tile self, int index, int minw, int minh, int maxw=2147483647, int maxh=2147483647)
        size_range(Fl_Tile self, Fl_Widget w, int minw, int minh, int maxw=2147483647, int maxh=2147483647)
        """
        return _fltk.Fl_Tile_size_range(self, *args)

    def init_size_range(self, *args):
        r"""init_size_range(Fl_Tile self, int default_min_w=-1, int default_min_h=-1)"""
        return _fltk.Fl_Tile_init_size_range(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Tile self, char * Fl_Tile)"""
        return _fltk.Fl_Tile_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tile(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Tile self)"""
        return _fltk.Fl_Tile_draw(self, *args)

# Register Fl_Tile in _fltk:
_fltk.Fl_Tile_swigregister(Fl_Tile)
class Fl_Tiled_Image(Fl_Image):
    r"""

    The Fl_Tiled_Image class supports tiling of images over a specified area. 
    The source (tile) image is not copied unless you call the color_average(), 
    desaturate(), or inactive() methods.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Tiled_Image self, Fl_Image i, int W=0, int H=0) -> Fl_Tiled_Image"""
        if self.__class__ == Fl_Tiled_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_Tiled_Image_swiginit(self, _fltk.new_Fl_Tiled_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_Tiled_Image

    def copy(self, *args):
        r"""
        copy(Fl_Tiled_Image self, int W, int H) -> Fl_Image
        copy(Fl_Tiled_Image self) -> Fl_Image
        """
        return _fltk.Fl_Tiled_Image_copy(self, *args)

    def color_average(self, *args):
        r"""color_average(Fl_Tiled_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Tiled_Image_color_average(self, *args)

    def desaturate(self, *args):
        r"""desaturate(Fl_Tiled_Image self)"""
        return _fltk.Fl_Tiled_Image_desaturate(self, *args)

    def draw(self, *args):
        r"""
        draw(Fl_Tiled_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Tiled_Image self, int X, int Y)
        """
        return _fltk.Fl_Tiled_Image_draw(self, *args)

    def image(self, *args):
        r"""image(Fl_Tiled_Image self) -> Fl_Image"""
        return _fltk.Fl_Tiled_Image_image(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tiled_Image(self)
        return weakref.proxy(self)

# Register Fl_Tiled_Image in _fltk:
_fltk.Fl_Tiled_Image_swigregister(Fl_Tiled_Image)
class Fl_Toggle_Button(Fl_Button):
    r"""Proxy of C++ Fl_Toggle_Button class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Toggle_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Toggle_Button"""
        if self.__class__ == Fl_Toggle_Button:
            _self = None
        else:
            _self = self
        _fltk.Fl_Toggle_Button_swiginit(self, _fltk.new_Fl_Toggle_Button(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Toggle_Button")
        #print("Adding type: ", Fl_Toggle_Button)




    def init_type(self, *args):
        r"""init_type(Fl_Toggle_Button self, char * Fl_Toggle_Button)"""
        return _fltk.Fl_Toggle_Button_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Toggle_Button
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Toggle_Button(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(Fl_Toggle_Button self)"""
        return _fltk.Fl_Toggle_Button_draw(self, *args)

# Register Fl_Toggle_Button in _fltk:
_fltk.Fl_Toggle_Button_swigregister(Fl_Toggle_Button)
class Fl_Tooltip(object):
    r"""

    The Fl_Tooltip class provides tooltip support for all FLTK widgets.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def delay(*args):
        r"""
        delay() -> float
        delay(float f)
        """
        return _fltk.Fl_Tooltip_delay(*args)

    @staticmethod
    def hidedelay(*args):
        r"""
        hidedelay() -> float
        hidedelay(float f)
        """
        return _fltk.Fl_Tooltip_hidedelay(*args)

    @staticmethod
    def hoverdelay(*args):
        r"""
        hoverdelay() -> float
        hoverdelay(float f)
        """
        return _fltk.Fl_Tooltip_hoverdelay(*args)

    @staticmethod
    def enabled(*args):
        r"""enabled() -> int"""
        return _fltk.Fl_Tooltip_enabled(*args)

    @staticmethod
    def enable(*args):
        r"""enable(int b=1)"""
        return _fltk.Fl_Tooltip_enable(*args)

    @staticmethod
    def disable(*args):
        r"""disable()"""
        return _fltk.Fl_Tooltip_disable(*args)

    @staticmethod
    def enter_area(*args):
        r"""enter_area(Fl_Widget w, int X, int Y, int W, int H, char const * tip)"""
        return _fltk.Fl_Tooltip_enter_area(*args)

    @staticmethod
    def current(*args):
        r"""
        current() -> Fl_Widget
        current(Fl_Widget arg1)
        """
        return _fltk.Fl_Tooltip_current(*args)

    @staticmethod
    def font(*args):
        r"""
        font() -> Fl_Font
        font(Fl_Font i)
        """
        return _fltk.Fl_Tooltip_font(*args)

    @staticmethod
    def size(*args):
        r"""
        size() -> Fl_Fontsize
        size(Fl_Fontsize s)
        """
        return _fltk.Fl_Tooltip_size(*args)

    @staticmethod
    def color(*args):
        r"""
        color() -> Fl_Color
        color(Fl_Color c)
        """
        return _fltk.Fl_Tooltip_color(*args)

    @staticmethod
    def textcolor(*args):
        r"""
        textcolor() -> Fl_Color
        textcolor(Fl_Color c)
        """
        return _fltk.Fl_Tooltip_textcolor(*args)

    @staticmethod
    def margin_width(*args):
        r"""
        margin_width() -> int
        margin_width(int v)
        """
        return _fltk.Fl_Tooltip_margin_width(*args)

    @staticmethod
    def margin_height(*args):
        r"""
        margin_height() -> int
        margin_height(int v)
        """
        return _fltk.Fl_Tooltip_margin_height(*args)

    @staticmethod
    def wrap_width(*args):
        r"""
        wrap_width() -> int
        wrap_width(int v)
        """
        return _fltk.Fl_Tooltip_wrap_width(*args)

    @staticmethod
    def current_window(*args):
        r"""current_window() -> Fl_Window"""
        return _fltk.Fl_Tooltip_current_window(*args)

    @staticmethod
    def override_text(*args):
        r"""override_text(char const * new_text) -> int"""
        return _fltk.Fl_Tooltip_override_text(*args)

    def __init__(self, *args):
        r"""__init__(Fl_Tooltip self) -> Fl_Tooltip"""
        _fltk.Fl_Tooltip_swiginit(self, _fltk.new_Fl_Tooltip(*args))
    __swig_destroy__ = _fltk.delete_Fl_Tooltip

# Register Fl_Tooltip in _fltk:
_fltk.Fl_Tooltip_swigregister(Fl_Tooltip)
class Fl_Value_Output(Fl_Valuator):
    r"""

    The Fl_Value_Output widget displays a floating point value. If step() is 
    not zero, the user can adjust the value by dragging the mouse left and right. 
    The left button moves one step()  per pixel, the middle by 10 * step(), and 
    the right button by 100 * step().

    This is much lighter-weight than Fl_Value_Input because it contains no text 
    editing code or character buffer. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Value_Output self)"""
        return _fltk.Fl_Value_Output_draw(self, *args)

    def handle(self, *args):
        r"""handle(Fl_Value_Output self, int arg0) -> int"""
        return _fltk.Fl_Value_Output_handle(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Value_Output self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Output"""
        if self.__class__ == Fl_Value_Output:
            _self = None
        else:
            _self = self
        _fltk.Fl_Value_Output_swiginit(self, _fltk.new_Fl_Value_Output(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Value_Output")
        #print("Adding type: ", Fl_Value_Output)




    def soft(self, *args):
        r"""
        soft(Fl_Value_Output self, uchar s)
        soft(Fl_Value_Output self) -> uchar
        """
        return _fltk.Fl_Value_Output_soft(self, *args)

    def textfont(self, *args):
        r"""
        textfont(Fl_Value_Output self) -> Fl_Font
        textfont(Fl_Value_Output self, Fl_Font s)
        """
        return _fltk.Fl_Value_Output_textfont(self, *args)

    def textsize(self, *args):
        r"""
        textsize(Fl_Value_Output self) -> Fl_Fontsize
        textsize(Fl_Value_Output self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Output_textsize(self, *args)

    def textcolor(self, *args):
        r"""
        textcolor(Fl_Value_Output self) -> Fl_Color
        textcolor(Fl_Value_Output self, Fl_Color s)
        """
        return _fltk.Fl_Value_Output_textcolor(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Value_Output self, char * Fl_Value_Output)"""
        return _fltk.Fl_Value_Output_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Value_Output
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Output(self)
        return weakref.proxy(self)

# Register Fl_Value_Output in _fltk:
_fltk.Fl_Value_Output_swigregister(Fl_Value_Output)
class Fl_Wizard(Fl_Group):
    r"""

    The Fl_Wizard widget is based off the Fl_Tabs widget, but instead of 
    displaying tabs it only changes 'tabs' under program control. Its primary 
    purpose is to support 'wizards' that step a user through configuration or 
    troubleshooting tasks.

    As with Fl_Tabs, wizard panes are composed of child (usually Fl_Group) 
    widgets. Navigation buttons must be added separately. 

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Wizard self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Wizard"""
        if self.__class__ == Fl_Wizard:
            _self = None
        else:
            _self = self
        _fltk.Fl_Wizard_swiginit(self, _fltk.new_Fl_Wizard(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Wizard")
        #print("Adding type: ", Fl_Wizard)




    def next(self, *args):
        r"""next(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_next(self, *args)

    def prev(self, *args):
        r"""prev(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_prev(self, *args)

    def value(self, *args):
        r"""
        value(Fl_Wizard self) -> Fl_Widget
        value(Fl_Wizard self, Fl_Widget arg2)
        """
        return _fltk.Fl_Wizard_value(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Wizard self, char * Fl_Wizard)"""
        return _fltk.Fl_Wizard_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Wizard
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Wizard(self)
        return weakref.proxy(self)

# Register Fl_Wizard in _fltk:
_fltk.Fl_Wizard_swigregister(Fl_Wizard)
class Fl_XBM_Image(Fl_Bitmap):
    r"""

    The Fl_XBM_Image class supports loading, caching, and drawing of X Bitmap 
    (XBM) bitmap files.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_XBM_Image self, char const * filename) -> Fl_XBM_Image"""
        if self.__class__ == Fl_XBM_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_XBM_Image_swiginit(self, _fltk.new_Fl_XBM_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_XBM_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XBM_Image(self)
        return weakref.proxy(self)

# Register Fl_XBM_Image in _fltk:
_fltk.Fl_XBM_Image_swigregister(Fl_XBM_Image)
class Fl_XPM_Image(Fl_Pixmap):
    r"""

    The Fl_XPM_Image class supports loading, caching, and drawing of X Pixmap (XPM) images, including transparency.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_XPM_Image self, char const * filename) -> Fl_XPM_Image"""
        if self.__class__ == Fl_XPM_Image:
            _self = None
        else:
            _self = self
        _fltk.Fl_XPM_Image_swiginit(self, _fltk.new_Fl_XPM_Image(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_XPM_Image
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XPM_Image(self)
        return weakref.proxy(self)

# Register Fl_XPM_Image in _fltk:
_fltk.Fl_XPM_Image_swigregister(Fl_XPM_Image)
class Fl_X(object):
    r"""Proxy of C++ Fl_X class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def flx(*args):
        r"""flx(Fl_Window w) -> Fl_X"""
        return _fltk.Fl_X_flx(*args)

    def __init__(self, *args):
        r"""__init__(Fl_X self) -> Fl_X"""
        _fltk.Fl_X_swiginit(self, _fltk.new_Fl_X(*args))
    __swig_destroy__ = _fltk.delete_Fl_X

# Register Fl_X in _fltk:
_fltk.Fl_X_swigregister(Fl_X)

def fl_xid(*args):
    r"""fl_xid(Fl_Window w) -> Window"""
    return _fltk.fl_xid(*args)

def fl_find(*args):
    r"""fl_find(Window xid) -> Fl_Window"""
    return _fltk.fl_find(*args)

def fl_open_display(*args):
    r"""fl_open_display()"""
    return _fltk.fl_open_display(*args)

def fl_close_display(*args):
    r"""fl_close_display()"""
    return _fltk.fl_close_display(*args)

def fl_parse_color(*args):
    r"""fl_parse_color(char const * p, uchar & r, uchar & g, uchar & b) -> int"""
    return _fltk.fl_parse_color(*args)

def fl_open_callback(*args):
    r"""fl_open_callback(void (*)(char const *) arg1)"""
    return _fltk.fl_open_callback(*args)
FL_TREE_SORT_NONE = _fltk.FL_TREE_SORT_NONE

FL_TREE_SORT_ASCENDING = _fltk.FL_TREE_SORT_ASCENDING

FL_TREE_SORT_DESCENDING = _fltk.FL_TREE_SORT_DESCENDING

FL_TREE_CONNECTOR_NONE = _fltk.FL_TREE_CONNECTOR_NONE

FL_TREE_CONNECTOR_DOTTED = _fltk.FL_TREE_CONNECTOR_DOTTED

FL_TREE_CONNECTOR_SOLID = _fltk.FL_TREE_CONNECTOR_SOLID

FL_TREE_SELECT_NONE = _fltk.FL_TREE_SELECT_NONE

FL_TREE_SELECT_SINGLE = _fltk.FL_TREE_SELECT_SINGLE

FL_TREE_SELECT_MULTI = _fltk.FL_TREE_SELECT_MULTI

FL_TREE_SELECT_SINGLE_DRAGGABLE = _fltk.FL_TREE_SELECT_SINGLE_DRAGGABLE

FL_TREE_SELECTABLE_ONCE = _fltk.FL_TREE_SELECTABLE_ONCE

FL_TREE_SELECTABLE_ALWAYS = _fltk.FL_TREE_SELECTABLE_ALWAYS

FL_TREE_ITEM_DRAW_DEFAULT = _fltk.FL_TREE_ITEM_DRAW_DEFAULT

FL_TREE_ITEM_DRAW_LABEL_AND_WIDGET = _fltk.FL_TREE_ITEM_DRAW_LABEL_AND_WIDGET

FL_TREE_ITEM_HEIGHT_FROM_WIDGET = _fltk.FL_TREE_ITEM_HEIGHT_FROM_WIDGET

class Fl_Tree_Prefs(object):
    r"""Proxy of C++ Fl_Tree_Prefs class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Tree_Prefs self) -> Fl_Tree_Prefs"""
        _fltk.Fl_Tree_Prefs_swiginit(self, _fltk.new_Fl_Tree_Prefs(*args))
    __swig_destroy__ = _fltk.delete_Fl_Tree_Prefs

    def item_labelfont(self, *args):
        r"""
        item_labelfont(Fl_Tree_Prefs self) -> Fl_Font
        item_labelfont(Fl_Tree_Prefs self, Fl_Font val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelfont(self, *args)

    def item_labelsize(self, *args):
        r"""
        item_labelsize(Fl_Tree_Prefs self) -> Fl_Fontsize
        item_labelsize(Fl_Tree_Prefs self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelsize(self, *args)

    def item_labelfgcolor(self, *args):
        r"""
        item_labelfgcolor(Fl_Tree_Prefs self) -> Fl_Color
        item_labelfgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelfgcolor(self, *args)

    def item_labelbgcolor(self, *args):
        r"""
        item_labelbgcolor(Fl_Tree_Prefs self) -> Fl_Color
        item_labelbgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelbgcolor(self, *args)

    def labelfont(self, *args):
        r"""
        labelfont(Fl_Tree_Prefs self) -> Fl_Font
        labelfont(Fl_Tree_Prefs self, Fl_Font val)
        """
        return _fltk.Fl_Tree_Prefs_labelfont(self, *args)

    def labelsize(self, *args):
        r"""
        labelsize(Fl_Tree_Prefs self) -> Fl_Fontsize
        labelsize(Fl_Tree_Prefs self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_Prefs_labelsize(self, *args)

    def labelfgcolor(self, *args):
        r"""
        labelfgcolor(Fl_Tree_Prefs self) -> Fl_Color
        labelfgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_labelfgcolor(self, *args)

    def labelbgcolor(self, *args):
        r"""
        labelbgcolor(Fl_Tree_Prefs self) -> Fl_Color
        labelbgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_labelbgcolor(self, *args)

    def marginleft(self, *args):
        r"""
        marginleft(Fl_Tree_Prefs self) -> int
        marginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_marginleft(self, *args)

    def margintop(self, *args):
        r"""
        margintop(Fl_Tree_Prefs self) -> int
        margintop(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_margintop(self, *args)

    def marginbottom(self, *args):
        r"""
        marginbottom(Fl_Tree_Prefs self) -> int
        marginbottom(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_marginbottom(self, *args)

    def openchild_marginbottom(self, *args):
        r"""
        openchild_marginbottom(Fl_Tree_Prefs self) -> int
        openchild_marginbottom(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_openchild_marginbottom(self, *args)

    def usericonmarginleft(self, *args):
        r"""
        usericonmarginleft(Fl_Tree_Prefs self) -> int
        usericonmarginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_usericonmarginleft(self, *args)

    def labelmarginleft(self, *args):
        r"""
        labelmarginleft(Fl_Tree_Prefs self) -> int
        labelmarginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_labelmarginleft(self, *args)

    def widgetmarginleft(self, *args):
        r"""
        widgetmarginleft(Fl_Tree_Prefs self) -> int
        widgetmarginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_widgetmarginleft(self, *args)

    def linespacing(self, *args):
        r"""
        linespacing(Fl_Tree_Prefs self) -> int
        linespacing(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_linespacing(self, *args)

    def connectorcolor(self, *args):
        r"""
        connectorcolor(Fl_Tree_Prefs self) -> Fl_Color
        connectorcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_connectorcolor(self, *args)

    def connectorstyle(self, *args):
        r"""
        connectorstyle(Fl_Tree_Prefs self) -> Fl_Tree_Connector
        connectorstyle(Fl_Tree_Prefs self, Fl_Tree_Connector val)
        connectorstyle(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_connectorstyle(self, *args)

    def connectorwidth(self, *args):
        r"""
        connectorwidth(Fl_Tree_Prefs self) -> int
        connectorwidth(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_connectorwidth(self, *args)

    def openicon_w(self, *args):
        r"""openicon_w(Fl_Tree_Prefs self) -> int"""
        return _fltk.Fl_Tree_Prefs_openicon_w(self, *args)

    def openicon_h(self, *args):
        r"""openicon_h(Fl_Tree_Prefs self) -> int"""
        return _fltk.Fl_Tree_Prefs_openicon_h(self, *args)

    def openicon(self, *args):
        r"""
        openicon(Fl_Tree_Prefs self) -> Fl_Image
        openicon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_openicon(self, *args)

    def closeicon_w(self, *args):
        r"""closeicon_w(Fl_Tree_Prefs self) -> int"""
        return _fltk.Fl_Tree_Prefs_closeicon_w(self, *args)

    def closeicon_h(self, *args):
        r"""closeicon_h(Fl_Tree_Prefs self) -> int"""
        return _fltk.Fl_Tree_Prefs_closeicon_h(self, *args)

    def closeicon(self, *args):
        r"""
        closeicon(Fl_Tree_Prefs self) -> Fl_Image
        closeicon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_closeicon(self, *args)

    def usericon(self, *args):
        r"""
        usericon(Fl_Tree_Prefs self) -> Fl_Image
        usericon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_usericon(self, *args)

    def opendeicon(self, *args):
        r"""opendeicon(Fl_Tree_Prefs self) -> Fl_Image"""
        return _fltk.Fl_Tree_Prefs_opendeicon(self, *args)

    def closedeicon(self, *args):
        r"""closedeicon(Fl_Tree_Prefs self) -> Fl_Image"""
        return _fltk.Fl_Tree_Prefs_closedeicon(self, *args)

    def userdeicon(self, *args):
        r"""userdeicon(Fl_Tree_Prefs self) -> Fl_Image"""
        return _fltk.Fl_Tree_Prefs_userdeicon(self, *args)

    def showcollapse(self, *args):
        r"""
        showcollapse(Fl_Tree_Prefs self) -> char
        showcollapse(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_showcollapse(self, *args)

    def sortorder(self, *args):
        r"""
        sortorder(Fl_Tree_Prefs self) -> Fl_Tree_Sort
        sortorder(Fl_Tree_Prefs self, Fl_Tree_Sort val)
        """
        return _fltk.Fl_Tree_Prefs_sortorder(self, *args)

    def selectbox(self, *args):
        r"""
        selectbox(Fl_Tree_Prefs self) -> Fl_Boxtype
        selectbox(Fl_Tree_Prefs self, Fl_Boxtype val)
        """
        return _fltk.Fl_Tree_Prefs_selectbox(self, *args)

    def showroot(self, *args):
        r"""
        showroot(Fl_Tree_Prefs self) -> int
        showroot(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_showroot(self, *args)

    def selectmode(self, *args):
        r"""
        selectmode(Fl_Tree_Prefs self) -> Fl_Tree_Select
        selectmode(Fl_Tree_Prefs self, Fl_Tree_Select val)
        """
        return _fltk.Fl_Tree_Prefs_selectmode(self, *args)

    def item_reselect_mode(self, *args):
        r"""
        item_reselect_mode(Fl_Tree_Prefs self) -> Fl_Tree_Item_Reselect_Mode
        item_reselect_mode(Fl_Tree_Prefs self, Fl_Tree_Item_Reselect_Mode mode)
        """
        return _fltk.Fl_Tree_Prefs_item_reselect_mode(self, *args)

    def item_draw_mode(self, *args):
        r"""
        item_draw_mode(Fl_Tree_Prefs self) -> Fl_Tree_Item_Draw_Mode
        item_draw_mode(Fl_Tree_Prefs self, Fl_Tree_Item_Draw_Mode val)
        """
        return _fltk.Fl_Tree_Prefs_item_draw_mode(self, *args)

    def item_draw_callback(self, *args):
        r"""
        item_draw_callback(Fl_Tree_Prefs self, Fl_Tree_Item_Draw_Callback * cb, void * data=None)
        item_draw_callback(Fl_Tree_Prefs self) -> Fl_Tree_Item_Draw_Callback *
        """
        return _fltk.Fl_Tree_Prefs_item_draw_callback(self, *args)

    def item_draw_user_data(self, *args):
        r"""item_draw_user_data(Fl_Tree_Prefs self) -> void *"""
        return _fltk.Fl_Tree_Prefs_item_draw_user_data(self, *args)

    def do_item_draw_callback(self, *args):
        r"""do_item_draw_callback(Fl_Tree_Prefs self, Fl_Tree_Item o)"""
        return _fltk.Fl_Tree_Prefs_do_item_draw_callback(self, *args)

# Register Fl_Tree_Prefs in _fltk:
_fltk.Fl_Tree_Prefs_swigregister(Fl_Tree_Prefs)
class Fl_Tree_Item_Array(object):
    r"""

    Because FLTK 1.x.x. has mandated that templates and STL not be used, we use this class to dynamically manage the arrays.
    None of the methods do range checking on index values; the caller must be sure that index values are within the range 0<index<total() (unless otherwise noted).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _fltk.delete_Fl_Tree_Item_Array

    def __init__(self, *args):
        r"""
        __init__(Fl_Tree_Item_Array self, int new_chunksize=10) -> Fl_Tree_Item_Array
        __init__(Fl_Tree_Item_Array self, Fl_Tree_Item_Array o) -> Fl_Tree_Item_Array
        """
        _fltk.Fl_Tree_Item_Array_swiginit(self, _fltk.new_Fl_Tree_Item_Array(*args))

    def total(self, *args):
        r"""total(Fl_Tree_Item_Array self) -> int"""
        return _fltk.Fl_Tree_Item_Array_total(self, *args)

    def swap(self, *args):
        r"""swap(Fl_Tree_Item_Array self, int ax, int bx)"""
        return _fltk.Fl_Tree_Item_Array_swap(self, *args)

    def move(self, *args):
        r"""move(Fl_Tree_Item_Array self, int to, int _from) -> int"""
        return _fltk.Fl_Tree_Item_Array_move(self, *args)

    def deparent(self, *args):
        r"""deparent(Fl_Tree_Item_Array self, int pos) -> int"""
        return _fltk.Fl_Tree_Item_Array_deparent(self, *args)

    def reparent(self, *args):
        r"""reparent(Fl_Tree_Item_Array self, Fl_Tree_Item item, Fl_Tree_Item newparent, int pos) -> int"""
        return _fltk.Fl_Tree_Item_Array_reparent(self, *args)

    def clear(self, *args):
        r"""clear(Fl_Tree_Item_Array self)"""
        return _fltk.Fl_Tree_Item_Array_clear(self, *args)

    def add(self, *args):
        r"""add(Fl_Tree_Item_Array self, Fl_Tree_Item val)"""
        return _fltk.Fl_Tree_Item_Array_add(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Tree_Item_Array self, int pos, Fl_Tree_Item new_item)"""
        return _fltk.Fl_Tree_Item_Array_insert(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Tree_Item_Array self, int pos, Fl_Tree_Item new_item)"""
        return _fltk.Fl_Tree_Item_Array_replace(self, *args)

    def remove(self, *args):
        r"""
        remove(Fl_Tree_Item_Array self, int index)
        remove(Fl_Tree_Item_Array self, Fl_Tree_Item item) -> int
        """
        return _fltk.Fl_Tree_Item_Array_remove(self, *args)

    def manage_item_destroy(self, *args):
        r"""
        manage_item_destroy(Fl_Tree_Item_Array self, int val)
        manage_item_destroy(Fl_Tree_Item_Array self) -> int
        """
        return _fltk.Fl_Tree_Item_Array_manage_item_destroy(self, *args)

# Register Fl_Tree_Item_Array in _fltk:
_fltk.Fl_Tree_Item_Array_swigregister(Fl_Tree_Item_Array)
class Fl_Tree_Item(object):
    r"""

    This class is a single tree item, and manages all of the item's attributes. Fl_Tree_Item is used by Fl_Tree, which is comprised of many instances of Fl_Tree_Item.
    Fl_Tree_Item is hierarchical; it dynamically manages an Fl_Tree_Item_Array of children that are themselves instances of Fl_Tree_Item. Each item can have zero or more children. When an item has children, close() and open() can be used to hide or show them. Items have their own attributes; font size, face, color. Items maintain their own hierarchy of children. When you make changes to items, you'll need to tell the tree to redraw() for the changes to show up.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw_vertical_connector(self, *args):
        r"""draw_vertical_connector(Fl_Tree_Item self, int x, int y1, int y2, Fl_Tree_Prefs prefs)"""
        return _fltk.Fl_Tree_Item_draw_vertical_connector(self, *args)

    def draw_horizontal_connector(self, *args):
        r"""draw_horizontal_connector(Fl_Tree_Item self, int x1, int x2, int y, Fl_Tree_Prefs prefs)"""
        return _fltk.Fl_Tree_Item_draw_horizontal_connector(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Tree_Item

    def __init__(self, *args):
        r"""
        __init__(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item
        __init__(Fl_Tree_Item self, Fl_Tree tree) -> Fl_Tree_Item
        __init__(Fl_Tree_Item self, Fl_Tree_Item o) -> Fl_Tree_Item
        """
        if self.__class__ == Fl_Tree_Item:
            _self = None
        else:
            _self = self
        _fltk.Fl_Tree_Item_swiginit(self, _fltk.new_Fl_Tree_Item(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Tree_Item")
        #print("Adding type: ", Fl_Tree_Item)




    def x(self, *args):
        r"""x(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_x(self, *args)

    def y(self, *args):
        r"""y(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_y(self, *args)

    def w(self, *args):
        r"""w(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_w(self, *args)

    def h(self, *args):
        r"""h(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_h(self, *args)

    def label_x(self, *args):
        r"""label_x(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_x(self, *args)

    def label_y(self, *args):
        r"""label_y(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_y(self, *args)

    def label_w(self, *args):
        r"""label_w(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_w(self, *args)

    def label_h(self, *args):
        r"""label_h(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_h(self, *args)

    def draw_item_content(self, *args):
        r"""draw_item_content(Fl_Tree_Item self, int render) -> int"""
        return _fltk.Fl_Tree_Item_draw_item_content(self, *args)

    def draw(self, *args):
        r"""draw(Fl_Tree_Item self, int X, int & Y, int W, Fl_Tree_Item itemfocus, int lastchild=1, int render=1)"""
        return _fltk.Fl_Tree_Item_draw(self, *args)

    def show_self(self, *args):
        r"""show_self(Fl_Tree_Item self, char const * indent="")"""
        return _fltk.Fl_Tree_Item_show_self(self, *args)

    def label(self, *args):
        r"""
        label(Fl_Tree_Item self, char const * val)
        label(Fl_Tree_Item self) -> char const *
        """
        return _fltk.Fl_Tree_Item_label(self, *args)

    def labelfont(self, *args):
        r"""
        labelfont(Fl_Tree_Item self, Fl_Font val)
        labelfont(Fl_Tree_Item self) -> Fl_Font
        """
        return _fltk.Fl_Tree_Item_labelfont(self, *args)

    def labelsize(self, *args):
        r"""
        labelsize(Fl_Tree_Item self, Fl_Fontsize val)
        labelsize(Fl_Tree_Item self) -> Fl_Fontsize
        """
        return _fltk.Fl_Tree_Item_labelsize(self, *args)

    def labelfgcolor(self, *args):
        r"""
        labelfgcolor(Fl_Tree_Item self, Fl_Color val)
        labelfgcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelfgcolor(self, *args)

    def labelcolor(self, *args):
        r"""
        labelcolor(Fl_Tree_Item self, Fl_Color val)
        labelcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelcolor(self, *args)

    def labelbgcolor(self, *args):
        r"""
        labelbgcolor(Fl_Tree_Item self, Fl_Color val)
        labelbgcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelbgcolor(self, *args)

    def widget(self, *args):
        r"""
        widget(Fl_Tree_Item self, Fl_Widget val)
        widget(Fl_Tree_Item self) -> Fl_Widget
        """
        return _fltk.Fl_Tree_Item_widget(self, *args)

    def children(self, *args):
        r"""children(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_children(self, *args)

    def child(self, *args):
        r"""
        child(Fl_Tree_Item self, int index) -> Fl_Tree_Item
        child(Fl_Tree_Item self, int t) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_child(self, *args)

    def has_children(self, *args):
        r"""has_children(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_has_children(self, *args)

    def find_child(self, *args):
        r"""
        find_child(Fl_Tree_Item self, char const * name) -> int
        find_child(Fl_Tree_Item self, Fl_Tree_Item item) -> int
        """
        return _fltk.Fl_Tree_Item_find_child(self, *args)

    def remove_child(self, *args):
        r"""
        remove_child(Fl_Tree_Item self, Fl_Tree_Item item) -> int
        remove_child(Fl_Tree_Item self, char const * new_label) -> int
        """
        return _fltk.Fl_Tree_Item_remove_child(self, *args)

    def clear_children(self, *args):
        r"""clear_children(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_clear_children(self, *args)

    def swap_children(self, *args):
        r"""
        swap_children(Fl_Tree_Item self, int ax, int bx)
        swap_children(Fl_Tree_Item self, Fl_Tree_Item a, Fl_Tree_Item b) -> int
        """
        return _fltk.Fl_Tree_Item_swap_children(self, *args)

    def find_child_item(self, *args):
        r"""
        find_child_item(Fl_Tree_Item self, char const * name) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char const * name) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_child_item(self, *args)

    def find_item(self, *args):
        r"""
        find_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        find_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_item(self, *args)

    def add(self, *args):
        r"""
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label, Fl_Tree_Item newitem) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char ** arr, Fl_Tree_Item newitem) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_add(self, *args)

    def replace(self, *args):
        r"""replace(Fl_Tree_Item self, Fl_Tree_Item new_item) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_replace(self, *args)

    def replace_child(self, *args):
        r"""replace_child(Fl_Tree_Item self, Fl_Tree_Item olditem, Fl_Tree_Item newitem) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_replace_child(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label, int pos=0) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_insert(self, *args)

    def insert_above(self, *args):
        r"""insert_above(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_insert_above(self, *args)

    def deparent(self, *args):
        r"""deparent(Fl_Tree_Item self, int index) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_deparent(self, *args)

    def reparent(self, *args):
        r"""reparent(Fl_Tree_Item self, Fl_Tree_Item newchild, int index) -> int"""
        return _fltk.Fl_Tree_Item_reparent(self, *args)

    def move(self, *args):
        r"""
        move(Fl_Tree_Item self, int to, int _from) -> int
        move(Fl_Tree_Item self, Fl_Tree_Item item, int op=0, int pos=0) -> int
        """
        return _fltk.Fl_Tree_Item_move(self, *args)

    def move_above(self, *args):
        r"""move_above(Fl_Tree_Item self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_Item_move_above(self, *args)

    def move_below(self, *args):
        r"""move_below(Fl_Tree_Item self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_Item_move_below(self, *args)

    def move_into(self, *args):
        r"""move_into(Fl_Tree_Item self, Fl_Tree_Item item, int pos=0) -> int"""
        return _fltk.Fl_Tree_Item_move_into(self, *args)

    def depth(self, *args):
        r"""depth(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_depth(self, *args)

    def prev(self, *args):
        r"""prev(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev(self, *args)

    def next(self, *args):
        r"""next(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next(self, *args)

    def next_sibling(self, *args):
        r"""next_sibling(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_sibling(self, *args)

    def prev_sibling(self, *args):
        r"""prev_sibling(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_sibling(self, *args)

    def update_prev_next(self, *args):
        r"""update_prev_next(Fl_Tree_Item self, int index)"""
        return _fltk.Fl_Tree_Item_update_prev_next(self, *args)

    def next_displayed(self, *args):
        r"""next_displayed(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_displayed(self, *args)

    def prev_displayed(self, *args):
        r"""prev_displayed(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_displayed(self, *args)

    def next_visible(self, *args):
        r"""next_visible(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_visible(self, *args)

    def prev_visible(self, *args):
        r"""prev_visible(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_visible(self, *args)

    def parent(self, *args):
        r"""
        parent(Fl_Tree_Item self) -> Fl_Tree_Item
        parent(Fl_Tree_Item self) -> Fl_Tree_Item
        parent(Fl_Tree_Item self, Fl_Tree_Item val)
        """
        return _fltk.Fl_Tree_Item_parent(self, *args)

    def prefs(self, *args):
        r"""prefs(Fl_Tree_Item self) -> Fl_Tree_Prefs"""
        return _fltk.Fl_Tree_Item_prefs(self, *args)

    def tree(self, *args):
        r"""
        tree(Fl_Tree_Item self) -> Fl_Tree
        tree(Fl_Tree_Item self) -> Fl_Tree
        """
        return _fltk.Fl_Tree_Item_tree(self, *args)

    def open(self, *args):
        r"""open(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_open(self, *args)

    def close(self, *args):
        r"""close(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_close(self, *args)

    def is_open(self, *args):
        r"""is_open(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_open(self, *args)

    def is_close(self, *args):
        r"""is_close(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_close(self, *args)

    def open_toggle(self, *args):
        r"""open_toggle(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_open_toggle(self, *args)

    def select(self, *args):
        r"""select(Fl_Tree_Item self, int val=1)"""
        return _fltk.Fl_Tree_Item_select(self, *args)

    def select_toggle(self, *args):
        r"""select_toggle(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_select_toggle(self, *args)

    def select_all(self, *args):
        r"""select_all(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_select_all(self, *args)

    def deselect(self, *args):
        r"""deselect(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_deselect(self, *args)

    def deselect_all(self, *args):
        r"""deselect_all(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_deselect_all(self, *args)

    def is_selected(self, *args):
        r"""is_selected(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_selected(self, *args)

    def activate(self, *args):
        r"""activate(Fl_Tree_Item self, int val=1)"""
        return _fltk.Fl_Tree_Item_activate(self, *args)

    def deactivate(self, *args):
        r"""deactivate(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_deactivate(self, *args)

    def is_activated(self, *args):
        r"""is_activated(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_activated(self, *args)

    def is_active(self, *args):
        r"""is_active(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_active(self, *args)

    def visible(self, *args):
        r"""visible(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_visible(self, *args)

    def is_visible(self, *args):
        r"""is_visible(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_visible(self, *args)

    def visible_r(self, *args):
        r"""visible_r(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_visible_r(self, *args)

    def is_visible_r(self, *args):
        r"""is_visible_r(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_visible_r(self, *args)

    def usericon(self, *args):
        r"""
        usericon(Fl_Tree_Item self, Fl_Image val)
        usericon(Fl_Tree_Item self) -> Fl_Image
        """
        return _fltk.Fl_Tree_Item_usericon(self, *args)

    def userdeicon(self, *args):
        r"""
        userdeicon(Fl_Tree_Item self, Fl_Image val)
        userdeicon(Fl_Tree_Item self) -> Fl_Image
        """
        return _fltk.Fl_Tree_Item_userdeicon(self, *args)

    def find_clicked(self, *args):
        r"""
        find_clicked(Fl_Tree_Item self, Fl_Tree_Prefs prefs, int yonly=0) -> Fl_Tree_Item
        find_clicked(Fl_Tree_Item self, Fl_Tree_Prefs prefs, int yonly=0) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_clicked(self, *args)

    def event_on_item(self, *args):
        r"""event_on_item(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_item(self, *args)

    def event_on_collapse_icon(self, *args):
        r"""event_on_collapse_icon(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_collapse_icon(self, *args)

    def event_on_user_icon(self, *args):
        r"""event_on_user_icon(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_user_icon(self, *args)

    def event_on_label(self, *args):
        r"""event_on_label(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_label(self, *args)

    def is_root(self, *args):
        r"""is_root(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_root(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Tree_Item self, char * Fl_Tree_Item)"""
        return _fltk.Fl_Tree_Item_init_type(self, *args)

    def user_data(self, *args):
        r"""
        user_data(Fl_Tree_Item self, PyObject * PyData)
        user_data(Fl_Tree_Item self) -> PyObject *
        """
        return _fltk.Fl_Tree_Item_user_data(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tree_Item(self)
        return weakref.proxy(self)

# Register Fl_Tree_Item in _fltk:
_fltk.Fl_Tree_Item_swigregister(Fl_Tree_Item)
FL_TREE_REASON_NONE = _fltk.FL_TREE_REASON_NONE

FL_TREE_REASON_SELECTED = _fltk.FL_TREE_REASON_SELECTED

FL_TREE_REASON_DESELECTED = _fltk.FL_TREE_REASON_DESELECTED

FL_TREE_REASON_RESELECTED = _fltk.FL_TREE_REASON_RESELECTED

FL_TREE_REASON_OPENED = _fltk.FL_TREE_REASON_OPENED

FL_TREE_REASON_CLOSED = _fltk.FL_TREE_REASON_CLOSED

FL_TREE_REASON_DRAGGED = _fltk.FL_TREE_REASON_DRAGGED

class Fl_Tree(Fl_Group):
    r"""

    An expandable tree widget. Similar to Fl_Browser, Fl_Tree is browser of Fl_Tree_Item's, which can be in a parented hierarchy. Subtrees can be expanded or closed. Items can be added, deleted, inserted, sorted and re-ordered. The tree items may also contain other FLTK widgets, like buttons, input fields, or even 'custom' widgets.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def draw(self, *args):
        r"""draw(Fl_Tree self)"""
        return _fltk.Fl_Tree_draw(self, *args)

    def __init__(self, *args):
        r"""__init__(Fl_Tree self, int X, int Y, int W, int H, char const * L=None) -> Fl_Tree"""
        if self.__class__ == Fl_Tree:
            _self = None
        else:
            _self = self
        _fltk.Fl_Tree_swiginit(self, _fltk.new_Fl_Tree(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("Fl_Tree")
        #print("Adding type: ", Fl_Tree)



    __swig_destroy__ = _fltk.delete_Fl_Tree

    def handle(self, *args):
        r"""handle(Fl_Tree self, int e) -> int"""
        return _fltk.Fl_Tree_handle(self, *args)

    def show_self(self, *args):
        r"""show_self(Fl_Tree self)"""
        return _fltk.Fl_Tree_show_self(self, *args)

    def resize(self, *args):
        r"""resize(Fl_Tree self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Tree_resize(self, *args)

    def root_label(self, *args):
        r"""root_label(Fl_Tree self, char const * new_label)"""
        return _fltk.Fl_Tree_root_label(self, *args)

    def root(self, *args):
        r"""
        root(Fl_Tree self) -> Fl_Tree_Item
        root(Fl_Tree self, Fl_Tree_Item newitem)
        """
        return _fltk.Fl_Tree_root(self, *args)

    def prefs(self, *args):
        r"""prefs(Fl_Tree self) -> Fl_Tree_Prefs"""
        return _fltk.Fl_Tree_prefs(self, *args)

    def add(self, *args):
        r"""
        add(Fl_Tree self, char const * path, Fl_Tree_Item newitem=None) -> Fl_Tree_Item
        add(Fl_Tree self, Fl_Tree_Item parent_item, char const * name) -> Fl_Tree_Item
        """
        val = _fltk.Fl_Tree_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert_above(self, *args):
        r"""insert_above(Fl_Tree self, Fl_Tree_Item above, char const * name) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_insert_above(self, *args)

    def insert(self, *args):
        r"""insert(Fl_Tree self, Fl_Tree_Item item, char const * name, int pos) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_insert(self, *args)

    def remove(self, *args):
        r"""remove(Fl_Tree self, Fl_Tree_Item item) -> int"""
        val = _fltk.Fl_Tree_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args):
        r"""clear(Fl_Tree self)"""
        return _fltk.Fl_Tree_clear(self, *args)

    def clear_children(self, *args):
        r"""clear_children(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_clear_children(self, *args)

    def find_item(self, *args):
        r"""
        find_item(Fl_Tree self, char const * path) -> Fl_Tree_Item
        find_item(Fl_Tree self, char const * path) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_find_item(self, *args)

    def item_pathname(self, *args):
        r"""item_pathname(Fl_Tree self, char * pathname, int pathnamelen, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_item_pathname(self, *args)

    def find_clicked(self, *args):
        r"""
        find_clicked(Fl_Tree self, int yonly=0) -> Fl_Tree_Item
        find_clicked(Fl_Tree self, int yonly=0) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_find_clicked(self, *args)

    def item_clicked(self, *args):
        r"""item_clicked(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_item_clicked(self, *args)

    def first(self, *args):
        r"""first(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first(self, *args)

    def first_visible(self, *args):
        r"""first_visible(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_visible(self, *args)

    def first_visible_item(self, *args):
        r"""first_visible_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_visible_item(self, *args)

    def next(self, *args):
        r"""next(Fl_Tree self, Fl_Tree_Item item=None) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next(self, *args)

    def prev(self, *args):
        r"""prev(Fl_Tree self, Fl_Tree_Item item=None) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_prev(self, *args)

    def last(self, *args):
        r"""last(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last(self, *args)

    def last_visible(self, *args):
        r"""last_visible(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_visible(self, *args)

    def last_visible_item(self, *args):
        r"""last_visible_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_visible_item(self, *args)

    def next_visible_item(self, *args):
        r"""next_visible_item(Fl_Tree self, Fl_Tree_Item start, int dir) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next_visible_item(self, *args)

    def first_selected_item(self, *args):
        r"""first_selected_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_selected_item(self, *args)

    def last_selected_item(self, *args):
        r"""last_selected_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_selected_item(self, *args)

    def next_item(self, *args):
        r"""next_item(Fl_Tree self, Fl_Tree_Item item, int dir=65364, bool visible=False) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next_item(self, *args)

    def next_selected_item(self, *args):
        r"""next_selected_item(Fl_Tree self, Fl_Tree_Item item=None, int dir=65364) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next_selected_item(self, *args)

    def get_selected_items(self, *args):
        r"""get_selected_items(Fl_Tree self, Fl_Tree_Item_Array items) -> int"""
        return _fltk.Fl_Tree_get_selected_items(self, *args)

    def open(self, *args):
        r"""
        open(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        open(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_open(self, *args)

    def open_toggle(self, *args):
        r"""open_toggle(Fl_Tree self, Fl_Tree_Item item, int docallback=1)"""
        return _fltk.Fl_Tree_open_toggle(self, *args)

    def close(self, *args):
        r"""
        close(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        close(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_close(self, *args)

    def is_open(self, *args):
        r"""
        is_open(Fl_Tree self, Fl_Tree_Item item) -> int
        is_open(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_open(self, *args)

    def is_close(self, *args):
        r"""
        is_close(Fl_Tree self, Fl_Tree_Item item) -> int
        is_close(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_close(self, *args)

    def select(self, *args):
        r"""
        select(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        select(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_select(self, *args)

    def select_toggle(self, *args):
        r"""select_toggle(Fl_Tree self, Fl_Tree_Item item, int docallback=1)"""
        return _fltk.Fl_Tree_select_toggle(self, *args)

    def deselect(self, *args):
        r"""
        deselect(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        deselect(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_deselect(self, *args)

    def deselect_all(self, *args):
        r"""deselect_all(Fl_Tree self, Fl_Tree_Item item=None, int docallback=1) -> int"""
        return _fltk.Fl_Tree_deselect_all(self, *args)

    def select_only(self, *args):
        r"""select_only(Fl_Tree self, Fl_Tree_Item selitem, int docallback=1) -> int"""
        return _fltk.Fl_Tree_select_only(self, *args)

    def select_all(self, *args):
        r"""select_all(Fl_Tree self, Fl_Tree_Item item=None, int docallback=1) -> int"""
        return _fltk.Fl_Tree_select_all(self, *args)

    def extend_selection_dir(self, *args):
        r"""extend_selection_dir(Fl_Tree self, Fl_Tree_Item _from, Fl_Tree_Item to, int dir, int val, bool visible) -> int"""
        return _fltk.Fl_Tree_extend_selection_dir(self, *args)

    def extend_selection(self, *args):
        r"""extend_selection(Fl_Tree self, Fl_Tree_Item _from, Fl_Tree_Item to, int val=1, bool visible=False) -> int"""
        return _fltk.Fl_Tree_extend_selection(self, *args)

    def set_item_focus(self, *args):
        r"""set_item_focus(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_set_item_focus(self, *args)

    def get_item_focus(self, *args):
        r"""get_item_focus(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_get_item_focus(self, *args)

    def is_selected(self, *args):
        r"""
        is_selected(Fl_Tree self, Fl_Tree_Item item) -> int
        is_selected(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_selected(self, *args)

    def item_labelfont(self, *args):
        r"""
        item_labelfont(Fl_Tree self) -> Fl_Font
        item_labelfont(Fl_Tree self, Fl_Font val)
        """
        return _fltk.Fl_Tree_item_labelfont(self, *args)

    def item_labelsize(self, *args):
        r"""
        item_labelsize(Fl_Tree self) -> Fl_Fontsize
        item_labelsize(Fl_Tree self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_item_labelsize(self, *args)

    def item_labelfgcolor(self, *args):
        r"""
        item_labelfgcolor(Fl_Tree self) -> Fl_Color
        item_labelfgcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_item_labelfgcolor(self, *args)

    def item_labelbgcolor(self, *args):
        r"""
        item_labelbgcolor(Fl_Tree self) -> Fl_Color
        item_labelbgcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_item_labelbgcolor(self, *args)

    def connectorcolor(self, *args):
        r"""
        connectorcolor(Fl_Tree self) -> Fl_Color
        connectorcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_connectorcolor(self, *args)

    def marginleft(self, *args):
        r"""
        marginleft(Fl_Tree self) -> int
        marginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_marginleft(self, *args)

    def margintop(self, *args):
        r"""
        margintop(Fl_Tree self) -> int
        margintop(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_margintop(self, *args)

    def marginbottom(self, *args):
        r"""
        marginbottom(Fl_Tree self) -> int
        marginbottom(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_marginbottom(self, *args)

    def linespacing(self, *args):
        r"""
        linespacing(Fl_Tree self) -> int
        linespacing(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_linespacing(self, *args)

    def openchild_marginbottom(self, *args):
        r"""
        openchild_marginbottom(Fl_Tree self) -> int
        openchild_marginbottom(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_openchild_marginbottom(self, *args)

    def usericonmarginleft(self, *args):
        r"""
        usericonmarginleft(Fl_Tree self) -> int
        usericonmarginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_usericonmarginleft(self, *args)

    def labelmarginleft(self, *args):
        r"""
        labelmarginleft(Fl_Tree self) -> int
        labelmarginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_labelmarginleft(self, *args)

    def widgetmarginleft(self, *args):
        r"""
        widgetmarginleft(Fl_Tree self) -> int
        widgetmarginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_widgetmarginleft(self, *args)

    def connectorwidth(self, *args):
        r"""
        connectorwidth(Fl_Tree self) -> int
        connectorwidth(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_connectorwidth(self, *args)

    def usericon(self, *args):
        r"""
        usericon(Fl_Tree self) -> Fl_Image
        usericon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_usericon(self, *args)

    def openicon(self, *args):
        r"""
        openicon(Fl_Tree self) -> Fl_Image
        openicon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_openicon(self, *args)

    def closeicon(self, *args):
        r"""
        closeicon(Fl_Tree self) -> Fl_Image
        closeicon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_closeicon(self, *args)

    def showcollapse(self, *args):
        r"""
        showcollapse(Fl_Tree self) -> int
        showcollapse(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_showcollapse(self, *args)

    def showroot(self, *args):
        r"""
        showroot(Fl_Tree self) -> int
        showroot(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_showroot(self, *args)

    def connectorstyle(self, *args):
        r"""
        connectorstyle(Fl_Tree self) -> Fl_Tree_Connector
        connectorstyle(Fl_Tree self, Fl_Tree_Connector val)
        """
        return _fltk.Fl_Tree_connectorstyle(self, *args)

    def sortorder(self, *args):
        r"""
        sortorder(Fl_Tree self) -> Fl_Tree_Sort
        sortorder(Fl_Tree self, Fl_Tree_Sort val)
        """
        return _fltk.Fl_Tree_sortorder(self, *args)

    def selectbox(self, *args):
        r"""
        selectbox(Fl_Tree self) -> Fl_Boxtype
        selectbox(Fl_Tree self, Fl_Boxtype val)
        """
        return _fltk.Fl_Tree_selectbox(self, *args)

    def selectmode(self, *args):
        r"""
        selectmode(Fl_Tree self) -> Fl_Tree_Select
        selectmode(Fl_Tree self, Fl_Tree_Select val)
        """
        return _fltk.Fl_Tree_selectmode(self, *args)

    def item_reselect_mode(self, *args):
        r"""
        item_reselect_mode(Fl_Tree self) -> Fl_Tree_Item_Reselect_Mode
        item_reselect_mode(Fl_Tree self, Fl_Tree_Item_Reselect_Mode mode)
        """
        return _fltk.Fl_Tree_item_reselect_mode(self, *args)

    def item_draw_mode(self, *args):
        r"""
        item_draw_mode(Fl_Tree self) -> Fl_Tree_Item_Draw_Mode
        item_draw_mode(Fl_Tree self, Fl_Tree_Item_Draw_Mode mode)
        item_draw_mode(Fl_Tree self, int mode)
        """
        return _fltk.Fl_Tree_item_draw_mode(self, *args)

    def calc_dimensions(self, *args):
        r"""calc_dimensions(Fl_Tree self)"""
        return _fltk.Fl_Tree_calc_dimensions(self, *args)

    def calc_tree(self, *args):
        r"""calc_tree(Fl_Tree self)"""
        return _fltk.Fl_Tree_calc_tree(self, *args)

    def recalc_tree(self, *args):
        r"""recalc_tree(Fl_Tree self)"""
        return _fltk.Fl_Tree_recalc_tree(self, *args)

    def displayed(self, *args):
        r"""displayed(Fl_Tree self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_displayed(self, *args)

    def show_item(self, *args):
        r"""
        show_item(Fl_Tree self, Fl_Tree_Item item, int yoff)
        show_item(Fl_Tree self, Fl_Tree_Item item)
        """
        return _fltk.Fl_Tree_show_item(self, *args)

    def show_item_top(self, *args):
        r"""show_item_top(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_top(self, *args)

    def show_item_middle(self, *args):
        r"""show_item_middle(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_middle(self, *args)

    def show_item_bottom(self, *args):
        r"""show_item_bottom(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_bottom(self, *args)

    def display(self, *args):
        r"""display(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_display(self, *args)

    def vposition(self, *args):
        r"""
        vposition(Fl_Tree self) -> int
        vposition(Fl_Tree self, int pos)
        """
        return _fltk.Fl_Tree_vposition(self, *args)

    def hposition(self, *args):
        r"""
        hposition(Fl_Tree self) -> int
        hposition(Fl_Tree self, int pos)
        """
        return _fltk.Fl_Tree_hposition(self, *args)

    def is_scrollbar(self, *args):
        r"""is_scrollbar(Fl_Tree self, Fl_Widget w) -> int"""
        return _fltk.Fl_Tree_is_scrollbar(self, *args)

    def scrollbar_size(self, *args):
        r"""
        scrollbar_size(Fl_Tree self) -> int
        scrollbar_size(Fl_Tree self, int size)
        """
        return _fltk.Fl_Tree_scrollbar_size(self, *args)

    def is_vscroll_visible(self, *args):
        r"""is_vscroll_visible(Fl_Tree self) -> int"""
        return _fltk.Fl_Tree_is_vscroll_visible(self, *args)

    def is_hscroll_visible(self, *args):
        r"""is_hscroll_visible(Fl_Tree self) -> int"""
        return _fltk.Fl_Tree_is_hscroll_visible(self, *args)

    def callback_item(self, *args):
        r"""
        callback_item(Fl_Tree self, Fl_Tree_Item item)
        callback_item(Fl_Tree self) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_callback_item(self, *args)

    def callback_reason(self, *args):
        r"""
        callback_reason(Fl_Tree self, Fl_Tree_Reason reason)
        callback_reason(Fl_Tree self) -> Fl_Tree_Reason
        """
        return _fltk.Fl_Tree_callback_reason(self, *args)

    def load(self, *args):
        r"""load(Fl_Tree self, Fl_Preferences arg2)"""
        return _fltk.Fl_Tree_load(self, *args)

    def init_type(self, *args):
        r"""init_type(Fl_Tree self, char * Fl_Tree)"""
        return _fltk.Fl_Tree_init_type(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tree(self)
        return weakref.proxy(self)

# Register Fl_Tree in _fltk:
_fltk.Fl_Tree_swigregister(Fl_Tree)
NO_PAGE_FORMATS = _fltk.NO_PAGE_FORMATS

class Fl_Paged_Device(Fl_Widget_Surface):
    r"""

    Represents page-structured drawing surfaces.

    This class has no public constructor: don't instantiate it; use Fl_Printer 
    or Fl_PostScript_File_Device instead.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Paged_Device self) -> Fl_Paged_Device"""
        if self.__class__ == Fl_Paged_Device:
            _self = None
        else:
            _self = self
        _fltk.Fl_Paged_Device_swiginit(self, _fltk.new_Fl_Paged_Device(_self, *args))
    A0 = _fltk.Fl_Paged_Device_A0
    
    A1 = _fltk.Fl_Paged_Device_A1
    
    A2 = _fltk.Fl_Paged_Device_A2
    
    A3 = _fltk.Fl_Paged_Device_A3
    
    A4 = _fltk.Fl_Paged_Device_A4
    
    A5 = _fltk.Fl_Paged_Device_A5
    
    A6 = _fltk.Fl_Paged_Device_A6
    
    A7 = _fltk.Fl_Paged_Device_A7
    
    A8 = _fltk.Fl_Paged_Device_A8
    
    A9 = _fltk.Fl_Paged_Device_A9
    
    B0 = _fltk.Fl_Paged_Device_B0
    
    B1 = _fltk.Fl_Paged_Device_B1
    
    B2 = _fltk.Fl_Paged_Device_B2
    
    B3 = _fltk.Fl_Paged_Device_B3
    
    B4 = _fltk.Fl_Paged_Device_B4
    
    B5 = _fltk.Fl_Paged_Device_B5
    
    B6 = _fltk.Fl_Paged_Device_B6
    
    B7 = _fltk.Fl_Paged_Device_B7
    
    B8 = _fltk.Fl_Paged_Device_B8
    
    B9 = _fltk.Fl_Paged_Device_B9
    
    B10 = _fltk.Fl_Paged_Device_B10
    
    C5E = _fltk.Fl_Paged_Device_C5E
    
    DLE = _fltk.Fl_Paged_Device_DLE
    
    EXECUTIVE = _fltk.Fl_Paged_Device_EXECUTIVE
    
    FOLIO = _fltk.Fl_Paged_Device_FOLIO
    
    LEDGER = _fltk.Fl_Paged_Device_LEDGER
    
    LEGAL = _fltk.Fl_Paged_Device_LEGAL
    
    LETTER = _fltk.Fl_Paged_Device_LETTER
    
    TABLOID = _fltk.Fl_Paged_Device_TABLOID
    
    ENVELOPE = _fltk.Fl_Paged_Device_ENVELOPE
    
    MEDIA = _fltk.Fl_Paged_Device_MEDIA
    
    PORTRAIT = _fltk.Fl_Paged_Device_PORTRAIT
    
    LANDSCAPE = _fltk.Fl_Paged_Device_LANDSCAPE
    
    REVERSED = _fltk.Fl_Paged_Device_REVERSED
    
    ORIENTATION = _fltk.Fl_Paged_Device_ORIENTATION
    
    __swig_destroy__ = _fltk.delete_Fl_Paged_Device

    def begin_job(self, *args):
        r"""begin_job(Fl_Paged_Device self, int pagecount=0, int * frompage=None, int * topage=None, char ** perr_message=None) -> int"""
        return _fltk.Fl_Paged_Device_begin_job(self, *args)

    def start_job(self, *args):
        r"""start_job(Fl_Paged_Device self, int pagecount=0, int * frompage=None, int * topage=None, char ** perr_message=None) -> int"""
        return _fltk.Fl_Paged_Device_start_job(self, *args)

    def begin_page(self, *args):
        r"""begin_page(Fl_Paged_Device self) -> int"""
        return _fltk.Fl_Paged_Device_begin_page(self, *args)

    def start_page(self, *args):
        r"""start_page(Fl_Paged_Device self) -> int"""
        return _fltk.Fl_Paged_Device_start_page(self, *args)

    def margins(self, *args):
        r"""margins(Fl_Paged_Device self, int * left, int * top, int * right, int * bottom)"""
        return _fltk.Fl_Paged_Device_margins(self, *args)

    def scale(self, *args):
        r"""scale(Fl_Paged_Device self, float scale_x, float scale_y=0.)"""
        return _fltk.Fl_Paged_Device_scale(self, *args)

    def rotate(self, *args):
        r"""rotate(Fl_Paged_Device self, float angle)"""
        return _fltk.Fl_Paged_Device_rotate(self, *args)

    def print_widget(self, *args):
        r"""print_widget(Fl_Paged_Device self, Fl_Widget widget, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Paged_Device_print_widget(self, *args)

    def print_window(self, *args):
        r"""print_window(Fl_Paged_Device self, Fl_Window win, int x_off=0, int y_off=0)"""
        return _fltk.Fl_Paged_Device_print_window(self, *args)

    def end_page(self, *args):
        r"""end_page(Fl_Paged_Device self) -> int"""
        return _fltk.Fl_Paged_Device_end_page(self, *args)

    def end_job(self, *args):
        r"""end_job(Fl_Paged_Device self)"""
        return _fltk.Fl_Paged_Device_end_job(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Paged_Device(self)
        return weakref.proxy(self)

    def end_current(self, *args):
        r"""end_current(Fl_Paged_Device self)"""
        return _fltk.Fl_Paged_Device_end_current(self, *args)

# Register Fl_Paged_Device in _fltk:
_fltk.Fl_Paged_Device_swigregister(Fl_Paged_Device)
class Fl_PDF_File_Surface(Fl_Paged_Device):
    r"""

    Declaration of classes Fl_PDF_File_Surface.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_PDF_File_Surface self) -> Fl_PDF_File_Surface"""
        if self.__class__ == Fl_PDF_File_Surface:
            _self = None
        else:
            _self = self
        _fltk.Fl_PDF_File_Surface_swiginit(self, _fltk.new_Fl_PDF_File_Surface(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_PDF_File_Surface

    def begin_job(self, *args):
        r"""
        begin_job(Fl_PDF_File_Surface self, char const * defaultfilename, char ** perr=None) -> int
        begin_job(Fl_PDF_File_Surface self, int arg0, int * arg1, int * arg2, char ** arg3) -> int
        """
        return _fltk.Fl_PDF_File_Surface_begin_job(self, *args)

    def begin_document(self, *args):
        r"""begin_document(Fl_PDF_File_Surface self, char const * pathname, enum Fl_Paged_Device::Page_Format format=A4, enum Fl_Paged_Device::Page_Layout layout=PORTRAIT, char ** perr=None) -> int"""
        return _fltk.Fl_PDF_File_Surface_begin_document(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_PDF_File_Surface self) -> int"""
        return _fltk.Fl_PDF_File_Surface_printable_rect(self, *args)

    def margins(self, *args):
        r"""margins(Fl_PDF_File_Surface self)"""
        return _fltk.Fl_PDF_File_Surface_margins(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_PDF_File_Surface self, int x, int y)
        origin(Fl_PDF_File_Surface self)
        """
        return _fltk.Fl_PDF_File_Surface_origin(self, *args)

    def scale(self, *args):
        r"""scale(Fl_PDF_File_Surface self, float s_x, float s_y=0)"""
        return _fltk.Fl_PDF_File_Surface_scale(self, *args)

    def rotate(self, *args):
        r"""rotate(Fl_PDF_File_Surface self, float angle)"""
        return _fltk.Fl_PDF_File_Surface_rotate(self, *args)

    def translate(self, *args):
        r"""translate(Fl_PDF_File_Surface self, int x, int y)"""
        return _fltk.Fl_PDF_File_Surface_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_PDF_File_Surface self)"""
        return _fltk.Fl_PDF_File_Surface_untranslate(self, *args)

    def begin_page(self, *args):
        r"""begin_page(Fl_PDF_File_Surface self) -> int"""
        return _fltk.Fl_PDF_File_Surface_begin_page(self, *args)

    def end_page(self, *args):
        r"""end_page(Fl_PDF_File_Surface self) -> int"""
        return _fltk.Fl_PDF_File_Surface_end_page(self, *args)

    def end_job(self, *args):
        r"""end_job(Fl_PDF_File_Surface self)"""
        return _fltk.Fl_PDF_File_Surface_end_job(self, *args)

    def pdf_filename(self, *args):
        r"""pdf_filename(Fl_PDF_File_Surface self) -> char const *"""
        return _fltk.Fl_PDF_File_Surface_pdf_filename(self, *args)

    def set_current(self, *args):
        r"""set_current(Fl_PDF_File_Surface self)"""
        return _fltk.Fl_PDF_File_Surface_set_current(self, *args)

    def is_current(self, *args):
        r"""is_current(Fl_PDF_File_Surface self) -> bool"""
        return _fltk.Fl_PDF_File_Surface_is_current(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PDF_File_Surface(self)
        return weakref.proxy(self)

    def end_current(self, *args):
        r"""end_current(Fl_PDF_File_Surface self)"""
        return _fltk.Fl_PDF_File_Surface_end_current(self, *args)

# Register Fl_PDF_File_Surface in _fltk:
_fltk.Fl_PDF_File_Surface_swigregister(Fl_PDF_File_Surface)
class Fl_PostScript_File_Device(Fl_Paged_Device):
    r"""Proxy of C++ Fl_PostScript_File_Device class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_PostScript_File_Device self) -> Fl_PostScript_File_Device"""
        if self.__class__ == Fl_PostScript_File_Device:
            _self = None
        else:
            _self = self
        _fltk.Fl_PostScript_File_Device_swiginit(self, _fltk.new_Fl_PostScript_File_Device(_self, *args))
    __swig_destroy__ = _fltk.delete_Fl_PostScript_File_Device

    def begin_job(self, *args):
        r"""
        begin_job(Fl_PostScript_File_Device self, int pagecount, int * _from, int * to, char ** perr_message) -> int
        begin_job(Fl_PostScript_File_Device self, int pagecount=0, enum Fl_Paged_Device::Page_Format format=A4, enum Fl_Paged_Device::Page_Layout layout=PORTRAIT) -> int
        begin_job(Fl_PostScript_File_Device self, FILE * ps_output, int pagecount=0, enum Fl_Paged_Device::Page_Format format=A4, enum Fl_Paged_Device::Page_Layout layout=PORTRAIT) -> int
        """
        return _fltk.Fl_PostScript_File_Device_begin_job(self, *args)

    def start_job(self, *args):
        r"""
        start_job(Fl_PostScript_File_Device self, int pagecount=0, enum Fl_Paged_Device::Page_Format format=A4, enum Fl_Paged_Device::Page_Layout layout=PORTRAIT) -> int
        start_job(Fl_PostScript_File_Device self, FILE * ps_output, int pagecount=0, enum Fl_Paged_Device::Page_Format format=A4, enum Fl_Paged_Device::Page_Layout layout=PORTRAIT) -> int
        """
        return _fltk.Fl_PostScript_File_Device_start_job(self, *args)

    def begin_page(self, *args):
        r"""begin_page(Fl_PostScript_File_Device self) -> int"""
        return _fltk.Fl_PostScript_File_Device_begin_page(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_PostScript_File_Device self) -> int"""
        return _fltk.Fl_PostScript_File_Device_printable_rect(self, *args)

    def margins(self, *args):
        r"""margins(Fl_PostScript_File_Device self)"""
        return _fltk.Fl_PostScript_File_Device_margins(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_PostScript_File_Device self)
        origin(Fl_PostScript_File_Device self, int x, int y)
        """
        return _fltk.Fl_PostScript_File_Device_origin(self, *args)

    def scale(self, *args):
        r"""scale(Fl_PostScript_File_Device self, float scale_x, float scale_y=0.)"""
        return _fltk.Fl_PostScript_File_Device_scale(self, *args)

    def rotate(self, *args):
        r"""rotate(Fl_PostScript_File_Device self, float angle)"""
        return _fltk.Fl_PostScript_File_Device_rotate(self, *args)

    def translate(self, *args):
        r"""translate(Fl_PostScript_File_Device self, int x, int y)"""
        return _fltk.Fl_PostScript_File_Device_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_PostScript_File_Device self)"""
        return _fltk.Fl_PostScript_File_Device_untranslate(self, *args)

    def end_page(self, *args):
        r"""end_page(Fl_PostScript_File_Device self) -> int"""
        return _fltk.Fl_PostScript_File_Device_end_page(self, *args)

    def end_job(self, *args):
        r"""end_job(Fl_PostScript_File_Device self)"""
        return _fltk.Fl_PostScript_File_Device_end_job(self, *args)

    def file(self, *args):
        r"""file(Fl_PostScript_File_Device self) -> FILE *"""
        return _fltk.Fl_PostScript_File_Device_file(self, *args)

    def close_command(self, *args):
        r"""close_command(Fl_PostScript_File_Device self, Fl_PostScript_Close_Command cmd)"""
        return _fltk.Fl_PostScript_File_Device_close_command(self, *args)

    def set_current(self, *args):
        r"""set_current(Fl_PostScript_File_Device self)"""
        return _fltk.Fl_PostScript_File_Device_set_current(self, *args)

    def end_current(self, *args):
        r"""end_current(Fl_PostScript_File_Device self)"""
        return _fltk.Fl_PostScript_File_Device_end_current(self, *args)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PostScript_File_Device(self)
        return weakref.proxy(self)

# Register Fl_PostScript_File_Device in _fltk:
_fltk.Fl_PostScript_File_Device_swigregister(Fl_PostScript_File_Device)
class Fl_EPS_File_Surface(Fl_Widget_Surface):
    r"""Proxy of C++ Fl_EPS_File_Surface class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_EPS_File_Surface self, int width, int height, FILE * eps_output, Fl_Color background=, Fl_PostScript_Close_Command closef=None) -> Fl_EPS_File_Surface"""
        _fltk.Fl_EPS_File_Surface_swiginit(self, _fltk.new_Fl_EPS_File_Surface(*args))
    __swig_destroy__ = _fltk.delete_Fl_EPS_File_Surface

    def printable_rect(self, *args):
        r"""printable_rect(Fl_EPS_File_Surface self) -> int"""
        return _fltk.Fl_EPS_File_Surface_printable_rect(self, *args)

    def file(self, *args):
        r"""file(Fl_EPS_File_Surface self) -> FILE *"""
        return _fltk.Fl_EPS_File_Surface_file(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_EPS_File_Surface self, int x, int y)
        origin(Fl_EPS_File_Surface self, int * px, int * py)
        """
        return _fltk.Fl_EPS_File_Surface_origin(self, *args)

    def translate(self, *args):
        r"""translate(Fl_EPS_File_Surface self, int x, int y)"""
        return _fltk.Fl_EPS_File_Surface_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_EPS_File_Surface self)"""
        return _fltk.Fl_EPS_File_Surface_untranslate(self, *args)

    def close(self, *args):
        r"""close(Fl_EPS_File_Surface self) -> int"""
        return _fltk.Fl_EPS_File_Surface_close(self, *args)

# Register Fl_EPS_File_Surface in _fltk:
_fltk.Fl_EPS_File_Surface_swigregister(Fl_EPS_File_Surface)
class Fl_Printer(Fl_Paged_Device):
    r"""

    Declaration of classes Fl_Printer, Fl_System_Printer and Fl_PostScript_Printer.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Fl_Printer self) -> Fl_Printer"""
        if self.__class__ == Fl_Printer:
            _self = None
        else:
            _self = self
        _fltk.Fl_Printer_swiginit(self, _fltk.new_Fl_Printer(_self, *args))

    def begin_job(self, *args):
        r"""begin_job(Fl_Printer self, int pagecount=0, int * frompage=None, int * topage=None, char ** perr_message=None) -> int"""
        return _fltk.Fl_Printer_begin_job(self, *args)

    def begin_page(self, *args):
        r"""begin_page(Fl_Printer self) -> int"""
        return _fltk.Fl_Printer_begin_page(self, *args)

    def printable_rect(self, *args):
        r"""printable_rect(Fl_Printer self) -> int"""
        return _fltk.Fl_Printer_printable_rect(self, *args)

    def margins(self, *args):
        r"""margins(Fl_Printer self)"""
        return _fltk.Fl_Printer_margins(self, *args)

    def origin(self, *args):
        r"""
        origin(Fl_Printer self)
        origin(Fl_Printer self, int x, int y)
        """
        return _fltk.Fl_Printer_origin(self, *args)

    def scale(self, *args):
        r"""scale(Fl_Printer self, float scale_x, float scale_y=0.)"""
        return _fltk.Fl_Printer_scale(self, *args)

    def rotate(self, *args):
        r"""rotate(Fl_Printer self, float angle)"""
        return _fltk.Fl_Printer_rotate(self, *args)

    def translate(self, *args):
        r"""translate(Fl_Printer self, int x, int y)"""
        return _fltk.Fl_Printer_translate(self, *args)

    def untranslate(self, *args):
        r"""untranslate(Fl_Printer self)"""
        return _fltk.Fl_Printer_untranslate(self, *args)

    def end_page(self, *args):
        r"""end_page(Fl_Printer self) -> int"""
        return _fltk.Fl_Printer_end_page(self, *args)

    def end_job(self, *args):
        r"""end_job(Fl_Printer self)"""
        return _fltk.Fl_Printer_end_job(self, *args)

    def set_current(self, *args):
        r"""set_current(Fl_Printer self)"""
        return _fltk.Fl_Printer_set_current(self, *args)

    def is_current(self, *args):
        r"""is_current(Fl_Printer self) -> bool"""
        return _fltk.Fl_Printer_is_current(self, *args)
    __swig_destroy__ = _fltk.delete_Fl_Printer
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Printer(self)
        return weakref.proxy(self)

    def end_current(self, *args):
        r"""end_current(Fl_Printer self)"""
        return _fltk.Fl_Printer_end_current(self, *args)

# Register Fl_Printer in _fltk:
_fltk.Fl_Printer_swigregister(Fl_Printer)

def fl_utf8bytes(*args):
    r"""fl_utf8bytes(unsigned int ucs) -> int"""
    return _fltk.fl_utf8bytes(*args)

def fl_utf8len(*args):
    r"""fl_utf8len(char c) -> int"""
    return _fltk.fl_utf8len(*args)

def fl_utf_nb_char(*args):
    r"""fl_utf_nb_char(unsigned char const * buf, int len) -> int"""
    return _fltk.fl_utf_nb_char(*args)

def fl_utf8decode(*args):
    r"""fl_utf8decode(char const * p, char const * end, int * len) -> unsigned int"""
    return _fltk.fl_utf8decode(*args)

def fl_utf8encode(*args):
    r"""fl_utf8encode(unsigned int ucs) -> int"""
    return _fltk.fl_utf8encode(*args)

def fl_utf8fwd(*args):
    r"""fl_utf8fwd(char const * p, char const * start, char const * end) -> char const *"""
    return _fltk.fl_utf8fwd(*args)

def fl_utf8back(*args):
    r"""fl_utf8back(char const * p, char const * start, char const * end) -> char const *"""
    return _fltk.fl_utf8back(*args)

def fl_utf8toUtf16(*args):
    r"""fl_utf8toUtf16(char const * src, unsigned int srclen, unsigned int dstlen) -> unsigned int"""
    return _fltk.fl_utf8toUtf16(*args)

def fl_utf8toa(*args):
    r"""fl_utf8toa(char const * src, unsigned int srclen, unsigned int arg3) -> unsigned int"""
    return _fltk.fl_utf8toa(*args)

def fl_utf8froma(*args):
    r"""fl_utf8froma(char * dst, unsigned int dstlen, char const * src, unsigned int srclen) -> unsigned int"""
    return _fltk.fl_utf8froma(*args)

def fl_utf8locale(*args):
    r"""fl_utf8locale() -> int"""
    return _fltk.fl_utf8locale(*args)

def fl_utf8test(*args):
    r"""fl_utf8test(char const * src, unsigned int len) -> int"""
    return _fltk.fl_utf8test(*args)

def fl_nonspacing(*args):
    r"""fl_nonspacing(unsigned int ucs) -> unsigned int"""
    return _fltk.fl_nonspacing(*args)

def fl_utf8to_mb(*args):
    r"""fl_utf8to_mb(char const * src, unsigned int srclen, char * dst, unsigned int dstlen) -> unsigned int"""
    return _fltk.fl_utf8to_mb(*args)

def fl_utf2mbcs(*args):
    r"""fl_utf2mbcs(char const * src) -> char *"""
    return _fltk.fl_utf2mbcs(*args)

def fl_utf8from_mb(*args):
    r"""fl_utf8from_mb(char * dst, unsigned int dstlen, char const * src, unsigned int srclen) -> unsigned int"""
    return _fltk.fl_utf8from_mb(*args)

def fl_utf8_to_locale(*args):
    r"""fl_utf8_to_locale(char const * s, int len, unsigned int codepage) -> char *"""
    return _fltk.fl_utf8_to_locale(*args)

def fl_locale_to_utf8(*args):
    r"""fl_locale_to_utf8(char const * s, int len, unsigned int codepage) -> char *"""
    return _fltk.fl_locale_to_utf8(*args)

def fl_utf_strncasecmp(*args):
    r"""fl_utf_strncasecmp(char const * s1, char const * s2, int n) -> int"""
    return _fltk.fl_utf_strncasecmp(*args)

def fl_utf_strcasecmp(*args):
    r"""fl_utf_strcasecmp(char const * s1, char const * s2) -> int"""
    return _fltk.fl_utf_strcasecmp(*args)

def fl_tolower(*args):
    r"""fl_tolower(unsigned int ucs) -> int"""
    return _fltk.fl_tolower(*args)

def fl_toupper(*args):
    r"""fl_toupper(unsigned int ucs) -> int"""
    return _fltk.fl_toupper(*args)

def fl_utf_tolower(*args):
    r"""fl_utf_tolower(unsigned char const * str, int len) -> int"""
    return _fltk.fl_utf_tolower(*args)

def fl_utf_toupper(*args):
    r"""fl_utf_toupper(unsigned char const * str, int len, char * buf) -> int"""
    return _fltk.fl_utf_toupper(*args)

def fl_chmod(*args):
    r"""fl_chmod(char const * f, int mode) -> int"""
    return _fltk.fl_chmod(*args)

def fl_access(*args):
    r"""fl_access(char const * f, int mode) -> int"""
    return _fltk.fl_access(*args)

def fl_getcwd(*args):
    r"""fl_getcwd(char * buf, int maxlen) -> char *"""
    return _fltk.fl_getcwd(*args)

def fl_fopen(*args):
    r"""fl_fopen(char const * f, char const * mode) -> FILE *"""
    return _fltk.fl_fopen(*args)

def fl_system(*args):
    r"""fl_system(char const * f) -> int"""
    return _fltk.fl_system(*args)

def fl_execvp(*args):
    r"""fl_execvp(char const * file, char *const * argv) -> int"""
    return _fltk.fl_execvp(*args)

def fl_open(*args):
    r"""fl_open(char const * f, int o) -> int"""
    return _fltk.fl_open(*args)

def fl_unlink(*args):
    r"""fl_unlink(char const * f) -> int"""
    return _fltk.fl_unlink(*args)

def fl_rmdir(*args):
    r"""fl_rmdir(char const * f) -> int"""
    return _fltk.fl_rmdir(*args)

def fl_getenv(*args):
    r"""fl_getenv(char const * name) -> char *"""
    return _fltk.fl_getenv(*args)

def fl_mkdir(*args):
    r"""fl_mkdir(char const * f, int mode) -> int"""
    return _fltk.fl_mkdir(*args)

def fl_rename(*args):
    r"""fl_rename(char const * f, char const * t) -> int"""
    return _fltk.fl_rename(*args)

def fl_make_path_for_file(*args):
    r"""fl_make_path_for_file(char const * path)"""
    return _fltk.fl_make_path_for_file(*args)

def fl_make_path(*args):
    r"""fl_make_path(char const * path) -> char"""
    return _fltk.fl_make_path(*args)

def upCB(*args):
    r"""upCB(Fl_Widget v, void * arg2)"""
    return _fltk.upCB(*args)

def downCB(*args):
    r"""downCB(Fl_Widget v, void * arg2)"""
    return _fltk.downCB(*args)

def toggleCB(*args):
    r"""toggleCB(Fl_Widget v, void * arg2)"""
    return _fltk.toggleCB(*args)
class ListSelect(Fl_Group):
    r"""Proxy of C++ ListSelect class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ListSelect self, int x, int y, int w, int h, char * topLabel=None, char * bottomLabel=None) -> ListSelect"""
        if self.__class__ == ListSelect:
            _self = None
        else:
            _self = self
        _fltk.ListSelect_swiginit(self, _fltk.new_ListSelect(_self, *args))

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        self.init_type("ListSelect")
        #print("Adding type: ", ListSelect)




    def getTopBrowser(self, *args):
        r"""getTopBrowser(ListSelect self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getTopBrowser(self, *args)

    def getBottomBrowser(self, *args):
        r"""getBottomBrowser(ListSelect self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getBottomBrowser(self, *args)

    def resize(self, *args):
        r"""resize(ListSelect self, int x, int y, int w, int h)"""
        return _fltk.ListSelect_resize(self, *args)

    def init_type(self, *args):
        r"""init_type(ListSelect self, char * ListSelect)"""
        return _fltk.ListSelect_init_type(self, *args)
    __swig_destroy__ = _fltk.delete_ListSelect
    def __disown__(self):
        self.this.disown()
        _fltk.disown_ListSelect(self)
        return weakref.proxy(self)

    def draw(self, *args):
        r"""draw(ListSelect self)"""
        return _fltk.ListSelect_draw(self, *args)

# Register ListSelect in _fltk:
_fltk.ListSelect_swigregister(ListSelect)

def glLoadIdentity(*args):
    r"""glLoadIdentity()"""
    return _fltk.glLoadIdentity(*args)

def glViewport(*args):
    r"""glViewport(int x, int y, int width, int height)"""
    return _fltk.glViewport(*args)

def glClear(*args):
    r"""glClear(int mask)"""
    return _fltk.glClear(*args)

def glColor3f(*args):
    r"""glColor3f(float red, float green, float blue)"""
    return _fltk.glColor3f(*args)

def glBegin(*args):
    r"""glBegin(int mode)"""
    return _fltk.glBegin(*args)

def glEnd(*args):
    r"""glEnd()"""
    return _fltk.glEnd(*args)

def glVertex3f(*args):
    r"""glVertex3f(float x, float y, float z)"""
    return _fltk.glVertex3f(*args)
M_PI = _fltk.M_PI

M_PI_2 = _fltk.M_PI_2

M_PI_4 = _fltk.M_PI_4

M_1_PI = _fltk.M_1_PI

M_2_PI = _fltk.M_2_PI

M_SQRT2 = _fltk.M_SQRT2

M_SQRT1_2 = _fltk.M_SQRT1_2


__idleCallbacks = []
def Fl_add_idle( func, data=None):
    __idleCallbacks.append( (func, data) )
    if len(__idleCallbacks) == 1:
        pyFLTK_controlIdleCallbacks(1)

def Fl_remove_idle( func, data=None):
    for cb in __idleCallbacks:
        if cb == ( func, data ):
            __idleCallbacks.remove(cb)
            break

def pyFLTK_doIdleCallbacks():
    for cb in __idleCallbacks:
        cb[0](cb[1])

pyFLTK_registerDoIdle(pyFLTK_doIdleCallbacks)


_fltk.add_idle = staticmethod(Fl_add_idle)
_fltk.remove_idle = staticmethod(Fl_remove_idle)




# override the implementation of Fl_Widget.callback
# new version to be used with directors
def __Fl_WidgetCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Widget_callback,new_args)
        return _fltk.Fl_Widget_callback(*new_args)

Fl_Widget.callback = __Fl_WidgetCallback
# end of the Fl_Widget.callback wrapper


# override the implementation of Fl_Text_Buffer.add_modify_callback
def __Fl_Text_BufferAddModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0])
        else:
            new_args = (self, args[0], args[1])
#return apply(_fltk.Fl_Text_Buffer_add_modify_callback,new_args)
        return _fltk.Fl_Text_Buffer_add_modify_callback(*new_args)

Fl_Text_Buffer.add_modify_callback = __Fl_Text_BufferAddModifyCallback
# end of the Fl_Text_Buffer.add_modify_callback wrapper


# override the implementation of Fl_Text_Buffer.remove_modify_callback
def __Fl_Text_BufferRemoveModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Text_Buffer_remove_modify_callback,new_args)
        return _fltk.Fl_Text_Buffer_remove_modify_callback(*new_args)

Fl_Text_Buffer.remove_modify_callback = __Fl_Text_BufferRemoveModifyCallback
# end of the Fl_Text_Buffer.remove_modify_callback wrapper


# override the implementation of Fl_File_Chooser.callback
def __Fl_File_ChooserCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_File_Chooser_callback,new_args)
        return _fltk.Fl_File_Chooser_callback(*new_args)

Fl_File_Chooser.callback = __Fl_File_ChooserCallback
# end of the Fl_File_Chooser.callback wrapper


# override the implementation of Fl_Help_View.link
def __Fl_Help_ViewLink(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Help_View_link,new_args)
        return _fltk.Fl_Help_View_link(*new_args)

Fl_Help_View.link = __Fl_Help_ViewLink
# end of the Fl_Help_View.link wrapper


_fltk.add_timeout = staticmethod(Fl_add_timeout)
_fltk.repeat_timeout = staticmethod(Fl_repeat_timeout)
_fltk.remove_timeout = staticmethod(Fl_remove_timeout)
_fltk.add_check = staticmethod(Fl_add_check)
_fltk.remove_check = staticmethod(Fl_remove_check)
_fltk.add_handler = staticmethod(Fl_add_handler)
_fltk.remove_handler = staticmethod(Fl_remove_handler)
_fltk.add_fd = staticmethod(Fl_add_fd)
_fltk.remove_fd = staticmethod(Fl_remove_fd)
_fltk.get_font_sizes = staticmethod(Fl_get_font_sizes_tmp)


setMenu = _fltk.setMenu

