"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class TMenuRegister {
    constructor() {
        this.aFloatMenus = [];
    }
    add(el) {
        this.aFloatMenus.push(el);
        oDDNO.add(el);
    }
    IsSomeMenu() {
        return this.aFloatMenus.length > 0;
    }
    GetPrevMenu(el) {
        if (this.aFloatMenus.length == 0)
            return null;
        if (!el) {
            return this.aFloatMenus[this.aFloatMenus.length - 1];
        }
        const nInd = this.aFloatMenus.findIndex(it => it == el);
        if (nInd && this.aFloatMenus.length > nInd) {
            return this.aFloatMenus[nInd - 1];
        }
        return null;
    }
    DeleteMenu(el) {
        if (this.aFloatMenus.length == 0)
            return;
        if (!el) {
            this.aFloatMenus.splice(this.aFloatMenus.length - 1);
            return;
        }
        const nInd = this.aFloatMenus.findIndex(it => it == el);
        if (nInd >= 0) {
            this.aFloatMenus.splice(nInd, 1);
        }
    }
    Erase() {
        this.aFloatMenus.splice(0);
    }
}
const oMenuRegister = new TMenuRegister;
function SetJobOptionMenu(oMenuPart, sMenuItemForAutoOpening) {
    if (!oMenuPart) {
        return;
    }
    if (jsCurrJobOptions.Filter) {
        if (jsCurrJobOptions.Filter.Included && jsCurrJobOptions.Filter.Included.length === 0) {
            jsCurrJobOptions.Filter.Included.push("undefined");
        }
        if (jsCurrJobOptions.Filter.Excluded && jsCurrJobOptions.Filter.Excluded.length === 0) {
            jsCurrJobOptions.Filter.Excluded.push("undefined");
        }
    }
    CreateFloatMenu(oMenuPart, { width: "680px", height: 640 }, jsCurrJobOptions, { "sMenuItemForAutoOpening": sMenuItemForAutoOpening, minWidth: "40rem", minHeight: "30rem", bCurrJobName: true }).promise
        .then(data => {
        if (data.command == "upload") {
            if (jsCurrJobOptions.Filter) {
                if (jsCurrJobOptions.Filter.Included) {
                    for (let i = jsCurrJobOptions.Filter.Included.length - 1; i >= 0; i--) {
                        const sFilt = ("" + jsCurrJobOptions.Filter.Included[i]).trim();
                        if (!sFilt || sFilt == 'undefined') {
                            jsCurrJobOptions.Filter.Included.splice(i, 1);
                        }
                        for (let j = 0; j < i; j++) {
                            const sFilt2 = ("" + jsCurrJobOptions.Filter.Included[j]).trim();
                            if (sFilt == sFilt2) {
                                jsCurrJobOptions.Filter.Included.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
                if (jsCurrJobOptions.Filter.Excluded) {
                    for (let i = jsCurrJobOptions.Filter.Excluded.length - 1; i >= 0; i--) {
                        const sFilt = ("" + jsCurrJobOptions.Filter.Excluded[i]).trim();
                        if (!sFilt || sFilt == 'undefined') {
                            jsCurrJobOptions.Filter.Excluded.splice(i, 1);
                        }
                        for (let j = 0; j < i; j++) {
                            const sFilt2 = ("" + jsCurrJobOptions.Filter.Excluded[j]).trim();
                            if (sFilt == sFilt2) {
                                jsCurrJobOptions.Filter.Excluded.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
            }
            SetJobOptions(jsCurrJobOptions);
        }
    }).catch(() => { });
}
function Fast1WayNoStateConfirm(sQ, bChecked) {
    const sQuestion = GetLocaleText(sQ);
    return new Promise(function (resolve, reject) {
        if (!bChecked) {
            resolve(null);
        }
        else {
            HtmlConfirm(sQuestion, "GoodSync", eMyConfDefBtn.ok, { icon: "warning" }).then(() => resolve(null)).catch(() => reject());
        }
    });
}
function CreateFloatMenu(jsMenuPart, oCoords, jsFloatMenuDescr, oParamsConst = {}) {
    if (!jsMenuPart || !oCoords.width || !oCoords.top && !oCoords.height) {
        return { oMenu: null, promise: new Promise(function (resolve, reject) { reject(); }) };
    }
    if (oParamsConst.id) {
        const oIsMenu = document.getElementById(oParamsConst.id);
        if (oIsMenu) {
            return { oMenu: oIsMenu, promise: oIsMenu.promise };
        }
    }
    let aZindsLen = aZInd.length - 1;
    if (aZindsLen > 99) {
        return { oMenu: null, promise: new Promise(function (resolve, reject) { reject(); }) };
    }
    let zInd = 100001;
    if (oParamsConst.bAboveAll) {
        zInd = 1000001;
    }
    else if (aZindsLen >= 0) {
        zInd = aZInd[aZindsLen] + 3;
    }
    jsMenuPart["pPrevSubMenu"] = null;
    if (!oParamsConst.bNoModal) {
        domModal.style.display = "";
        domModal.style.zIndex = (zInd - 1) + "";
        aZInd.push(zInd - 1);
    }
    let menu = document.createElement('div');
    oMenuRegister.add(menu);
    if (oParamsConst.bNoborder) {
        menu.className = "float_menu float_menu_no_border flex_vert";
    }
    else {
        menu.className = "float_menu float_menu_with_border flex_vert";
    }
    if (!oParamsConst.bNoResize) {
        menu.className += " stretch_x stretch_y";
    }
    if (oParamsConst.id) {
        menu.id = oParamsConst.id;
    }
    else {
        menu.id = "FloatMenu" + zInd;
    }
    menu.style.zIndex = zInd + "";
    menu.style.width = oCoords.width;
    if (oCoords.top) {
        menu.style.top = oCoords.top;
    }
    else if (oCoords.height) {
        if (oCoords.height > 0) {
            if (oCoords.height <= document.documentElement.clientHeight) {
                menu.style.top = (document.documentElement.clientHeight - oCoords.height) / 2 + "px";
            }
            else {
                menu.style.top = "0";
                oCoords.height = document.documentElement.clientHeight - 2;
            }
        }
        else {
            if (oCoords.height > -100) {
                menu.style.top = (100 + oCoords.height) / 2 + "%";
            }
            else {
                menu.style.top = "0";
                oCoords.height = -100;
            }
        }
    }
    if (oCoords.left) {
        menu.style.left = oCoords.left;
    }
    else {
        const oSize = ParseSizeAndUnits(menu.style.width);
        if (oSize) {
            const nWindowWidth = GetBrowserWidthInUnits(oSize.unit);
            if (nWindowWidth) {
                if (oSize.value >= nWindowWidth) {
                    menu.style.left = "0";
                }
                else {
                    menu.style.left = (nWindowWidth - oSize.value) / 2 + oSize.unit;
                }
            }
        }
        if (!menu.style.left) {
            menu.style.left = "1px";
        }
    }
    if (oCoords.height) {
        if (oCoords.height < -1)
            menu.style.height = (0 - oCoords.height) + "%";
        else if (oCoords.height > 10)
            menu.style.height = oCoords.height + "px";
    }
    if (oParamsConst.fontSize) {
        menu.style.fontSize = oParamsConst.fontSize;
    }
    if (oParamsConst.lineHeight) {
        menu.style.lineHeight = oParamsConst.lineHeight;
    }
    if (oParamsConst.bg) {
        menu.style.background = oParamsConst.bg;
    }
    if (oParamsConst.minWidth) {
        menu.style.minWidth = oParamsConst.minWidth;
    }
    if (oParamsConst.minHeight) {
        menu.style.minHeight = oParamsConst.minHeight;
    }
    menu["modal"] = !oParamsConst.bNoModal;
    menu["jsMenuPart"] = jsMenuPart;
    menu["jsFloatMenuDescr"] = jsFloatMenuDescr;
    menu["fUserResize"] = function () {
        const aWasResizeEl = document.getElementsByClassName("float_menu_user_resize");
        for (let item of aWasResizeEl) {
            const oDomPlus = item;
            if (oDomPlus.fUserResize) {
                oDomPlus.fUserResize(menu.nResizeX, menu.nResizeY);
            }
        }
    };
    menu.classList.add("I_have_user_resise");
    menu["nResizeX"] = 0;
    menu["nResizeY"] = 0;
    menu["bNoCancel"] = oParamsConst.bNoCancel;
    if (oParamsConst.fOnChangeFM)
        menu["fOnChangeFM"] = oParamsConst.fOnChangeFM;
    document.body.append(menu);
    menu["mapSameLenghtEls"] = {};
    menu.aStretchEls = [];
    menu.blockSaveBtmMap = new Set;
    if (oParamsConst.xArgs)
        menu.xArgs = oParamsConst.xArgs;
    menu.promise = new Promise(function (resolve, reject) {
        const oEnterProc = { "aInpEl": [], resolve: resolve };
        menu.fUserKeyDown = function (e) {
            EnterProcessing(e, oEnterProc, menu);
        };
        menu.fCloseMenu = (bIsEsc = false) => {
            reject("Off from Esc");
            CloseFloatMenu(menu, bIsEsc);
        };
        let nExtraH = 0;
        if (!oParamsConst.bNoTitle) {
            let head = document.createElement('div');
            menu.append(head);
            head.className = "flex_gor_center float_menu_head";
            if (oParamsConst.icon) {
                const icon = SetImg(oParamsConst.icon, "var(--fltmn-icon-size)");
                if (icon) {
                    icon.classList.add("fltmn_icon");
                    head.append(icon);
                }
            }
            menu.domTitle = document.createElement('div');
            head.append(menu.domTitle);
            menu.domTitle.className = "float_menu_title nonselect";
            menu.domTitle.id = menu.id + "_title";
            if (sCurrJob != "" && oParamsConst.bCurrJobName) {
                menu.domTitle.innerHTML += ("<span class='float_menu_title_job_name'>" + sCurrJob + "</span>");
            }
            menu.domTitle.innerHTML += GetLocaleText(jsMenuPart.title);
            menu.domTitle.onmousedown = function (e) {
                e.stopPropagation();
                const rectMenu = menu.getBoundingClientRect();
                sgd.globY = e.clientY;
                sgd.globX = e.clientX;
                nFloatMenuX = rectMenu.x;
                nFloatMenuY = rectMenu.y;
                document.onmousemove = function (e) {
                    menu.style.left = (nFloatMenuX + e.clientX - sgd.globX) + "px";
                    menu.style.top = (nFloatMenuY + e.clientY - sgd.globY) + "px";
                };
                document.onmouseup = function () {
                    FloatMenuMoveEnd();
                    document.onmouseup = BaseMouseUp;
                };
            };
            menu.domTitle.onmouseup = function () {
                FloatMenuMoveEnd();
                document.onmouseup = BaseMouseUp;
            };
            if (!oParamsConst.bNoCancel) {
                let cancel = document.createElement('div');
                head.append(cancel);
                cancel.className = "cancel_button nonselect";
                cancel.innerHTML = "&#10005;";
                cancel.onclick = function () {
                    CloseFloatMenu(menu);
                    reject("Off of " + jsMenuPart.title);
                };
            }
            nExtraH = head.getBoundingClientRect().height;
        }
        let menuWindow = document.createElement('div');
        menuWindow.className = "fltmn_main_window";
        if (oParamsConst.class) {
            menuWindow.classList.add(oParamsConst.class);
        }
        menuWindow.style.maxHeight = "calc(100% - " + (nExtraH + 10) + "px)";
        menu.append(menuWindow);
        let help = null;
        if ("help_url" in jsMenuPart) {
            help = document.createElement("a");
            help.innerText = "Detailed Help";
            help.target = "_blank";
            help.className = "fltmn_help_link";
        }
        let rightWin;
        if (jsMenuPart.vert_win) {
            let leftWin = document.createElement('div');
            menuWindow.append(leftWin);
            leftWin.className = "white_panel float_menu_left_win width100";
            menu.domLeftWin = leftWin;
            rightWin = document.createElement('div');
            menuWindow.append(rightWin);
            rightWin.className = "float_menu_right_win1 flex_vert width100";
            let jsVertItems = jsMenuPart.cont;
            let vertItem = null;
            let domFirstVertItem = null;
            for (let i = 0; i < jsVertItems.length; i++) {
                vertItem = document.createElement('div');
                vertItem.className = "vert_float_menu nonselect";
                let helpURL = jsVertItems[i].help_url;
                let subMenu = jsVertItems[i].cont;
                vertItem.addEventListener('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    const nPosEl = this.getBoundingClientRect().top;
                    const nLeftWinTop = leftWin.getBoundingClientRect().top;
                    SelectPointBorderMove(nPosEl - 5 - nLeftWinTop, rightWin.prevEl);
                    if (jsMenuPart.pPrevSubMenu) {
                        _DeleteElFromSubMenu(jsMenuPart.pPrevSubMenu, jsFloatMenuDescr);
                    }
                    jsMenuPart.pPrevSubMenu = subMenu;
                    OpenSubMenu(menu, subMenu, rightWin, jsFloatMenuDescr, false, oEnterProc, oParamsConst.sSrcDataName);
                    if (help) {
                        if (helpURL) {
                            help.href = helpURL;
                            help.innerText = "Detailed Help";
                        }
                        else {
                            help.innerText = "";
                        }
                    }
                    for (const key of Object.keys(menu.mapSameLenghtEls)) {
                        let nMaxLen = 0;
                        for (const it of menu.mapSameLenghtEls[key]) {
                            if (nMaxLen < it.offsetWidth) {
                                nMaxLen = it.offsetWidth;
                            }
                        }
                        for (const it of menu.mapSameLenghtEls[key]) {
                            it.style.flex = "0 0 " + nMaxLen + "px";
                        }
                    }
                });
                if (jsVertItems[i].icon) {
                    let img = SetImg(jsVertItems[i].icon, "1rem");
                    if (img) {
                        img.classList.add('vert_menu_icon');
                        vertItem.append(img);
                    }
                }
                vertItem.append(GetLocaleText(jsVertItems[i].title));
                leftWin.append(vertItem);
                if ((!oParamsConst.sMenuItemForAutoOpening && i == 0) || (oParamsConst.sMenuItemForAutoOpening == jsVertItems[i].title)) {
                    domFirstVertItem = vertItem;
                    jsMenuPart.pPrevSubMenu = subMenu;
                    menu.nVertItem = i;
                    OpenSubMenu(menu, subMenu, rightWin, jsFloatMenuDescr, false, oEnterProc, oParamsConst.sSrcDataName);
                    if (help) {
                        if (helpURL) {
                            help.href = helpURL;
                            help.innerText = "Detailed Help";
                        }
                        else {
                            help.innerText = "";
                        }
                    }
                    for (const key of Object.keys(menu.mapSameLenghtEls)) {
                        let nMaxLen = 0;
                        menu.mapSameLenghtEls[key].map(it => { if (nMaxLen < it.offsetWidth)
                            nMaxLen = it.offsetWidth; });
                        menu.mapSameLenghtEls[key].map(it => { it.style.flex = "0 0 " + nMaxLen + "px"; });
                    }
                }
                else if (i == 0) {
                    domFirstVertItem = vertItem;
                    menu.nVertItem = 0;
                }
            }
            if (vertItem) {
                vertItem.style.marginBottom = "0px";
            }
            if (domFirstVertItem) {
                const rect = domFirstVertItem.getBoundingClientRect();
                const oLeftWinRect = leftWin.getBoundingClientRect();
                rightWin.prevEl = SelectPointBorder(leftWin, oLeftWinRect.width, rect.height + 10, rect.top - oLeftWinRect.top - 5, 3, "var(--dark-border-color)");
            }
        }
        else {
            rightWin = document.createElement('div');
            menuWindow.append(rightWin);
            rightWin.className = "float_menu_right_win2 flex_vert width100";
            if (oParamsConst.sRightWinClass) {
                rightWin.className += " " + oParamsConst.sRightWinClass;
            }
            OpenSubMenu(menu, jsMenuPart.cont[0].cont, rightWin, jsFloatMenuDescr, false, oEnterProc, oParamsConst.sSrcDataName);
            for (const key of Object.keys(menu.mapSameLenghtEls)) {
                let nMaxLen = 0;
                menu.mapSameLenghtEls[key].map(it => { if (nMaxLen < it.offsetWidth)
                    nMaxLen = it.offsetWidth; });
                menu.mapSameLenghtEls[key].map(it => { it.style.flex = "0 0 " + nMaxLen + "px"; });
            }
        }
        if ("bottom_box" in jsMenuPart && jsMenuPart.bottom_box.length > 0) {
            let bottomBox = document.createElement("div");
            bottomBox.className = "bottom_box flex_gor_center";
            const bottom_box_place = document.getElementById("bottom_box_" + menu.id);
            if (!bottom_box_place) {
                menu.append(bottomBox);
            }
            else {
                bottom_box_place.append(bottomBox);
            }
            let bWasSase = false;
            for (const item of jsMenuPart.bottom_box) {
                if (item.space) {
                    const space = document.createElement("div");
                    space.className = "flex_1_1";
                    bottomBox.append(space);
                    bWasSase = true;
                    continue;
                }
                let btn = document.createElement("button");
                btn.innerHTML = GetLocaleText(item.title);
                btn.className = "nonselect";
                if (oParamsConst.fontSize)
                    btn.style.fontSize = oParamsConst.fontSize;
                let sCommand = item.command;
                let bClose = item.close;
                btn.onclick = function () {
                    if (btn.disabled)
                        return;
                    if (sCommand) {
                        if (item.nofinal) {
                            eval(sCommand + "(menu)");
                        }
                        else if (!jsFloatMenuDescr) {
                            resolve({ "command": sCommand, "data": {}, "pMenu": menu });
                        }
                        else {
                            resolve({ "command": sCommand, "data": jsFloatMenuDescr, "pMenu": menu });
                        }
                    }
                    else if (item.nofinal) {
                        resolve({ "command": "", "data": {}, "pMenu": menu });
                    }
                    else {
                        reject(jsFloatMenuDescr);
                    }
                    if (bClose) {
                        CloseFloatMenu(menu);
                    }
                };
                bottomBox.append(btn);
                if (item.default) {
                    oEnterProc.comm = { "command": sCommand, "data": jsFloatMenuDescr, nofinal: item.nofinal };
                    btn.classList.add("flt_menu_btn_as_def");
                }
                else {
                    btn.classList.add("flt_menu_btn");
                }
                if (item.id) {
                    btn.id = item.id + "_" + menu.id;
                }
                if (item.disabled) {
                    btn.disabled = true;
                }
            }
            if (!bWasSase) {
                const space = document.createElement("div");
                space.className = "flex_1_1";
                bottomBox.prepend(space);
            }
            if (help) {
                bottomBox.prepend(help);
            }
            nExtraH += bottomBox.getBoundingClientRect().height;
        }
        else {
            menuWindow.style.paddingBottom = "0.5rem";
        }
        if (menu.pFirstField) {
            menu.pFirstField.focus();
        }
        menuWindow.style.maxHeight = "calc(100% - " + (nExtraH + 10) + "px)";
        if (menu.aStretchEls.length > 0) {
            const nNonStretchEls = menuWindow.getBoundingClientRect().height - menu.aStretchEls.length * 20;
            for (const item of menu.aStretchEls) {
                item.el.style.height = "calc(" + item.percent + "% - " + nNonStretchEls + "px)";
            }
        }
        if (menu.getBoundingClientRect().bottom > document.documentElement.clientHeight && !menu.style.height) {
            menu.style.height = "calc(90% - " + (nExtraH + 10) + "px)";
        }
        if (menu.fOnChangeFM) {
            menu.fOnChangeFM(null, menu);
        }
        SetStretchEl();
    });
    const oPrevMenu = oMenuRegister.GetPrevMenu(menu);
    if (oPrevMenu && oPrevMenu.innerText === menu.innerText) {
        CloseFloatMenu(oPrevMenu);
    }
    return { oMenu: menu, promise: menu.promise };
}
function OpenSubMenu(oMenu, subMenu, container, jsFloatMenuDescr, bNotMoveFildsToRight, oEnterProc, sSrcDataName) {
    container.innerHTML = "";
    if (wasStretchEl) {
        wasStretchEl = false;
        SetStretchEl();
    }
    for (let i = 0; i < subMenu.length; i++) {
        let row = document.createElement('div');
        container.append(row);
        CreateFloatMenuEl(oMenu, subMenu[i], row, jsFloatMenuDescr, bNotMoveFildsToRight, oEnterProc, sSrcDataName);
    }
}
function CreateFloatMenuEl(oMenu, jsParent, cell, jsFloatMenuDescr, bNotMoveFildsToRight, oEnterProc, sJsonFildName, oControlCheckBox) {
    let title = (jsParent.title) ? GetLocaleText(jsParent.title) : "";
    let sHint = GetHelpText(jsParent.title);
    if (jsParent.hint) {
        sHint = GetLocaleText(jsParent.hint);
    }
    if (sHint == title) {
        sHint = "";
    }
    let sValueName = jsParent.value;
    if (!(typeof sValueName === "string")) {
        sValueName = "";
    }
    else if (sValueName && sJsonFildName) {
        sValueName = sValueName.trim();
        let nDotPos = sValueName.indexOf(sJsonFildName + ".");
        if (nDotPos >= 0)
            sValueName = sValueName.slice(nDotPos + sJsonFildName.length + 1);
    }
    if (jsParent.lineHeight) {
        cell.style.lineHeight = jsParent.lineHeight;
    }
    switch (jsParent.type) {
        case "hidden_group":
            {
                if (!jsParent.cont) {
                    return oControlCheckBox;
                }
                cell.style.paddingTop = "5px";
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                let inCell = document.createElement('div');
                if (jsParent.class)
                    inCell.className = jsParent.class;
                else
                    inCell.className = "float_menu_hidden_group_body";
                inCell.style.display = "none";
                if (jsParent.h) {
                    inCell.style.maxHeight = jsParent.h + "px";
                    inCell.style.overflowY = "auto";
                }
                let domControlEl = document.createElement('div');
                if (jsParent.el_class)
                    domControlEl.className = jsParent.el_class;
                else
                    domControlEl.className = "fltmn_hidden_group_control";
                const chevron = SetImg("chevron-right", "var(--horizontal-img-btn-size)");
                if (chevron)
                    domControlEl.append(chevron);
                else
                    domControlEl.innerHTML = "&#128898;";
                domControlEl.innerHTML += " " + title;
                domControlEl.onclick = function () {
                    if (inCell.style.display == "none") {
                        inCell.style.display = "";
                        const chevronD = SetImg("chevron-down", "var(--horizontal-img-btn-size)");
                        if (chevronD) {
                            domControlEl.innerHTML = "";
                            domControlEl.append(chevronD);
                        }
                        else
                            domControlEl.innerHTML = "&#128899;";
                        domControlEl.innerHTML += " " + title;
                    }
                    else {
                        inCell.style.display = "none";
                        const chevronR = SetImg("chevron-right", "var(--horizontal-img-btn-size)");
                        if (chevronR) {
                            domControlEl.innerHTML = "";
                            domControlEl.append(chevronR);
                        }
                        else
                            domControlEl.innerHTML = "&#128898;";
                        domControlEl.innerHTML += " " + title;
                    }
                };
                cell.append(domControlEl);
                cell.append(inCell);
                OpenSubMenu(oMenu, jsParent.cont, inCell, jsFloatMenuDescr, bNotMoveFildsToRight, oEnterProc, sJsonFildName);
            }
            break;
        case "option_group":
            {
                if (!jsParent.cont) {
                    return oControlCheckBox;
                }
                cell.className = "float_menu_option_group";
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                let headCell = document.createElement('div');
                if (jsParent.el_class)
                    headCell.className = jsParent.el_class;
                else
                    headCell.className = "float_menu_option_group_title";
                headCell.innerHTML = "<span style='background: var(--main-bg-color); z-index:" + (aZInd[aZInd.length - 1] + 5) + "; white-space:pre;'>" +
                    ((title == "") ? "" : " " + title + " ") + "</span>";
                if (jsParent.noactive) {
                    headCell.style.color = "#888";
                }
                cell.append(headCell);
                let inCell = document.createElement('div');
                if (jsParent.class)
                    inCell.className = jsParent.class;
                else
                    inCell.className = "float_menu_option_group_body";
                cell.append(inCell);
                OpenSubMenu(oMenu, jsParent.cont, inCell, jsFloatMenuDescr, bNotMoveFildsToRight, oEnterProc, sJsonFildName);
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "column":
            {
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                if (!jsParent.cont && !jsParent.w) {
                    return oControlCheckBox;
                }
                cell.className = "flex_vert fltmn_col";
                if (jsParent.class) {
                    cell.className += " " + jsParent.class;
                }
                if (jsParent.w) {
                    if (typeof jsParent.w === 'number') {
                        jsParent.w = jsParent.w + "px";
                    }
                    if (jsParent.w.includes("%")) {
                        cell.style.flex = "1 1 " + jsParent.w;
                    }
                    else {
                        cell.style.flex = "0 0 " + jsParent.w;
                    }
                }
                else {
                    cell.style.flex = "1 1 100%";
                }
                if (!jsParent.cont) {
                    return oControlCheckBox;
                }
                for (const jsRow of jsParent.cont) {
                    let inCell = document.createElement("div");
                    cell.append(inCell);
                    oControlCheckBox = CreateFloatMenuEl(oMenu, jsRow, inCell, jsFloatMenuDescr, true, oEnterProc, sJsonFildName, oControlCheckBox);
                }
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "row":
            {
                SetElementHeight(jsParent, cell);
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                if (!jsParent.cont) {
                    return oControlCheckBox;
                }
                if (jsParent.class) {
                    cell.className = jsParent.class;
                }
                else {
                    cell.className = "flex_gor fltmn_row";
                    cell.style.alignItems = "center";
                }
                for (let jsCell of jsParent.cont) {
                    let inCell = document.createElement("div");
                    cell.append(inCell);
                    oControlCheckBox = CreateFloatMenuEl(oMenu, jsCell, inCell, jsFloatMenuDescr, true, oEnterProc, sJsonFildName, oControlCheckBox);
                }
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "checkbox":
            {
                cell.style.whiteSpace = "nowrap";
                const el = document.createElement("input");
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                else
                    el.className = "fltmn_checkbox";
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                el.type = 'checkbox';
                el.checked = eval("jsFloatMenuDescr." + sValueName);
                if (jsParent.confirm) {
                    el.addEventListener('change', function () {
                        const checked = el.checked;
                        const promise = eval(jsParent.confirm);
                        if (promise) {
                            promise.then(() => {
                                eval("jsFloatMenuDescr." + sValueName + " = el.checked");
                                if (oMenu.fOnChangeFM) {
                                    oMenu.fOnChangeFM(el, oMenu.id);
                                }
                                if (el.fChange) {
                                    el.fChange();
                                }
                            }).catch(() => {
                                el.checked = eval("jsFloatMenuDescr." + sValueName);
                            });
                        }
                    });
                }
                else {
                    el.addEventListener('change', function () {
                        eval("jsFloatMenuDescr." + sValueName + " = el.checked");
                        if (el.fChange) {
                            el.fChange();
                        }
                        if (oMenu.fOnChangeFM) {
                            oMenu.fOnChangeFM(el, oMenu.id);
                        }
                    });
                }
                if (!jsParent.noControl)
                    oControlCheckBox = el;
                jsParent.el = el;
                const label = document.createElement("label");
                if (jsParent.class) {
                    label.className = jsParent.class;
                }
                else {
                    label.className = "short_label";
                }
                label.append(el);
                label.append(title);
                cell.append(label);
                if (sHint) {
                    const domTmp = document.createElement("span");
                    label.style.display = "inline";
                    cell.append(domTmp);
                    addSuperscriptText(domTmp, sHint);
                }
                SetElementControl(oMenu, jsParent, cell, el);
                if (jsParent.controlledEls) {
                    SetElementManager(jsParent);
                }
            }
            break;
        case "droplist":
            {
                if (!jsFloatMenuDescr || !jsParent.list || !sValueName)
                    break;
                const el = document.createElement('select');
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                else
                    el.className = "fltmn_drop_list";
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                for (const listItem of jsParent.list) {
                    const item = document.createElement('option');
                    item.text = GetLocaleText(listItem);
                    el.add(item);
                }
                if (jsParent.str) {
                    let str = eval("jsFloatMenuDescr." + sValueName);
                    if (!str) {
                        el.selectedIndex = 0;
                    }
                    else {
                        el.selectedIndex = jsParent.list.findIndex(it => it == str);
                        if (el.selectedIndex < 0)
                            el.selectedIndex = 0;
                    }
                    el.addEventListener('change', function () {
                        eval("jsFloatMenuDescr." + sValueName + " = jsParent.list[el.selectedIndex]");
                        if (el.fChange) {
                            el.fChange();
                        }
                        if (oMenu.fOnChangeFM) {
                            oMenu.fOnChangeFM(el, oMenu.id);
                        }
                    });
                }
                else {
                    el.selectedIndex = eval("jsFloatMenuDescr." + sValueName);
                    if (!el.selectedIndex) {
                        el.selectedIndex = 0;
                    }
                    el.addEventListener('change', function () {
                        eval("jsFloatMenuDescr." + sValueName + " = el.selectedIndex");
                        if (el.fChange) {
                            el.fChange();
                        }
                        if (oMenu.fOnChangeFM) {
                            oMenu.fOnChangeFM(el, oMenu.id);
                        }
                    });
                }
                if (title) {
                    cell.style.display = "flex";
                    cell.style.alignItems = "center";
                    let sClass = 'fltmn_text';
                    if (jsParent.class) {
                        sClass += " " + jsParent.class;
                    }
                    const domTitle = document.createElement("div");
                    domTitle.className = sClass;
                    domTitle.innerHTML = title;
                    if (sHint) {
                        addSuperscriptText(domTitle, sHint);
                        const domTmp = document.createElement("div");
                        domTmp.className = "flex_1_1_100";
                        domTmp.append(domTitle);
                        cell.append(domTmp);
                    }
                    else {
                        domTitle.classList.add("flex_1_1_100");
                        cell.append(domTitle);
                    }
                }
                cell.append(el);
                jsParent["el"] = el;
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "radio":
            {
                if (!(jsParent.list && jsParent.list.length >= 0) && !(jsParent.listImg && jsParent.listImg.length >= 0))
                    break;
                for (let j = 0;;) {
                    let item = document.createElement('label');
                    item.className = "fltmn_radioLabel";
                    let el = document.createElement('input');
                    el.type = "radio";
                    el.name = sValueName;
                    el.value = j + "";
                    if (jsParent.id) {
                        el.id = jsParent.id + "_" + j;
                    }
                    if (jsParent.el_class)
                        el.className = jsParent.el_class;
                    else
                        el.className = "fltmn_radioEl";
                    if (j == eval("jsFloatMenuDescr." + sValueName))
                        el.checked = true;
                    el.addEventListener('change', function () {
                        eval("jsFloatMenuDescr." + sValueName + " = Number(this.value)");
                        if (el.fChange) {
                            el.fChange();
                        }
                        if (oMenu.fOnChangeFM) {
                            oMenu.fOnChangeFM(el, oMenu.id);
                        }
                    });
                    item.append(el);
                    if (jsParent.list) {
                        item.append(GetLocaleText(jsParent.list[j]));
                        if (jsParent.helps && jsParent.helps[j]) {
                            const sItemHelp = GetLocaleText(jsParent.helps[j]);
                            if (sItemHelp) {
                                const domTmp = document.createElement("div");
                                domTmp.style.width = "fit-content";
                                domTmp.append(item);
                                cell.append(domTmp);
                                cell.classList.add("el_with_help");
                                addSuperscriptText(domTmp, sItemHelp);
                            }
                            else {
                                cell.append(item);
                            }
                        }
                        else {
                            cell.append(item);
                        }
                        j++;
                        if (j >= jsParent.list.length)
                            break;
                    }
                    else {
                        const img = SetImg(jsParent.listImg[j].img, "var(--horizontal-img-btn-size)");
                        if (img) {
                            img.style.margin = "0 5px";
                            item.append(img);
                        }
                        item.append(GetLocaleText(jsParent.listImg[j].text));
                        cell.append(item);
                        j++;
                        if (j >= jsParent.listImg.length)
                            break;
                    }
                }
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "numberfield":
            {
                const el = document.createElement('input');
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                else
                    el.className = "fltmn_numberfield";
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                el.type = "number";
                if (jsParent.w) {
                    if (typeof jsParent.w === "string") {
                        el.style.width = jsParent.w;
                    }
                    else {
                        el.style.width = jsParent.w + "px";
                    }
                }
                let val = Number(eval("jsFloatMenuDescr." + sValueName));
                let bWasChange = false;
                if (typeof jsParent.min === "number" && typeof jsParent.max === "number" && jsParent.min > jsParent.max) {
                    const tmp = jsParent.min;
                    jsParent.min = jsParent.max;
                    jsParent.max = tmp;
                }
                if (typeof jsParent.min === "number") {
                    el.min = jsParent.min + "";
                    if (isNaN(val) || val < jsParent.min) {
                        bWasChange = true;
                        val = jsParent.min;
                    }
                }
                if (typeof jsParent.max === "number") {
                    el.max = jsParent.max + "";
                    if (!isNaN(val) && val > jsParent.max) {
                        bWasChange = true;
                        val = jsParent.max;
                    }
                }
                el.value = val + "";
                if (bWasChange && oMenu.fOnChangeFM) {
                    oMenu.fOnChangeFM(el, oMenu.id);
                }
                el.addEventListener('change', function () {
                    let val = Number(el.value);
                    if (el.min) {
                        if (isNaN(val) || val < Number(el.min)) {
                            el.value = el.min;
                            val = Number(el.min);
                        }
                    }
                    if (el.max) {
                        if (!isNaN(val) && val > Number(el.max)) {
                            el.value = el.max;
                            val = Number(el.max);
                        }
                    }
                    if (!isNaN(val)) {
                        eval("jsFloatMenuDescr." + sValueName + "= Number(this.value)");
                        if (oMenu.fOnChangeFM)
                            oMenu.fOnChangeFM(el, oMenu.id);
                    }
                    else {
                        el.value = "";
                    }
                });
                if (oControlCheckBox) {
                    if (!oControlCheckBox.checked) {
                        el.readOnly = true;
                        el.tabIndex = -1;
                    }
                    oControlCheckBox.addEventListener('change', function () {
                        el.readOnly = !(oControlCheckBox.checked);
                        el.tabIndex = (oControlCheckBox.checked) ? 0 : -1;
                    });
                }
                SetGetPutFunc(oMenu, jsParent, el, sValueName, jsFloatMenuDescr);
                if (title) {
                    cell.classList.add("fltmn_numberfield_cell");
                    let sClass = 'fltmn_text';
                    if (jsParent.class) {
                        sClass += " " + jsParent.class;
                    }
                    const domTitle = document.createElement("div");
                    domTitle.className = sClass;
                    domTitle.innerHTML = title;
                    if (sHint) {
                        addSuperscriptText(domTitle, sHint);
                        const domTmp = document.createElement("div");
                        domTmp.className = "flex_1_1_100";
                        domTmp.append(domTitle);
                        cell.append(domTmp);
                    }
                    else {
                        domTitle.classList.add("flex_1_1_100");
                        cell.append(domTitle);
                    }
                }
                cell.append(el);
                if (!jsParent.optional) {
                    oEnterProc.aInpEl.push(el);
                }
                if (!oMenu.pFirstField) {
                    oMenu.pFirstField = el;
                }
            }
            break;
        case "textfield":
            {
                if (!cell.classList.contains("flex_gor_center") && !cell.classList.contains("flex_gor")) {
                    cell.classList.add("flex_gor_center");
                }
                if (!jsParent.w && !isParentFlexColumn(cell)) {
                    cell.classList.add("flex_1_1_100");
                }
                const el = document.createElement("input");
                el.type = 'text';
                if (jsParent.el_class) {
                    el.className = jsParent.el_class;
                }
                else if (!jsParent.readOnly) {
                    el.className = "fltmn_textfield";
                }
                if (jsParent.readOnly) {
                    el.classList.add("input_readonly");
                    el.readOnly = true;
                    el.tabIndex = -1;
                }
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                SetGetPutFunc(oMenu, jsParent, el, sValueName, jsFloatMenuDescr);
                if (title) {
                    const text = document.createElement("div");
                    let sClass = 'fltmn_short_text';
                    if (jsParent.class) {
                        sClass += " " + jsParent.class;
                    }
                    text.className = sClass;
                    text.innerHTML = title;
                    let domTextTmp = text;
                    if (sHint) {
                        addSuperscriptText(text, sHint);
                        text.style.marginRight = "1rem";
                        text.style.width = "fit-content";
                        domTextTmp = document.createElement("div");
                        domTextTmp.className = 'fltmn_short_text';
                        domTextTmp.append(text);
                    }
                    if (jsParent.title_width_group) {
                        if (!oMenu.mapSameLenghtEls[jsParent.title_width_group]) {
                            oMenu.mapSameLenghtEls[jsParent.title_width_group] = [domTextTmp];
                        }
                        else {
                            oMenu.mapSameLenghtEls[jsParent.title_width_group].push(domTextTmp);
                        }
                    }
                    else if (jsParent.title_width) {
                        domTextTmp.style.flex = "0 0 " + jsParent.title_width;
                    }
                    cell.append(domTextTmp);
                    if (jsParent.w) {
                        if (typeof jsParent.w === "string") {
                            if (jsParent.w.endsWith("%")) {
                                el.style.flex = "1 1 " + jsParent.w;
                            }
                            else {
                                el.style.width = jsParent.w;
                            }
                        }
                        else {
                            el.style.width = jsParent.w + "px";
                        }
                    }
                    else {
                        el.classList.add("flex_1_1_100");
                    }
                }
                else {
                    if (cell.parentElement.classList.contains("flex_gor_center") || cell.parentElement.classList.contains("flex_gor")) {
                        if (jsParent.w) {
                            if (typeof jsParent.w === "string") {
                                if (jsParent.w.endsWith("%")) {
                                    cell.style.flex = "1 1 " + jsParent.w;
                                }
                                else {
                                    cell.style.flex = "0 0 " + jsParent.w;
                                }
                            }
                            else {
                                cell.style.width = "0 0 " + jsParent.w + "px";
                            }
                        }
                        else {
                            cell.classList.add("flex_1_1_100");
                        }
                    }
                    else {
                        cell.classList.add("width100");
                    }
                    el.classList.add("flex_1_1_100");
                }
                if (jsParent.non_empty) {
                    if (!el.value) {
                        el.classList.add("err_in_field");
                        oMenu.blockSaveBtmMap.add(jsParent.id + "_" + oMenu.id);
                    }
                    else {
                        el.classList.remove("err_in_field");
                        oMenu.blockSaveBtmMap.delete(jsParent.id + "_" + oMenu.id);
                    }
                    el.addEventListener('input', (event) => {
                        if (!el.value) {
                            el.classList.add("err_in_field");
                            oMenu.blockSaveBtmMap.add(jsParent.id + "_" + oMenu.id);
                        }
                        else {
                            el.classList.remove("err_in_field");
                            oMenu.blockSaveBtmMap.delete(jsParent.id + "_" + oMenu.id);
                        }
                        if (oMenu.fOnChangeFM) {
                            oMenu.fOnChangeFM(el, oMenu);
                        }
                    });
                }
                cell.append(el);
                if (!(jsParent.optional || jsParent.readOnly)) {
                    oEnterProc.aInpEl.push(el);
                }
                if (!oMenu.pFirstField) {
                    oMenu.pFirstField = el;
                }
                SetElementControl(oMenu, jsParent, cell, el);
            }
            break;
        case "password":
            {
                let el = document.createElement("input");
                el.type = 'password';
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                else
                    el.className = "fltmn_password";
                if (jsParent.size) {
                    el.size = jsParent.size;
                }
                SetGetPutFunc(oMenu, jsParent, el, sValueName, jsFloatMenuDescr);
                if (title) {
                    cell.className = "fltmn_password_container";
                    const text = document.createElement("div");
                    let sClass = 'fltmn_short_text';
                    if (jsParent.class) {
                        sClass += " " + jsParent.class;
                    }
                    text.className = sClass;
                    text.innerHTML = title;
                    let domTextTmp = text;
                    if (sHint) {
                        addSuperscriptText(text, sHint);
                        text.style.marginRight = "1rem";
                        text.style.width = "fit-content";
                        domTextTmp = document.createElement("div");
                        domTextTmp.className = 'fltmn_short_text';
                        domTextTmp.append(text);
                    }
                    if (jsParent.title_width_group) {
                        if (!oMenu.mapSameLenghtEls[jsParent.title_width_group]) {
                            oMenu.mapSameLenghtEls[jsParent.title_width_group] = [domTextTmp];
                        }
                        else {
                            oMenu.mapSameLenghtEls[jsParent.title_width_group].push(domTextTmp);
                        }
                    }
                    else if (jsParent.title_width) {
                        domTextTmp.style.flex = "0 0 " + jsParent.title_width;
                    }
                    cell.append(domTextTmp);
                }
                else {
                    cell.className = "fltmn_password_container_wo_title";
                }
                if (jsParent.same) {
                    el.addEventListener('input', (event) => {
                        const domSameEl = document.getElementById(jsParent.same.id + "_" + oMenu.id);
                        if (domSameEl && domSameEl.tagName.toUpperCase() == "INPUT") {
                            if (el.value != domSameEl.value) {
                                el.classList.add("err_in_field");
                                domSameEl.classList.add("err_in_field");
                                for (const ids of jsParent.same.disable) {
                                    const dom = document.getElementById(ids + "_" + oMenu.id);
                                    if (dom) {
                                        dom.disabled = true;
                                    }
                                }
                            }
                            else {
                                el.classList.remove("err_in_field");
                                domSameEl.classList.remove("err_in_field");
                                for (const ids of jsParent.same.disable) {
                                    const dom = document.getElementById(ids + "_" + oMenu.id);
                                    if (dom) {
                                        dom.disabled = false;
                                    }
                                }
                            }
                        }
                    });
                }
                cell.append(el);
                const domShowHide = document.createElement("div");
                domShowHide.className = "show_hide_psw";
                domShowHide.onclick = function () { PassShow(domShowHide, el, "var(--base-el-size)"); };
                if (oMenu.fOnChangeFM) {
                    el.onkeydown = function () {
                        oMenu.fOnChangeFM(el, oMenu.id);
                    };
                }
                PassHide(domShowHide, el, "var(--base-el-size)");
                cell.append(domShowHide);
                if (!jsParent.optional) {
                    oEnterProc.aInpEl.push(el);
                }
                if (!oMenu.pFirstField) {
                    oMenu.pFirstField = el;
                }
                SetElementControl(oMenu, jsParent, cell, el);
            }
            break;
        case "fileload":
            {
                if (!jsParent.command)
                    break;
                let el = document.createElement("input");
                el.type = "file";
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                let sCommand = jsParent.command;
                if (!jsParent.command.includes("(")) {
                    sCommand = jsParent.command + "('" + oMenu.id + "', jsFloatMenuDescr." + sValueName + ")";
                }
                el.onchange = (event) => {
                    const input = event.target;
                    if (!input.files || input.files.length == 0)
                        return;
                    const file = input.files[0];
                    if (file) {
                        const reader = new FileReader();
                        reader.onload = (e) => {
                            if (!e.target) {
                                console.error('Error creating FileReader for file ' + file.name);
                                return;
                            }
                            const text = e.target.result;
                            eval(sCommand);
                        };
                        reader.onerror = () => {
                            console.error('Error reading file' + file.name);
                        };
                        reader.readAsText(file);
                    }
                };
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                if (title) {
                    cell.style.display = "flex";
                    cell.style.alignItems = "center";
                    const text = document.createElement("div");
                    if (jsParent.class)
                        text.className = jsParent.class;
                    else
                        text.className = "fltmn_text";
                    text.innerHTML = title;
                    let domTextTmp = text;
                    if (sHint) {
                        addSuperscriptText(text, sHint);
                        text.style.marginRight = "1rem";
                        text.style.width = "fit-content";
                        domTextTmp = document.createElement("div");
                        domTextTmp.className = 'fltmn_short_text';
                        domTextTmp.append(text);
                    }
                    if (jsParent.title_width) {
                        domTextTmp.style.flex = "flex:0 0 " + jsParent.title_width + "'";
                    }
                    if (jsParent.title_width_group) {
                        if (!oMenu.mapSameLenghtEls[jsParent.title_width_group]) {
                            oMenu.mapSameLenghtEls[jsParent.title_width_group] = [];
                        }
                        oMenu.mapSameLenghtEls[jsParent.title_width_group].push(domTextTmp);
                    }
                    cell.append(domTextTmp);
                }
                else {
                    cell.classList.add("flex_1_1_100");
                    cell.classList.add("fltmn_text_around_field");
                }
                cell.append(el);
                SetElementControl(oMenu, jsParent, cell, el);
            }
            break;
        case "textarea":
            {
                let el = document.createElement("textarea");
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                if (jsParent.el_class)
                    el.className = jsParent.el_class;
                else
                    el.className = "float_menu_textarea";
                if (jsParent.nLine)
                    el.rows = +jsParent.nLine;
                else
                    el.rows = 4;
                SetElementHeight(jsParent, cell);
                SetGetPutFunc(oMenu, jsParent, el, sValueName, jsFloatMenuDescr);
                cell.className += "float_menu_panel";
                cell.style.paddingRight = "5px";
                cell.append(el);
                if (!oMenu.pFirstField) {
                    oMenu.pFirstField = el;
                }
            }
            break;
        case "table":
            {
                if (!jsFloatMenuDescr || !jsParent.dynTable) {
                    break;
                }
                let oDTP = eval("jsFloatMenuDescr." + jsParent.dynTable);
                if (jsParent.class) {
                    cell.className += " " + jsParent.class;
                }
                else {
                    cell.className += " white_panel float_menu_panel";
                }
                cell.domLimEl = document.body;
                oDTP.domLimWindow = cell;
                SetElementHeight(jsParent, cell);
                SetElementWidth(jsParent, cell);
                if (jsParent.nLine) {
                    oDTP.nLines = jsParent.nLine;
                }
                CreateTable(oDTP);
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                wasStretchEl = true;
            }
            break;
        case "mtable":
            {
                if (!jsFloatMenuDescr || sValueName == "")
                    break;
                const aTableFill = eval("jsFloatMenuDescr." + sValueName);
                if (!Array.isArray(aTableFill))
                    break;
                cell.className += " white_panel float_menu_panel panel_with_border";
                const inCell = document.createElement('div');
                inCell.className = "float_menu_user_resize";
                inCell.fUserResize = function (nDeltaX, nDeltaY) {
                    if (inCell.pTable && nDeltaY > 0) {
                        inCell.pTable.nWindowHeight += nDeltaY;
                        inCell.pTable.domLimWindow.style.maxHeight = inCell.pTable.nWindowHeight + "pt";
                        inCell.pTable.domLimWindow.fUserResize();
                    }
                };
                cell.append(inCell);
                const oTableParams = new TDynamicTableProperties();
                oTableParams.root.fAddDataArr(aTableFill);
                oTableParams.domContainer = inCell;
                oTableParams.domLimWindow = cell;
                if (jsParent.el_class) {
                    oTableParams.sCellClass = jsParent.el_class;
                }
                else {
                    oTableParams.bStriped = true;
                }
                if (jsParent.editable) {
                    oTableParams.bEditable = true;
                    oTableParams.fOnChange = function () {
                        const bObjRows = IsObject(aTableFill[0]);
                        aTableFill.splice(0);
                        const arr = oTableParams.fGetCont();
                        if (bObjRows) {
                            for (const it of arr) {
                                aTableFill.push(it);
                            }
                        }
                        else {
                            for (const it of arr) {
                                aTableFill.push(it["-"]);
                            }
                        }
                        if (jsParent.fOnChange) {
                            if (jsParent.fOnChange.endsWith(")+")) {
                                eval(jsParent.fOnChange.replace(")+", ", '" + oMenu.id + "')"));
                            }
                            else if (jsParent.fOnChange.includes("(")) {
                                eval(jsParent.fOnChange);
                            }
                            else {
                                eval(jsParent.fOnChange + "('" + oMenu.id + "')");
                            }
                        }
                    };
                }
                if (jsParent.head) {
                    oTableParams.aHead = jsFloatMenuTableHeads[jsParent.head];
                }
                else {
                    oTableParams.bWithoutHead = true;
                }
                SetElementHeight(jsParent, cell);
                if (jsParent.nLine) {
                    oTableParams.nLines = jsParent.nLine;
                }
                if (jsParent.open_folder_func) {
                    oTableParams.fOpenFolder = eval(jsParent.open_folder_func);
                }
                if (jsParent.dblclick) {
                    oTableParams.fDblclick = eval(jsParent.dblclick);
                }
                oTableParams.bResetSelectIfClickOut = true;
                const pTable = CreateTable(oTableParams);
                if (pTable) {
                    inCell.pTable = pTable;
                    if (jsParent.id) {
                        inCell.id = jsParent.id + "_" + oMenu.id;
                    }
                }
                wasStretchEl = true;
            }
            break;
        case "button":
            {
                let el = document.createElement("button");
                if (sHint) {
                    el.title = GetLocaleText(sHint);
                }
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                if (jsParent.img) {
                    const img = SetImg(jsParent.img, "1rem");
                    if (img) {
                        el.append(img);
                        if (jsParent.title) {
                            el.append(GetLocaleText(jsParent.title));
                            img.classList.add("fltmn_button_img");
                        }
                        else {
                            el.classList.add("only_img_btn");
                        }
                    }
                    else {
                        if (!jsParent.title) {
                            jsParent.title = "Unknown button";
                        }
                        el.innerHTML = GetLocaleText(jsParent.title);
                    }
                }
                else {
                    if (!jsParent.title) {
                        jsParent.title = "Unknown button";
                    }
                    el.innerHTML = GetLocaleText(jsParent.title);
                }
                if (jsParent.class) {
                    el.className = (el.className ? " " : "") + jsParent.class;
                }
                else if (!el.className) {
                    el.classList.add("flt_menu_btn");
                }
                let sCommand = 'alert("Ups! No command for this button.")';
                if (jsParent.command) {
                    if (jsParent.command.endsWith(")++")) {
                        sCommand = jsParent.command.replace(")++", ", oMenu)");
                    }
                    else if (jsParent.command.endsWith(")+")) {
                        sCommand = jsParent.command.replace(")+", ", '" + oMenu.id + "')");
                    }
                    else if (jsParent.command.includes("(") || jsParent.command.includes("{")) {
                        sCommand = jsParent.command;
                    }
                    else if (sValueName) {
                        sCommand = jsParent.command + "('" + oMenu.id + "', jsFloatMenuDescr." + sValueName + ")";
                    }
                    else {
                        sCommand = jsParent.command + "('" + oMenu.id + ")";
                    }
                }
                if (jsParent.onDown) {
                    el.addEventListener('mousedown', function () {
                        eval(sCommand);
                    });
                }
                else {
                    el.addEventListener('click', function (e) {
                        e.preventDefault();
                        e.stopPropagation();
                        eval(sCommand);
                    });
                }
                if (oControlCheckBox) {
                    if (!oControlCheckBox.checked)
                        el.disabled = true;
                    oControlCheckBox.addEventListener('change', function () {
                        el.disabled = !(oControlCheckBox.checked);
                    });
                }
                if (jsParent.w_s) {
                    el.style.whiteSpace = jsParent.w_s;
                }
                cell.append(el);
                SetElementControl(oMenu, jsParent, cell, el);
            }
            break;
        case "text":
            {
                if (jsParent.class) {
                    cell.className = (cell.className ? " " : "") + jsParent.class;
                }
                else {
                    cell.className = "fltmn_text";
                }
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                if (jsParent.w_s)
                    cell.style.whiteSpace = jsParent.w_s;
                if (jsParent.fontSize)
                    cell.style.fontSize = jsParent.fontSize + "px";
                if (jsParent.w) {
                    if (typeof jsParent.w == 'string') {
                        cell.style.width = jsParent.w;
                    }
                    else {
                        cell.style.width = jsParent.w + "px";
                    }
                }
                if (jsParent.title_width_group) {
                    if (!oMenu.mapSameLenghtEls[jsParent.title_width_group]) {
                        oMenu.mapSameLenghtEls[jsParent.title_width_group] = [];
                    }
                    oMenu.mapSameLenghtEls[jsParent.title_width_group].push(cell);
                }
                let sTextTmp = title;
                if (jsParent.value) {
                    sTextTmp = eval("jsFloatMenuDescr." + jsParent.value);
                }
                else if (jsParent.globalVal) {
                    sTextTmp = eval(jsParent.globalVal);
                }
                if (sHint) {
                    const domTextTmp = document.createElement('div');
                    domTextTmp.innerText = sTextTmp;
                    domTextTmp.style.width = "fit-content";
                    addSuperscriptText(domTextTmp, sHint);
                    cell.append(domTextTmp);
                }
                else {
                    if (sTextTmp.includes("<br/>") && sTextTmp.includes("\t")) {
                        sTextTmp = StringToTable(sTextTmp);
                    }
                    cell.innerHTML = sTextTmp;
                }
                SetElementControl(oMenu, jsParent, cell);
            }
            break;
        case "place":
            {
                if (jsParent.id) {
                    cell.id = jsParent.id + "_" + oMenu.id;
                }
                if (jsParent.class) {
                    cell.className = jsParent.class;
                }
                if (jsParent.w) {
                    if (typeof jsParent.w == 'string') {
                        cell.style.width = jsParent.w;
                    }
                    else {
                        cell.style.width = jsParent.w + "px";
                    }
                }
                SetElementHeight(jsParent, cell, true);
            }
            break;
        case "progressbar":
            {
                if (!jsParent.id)
                    return;
                const pbIndicator = document.createElement('div');
                const pbNumber = document.createElement('div');
                if (!pbIndicator || !pbNumber)
                    return;
                cell.id = jsParent.id + "_" + oMenu.id;
                pbIndicator.style.width = "0";
                if (jsParent.class) {
                    cell.className = jsParent.class;
                }
                else {
                    cell.className = "fltmn_progressbar";
                }
                pbIndicator.className = "fltmn_pb_indicator";
                pbNumber.className = "fltmn_pb_number";
                cell.append(pbIndicator);
                cell.append(pbNumber);
            }
            break;
        case "separator":
            {
                const domHr = document.createElement('hr');
                if (jsParent.w) {
                    if (typeof jsParent.w == 'string') {
                        domHr.style.width = jsParent.w;
                    }
                    else {
                        domHr.style.width = jsParent.w + "px";
                    }
                }
                cell.append(domHr);
            }
            break;
        case "bottom_box":
            {
                cell.id = "bottom_box_" + oMenu.id;
            }
            break;
        case "img":
            {
                if (typeof jsParent.value != 'string') {
                    cell.append(title);
                }
                else {
                    if (!jsParent.w) {
                        jsParent.w = "var(--horizontal-img-btn-size)";
                    }
                    else if (typeof jsParent.w === 'number') {
                        jsParent.w = jsParent.w + "px";
                    }
                    const img = SetImg(jsParent.value, jsParent.w);
                    if (img) {
                        if (jsParent.class) {
                            cell.classList.add(jsParent.class);
                        }
                        cell.append(img);
                    }
                    if (img)
                        cell.append(img);
                }
            }
            break;
        case "link":
            {
                if (typeof jsParent.value != 'string') {
                    return;
                }
                const el = document.createElement('a');
                el.href = jsParent.value;
                el.target = "_blank";
                if (jsParent.class) {
                    el.className = jsParent.class;
                }
                else {
                    el.className = "fltmn_link";
                }
                if (title) {
                    el.innerHTML = title;
                }
                else {
                    el.innerHTML = jsParent.value;
                }
                if (jsParent.id) {
                    el.id = jsParent.id + "_" + oMenu.id;
                }
                addSuperscriptText(el, sHint);
                cell.append(el);
            }
            break;
        case "space":
            {
                if (jsParent.class) {
                    cell.className = jsParent.class;
                }
                SetElementHeight(jsParent, cell);
                if (jsParent.w && typeof jsParent.w == 'string') {
                    if (jsParent.w.includes("%")) {
                        cell.style.flex = "1 1 " + jsParent.w;
                    }
                    else {
                        cell.style.flex = "0 0 " + jsParent.w;
                    }
                }
                else {
                    cell.style.flex = "0 0 " + jsParent.w + "px";
                }
            }
            break;
    }
    return oControlCheckBox;
}
function addSuperscriptText(dom, sHint) {
    if (dom && sHint) {
        dom.title = sHint;
        dom.style.position = "relative";
        const supElement = document.createElement('div');
        supElement.className = "help_question";
        const img = SetImg("properties", "var(--base-el-size)");
        if (img) {
            supElement.append(img);
            dom.appendChild(supElement);
            supElement.oncontextmenu = function (e) {
                const jsHintMenu = [
                    { title: "Str_CopyHintToClipboard", img: "copy", command: "CopyHintToClipBoard(xAddArgs)" },
                ];
                e.preventDefault();
                CreateDropMenuItems(jsHintMenu, e.clientX, e.clientY, e.clientX, e.target, false, sHint);
            };
            supElement.onclick = function (e) {
                let domCurr = dom;
                while (domCurr.parentElement) {
                    if (domCurr.parentElement.classList.contains("float_menu_option_group_body") ||
                        domCurr.parentElement.classList.contains("float_menu_hidden_group_body") ||
                        domCurr.parentElement.classList.contains("el_with_help") ||
                        domCurr.parentElement.classList.contains("float_menu_right_win1") ||
                        domCurr.parentElement.classList.contains("float_menu_right_win2"))
                        break;
                    domCurr = domCurr.parentElement;
                }
                if (domCurr) {
                    let nextSibling = domCurr.nextElementSibling;
                    while (nextSibling) {
                        if (nextSibling.textContent == sHint && nextSibling.classList.contains("fltmn_hint")) {
                            nextSibling.remove();
                            return;
                        }
                        nextSibling = nextSibling.nextElementSibling;
                    }
                    const hintElement = document.createElement('div');
                    hintElement.className = "fltmn_hint";
                    hintElement.textContent = sHint;
                    domCurr.insertAdjacentElement("afterend", hintElement);
                }
            };
        }
    }
}
function CopyHintToClipBoard(sText) {
    navigator.clipboard.writeText(sText).catch(err => alert("Something went wrong: " + err));
}
function SetElementHeight(jsParent, cell, max) {
    if (jsParent.h) {
        if (typeof jsParent.h === 'string') {
            if (jsParent.h.endsWith("%")) {
                cell.style.flex = "1 1 " + jsParent.h;
                let nPercent = +jsParent.h.slice(0, -1);
                if (isNaN(nPercent) || nPercent == 0)
                    nPercent = 100;
            }
            else {
                if (max) {
                    cell.style.maxHeight = jsParent.h;
                }
                else
                    cell.style.flex = "0 0 " + jsParent.h;
            }
        }
        else {
            if (max) {
                cell.style.maxHeight = jsParent.h + "px";
            }
            else
                cell.style.flex = "0 0 " + jsParent.h + "px";
        }
        cell.style.overflow = "auto";
    }
    if (jsParent.maxH) {
        cell.style.maxHeight = jsParent.maxH;
        cell.style.overflowY = "auto";
    }
    if (jsParent.minH) {
        cell.style.minHeight = jsParent.minH;
    }
}
function SetElementWidth(jsParent, cell, max) {
    if (jsParent.w) {
        if (typeof jsParent.w === 'string') {
            if (jsParent.w.endsWith("%")) {
                cell.style.flex = "1 1 " + jsParent.w;
                let nPercent = +jsParent.w.slice(0, -1);
                if (isNaN(nPercent) || nPercent == 0)
                    nPercent = 100;
            }
            else {
                if (max) {
                    cell.style.maxWidth = jsParent.w;
                }
                else
                    cell.style.flex = "0 0 " + jsParent.w;
            }
        }
        else {
            if (max) {
                cell.style.maxWidth = jsParent.w + "px";
            }
            else
                cell.style.flex = "0 0 " + jsParent.w + "px";
        }
        cell.style.overflow = "auto";
    }
}
function CloseFloatMenu(menu, bIsEsc = false) {
    if (!menu || bIsEsc && menu.bNoCancel || menu.bSelfDeleted) {
        return;
    }
    if (menu.jsMenuPart && menu.jsMenuPart.pPrevSubMenu) {
        _DeleteElFromSubMenu(menu.jsMenuPart.pPrevSubMenu, menu.jsFloatMenuDescr);
    }
    oMenuRegister.DeleteMenu(menu);
    CloseModalWindow(menu);
    menu.bSelfDeleted = true;
}
function CloseModalWindow(pWin) {
    if (pWin.modal) {
        aZInd.pop();
        if (aZInd.length > 0) {
            domModal.style.zIndex = aZInd[aZInd.length - 1] + "";
        }
        else {
            domModal.style.display = "none";
        }
    }
    pWin.innerHTML = "";
    const parent = pWin.parentElement;
    if (parent) {
        parent.removeChild(pWin);
    }
    else {
        pWin.remove();
    }
    SetStretchEl();
}
function FloatMenuMoveEnd() {
    document.onmousemove = null;
    SetStretchEl();
}
function SetValue(jsParent, el, sValueName, jsFloatMenuDescr) {
    if (jsParent.get) {
        el.value = eval(jsParent.get + "(jsFloatMenuDescr." + sValueName + ")");
    }
    else if (jsParent.time) {
        el.value = eval("GetDTString(jsFloatMenuDescr." + sValueName + ")");
    }
    else {
        el.value = eval("jsFloatMenuDescr." + sValueName);
    }
    if (el.value == 'undefined') {
        el.value = '';
    }
}
function SetGetPutFunc(oMenu, jsParent, el, sValueName, jsFloatMenuDescr) {
    SetValue(jsParent, el, sValueName, jsFloatMenuDescr);
    el.oninput = function () {
        if (jsParent.valid) {
            if (jsParent.valid.endsWith(")+")) {
                jsParent.valid = jsParent.valid.replace(")+", ", '" + oMenu.id + "')");
            }
            if (!eval(jsParent.valid)) {
                SetValue(jsParent, el, sValueName, jsFloatMenuDescr);
                return;
            }
        }
        else {
            if (jsParent.type == "numberfield") {
                const n = +el.value;
                if (el.value === "" || isNaN(n) || "min" in jsParent && n < jsParent.min || "max" in jsParent && n > jsParent.max) {
                    SetValue(jsParent, el, sValueName, jsFloatMenuDescr);
                    return;
                }
            }
        }
        if (jsParent.put) {
            eval(jsParent.put + "(jsFloatMenuDescr." + sValueName + ",'" + el.value + "', jsFloatMenuDescr, '" + sValueName + "')");
        }
        else {
            eval("jsFloatMenuDescr." + sValueName + " = el.value");
        }
        if (oMenu.fOnChangeFM)
            oMenu.fOnChangeFM(el, oMenu);
    };
}
function DeleteAllFloatMenu() {
    let dmArr = document.getElementsByClassName("float_menu");
    for (let i = dmArr.length - 1; i >= 0; i--) {
        const tmp = dmArr[i];
        if (tmp.jsMenuPart && tmp.jsMenuPart.pPrevSubMenu)
            _DeleteElFromSubMenu(tmp.jsMenuPart.pPrevSubMenu, null);
        dmArr[i].remove();
    }
    if (domModal) {
        domModal.style.display = "none";
    }
    aZInd.splice(0);
    oMenuRegister.Erase();
}
function _DeleteElFromSubMenu(subMenu, jsFloatMenuDescr) {
    for (let iSubMenu of subMenu) {
        if (IsObject(iSubMenu)) {
            if (iSubMenu.cont)
                _DeleteElFromSubMenu(iSubMenu.cont, jsFloatMenuDescr);
            if (iSubMenu.el)
                delete iSubMenu.el;
            if (iSubMenu.controlledEls)
                delete iSubMenu.controlledEls;
            if (iSubMenu.fSetState)
                delete iSubMenu.fSetState;
            if (iSubMenu.control) {
                if (iSubMenu.control.disAfterParse)
                    delete iSubMenu.control.disAfterParse;
                if (iSubMenu.control.resAfterParse)
                    delete iSubMenu.control.resAfterParse;
                if (iSubMenu.control.hidAfterParse)
                    delete iSubMenu.control.hidAfterParse;
            }
        }
    }
}
function GetElemByIdFromFloatMenuBase(cont, id) {
    for (const el of cont) {
        if (el.id == id)
            return el;
        if (el.cont) {
            const ret = GetElemByIdFromFloatMenuBase(el.cont, id);
            if (ret)
                return ret;
        }
    }
    return null;
}
function GetElemById(jsMenuPart, id) {
    for (const el of jsMenuPart.cont) {
        const ret = GetElemByIdFromFloatMenuBase(el.cont, id);
        if (ret)
            return ret;
    }
    return null;
}
function SetControlledEls(controlledEls) {
    if (controlledEls) {
        for (const el of controlledEls) {
            if (el.fSetState)
                el.fSetState();
        }
    }
}
function ParseJsIds(oMenu, command, jsParent) {
    let ret = "";
    if (!oMenu.jsMenuPart)
        return command;
    for (let end = 0; end >= 0;) {
        let start = command.indexOf("ID#[", end);
        if (start >= 0) {
            ret += command.substring(end, start);
            start += 4;
            end = command.indexOf("]", start);
            if (end > 0) {
                const id = command.substring(start, end);
                const oEl = GetElemById(oMenu.jsMenuPart, id);
                if (oEl) {
                    try {
                        eval("oMenu.jsFloatMenuDescr." + oEl.value);
                        ret += "oMenu.jsFloatMenuDescr." + oEl.value;
                        if (!oEl.controlledEls) {
                            oEl.controlledEls = new Set;
                        }
                        oEl.controlledEls.add(jsParent);
                        if (oEl.type == "radio" && oEl.list) {
                            for (let i = 0; i < oEl.list.length; i++) {
                                const domRadio = document.getElementById(id + "_" + i);
                                if (domRadio) {
                                    domRadio.fChange = () => SetControlledEls(oEl.controlledEls);
                                }
                            }
                        }
                        else if (oEl.el) {
                            oEl.el.fChange = () => SetControlledEls(oEl.controlledEls);
                        }
                    }
                    catch (_a) {
                        ret += 'undefined';
                    }
                }
                else {
                    ret += 'undefined';
                }
                end++;
            }
        }
        else {
            ret += command.substring(end);
            break;
        }
    }
    return ret;
}
function SetElementControl(oMenu, jsParent, cell, el) {
    if (!jsParent.control) {
        return true;
    }
    if (jsParent.control.disable) {
        jsParent.control.disAfterParse = ParseJsIds(oMenu, jsParent.control.disable, jsParent);
    }
    if (jsParent.control.reset) {
        jsParent.control.resAfterParse = ParseJsIds(oMenu, jsParent.control.reset, jsParent);
    }
    if (jsParent.control.hide) {
        jsParent.control.hidAfterParse = ParseJsIds(oMenu, jsParent.control.hide, jsParent);
    }
    if (el) {
        if (jsParent.control.disAfterParse && eval(jsParent.control.disAfterParse)) {
            if ("disabled" in el) {
                el.disabled = true;
            }
            cell.classList.add("disabled_cell");
        }
        if (jsParent.control.resAfterParse && "checked" in el && el.checked && eval(jsParent.control.resAfterParse)) {
            el.checked = false;
            if (oMenu.fOnChangeFM) {
                oMenu.fOnChangeFM(el, oMenu.id);
            }
        }
    }
    else {
        if (jsParent.control.disAfterParse && eval(jsParent.control.disAfterParse)) {
            cell.classList.add("disabled_cell");
        }
    }
    if (jsParent.control.hidAfterParse) {
        if (eval(jsParent.control.hidAfterParse)) {
            if (cell.style.display != "none") {
                cell.classList.add("display_before_hidding_" + cell.style.display);
                cell.style.display = "none";
            }
        }
    }
    jsParent.fSetState = () => {
        if (el) {
            if (jsParent.control.disAfterParse) {
                if (eval(jsParent.control.disAfterParse)) {
                    if ("disabled" in el) {
                        el.disabled = true;
                    }
                    cell.classList.add("disabled_cell");
                }
                else {
                    if ("disabled" in el) {
                        el.disabled = false;
                    }
                    cell.classList.remove("disabled_cell");
                }
            }
            if (jsParent.control.resAfterParse && "checked" in el && el.checked) {
                if (eval(jsParent.control.resAfterParse)) {
                    el.checked = false;
                    el.dispatchEvent(new Event('change'));
                    SetControlledEls(jsParent.controlledEls);
                }
            }
        }
        else {
            if (jsParent.control.disAfterParse) {
                if (eval(jsParent.control.disAfterParse)) {
                    cell.classList.add("disabled_cell");
                }
                else {
                    cell.classList.remove("disabled_cell");
                }
            }
        }
        if (jsParent.control.hidAfterParse) {
            if (eval(jsParent.control.hidAfterParse)) {
                if (cell.style.display != "none") {
                    cell.classList.add("display_before_hidding_" + cell.style.display);
                    cell.style.display = "none";
                }
            }
            else {
                for (const cl of cell.classList) {
                    if (cl.indexOf("display_before_hidding_") == 0) {
                        cell.style.display = cl.substring(23);
                        cell.classList.remove(cl);
                    }
                }
                if (cell.style.display == "none") {
                    cell.style.display = "";
                }
            }
        }
    };
}
function SetElementManager(oControl) {
    if (oControl.el) {
        oControl.el.fChange = () => SetControlledEls(oControl.controlledEls);
    }
}
function OpenSchedulSets() {
    CreateFloatMenu(jsFloatMenu["ScheduleOptions"], { top: '20%', width: '450px' }, CopySchedele(jsCurrJobOptions.schedule), { sRightWinClass: "padding_0_x", bCurrJobName: true, fOnChangeFM: OnChangeSchedule })
        .promise.then(data => {
        if (data.command == "save") {
            jsCurrJobOptions.schedule = data.data;
            if (jsCurrJobOptions.schedule.rMinute.RangeList.length == 0) {
                jsCurrJobOptions.schedule.rMinute.RangeList.push({ from: 0, to: 0, step: 1 });
            }
        }
        else if (data.command == "test") {
            TestScheduleSets(data.data);
        }
    }).catch(() => { });
}
function SaveScheduleSets() {
}
function CancelScheduleSets() {
}
function TestScheduleSets(obj) {
    alert("Implementation in progress");
}
function OnChangeSchedule(el, oMenu) {
    if (!oMenu)
        return;
    const domSaveBtn = document.getElementById("save_btn_" + oMenu.id);
    if (domSaveBtn) {
        domSaveBtn.disabled = oMenu.blockSaveBtmMap.size > 0;
    }
    const domTestBtn = document.getElementById("test_btn_" + oMenu.id);
    if (domTestBtn) {
        domTestBtn.disabled = oMenu.blockSaveBtmMap.size > 0;
    }
}
class TScheduleContainer {
    constructor() {
        this.RangeList = [];
    }
}
class TScheduleObj {
    constructor() {
        this.rDayOfWeek = new TScheduleContainer;
        this.rDayOfMonth = new TScheduleContainer;
        this.rHour = new TScheduleContainer;
        this.rMinute = new TScheduleContainer;
        this.rMonth = new TScheduleContainer;
    }
}
function CopySchedele(obj) {
    const ret = new TScheduleObj();
    for (let fild in obj) {
        for (let iShad of obj[fild].RangeList) {
            ret[fild].RangeList.push({ "from": iShad.from, "to": iShad.to, "step": iShad.step });
        }
    }
    return ret;
}
function GetSchedule(objIn) {
    if (!objIn)
        return "";
    const obj = objIn.RangeList;
    let str = "";
    for (let i = 0; i < obj.length; i++) {
        if ((obj[i].from == obj[i].to || obj[i].to == 0) && !isNaN(+obj[i].from)) {
            str += obj[i].from;
        }
        else if (!isNaN(+obj[i].from) && !isNaN(+obj[i].to)) {
            str += obj[i].from + "-" + obj[i].to;
            if (obj[i].step > 1) {
                str += "/" + obj[i].step;
            }
        }
        if (i < obj.length - 1 && str.length > 0)
            str += ", ";
    }
    return str;
}
function PutSchedule(objIn, str) {
    if (!objIn)
        return;
    const obj = objIn.RangeList;
    obj.splice(0);
    let arr = SplitWithTrim(str, ",");
    for (let i = 0; i < arr.length; i++) {
        obj.push({ "from": -1, "to": -1, "step": 1 });
        let subStr = arr[i];
        const subArr = SplitWithTrim(subStr, "/");
        if (!subArr.length)
            return;
        const subSubArr = subArr[0].split("-");
        if (subSubArr.length > 1) {
            obj[i].to = Number(subSubArr[1]);
        }
        else {
            obj[i].to = Number(subSubArr[0]);
        }
        obj[i].from = Number(subSubArr[0]);
        if (obj[i].to > -1 && obj[i].from > obj[i].to) {
            const tmp = obj[i].from;
            obj[i].from = obj[i].to;
            obj[i].to = tmp;
        }
        if (subArr.length > 1) {
            obj[i].step = +subArr[1];
        }
    }
}
function EnterProcessing(e, oEnterProc, menu) {
    if (e.code == 'Enter') {
        let bIsNotFillField = false;
        for (const it of oEnterProc.aInpEl) {
            if (!it.value) {
                it.focus();
                bIsNotFillField = true;
                break;
            }
            else {
                let x;
                if (it.onchange) {
                    it.onchange(x);
                }
            }
        }
        if (!bIsNotFillField && oEnterProc.comm) {
            if (oEnterProc.comm.nofinal) {
                eval(oEnterProc.comm.command + "(menu)");
            }
            else {
                oEnterProc.resolve(oEnterProc.comm);
                CloseFloatMenu(menu);
            }
        }
    }
}
function PeriodValidate(sObjOfValidate, sMenuId) {
    const domMinutes = document.getElementById("minutes_" + sMenuId);
    const nMinutes = +(domMinutes.value);
    const domHours = document.getElementById("hours_" + sMenuId);
    const nHours = +(domHours.value);
    if (isNaN(nMinutes) || domMinutes.value === "") {
        if (nHours > 0) {
            domMinutes.value = "0";
        }
        else {
            domMinutes.value = "1";
        }
        return true;
    }
    if (isNaN(nHours) || domHours.value === "" || nHours < 0) {
        if (nMinutes > 0) {
            domHours.value = "0";
        }
        else {
            domHours.value = "1";
        }
        return true;
    }
    if (nHours > 0) {
        if (nMinutes > 59) {
            domMinutes.value = "0";
            domHours.value = (nHours + 1) + "";
        }
        else if (nMinutes < 0) {
            domMinutes.value = "59";
            domHours.value = (nHours - 1) + "";
        }
    }
    else {
        if (nMinutes > 59) {
            domHours.value = "1";
            domMinutes.value = "0";
        }
        else if (nMinutes <= 0) {
            domMinutes.value = "59";
        }
    }
    return true;
}
function ScheduleTextValidate(str, oValid, sId, sMenuId) {
    const dom = document.getElementById(sId + "_" + sMenuId);
    const oMenu = document.getElementById(sMenuId);
    let sError = "";
    str = str.trim();
    if (!str) {
    }
    else if (str.startsWith("-") || str.startsWith(",")) {
        sError = GetLocaleText("Err_IncorrectFormula");
    }
    else if (/[^\/0-9,\-\s]/.test(str)) {
        sError = GetLocaleText("Err_IncorrectSimbol");
    }
    else {
        let arr = SplitWithTrim(str, ",");
        for (let i = 0; i < arr.length; i++) {
            let subStr = arr[i];
            let subArr = SplitWithTrim(subStr, "/");
            if (subArr.length > 2 || subArr.length < 1) {
                sError = GetLocaleText("Err_IncorrectFormula");
                break;
            }
            let subSubArr = SplitWithTrim(subArr[0], "-");
            if (subSubArr.length > 2 || subSubArr.length < 1) {
                sError = GetLocaleText("Err_IncorrectFormula");
                break;
            }
            const nFrom = +subSubArr[0];
            if (isNaN(nFrom) || "max" in oValid && nFrom > oValid.max || "min" in oValid && nFrom < oValid.min) {
                sError = GetLocaleText("Err_IncorrectRange", [subSubArr[0]], { sQuotes: "'" });
                break;
            }
            let nTo;
            if (subSubArr.length > 1) {
                nTo = +subSubArr[1];
                if (isNaN(nTo) || "max" in oValid && nTo > oValid.max || "min" in oValid && nTo < oValid.min) {
                    sError = GetLocaleText("Err_IncorrectRange", ["To = " + subSubArr[1]], { sQuotes: "'" });
                    break;
                }
                if (nTo < nFrom) {
                    sError = GetLocaleText("Err_IncorrectOrder", [nTo + " - " + nFrom, nFrom + " - " + nTo], { sQuotes: "'" });
                    break;
                }
            }
            if (subArr.length > 1) {
                if (nTo === undefined) {
                    sError = GetLocaleText("Err_IncorrectFormula");
                    break;
                }
                const nStep = +subArr[1];
                if (nStep <= 0 || nStep > Math.abs(nTo - nFrom)) {
                    sError = GetLocaleText("Err_IncorrectRange", ["Step = " + subArr[1]], { sQuotes: "'" });
                    break;
                }
            }
        }
        if (!sError && (sId == 'DayOfMonth' || sId == 'Month')) {
            const oShedObj = oMenu.jsFloatMenuDescr;
            let sId2;
            if (sId == 'DayOfMonth') {
                PutSchedule(oShedObj.rDayOfMonth, str);
                sId2 = "Month";
            }
            else {
                PutSchedule(oShedObj.rMonth, str);
                sId2 = "DayOfMonth";
            }
            const dom2 = document.getElementById(sId2 + "_" + sMenuId);
            if (!GetNextSchedule(oShedObj, dateToDateTime(new Date()))) {
                sError = GetLocaleText("Err_NoSuchDaysInTheseMonths");
                if (dom2 && !dom2.classList.contains("err_in_field")) {
                    dom2.classList.add("err_in_field");
                    dom2.title = sError;
                }
            }
            else {
                if (dom2 && dom2.title == GetLocaleText("Err_NoSuchDaysInTheseMonths")) {
                    dom2.classList.remove("err_in_field");
                    dom2.title = "";
                    oMenu.blockSaveBtmMap.delete(sId2);
                }
            }
        }
    }
    if (oMenu && dom) {
        if (sError) {
            dom.classList.add("err_in_field");
            dom.title = sError;
            oMenu.blockSaveBtmMap.add(sId);
        }
        else {
            dom.classList.remove("err_in_field");
            dom.title = "";
            oMenu.blockSaveBtmMap.delete(sId);
        }
    }
    else if (sError) {
        return false;
    }
    return true;
}
function ScheduleTest(oMenu) {
    const sResult = "<b>" + GetLocaleText("Str_JobWillRun") + "</b>" + ScheduleCalculater(oMenu.jsFloatMenuDescr);
    HtmlMsgbox(sResult, "Title_TestSedule");
}
function ScheduleCalculater(schedule, count = 10) {
    const dtPresentDT = new Date();
    let mdt = dateToDateTime(dtPresentDT);
    let result = "";
    if (schedule.rMinute.RangeList.length == 0) {
        schedule.rMinute.RangeList.push({ from: 0, to: 0, step: 1 });
    }
    let bLessThanYear = true;
    for (let i = 0; i < count; i++) {
        mdt = GetNextSchedule(schedule, mdt);
        if (!mdt) {
            return result ? ((i < count) ? result + "<br>----- " + GetLocaleText("Wrn_More10YearUntilSync") + " -----" : result) : " Never";
        }
        const time = dateTimeToDate(mdt);
        if (bLessThanYear) {
            if ((time.getTime() - dtPresentDT.getTime()) >= 366 * 24 * 60 * 60 * 1000) {
                bLessThanYear = false;
                result += "<br>----- " + GetLocaleText("Wrn_MoreYearUntilSync") + " -----";
            }
        }
        result += "<br>" + time.toLocaleTimeString(oWebGuSettings.sLocal) + ", "
            + time.toLocaleDateString(oWebGuSettings.sLocal, { year: 'numeric', month: 'short', day: 'numeric', weekday: 'short' });
    }
    return result;
}
function dateToDateTime(date) {
    return {
        year: date.getFullYear(),
        month: date.getMonth() + 1,
        day: date.getDate(),
        hour: date.getHours(),
        minute: date.getMinutes(),
        dayOfWeek: date.getDay()
    };
}
function dateTimeToDate(dateTime) {
    return new Date(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute);
}
function GetNextSchedule(schedule, current) {
    let next = Object.assign({}, current);
    next.minute++;
    while (true) {
        let mdt = dateToDateTime(new Date());
        if (next.year > mdt.year + 10) {
            return null;
        }
        if (schedule.rMinute.RangeList.length > 0 && !isInRanges(next.minute, schedule.rMinute.RangeList, 0, 59)) {
            next.minute = findNextInRanges(next.minute, schedule.rMinute.RangeList, 0, 59);
            if (next.minute < -1) {
            }
            else if (next.minute < 0) {
                next.minute = findFirstInRanges(schedule.rMinute.RangeList);
                next.hour++;
            }
            else {
                if (checkOtherFields(schedule, next)) {
                    break;
                }
                else {
                    next.minute++;
                    continue;
                }
            }
        }
        if (schedule.rHour.RangeList.length > 0 && !isInRanges(next.hour, schedule.rHour.RangeList, 0, 23)) {
            next.hour = findNextInRanges(next.hour, schedule.rHour.RangeList, 0, 23);
            if (next.hour < 0) {
                next.hour = findFirstInRanges(schedule.rHour.RangeList);
                next.day++;
                next.dayOfWeek = (next.dayOfWeek + 1) % 7;
            }
            else {
                next.minute = findFirstInRanges(schedule.rMinute.RangeList);
                continue;
            }
        }
        if (schedule.rDayOfWeek.RangeList.length > 0 && !isInRanges(next.dayOfWeek, schedule.rDayOfWeek.RangeList, 0, 6)) {
            const nextDayOfWeek = findNextInRanges(next.dayOfWeek, schedule.rDayOfWeek.RangeList, 0, 6);
            if (nextDayOfWeek < 0) {
                next.dayOfWeek = findFirstInRanges(schedule.rDayOfWeek.RangeList);
                const daysToAdd = (6 + (next.dayOfWeek - current.dayOfWeek)) % 7;
                next.day += daysToAdd ? daysToAdd : 6;
            }
            else {
                const daysToAdd = (nextDayOfWeek - next.dayOfWeek + 7) % 7;
                next.day += daysToAdd;
                next.dayOfWeek = nextDayOfWeek;
            }
            next.hour = findFirstInRanges(schedule.rHour.RangeList);
            next.minute = findFirstInRanges(schedule.rMinute.RangeList);
            const daysInMonth = getDaysInMonth(next.month, next.year);
            if (next.day > daysInMonth) {
                next.day -= daysInMonth;
                next.month++;
                if (next.month > 12) {
                    next.year++;
                    next.month = 1;
                }
            }
            continue;
        }
        if (schedule.rDayOfMonth.RangeList.length > 0 && !isInRanges(next.day, schedule.rDayOfMonth.RangeList, 1, 31)) {
            const nextDay = findNextInRanges(next.day, schedule.rDayOfMonth.RangeList, 1, 31);
            if (nextDay < 0) {
                next.day = findFirstInRanges(schedule.rDayOfMonth.RangeList);
                next.month++;
                if (next.month > 12) {
                    next.year++;
                    next.month = 1;
                }
            }
            else if (nextDay > getDaysInMonth(next.month, next.year)) {
                next.day = 1;
                next.month++;
                if (next.month > 12) {
                    next.year++;
                    next.month = 1;
                }
            }
            else {
                next.day = nextDay;
            }
            next.dayOfWeek = (new Date(next.year, next.month - 1, next.day)).getDay();
            next.hour = findFirstInRanges(schedule.rHour.RangeList);
            next.minute = findFirstInRanges(schedule.rMinute.RangeList);
            continue;
        }
        if (!isInRanges(next.month, schedule.rMonth.RangeList, 1, 12)) {
            next.month = findNextInRanges(next.month, schedule.rMonth.RangeList, 1, 12);
            if (next.month < 0) {
                next.month = findFirstInRanges(schedule.rMonth.RangeList);
                next.year++;
            }
            next.day = schedule.rDayOfMonth.RangeList.length > 0 ?
                findFirstInRanges(schedule.rDayOfMonth.RangeList) : 1;
            next.dayOfWeek = (new Date(next.year, next.month - 1, next.day)).getDay();
            next.hour = findFirstInRanges(schedule.rHour.RangeList);
            next.minute = findFirstInRanges(schedule.rMinute.RangeList);
            continue;
        }
        if (next.day > getDaysInMonth(next.month, next.year)) {
            next.day = 1;
            next.month++;
            if (next.month > 12) {
                next.month = 1;
                next.year++;
            }
            continue;
        }
        break;
    }
    return next;
}
function checkOtherFields(schedule, dateTime) {
    if (!isInRanges(dateTime.hour, schedule.rHour.RangeList, 0, 23)) {
        return false;
    }
    if (schedule.rDayOfWeek.RangeList.length > 0 &&
        !isInRanges(dateTime.dayOfWeek, schedule.rDayOfWeek.RangeList, 0, 6)) {
        return false;
    }
    if (schedule.rDayOfMonth.RangeList.length > 0 &&
        !isInRanges(dateTime.day, schedule.rDayOfMonth.RangeList, 1, 31)) {
        return false;
    }
    if (!isInRanges(dateTime.month, schedule.rMonth.RangeList, 1, 12)) {
        return false;
    }
    return true;
}
function isInRanges(value, ranges, min, max) {
    if (ranges.length === 0)
        return true;
    for (const range of ranges) {
        if (range.from <= range.to) {
            if (value >= range.from && value <= range.to) {
                if ((value - range.from) % range.step === 0) {
                    return true;
                }
            }
        }
    }
    return false;
}
function findNextInRanges(current, ranges, min, max) {
    if (ranges.length === 0)
        return current;
    let nextValues = [];
    for (const range of ranges) {
        if (range.from <= range.to) {
            for (let i = range.from; i <= range.to; i += range.step) {
                if (i >= current) {
                    nextValues.push(i);
                }
            }
        }
    }
    if (nextValues.length === 0)
        return -1;
    nextValues = nextValues.filter(v => v >= current);
    if (nextValues.length === 0)
        return -1;
    return Math.min(...nextValues);
}
function findFirstInRanges(ranges) {
    if (ranges.length === 0)
        return 0;
    let firstValues = [];
    for (const range of ranges) {
        if (range.from <= range.to) {
            firstValues.push(range.from);
        }
        else {
        }
    }
    if (firstValues.length == 0) {
        return -2;
    }
    return Math.min(...firstValues);
}
function getDaysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}
function ShowProgramOptions() {
    return __awaiter(this, void 0, void 0, function* () {
        const oDTP = new TDynamicTableProperties();
        oDTP.aHead = jsFloatMenuTableHeads.Shared_by_my;
        oDTP.bNeedSort = true;
        oDTP.bStriped = true;
        oDTP.bEditable = true;
        oDTP.root.fAddDataArr([{ from_computer: "", to_computer: "", to_user: "", read_only: "", }], {
            sPathFieldName: "from_computer",
        });
        const pLocal = AsyncUnicSendRecivePostApiWithRetry("GetLocalProgramOptions", {});
        const pGlobal = AsyncUnicSendRecivePostApiWithRetry("GetGlobalProgramOptions", {});
        const pUser = AsyncUnicSendRecivePostApiWithRetry("GetUserInfo", {});
        try {
            const aData = yield Promise.all([pLocal, pGlobal, pUser]);
            if (aData[1] && aData[1].m_GlobFilter) {
                if (aData[1].m_GlobFilter.Included && aData[1].m_GlobFilter.Included.length === 0) {
                    aData[1].m_GlobFilter.Included.push("undefined");
                }
                if (aData[1].m_GlobFilter.Excluded && aData[1].m_GlobFilter.Excluded.length === 0) {
                    aData[1].m_GlobFilter.Excluded.push("undefined");
                }
            }
            const sPasswordA = yield DecryptStringWithKey(aData[1].m_SmtpServer.m_sPasswordEncMasterA, oWebGuSettings.key, oWebGuSettings.iv);
            const obj = {
                oDTP: oDTP,
                CProgramOptionsLocalOnly: aData[0],
                CProgramOptionsGlobal: aData[1],
                JobServerUserInformation: aData[2],
                webGuiOptions: oWebGuSettings.oOpts,
                sPassword: sPasswordA
            };
            const oMenu = CreateFloatMenu(jsFloatMenu["ProgramOptions"], { width: '650px', height: 600 }, obj, { minWidth: "40rem", minHeight: "30rem" });
            yield oMenu.promise;
            oWebGuSettings.oOpts = obj.webGuiOptions;
            localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
            if (obj.CProgramOptionsGlobal.m_GlobFilter) {
                if (obj.CProgramOptionsGlobal.m_GlobFilter.Included) {
                    for (let i = obj.CProgramOptionsGlobal.m_GlobFilter.Included.length - 1; i >= 0; i--) {
                        const sFilt = ("" + obj.CProgramOptionsGlobal.m_GlobFilter.Included[i]).trim();
                        if (!sFilt || sFilt == 'undefined') {
                            obj.CProgramOptionsGlobal.m_GlobFilter.Included.splice(i, 1);
                        }
                        for (let j = 0; j < i; j++) {
                            const sFilt2 = ("" + obj.CProgramOptionsGlobal.m_GlobFilter.Included[j]).trim();
                            if (sFilt == sFilt2) {
                                obj.CProgramOptionsGlobal.m_GlobFilter.Included.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
                if (obj.CProgramOptionsGlobal.m_GlobFilter.Excluded) {
                    for (let i = obj.CProgramOptionsGlobal.m_GlobFilter.Excluded.length - 1; i >= 0; i--) {
                        const sFilt = ("" + obj.CProgramOptionsGlobal.m_GlobFilter.Excluded[i]).trim();
                        if (!sFilt || sFilt == 'undefined') {
                            obj.CProgramOptionsGlobal.m_GlobFilter.Excluded.splice(i, 1);
                        }
                        for (let j = 0; j < i; j++) {
                            const sFilt2 = ("" + obj.CProgramOptionsGlobal.m_GlobFilter.Excluded[j]).trim();
                            if (sFilt == sFilt2) {
                                obj.CProgramOptionsGlobal.m_GlobFilter.Excluded.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
            }
            obj.CProgramOptionsGlobal.m_SmtpServer.m_sPasswordEncMasterA = yield EncryptStringWithKey(obj.sPassword, oWebGuSettings.key, oWebGuSettings.iv);
            obj.CProgramOptionsGlobal.m_SmtpServer.m_bUseOAuth2 = obj.CProgramOptionsGlobal.m_SmtpServer.m_OAuthProvider > 0;
            AsyncUnicSendRecivePostApiWithRetry("SetLocalProgramOptions", { "options": obj.CProgramOptionsLocalOnly });
            AsyncUnicSendRecivePostApiWithRetry("SetGlobalProgramOptions", { "options": obj.CProgramOptionsGlobal });
        }
        catch (_a) { }
    });
}
