export default class Settings {
    /**
     * Loads settings.
     */
    static load(): void;
    /**
     * Adds event listeners for all settings.
     */
    private static addEventListeners;
    /**
     * Adds general events for the setting.
     */
    private static addGeneralEvents;
    /**
     * Gets all settings as an object.
     */
    static getAllSettings(): Record<string, any>;
    /**
     * Updates the `_pageSettings.config`.
     */
    static updateInitSettings(newSettings: Record<string, any>): void;
    /**
     * Loads select box items.
     */
    private static loadSelectBoxEnums;
}
