/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.downloaditem.hls;

import ir.amirab.downloader.DownloadManager;
import ir.amirab.downloader.Downloader;
import ir.amirab.downloader.connection.HttpDownloaderClient;
import ir.amirab.downloader.downloaditem.IDownloadItem;
import ir.amirab.downloader.downloaditem.hls.HLSDownloadCredentials;
import ir.amirab.downloader.downloaditem.hls.HLSDownloadItem;
import ir.amirab.downloader.downloaditem.hls.HLSDownloadJob;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0014H\u0016R\u001b\u0010\u0005\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lir/amirab/downloader/downloaditem/hls/HLSDownloader;", "Lir/amirab/downloader/Downloader;", "Lir/amirab/downloader/downloaditem/hls/HLSDownloadItem;", "Lir/amirab/downloader/downloaditem/hls/HLSDownloadJob;", "Lir/amirab/downloader/downloaditem/hls/HLSDownloadCredentials;", "client", "Lkotlin/Lazy;", "Lir/amirab/downloader/connection/HttpDownloaderClient;", "<init>", "(Lkotlin/Lazy;)V", "getClient", "()Lir/amirab/downloader/connection/HttpDownloaderClient;", "client$delegate", "Lkotlin/Lazy;", "createJob", "item", "downloadManager", "Lir/amirab/downloader/DownloadManager;", "accept", "", "Lir/amirab/downloader/downloaditem/IDownloadItem;", "downloadItemClass", "Lkotlin/reflect/KClass;", "getDownloadItemClass", "()Lkotlin/reflect/KClass;", "downloadCredentialsClass", "getDownloadCredentialsClass", "downloadJobClass", "getDownloadJobClass", "downloadItemSerializer", "Lkotlinx/serialization/KSerializer;", "getDownloadItemSerializer", "()Lkotlinx/serialization/KSerializer;", "downloadCredentialsSerializer", "getDownloadCredentialsSerializer", "core"})
public final class HLSDownloader
implements Downloader<HLSDownloadItem, HLSDownloadJob, HLSDownloadCredentials> {
    @NotNull
    private final Lazy client$delegate;
    @NotNull
    private final KClass<HLSDownloadItem> downloadItemClass;
    @NotNull
    private final KClass<HLSDownloadCredentials> downloadCredentialsClass;
    @NotNull
    private final KClass<HLSDownloadJob> downloadJobClass;
    @NotNull
    private final KSerializer<HLSDownloadItem> downloadItemSerializer;
    @NotNull
    private final KSerializer<HLSDownloadCredentials> downloadCredentialsSerializer;

    public HLSDownloader(@NotNull Lazy<? extends HttpDownloaderClient> client) {
        Intrinsics.checkNotNullParameter(client, (String)"client");
        this.client$delegate = client;
        this.downloadItemClass = Reflection.getOrCreateKotlinClass(HLSDownloadItem.class);
        this.downloadCredentialsClass = Reflection.getOrCreateKotlinClass(HLSDownloadCredentials.class);
        this.downloadJobClass = Reflection.getOrCreateKotlinClass(HLSDownloadJob.class);
        this.downloadItemSerializer = HLSDownloadItem.Companion.serializer();
        this.downloadCredentialsSerializer = HLSDownloadCredentials.Companion.serializer();
    }

    @NotNull
    public final HttpDownloaderClient getClient() {
        Lazy lazy = this.client$delegate;
        return (HttpDownloaderClient)lazy.getValue();
    }

    @Override
    @NotNull
    public HLSDownloadJob createJob(@NotNull HLSDownloadItem item, @NotNull DownloadManager downloadManager) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        return new HLSDownloadJob(item, downloadManager, this.getClient());
    }

    @Override
    public boolean accept(@NotNull IDownloadItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item instanceof HLSDownloadItem;
    }

    @Override
    @NotNull
    public KClass<HLSDownloadItem> getDownloadItemClass() {
        return this.downloadItemClass;
    }

    @Override
    @NotNull
    public KClass<HLSDownloadCredentials> getDownloadCredentialsClass() {
        return this.downloadCredentialsClass;
    }

    @Override
    @NotNull
    public KClass<HLSDownloadJob> getDownloadJobClass() {
        return this.downloadJobClass;
    }

    @Override
    @NotNull
    public KSerializer<HLSDownloadItem> getDownloadItemSerializer() {
        return this.downloadItemSerializer;
    }

    @Override
    @NotNull
    public KSerializer<HLSDownloadCredentials> getDownloadCredentialsSerializer() {
        return this.downloadCredentialsSerializer;
    }
}

