/*
 * Decompiled with CFR 0.152.
 */
package coil3.memory;

import coil3.BitmapImage;
import coil3.EventListener;
import coil3.ImageLoader;
import coil3.decode.DataSource;
import coil3.intercept.EngineInterceptor;
import coil3.intercept.Interceptor;
import coil3.memory.MemoryCache;
import coil3.request.CachePolicy;
import coil3.request.ImageRequest;
import coil3.request.ImageRequestsKt;
import coil3.request.Options;
import coil3.request.RequestService;
import coil3.request.SuccessResult;
import coil3.size.Dimension;
import coil3.size.Precision;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeKt;
import coil3.util.Logger;
import coil3.util.UtilsKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J5\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001dJ0\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001f\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00020\u001b*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u0004\u0018\u00010)*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lcoil3/memory/MemoryCacheService;", "", "imageLoader", "Lcoil3/ImageLoader;", "requestService", "Lcoil3/request/RequestService;", "logger", "Lcoil3/util/Logger;", "<init>", "(Lcoil3/ImageLoader;Lcoil3/request/RequestService;Lcoil3/util/Logger;)V", "newCacheKey", "Lcoil3/memory/MemoryCache$Key;", "request", "Lcoil3/request/ImageRequest;", "mappedData", "options", "Lcoil3/request/Options;", "eventListener", "Lcoil3/EventListener;", "getCacheValue", "Lcoil3/memory/MemoryCache$Value;", "cacheKey", "size", "Lcoil3/size/Size;", "scale", "Lcoil3/size/Scale;", "isCacheValueValid", "", "cacheValue", "isCacheValueValid$coil_core", "isCacheValueValidForSize", "setCacheValue", "result", "Lcoil3/intercept/EngineInterceptor$ExecuteResult;", "newResult", "Lcoil3/request/SuccessResult;", "chain", "Lcoil3/intercept/Interceptor$Chain;", "isSampled", "(Lcoil3/memory/MemoryCache$Value;)Z", "diskCacheKey", "", "getDiskCacheKey", "(Lcoil3/memory/MemoryCache$Value;)Ljava/lang/String;", "Companion", "coil-core"})
@SourceDebugExtension(value={"SMAP\nMemoryCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCacheService.kt\ncoil3/memory/MemoryCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncoil3/util/LoggingKt\n+ 4 Dimension.kt\ncoil3/size/DimensionKt\n*L\n1#1,255:1\n1#2:256\n68#3,4:257\n68#3,4:261\n68#3,4:269\n68#3,4:273\n43#4:265\n43#4:266\n43#4:267\n43#4:268\n*S KotlinDebug\n*F\n+ 1 MemoryCacheService.kt\ncoil3/memory/MemoryCacheService\n*L\n92#1:257,4\n117#1:261,4\n183#1:269,4\n193#1:273,4\n139#1:265\n140#1:266\n143#1:267\n144#1:268\n*E\n"})
public final class MemoryCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final RequestService requestService;
    @Nullable
    private final Logger logger;
    @NotNull
    private static final String TAG = "MemoryCacheService";
    @NotNull
    public static final String EXTRA_SIZE = "coil#size";
    @NotNull
    public static final String EXTRA_IS_SAMPLED = "coil#is_sampled";
    @NotNull
    public static final String EXTRA_DISK_CACHE_KEY = "coil#disk_cache_key";

    public MemoryCacheService(@NotNull ImageLoader imageLoader, @NotNull RequestService requestService, @Nullable Logger logger) {
        this.imageLoader = imageLoader;
        this.requestService = requestService;
        this.logger = logger;
    }

    @Nullable
    public final MemoryCache.Key newCacheKey(@NotNull ImageRequest request, @NotNull Object mappedData, @NotNull Options options, @NotNull EventListener eventListener) {
        if (request.getMemoryCachePolicy() == CachePolicy.DISABLED) {
            return null;
        }
        if (request.getMemoryCacheKey() != null) {
            return new MemoryCache.Key(request.getMemoryCacheKey(), request.getMemoryCacheKeyExtras());
        }
        eventListener.keyStart(request, mappedData);
        String key = UtilsKt.key(this.imageLoader.getComponents(), mappedData, options, this.logger, TAG);
        eventListener.keyEnd(request, key);
        if (key == null) {
            return null;
        }
        if (!((Collection)ImageRequestsKt.getTransformations(request)).isEmpty()) {
            Map extras = MapsKt.toMutableMap(request.getMemoryCacheKeyExtras());
            extras.put(EXTRA_SIZE, options.getSize().toString());
            return new MemoryCache.Key(key, extras);
        }
        return new MemoryCache.Key(key, request.getMemoryCacheKeyExtras());
    }

    @Nullable
    public final MemoryCache.Value getCacheValue(@NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull Size size, @NotNull Scale scale) {
        MemoryCache.Value value;
        MemoryCache.Value cacheValue;
        if (!request.getMemoryCachePolicy().getReadEnabled()) {
            return null;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        MemoryCache.Value value2 = cacheValue = memoryCache != null ? memoryCache.get(cacheKey) : null;
        if (value2 != null) {
            MemoryCache.Value value3;
            MemoryCache.Value it = value3 = value2;
            boolean bl = false;
            value = this.isCacheValueValid$coil_core(request, cacheKey, it, size, scale) ? value3 : null;
        } else {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCacheValueValid$coil_core(@NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull MemoryCache.Value cacheValue, @NotNull Size size, @NotNull Scale scale) {
        if (!this.requestService.isCacheValueValidForHardware(request, cacheValue)) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                Logger.Level level$iv = Logger.Level.Debug;
                boolean $i$f$log = false;
                if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                    void tag$iv;
                    Logger.Level level = level$iv;
                    void var12_11 = tag$iv;
                    void var11_12 = $this$log$iv;
                    boolean bl = false;
                    String string2 = request.getData() + ": Cached bitmap is hardware-backed, which is incompatible with the request.";
                    var11_12.log((String)var12_11, level, string2, null);
                }
            }
            return false;
        }
        return this.isCacheValueValidForSize(request, cacheKey, cacheValue, size, scale);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValueValidForSize(ImageRequest request, MemoryCache.Key cacheKey, MemoryCache.Value cacheValue, Size size, Scale scale) {
        int n;
        int n2;
        int n3;
        int n4;
        String cacheKeySize = cacheKey.getExtras().get(EXTRA_SIZE);
        if (cacheKeySize != null) {
            if (Intrinsics.areEqual((Object)cacheKeySize, (Object)size.toString())) {
                return true;
            }
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                Logger.Level level$iv = Logger.Level.Debug;
                boolean $i$f$log = false;
                if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                    void tag$iv;
                    Logger.Level level = level$iv;
                    void var25_19 = tag$iv;
                    void var24_22 = $this$log$iv;
                    boolean bl = false;
                    String string2 = request.getData() + ": Memory cached image's size (" + cacheKeySize + ") does not exactly match the target size (" + size + ").";
                    var24_22.log((String)var25_19, level, string2, null);
                }
            }
            return false;
        }
        if (!this.isSampled(cacheValue) && (SizeKt.isOriginal(size) || request.getPrecision() == Precision.INEXACT)) {
            return true;
        }
        int srcWidth = cacheValue.getImage().getWidth();
        int srcHeight = cacheValue.getImage().getHeight();
        Size maxSize = cacheValue.getImage() instanceof BitmapImage ? ImageRequestsKt.getMaxBitmapSize(request) : Size.ORIGINAL;
        Dimension $this$pxOrElse$iv22 = size.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv22 instanceof Dimension.Pixels) {
            n4 = ((Dimension.Pixels)$this$pxOrElse$iv22).unbox-impl();
        } else {
            boolean bl = false;
            n4 = Integer.MAX_VALUE;
        }
        int $this$pxOrElse$iv22 = n4;
        Dimension $this$pxOrElse$iv32 = maxSize.getWidth();
        boolean $i$f$pxOrElse2 = false;
        if ($this$pxOrElse$iv32 instanceof Dimension.Pixels) {
            n3 = ((Dimension.Pixels)$this$pxOrElse$iv32).unbox-impl();
        } else {
            boolean bl = false;
            n3 = Integer.MAX_VALUE;
        }
        int $this$pxOrElse$iv32 = n3;
        int dstWidth = Math.min($this$pxOrElse$iv22, $this$pxOrElse$iv32);
        Dimension $this$pxOrElse$iv42 = size.getHeight();
        $i$f$pxOrElse2 = false;
        if ($this$pxOrElse$iv42 instanceof Dimension.Pixels) {
            n2 = ((Dimension.Pixels)$this$pxOrElse$iv42).unbox-impl();
        } else {
            boolean bl = false;
            n2 = Integer.MAX_VALUE;
        }
        int $this$pxOrElse$iv42 = n2;
        Dimension $this$pxOrElse$iv = maxSize.getHeight();
        boolean $i$f$pxOrElse3 = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            boolean bl = false;
            n = Integer.MAX_VALUE;
        }
        int n5 = n;
        int dstHeight = Math.min($this$pxOrElse$iv42, n5);
        double multiplier = 0.0;
        int difference = 0;
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        switch (WhenMappings.$EnumSwitchMapping$0[(dstWidth != Integer.MAX_VALUE && dstHeight != Integer.MAX_VALUE ? scale : Scale.FIT).ordinal()]) {
            case 1: {
                if (widthPercent > heightPercent) {
                    multiplier = widthPercent;
                    difference = Math.abs(dstWidth - srcWidth);
                    break;
                }
                multiplier = heightPercent;
                difference = Math.abs(dstHeight - srcHeight);
                break;
            }
            case 2: {
                if (widthPercent < heightPercent) {
                    multiplier = widthPercent;
                    difference = Math.abs(dstWidth - srcWidth);
                    break;
                }
                multiplier = heightPercent;
                difference = Math.abs(dstHeight - srcHeight);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (difference <= 1) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[request.getPrecision().ordinal()]) {
            case 1: {
                if (multiplier == 1.0) {
                    return true;
                }
                Logger logger = this.logger;
                if (logger != null) {
                    void $this$log$iv;
                    Logger logger3 = logger;
                    String string = TAG;
                    Logger.Level level$iv = Logger.Level.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                        void tag$iv;
                        Logger.Level level = level$iv;
                        void var25_20 = tag$iv;
                        void var24_23 = $this$log$iv;
                        boolean bl = false;
                        String string3 = request.getData() + ": Memory cached image's size (" + srcWidth + ", " + srcHeight + ") does not exactly match the target size (" + dstWidth + ", " + dstHeight + ").";
                        var24_23.log((String)var25_20, level, string3, null);
                    }
                }
                return false;
            }
            case 2: {
                if (multiplier <= 1.0) {
                    return true;
                }
                Logger logger = this.logger;
                if (logger != null) {
                    Logger $this$log$iv = logger;
                    String tag$iv = TAG;
                    Logger.Level level$iv = Logger.Level.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                        Logger.Level level = level$iv;
                        String string = tag$iv;
                        Logger logger4 = $this$log$iv;
                        boolean bl = false;
                        String string4 = request.getData() + ": Memory cached image's size (" + srcWidth + ", " + srcHeight + ") is smaller than the target size (" + dstWidth + ", " + dstHeight + ").";
                        logger4.log(string, level, string4, null);
                    }
                }
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final boolean setCacheValue(@Nullable MemoryCache.Key cacheKey, @NotNull ImageRequest request, @NotNull EngineInterceptor.ExecuteResult result2) {
        if (cacheKey == null || !request.getMemoryCachePolicy().getWriteEnabled() || !result2.getImage().getShareable()) {
            return false;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        if (memoryCache == null) {
            return false;
        }
        MemoryCache memoryCache2 = memoryCache;
        Map extras = new LinkedHashMap();
        extras.put(EXTRA_IS_SAMPLED, result2.isSampled());
        String string = result2.getDiskCacheKey();
        if (string != null) {
            String it = string;
            boolean bl = false;
            extras.put(EXTRA_DISK_CACHE_KEY, it);
        }
        memoryCache2.set(cacheKey, new MemoryCache.Value(result2.getImage(), extras));
        return true;
    }

    @NotNull
    public final SuccessResult newResult(@NotNull Interceptor.Chain chain, @NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull MemoryCache.Value cacheValue) {
        return new SuccessResult(cacheValue.getImage(), request, DataSource.MEMORY_CACHE, cacheKey, this.getDiskCacheKey(cacheValue), this.isSampled(cacheValue), UtilsKt.isPlaceholderCached(chain));
    }

    private final boolean isSampled(MemoryCache.Value $this$isSampled) {
        Object object = $this$isSampled.getExtras().get(EXTRA_IS_SAMPLED);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private final String getDiskCacheKey(MemoryCache.Value $this$diskCacheKey) {
        Object object = $this$diskCacheKey.getExtras().get(EXTRA_DISK_CACHE_KEY);
        return object instanceof String ? (String)object : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil3/memory/MemoryCacheService$Companion;", "", "<init>", "()V", "TAG", "", "EXTRA_SIZE", "EXTRA_IS_SAMPLED", "EXTRA_DISK_CACHE_KEY", "coil-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scale.FIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Precision.values().length];
            try {
                nArray[Precision.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Precision.INEXACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

