/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.pages.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.font.FontFamily;
import com.abdownloadmanager.desktop.pages.settings.FontFamilyUtil;
import com.abdownloadmanager.desktop.pages.settings.FontInfo;
import com.abdownloadmanager.desktop.storage.AppSettingsStorage;
import com.abdownloadmanager.resources.Res;
import ir.amirab.util.GuardedEntry;
import ir.amirab.util.GuardedEntryKt;
import ir.amirab.util.compose.StringSourceKt;
import ir.amirab.util.flow.StateFlowUtilKt;
import java.awt.GraphicsEnvironment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u001d\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/abdownloadmanager/desktop/pages/settings/FontManager;", "", "appSettings", "Lcom/abdownloadmanager/desktop/storage/AppSettingsStorage;", "<init>", "(Lcom/abdownloadmanager/desktop/storage/AppSettingsStorage;)V", "_availableFonts", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/abdownloadmanager/desktop/pages/settings/FontInfo;", "availableFonts", "Lkotlinx/coroutines/flow/StateFlow;", "getAvailableFonts", "()Lkotlinx/coroutines/flow/StateFlow;", "getFontByUri", "Landroidx/compose/ui/text/font/FontFamily;", "uri", "", "selectableFonts", "getSelectableFonts", "currentFontInfo", "getCurrentFontInfo", "currentFontFamily", "getCurrentFontFamily", "setFont", "", "fontId", "booted", "Lir/amirab/util/GuardedEntry;", "boot", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontManager.kt\ncom/abdownloadmanager/desktop/pages/settings/FontManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,169:1\n1#2:170\n1#2:182\n1642#3,10:171\n1915#3:181\n1916#3:183\n1652#3:184\n230#4,5:185\n*S KotlinDebug\n*F\n+ 1 FontManager.kt\ncom/abdownloadmanager/desktop/pages/settings/FontManager\n*L\n97#1:182\n97#1:171,10\n97#1:181\n97#1:183\n97#1:184\n120#1:185,5\n*E\n"})
public final class FontManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppSettingsStorage appSettings;
    @NotNull
    private final MutableStateFlow<List<FontInfo>> _availableFonts;
    @NotNull
    private final StateFlow<List<FontInfo>> availableFonts;
    @NotNull
    private final StateFlow<List<FontInfo>> selectableFonts;
    @NotNull
    private final StateFlow<FontInfo> currentFontInfo;
    @NotNull
    private final StateFlow<FontFamily> currentFontFamily;
    @NotNull
    private final GuardedEntry booted;
    public static final int $stable = 8;
    @NotNull
    private static final String DEFAULT_FONT_ID = "default";
    @NotNull
    private static final FontInfo defaultFontInfo = new FontInfo("default", "", StringSourceKt.asStringSource-HhCFyaE((String)Res.INSTANCE.getString().getDefault-rO2e7mk()), (FontFamily)FontFamily.Companion.getDefault());

    public FontManager(@NotNull AppSettingsStorage appSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)appSettings), (String)"appSettings");
        this.appSettings = appSettings;
        this._availableFonts = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.availableFonts = FlowKt.asStateFlow(this._availableFonts);
        this.selectableFonts = StateFlowUtilKt.mapStateFlow(this.availableFonts, FontManager::selectableFonts$lambda$0);
        this.currentFontInfo = StateFlowUtilKt.combineStateFlows((StateFlow)((StateFlow)this.appSettings.getFont()), this.selectableFonts, FontManager::currentFontInfo$lambda$0);
        this.currentFontFamily = StateFlowUtilKt.mapStateFlow(this.currentFontInfo, FontManager::currentFontFamily$lambda$0);
        this.booted = GuardedEntryKt.guardedEntry();
    }

    @NotNull
    public final StateFlow<List<FontInfo>> getAvailableFonts() {
        return this.availableFonts;
    }

    private final FontFamily getFontByUri(String uri) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                FontManager $this$getFontByUri_u24lambda_u240 = object;
                boolean bl = false;
                URI uRI = URI.create(uri);
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                object2 = Result.constructor-impl((Object)FontFamilyUtil.INSTANCE.fromUri(uRI));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        return (FontFamily)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public final StateFlow<List<FontInfo>> getSelectableFonts() {
        return this.selectableFonts;
    }

    @NotNull
    public final StateFlow<FontInfo> getCurrentFontInfo() {
        return this.currentFontInfo;
    }

    @NotNull
    public final StateFlow<FontFamily> getCurrentFontFamily() {
        return this.currentFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setFont(@Nullable String fontId) {
        FontManager fontManager = this;
        synchronized (fontManager) {
            void it;
            FontInfo font;
            FontInfo fontInfo;
            Object v1;
            Object object;
            block6: {
                boolean bl = false;
                String string = fontId;
                if (string == null) {
                    string = DEFAULT_FONT_ID;
                }
                String fontId2 = string;
                object = (Iterable)this.availableFonts.getValue();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    FontInfo it2 = (FontInfo)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)fontId2)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if ((fontInfo = (FontInfo)v1) == null) {
                fontInfo = defaultFontInfo;
            }
            FontInfo fontInfo2 = font = fontInfo;
            object = fontInfo2;
            MutableStateFlow<String> mutableStateFlow = this.appSettings.getFont();
            boolean bl = false;
            FontInfo fontInfo3 = Boolean.valueOf(!Intrinsics.areEqual((Object)it, (Object)defaultFontInfo)) != false ? fontInfo2 : null;
            mutableStateFlow.setValue((Object)(fontInfo3 != null ? fontInfo3.getUri() : null));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void boot() {
        this.booted.action(() -> FontManager.boot$lambda$0(this));
    }

    private static final List selectableFonts$lambda$0(List it) {
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List $this$selectableFonts_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$selectableFonts_u24lambda_u240_u240.add(defaultFontInfo);
        $this$selectableFonts_u24lambda_u240_u240.addAll(it);
        return CollectionsKt.build((List)list);
    }

    private static final FontInfo currentFontInfo$lambda$0(String fontId, List possibleFonts) {
        FontInfo fontInfo;
        Object v1;
        FontInfo it;
        Iterable iterable;
        block4: {
            Intrinsics.checkNotNullParameter((Object)possibleFonts, (String)"possibleFonts");
            String string = fontId;
            if (string == null) {
                string = DEFAULT_FONT_ID;
            }
            String fontId2 = string;
            iterable = possibleFonts;
            for (Object t : iterable) {
                it = (FontInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)fontId2)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((fontInfo = (FontInfo)v1) == null) {
            Object v3;
            block5: {
                iterable = possibleFonts;
                for (Object t : iterable) {
                    it = (FontInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)DEFAULT_FONT_ID)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            Intrinsics.checkNotNull(v3);
            fontInfo = v3;
        }
        return fontInfo;
    }

    private static final FontFamily currentFontFamily$lambda$0(FontInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFontFamily();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit boot$lambda$0(FontManager this$0) {
        List it;
        List nextValue$iv;
        Object prevValue$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = Companion.getUsableFontFamilyNamesOfSystem();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FontInfo it$iv$iv;
            FontFamily fontFamily;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String fontFamilyName = (String)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this$0;
            try {
                FontManager $this$boot_u24lambda_u240_u240_u240 = object2;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)new URI("system", fontFamilyName, null).toString());
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object throwable2 = object = throwable;
                boolean bl4 = false;
                System.out.println((Object)("system font family with name:\"" + fontFamilyName + "\" can't be used: " + (Throwable)throwable2));
            }
            String uri = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
            if ((uri == null ? null : ((fontFamily = this$0.getFontByUri(uri)) == null ? null : new FontInfo(uri, uri, StringSourceKt.asStringSource((String)fontFamilyName), fontFamily))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List systemFontFamilies = (List)destination$iv$iv;
        MutableStateFlow<List<FontInfo>> $this$update$iv = this$0._availableFonts;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (List)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CollectionsKt.plus((Collection)it, (Iterable)systemFontFamilies))));
        this$0.setFont((String)this$0.appSettings.getFont().getValue());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/abdownloadmanager/desktop/pages/settings/FontManager$Companion;", "", "<init>", "()V", "DEFAULT_FONT_ID", "", "defaultFontInfo", "Lcom/abdownloadmanager/desktop/pages/settings/FontInfo;", "getDefaultFontInfo", "()Lcom/abdownloadmanager/desktop/pages/settings/FontInfo;", "getUsableFontFamilyNamesOfSystem", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontInfo getDefaultFontInfo() {
            return defaultFontInfo;
        }

        @NotNull
        public final List<String> getUsableFontFamilyNamesOfSystem() {
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAvailableFontFamilyNames(...)");
            return ArraysKt.toList((Object[])stringArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

