/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.downloaditem.http;

import ir.amirab.downloader.DownloadManager;
import ir.amirab.downloader.Downloader;
import ir.amirab.downloader.connection.HttpDownloaderClient;
import ir.amirab.downloader.downloaditem.IDownloadItem;
import ir.amirab.downloader.downloaditem.http.HttpDownloadCredentials;
import ir.amirab.downloader.downloaditem.http.HttpDownloadItem;
import ir.amirab.downloader.downloaditem.http.HttpDownloadJob;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0014H\u0016R\u001b\u0010\u0005\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lir/amirab/downloader/downloaditem/http/HttpDownloader;", "Lir/amirab/downloader/Downloader;", "Lir/amirab/downloader/downloaditem/http/HttpDownloadItem;", "Lir/amirab/downloader/downloaditem/http/HttpDownloadJob;", "Lir/amirab/downloader/downloaditem/http/HttpDownloadCredentials;", "httpDownloaderClient", "Lkotlin/Lazy;", "Lir/amirab/downloader/connection/HttpDownloaderClient;", "<init>", "(Lkotlin/Lazy;)V", "getHttpDownloaderClient", "()Lir/amirab/downloader/connection/HttpDownloaderClient;", "httpDownloaderClient$delegate", "Lkotlin/Lazy;", "createJob", "item", "downloadManager", "Lir/amirab/downloader/DownloadManager;", "accept", "", "Lir/amirab/downloader/downloaditem/IDownloadItem;", "downloadItemClass", "Lkotlin/reflect/KClass;", "getDownloadItemClass", "()Lkotlin/reflect/KClass;", "downloadCredentialsClass", "getDownloadCredentialsClass", "downloadJobClass", "getDownloadJobClass", "downloadItemSerializer", "Lkotlinx/serialization/KSerializer;", "getDownloadItemSerializer", "()Lkotlinx/serialization/KSerializer;", "downloadCredentialsSerializer", "getDownloadCredentialsSerializer", "core"})
public final class HttpDownloader
implements Downloader<HttpDownloadItem, HttpDownloadJob, HttpDownloadCredentials> {
    @NotNull
    private final Lazy httpDownloaderClient$delegate;
    @NotNull
    private final KClass<HttpDownloadItem> downloadItemClass;
    @NotNull
    private final KClass<HttpDownloadCredentials> downloadCredentialsClass;
    @NotNull
    private final KClass<HttpDownloadJob> downloadJobClass;
    @NotNull
    private final KSerializer<HttpDownloadItem> downloadItemSerializer;
    @NotNull
    private final KSerializer<HttpDownloadCredentials> downloadCredentialsSerializer;

    public HttpDownloader(@NotNull Lazy<? extends HttpDownloaderClient> httpDownloaderClient) {
        Intrinsics.checkNotNullParameter(httpDownloaderClient, (String)"httpDownloaderClient");
        this.httpDownloaderClient$delegate = httpDownloaderClient;
        this.downloadItemClass = Reflection.getOrCreateKotlinClass(HttpDownloadItem.class);
        this.downloadCredentialsClass = Reflection.getOrCreateKotlinClass(HttpDownloadCredentials.class);
        this.downloadJobClass = Reflection.getOrCreateKotlinClass(HttpDownloadJob.class);
        this.downloadItemSerializer = HttpDownloadItem.Companion.serializer();
        this.downloadCredentialsSerializer = HttpDownloadCredentials.Companion.serializer();
    }

    @NotNull
    public final HttpDownloaderClient getHttpDownloaderClient() {
        Lazy lazy = this.httpDownloaderClient$delegate;
        return (HttpDownloaderClient)lazy.getValue();
    }

    @Override
    @NotNull
    public HttpDownloadJob createJob(@NotNull HttpDownloadItem item, @NotNull DownloadManager downloadManager) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        return new HttpDownloadJob(item, downloadManager, this.getHttpDownloaderClient());
    }

    @Override
    public boolean accept(@NotNull IDownloadItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item instanceof HttpDownloadItem;
    }

    @Override
    @NotNull
    public KClass<HttpDownloadItem> getDownloadItemClass() {
        return this.downloadItemClass;
    }

    @Override
    @NotNull
    public KClass<HttpDownloadCredentials> getDownloadCredentialsClass() {
        return this.downloadCredentialsClass;
    }

    @Override
    @NotNull
    public KClass<HttpDownloadJob> getDownloadJobClass() {
        return this.downloadJobClass;
    }

    @Override
    @NotNull
    public KSerializer<HttpDownloadItem> getDownloadItemSerializer() {
        return this.downloadItemSerializer;
    }

    @Override
    @NotNull
    public KSerializer<HttpDownloadCredentials> getDownloadCredentialsSerializer() {
        return this.downloadCredentialsSerializer;
    }
}

