/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.destination;

import ir.amirab.downloader.destination.DestWriter;
import ir.amirab.downloader.destination.DownloadDestination;
import ir.amirab.downloader.destination.IncompleteFileUtil;
import ir.amirab.downloader.part.DownloadPart;
import ir.amirab.downloader.utils.EmptyFileCreator;
import ir.amirab.util.FileExtensionsKt;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileHandle;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\u001e\u0010\u001f\u001a\u00020\u001d2\u0014\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\u001d0!H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J$\u0010,\u001a\u00020\u001d2\u0014\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\u001d0!H\u0096@\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u00020\u001dH\u0014J\u0010\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u0003H\u0016J\b\u00104\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010#\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010&\u00a8\u00065"}, d2={"Lir/amirab/downloader/destination/SimpleDownloadDestination;", "Lir/amirab/downloader/destination/DownloadDestination;", "file", "Ljava/io/File;", "appendExtensionToIncompleteDownloads", "", "downloadId", "", "emptyFileCreator", "Lir/amirab/downloader/utils/EmptyFileCreator;", "<init>", "(Ljava/io/File;ZJLir/amirab/downloader/utils/EmptyFileCreator;)V", "getAppendExtensionToIncompleteDownloads", "()Z", "getDownloadId", "()J", "incompleteFile", "getIncompleteFile", "()Ljava/io/File;", "incompleteFile$delegate", "Lkotlin/Lazy;", "fileToWrite", "_fileHandle", "Lokio/FileHandle;", "fileHandle", "getFileHandle", "()Lokio/FileHandle;", "initFileHandle", "removeFileHandle", "", "onAllFilePartsRemoved", "onAllPartsCompleted", "onProgressUpdate", "Lkotlin/Function1;", "", "outputSize", "getOutputSize", "setOutputSize", "(J)V", "getWriterFor", "Lir/amirab/downloader/destination/DestWriter;", "part", "Lir/amirab/downloader/part/DownloadPart;", "flush", "prepareFile", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDownloadedPartsIsValid", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canGetFileWriter", "updateLastModified", "moveOutput", "to", "cleanUpJunkFiles", "core"})
@SourceDebugExtension(value={"SMAP\nSimpleDownloadDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleDownloadDestination.kt\nir/amirab/downloader/destination/SimpleDownloadDestination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class SimpleDownloadDestination
extends DownloadDestination {
    private final boolean appendExtensionToIncompleteDownloads;
    private final long downloadId;
    @NotNull
    private final EmptyFileCreator emptyFileCreator;
    @NotNull
    private final Lazy incompleteFile$delegate;
    @NotNull
    private final File fileToWrite;
    @Nullable
    private FileHandle _fileHandle;
    private long outputSize;

    public SimpleDownloadDestination(@NotNull File file, boolean appendExtensionToIncompleteDownloads, long downloadId, @NotNull EmptyFileCreator emptyFileCreator) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)emptyFileCreator, (String)"emptyFileCreator");
        super(file);
        this.appendExtensionToIncompleteDownloads = appendExtensionToIncompleteDownloads;
        this.downloadId = downloadId;
        this.emptyFileCreator = emptyFileCreator;
        this.incompleteFile$delegate = LazyKt.lazy(() -> SimpleDownloadDestination.incompleteFile_delegate$lambda$0(this));
        if (this.appendExtensionToIncompleteDownloads) {
            file2 = this.getIncompleteFile();
        } else {
            File file3 = this.getOutputFile();
            Intrinsics.checkNotNull((Object)file3);
            file2 = file3;
        }
        this.fileToWrite = file2;
        this.outputSize = -1L;
    }

    public final boolean getAppendExtensionToIncompleteDownloads() {
        return this.appendExtensionToIncompleteDownloads;
    }

    public final long getDownloadId() {
        return this.downloadId;
    }

    @NotNull
    public final File getIncompleteFile() {
        Lazy lazy = this.incompleteFile$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileHandle getFileHandle() {
        SimpleDownloadDestination simpleDownloadDestination = this;
        synchronized (simpleDownloadDestination) {
            block4: {
                boolean bl = false;
                if (this._fileHandle != null) break block4;
                FileHandle fileHandle = this.initFileHandle();
                return fileHandle;
            }
            Unit unit = Unit.INSTANCE;
        }
        FileHandle fileHandle = this._fileHandle;
        Intrinsics.checkNotNull((Object)fileHandle);
        return fileHandle;
    }

    private final FileHandle initFileHandle() {
        FileHandle handle;
        this._fileHandle = handle = FileSystem.SYSTEM.openReadWrite(Path.Companion.get$default((Path.Companion)Path.Companion, (File)this.fileToWrite, (boolean)false, (int)1, null));
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFileHandle() {
        SimpleDownloadDestination simpleDownloadDestination = this;
        synchronized (simpleDownloadDestination) {
            boolean bl = false;
            FileHandle fileHandle = this._fileHandle;
            if (fileHandle != null) {
                fileHandle.close();
            }
            this._fileHandle = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    protected void onAllFilePartsRemoved() {
        super.onAllFilePartsRemoved();
        this.removeFileHandle();
    }

    @Override
    public void onAllPartsCompleted(@NotNull Function1<? super Integer, Unit> onProgressUpdate) {
        Intrinsics.checkNotNullParameter(onProgressUpdate, (String)"onProgressUpdate");
        if (this.appendExtensionToIncompleteDownloads) {
            File incompleteFile = this.getIncompleteFile();
            if (!incompleteFile.exists()) {
                return;
            }
            File completeFile = this.getOutputFile();
            if (completeFile.exists()) {
                completeFile.delete();
            }
            try {
                Intrinsics.checkNotNull((Object)completeFile);
                FileExtensionsKt.tryAtomicMove((File)incompleteFile, (File)completeFile);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to move .part file to the actual output file! " + e.getLocalizedMessage(), e);
            }
        }
        super.onAllPartsCompleted(onProgressUpdate);
    }

    public final long getOutputSize() {
        return this.outputSize;
    }

    public final void setOutputSize(long l) {
        this.outputSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DestWriter getWriterFor(@NotNull DownloadPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        if (!this.canGetFileWriter()) {
            throw new IllegalStateException("First check then ask for...");
        }
        File outFile = this.fileToWrite;
        DestWriter returned = this.returnIfAlreadyHaveWriter(part.getID());
        if (returned != null) {
            DestWriter it = returned;
            boolean bl = false;
            return it;
        }
        DestWriter writer = new DestWriter(part.getID(), outFile, part.getCurrent(), this.getFileHandle());
        SimpleDownloadDestination simpleDownloadDestination = this;
        synchronized (simpleDownloadDestination) {
            boolean bl = false;
            boolean bl2 = this.getFileParts().add(writer);
        }
        return writer;
    }

    @Override
    public void flush() {
        SimpleDownloadDestination simpleDownloadDestination = this;
        try {
            Unit unit;
            SimpleDownloadDestination $this$flush_u24lambda_u240 = simpleDownloadDestination;
            boolean bl = false;
            FileHandle fileHandle = $this$flush_u24lambda_u240._fileHandle;
            if (fileHandle != null) {
                fileHandle.flush();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @Override
    @Nullable
    public Object prepareFile(@NotNull Function1<? super Integer, Unit> onProgressUpdate, @NotNull Continuation<? super Unit> $completion) {
        File incompleteFile = this.fileToWrite;
        File it = incompleteFile.getParentFile();
        boolean bl = false;
        it.getCanonicalFile().mkdirs();
        if (!it.exists()) {
            throw new IllegalStateException(("can't create folder for destination file " + it).toString());
        }
        if (!it.isDirectory()) {
            throw new IllegalStateException((incompleteFile.getParentFile() + " is not a directory").toString());
        }
        Object object = this.emptyFileCreator.prepareFile(incompleteFile, this.outputSize, onProgressUpdate, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object isDownloadedPartsIsValid(@NotNull Continuation<? super Boolean> $completion) {
        File targetFile = this.fileToWrite;
        boolean fileExists = targetFile.exists();
        boolean fileEqualToContentSize = targetFile.length() == this.outputSize;
        return Boxing.boxBoolean((fileExists && fileEqualToContentSize ? 1 : 0) != 0);
    }

    @Override
    public boolean canGetFileWriter() {
        return true;
    }

    @Override
    protected void updateLastModified() {
        SimpleDownloadDestination simpleDownloadDestination = this;
        try {
            Boolean bl;
            SimpleDownloadDestination $this$updateLastModified_u24lambda_u240 = simpleDownloadDestination;
            boolean bl2 = false;
            Long l = $this$updateLastModified_u24lambda_u240.getRequestedToChangeLastModified();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                bl = $this$updateLastModified_u24lambda_u240.fileToWrite.setLastModified(it);
            } else {
                bl = null;
            }
            Object object = Result.constructor-impl(bl);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @Override
    public void moveOutput(@NotNull File to) {
        File incompleteFile;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (this.appendExtensionToIncompleteDownloads && (incompleteFile = this.getIncompleteFile()).exists()) {
            try {
                FileExtensionsKt.tryAtomicMove((File)incompleteFile, (File)IncompleteFileUtil.INSTANCE.addIncompleteIndicator(to, this.downloadId));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to move .part file to the new destination: " + e.getLocalizedMessage(), e);
            }
        }
        super.moveOutput(to);
    }

    @Override
    public void cleanUpJunkFiles() {
        File incompleteFile = this.getIncompleteFile();
        if (incompleteFile.exists()) {
            incompleteFile.delete();
        }
    }

    private static final File incompleteFile_delegate$lambda$0(SimpleDownloadDestination this$0) {
        File file = this$0.getOutputFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"<get-outputFile>(...)");
        return IncompleteFileUtil.INSTANCE.addIncompleteIndicator(file, this$0.downloadId);
    }
}

