/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.Skip;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

public enum SkipAttribute implements Attribute<Skip, Skip.Builder>
{
    SKIPPED_SEGMENTS{

        @Override
        public void read(Skip.Builder builder, String value) throws PlaylistParserException {
            builder.skippedSegments(Long.parseLong(value));
        }

        @Override
        public void write(Skip value, TextBuilder textBuilder) {
            textBuilder.add(this.key(), Long.toString(value.skippedSegments()));
        }
    }
    ,
    RECENTLY_REMOVED_DATERANGES{

        @Override
        public void read(Skip.Builder builder, String value) throws PlaylistParserException {
            builder.recentlyRemovedDateRanges(ParserUtils.split(value, "\t"));
        }

        @Override
        public void write(Skip value, TextBuilder textBuilder) {
            if (!value.recentlyRemovedDateRanges().isEmpty()) {
                textBuilder.addQuoted(this.key(), String.join((CharSequence)"\t", value.recentlyRemovedDateRanges()));
            }
        }
    };

    static final Map<String, SkipAttribute> attributeMap;

    static Skip parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        Skip.Builder builder = Skip.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(SkipAttribute.values(), Attribute::key);
    }
}

