/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.SessionData;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class SessionDataBuilder {
    private static final long INIT_BIT_DATA_ID = 1L;
    private long initBits = 1L;
    private String dataId;
    private String value;
    private String uri;
    private String language;

    SessionDataBuilder() {
        if (!(this instanceof SessionData.Builder)) {
            throw new UnsupportedOperationException("Use: new SessionData.Builder()");
        }
    }

    public final SessionData.Builder from(SessionData instance) {
        Optional<String> languageOptional;
        Optional<String> uriOptional;
        Objects.requireNonNull(instance, "instance");
        this.dataId(instance.dataId());
        Optional<String> valueOptional = instance.value();
        if (valueOptional.isPresent()) {
            this.value(valueOptional);
        }
        if ((uriOptional = instance.uri()).isPresent()) {
            this.uri(uriOptional);
        }
        if ((languageOptional = instance.language()).isPresent()) {
            this.language(languageOptional);
        }
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder dataId(String dataId) {
        this.dataId = Objects.requireNonNull(dataId, "dataId");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder value(Optional<String> value) {
        this.value = value.orElse(null);
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder uri(Optional<String> uri) {
        this.uri = uri.orElse(null);
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder language(String language) {
        this.language = Objects.requireNonNull(language, "language");
        return (SessionData.Builder)this;
    }

    public final SessionData.Builder language(Optional<String> language) {
        this.language = language.orElse(null);
        return (SessionData.Builder)this;
    }

    public SessionData build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableSessionData(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("dataId");
        }
        return "Cannot build SessionData, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableSessionData
    implements SessionData {
        private final String dataId;
        private final String value;
        private final String uri;
        private final String language;

        private ImmutableSessionData(SessionDataBuilder builder) {
            this.dataId = builder.dataId;
            this.value = builder.value;
            this.uri = builder.uri;
            this.language = builder.language;
        }

        @Override
        public String dataId() {
            return this.dataId;
        }

        @Override
        public Optional<String> value() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public Optional<String> uri() {
            return Optional.ofNullable(this.uri);
        }

        @Override
        public Optional<String> language() {
            return Optional.ofNullable(this.language);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableSessionData && this.equalTo((ImmutableSessionData)another);
        }

        private boolean equalTo(ImmutableSessionData another) {
            return this.dataId.equals(another.dataId) && Objects.equals(this.value, another.value) && Objects.equals(this.uri, another.uri) && Objects.equals(this.language, another.language);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.dataId.hashCode();
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Objects.hashCode(this.uri);
            h += (h << 5) + Objects.hashCode(this.language);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SessionData{");
            builder.append("dataId=").append(this.dataId);
            if (this.value != null) {
                builder.append(", ");
                builder.append("value=").append(this.value);
            }
            if (this.uri != null) {
                builder.append(", ");
                builder.append("uri=").append(this.uri);
            }
            if (this.language != null) {
                builder.append(", ");
                builder.append("language=").append(this.language);
            }
            return builder.append("}").toString();
        }
    }
}

