/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.PartialSegmentInformation;
import java.util.ArrayList;
import java.util.Objects;

class PartialSegmentInformationBuilder {
    private static final long INIT_BIT_PART_TARGET_DURATION = 1L;
    private long initBits = 1L;
    private double partTargetDuration;

    PartialSegmentInformationBuilder() {
        if (!(this instanceof PartialSegmentInformation.Builder)) {
            throw new UnsupportedOperationException("Use: new PartialSegmentInformation.Builder()");
        }
    }

    public final PartialSegmentInformation.Builder from(PartialSegmentInformation instance) {
        Objects.requireNonNull(instance, "instance");
        this.partTargetDuration(instance.partTargetDuration());
        return (PartialSegmentInformation.Builder)this;
    }

    public final PartialSegmentInformation.Builder partTargetDuration(double partTargetDuration) {
        this.partTargetDuration = partTargetDuration;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (PartialSegmentInformation.Builder)this;
    }

    public PartialSegmentInformation build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutablePartialSegmentInformation(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("partTargetDuration");
        }
        return "Cannot build PartialSegmentInformation, some of required attributes are not set " + attributes;
    }

    private static final class ImmutablePartialSegmentInformation
    implements PartialSegmentInformation {
        private final double partTargetDuration;

        private ImmutablePartialSegmentInformation(PartialSegmentInformationBuilder builder) {
            this.partTargetDuration = builder.partTargetDuration;
        }

        @Override
        public double partTargetDuration() {
            return this.partTargetDuration;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePartialSegmentInformation && this.equalTo((ImmutablePartialSegmentInformation)another);
        }

        private boolean equalTo(ImmutablePartialSegmentInformation another) {
            return Double.doubleToLongBits(this.partTargetDuration) == Double.doubleToLongBits(another.partTargetDuration);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Double.hashCode(this.partTargetDuration);
            return h;
        }

        public String toString() {
            return "PartialSegmentInformation{partTargetDuration=" + this.partTargetDuration + "}";
        }
    }
}

