/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Status;
import org.http4k.core.UriTemplate;
import org.http4k.routing.RouteMatcher;
import org.http4k.routing.Router;
import org.http4k.routing.RouterDescription;
import org.http4k.routing.RoutingHandler;
import org.http4k.routing.RoutingMatch;
import org.http4k.routing.RoutingResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*,\b\u0001\u0010\u0002*&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00030\u0003*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0006Bs\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00028\u0001\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u0003\u0012*\u0010\u000f\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00030\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\f\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/http4k/routing/TemplatedRoute;", "R", "F", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Self", "Lorg/http4k/routing/RouteMatcher;", "uriTemplate", "Lorg/http4k/core/UriTemplate;", "handler", "router", "Lorg/http4k/routing/Router;", "filter", "responseFor", "Lorg/http4k/core/Status;", "addUriTemplateFilter", "<init>", "(Lorg/http4k/core/UriTemplate;Lkotlin/jvm/functions/Function1;Lorg/http4k/routing/Router;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getUriTemplate", "()Lorg/http4k/core/UriTemplate;", "getHandler", "()Lkotlin/jvm/functions/Function1;", "getRouter", "()Lorg/http4k/routing/Router;", "getFilter", "Lkotlin/jvm/functions/Function1;", "match", "Lorg/http4k/routing/RoutingMatch;", "request", "toString", "", "http4k-core"})
public abstract class TemplatedRoute<R, F extends Function1<? super Function1<? super Request, ? extends R>, ? extends Function1<? super Request, ? extends R>>, Self extends RouteMatcher<R, F>>
implements RouteMatcher<R, F> {
    @NotNull
    private final UriTemplate uriTemplate;
    @NotNull
    private final Function1<Request, R> handler;
    @NotNull
    private final Router router;
    @NotNull
    private final F filter;
    @NotNull
    private final Function1<Status, R> responseFor;
    @NotNull
    private final Function1<Function1<? super Request, ? extends R>, Function1<Request, R>> addUriTemplateFilter;

    public TemplatedRoute(@NotNull UriTemplate uriTemplate, @NotNull Function1<? super Request, ? extends R> handler, @NotNull Router router, @NotNull F filter, @NotNull Function1<? super Status, ? extends R> responseFor, @NotNull Function1<? super Function1<? super Request, ? extends R>, ? extends Function1<? super Request, ? extends R>> addUriTemplateFilter) {
        Intrinsics.checkNotNullParameter((Object)uriTemplate, (String)"uriTemplate");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(responseFor, (String)"responseFor");
        Intrinsics.checkNotNullParameter(addUriTemplateFilter, (String)"addUriTemplateFilter");
        this.uriTemplate = uriTemplate;
        this.handler = handler;
        this.router = router;
        this.filter = filter;
        this.responseFor = responseFor;
        this.addUriTemplateFilter = addUriTemplateFilter;
        if (!(!(this.handler instanceof RoutingHandler))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected final UriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    @NotNull
    protected final Function1<Request, R> getHandler() {
        return this.handler;
    }

    @NotNull
    protected final Router getRouter() {
        return this.router;
    }

    @NotNull
    protected final F getFilter() {
        return this.filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public RoutingMatch<R> match(@NotNull Request request) {
        RoutingMatch routingMatch;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.uriTemplate.matches(request.getUri().getPath())) {
            RoutingResult result = this.router.invoke(request);
            if (result instanceof RoutingResult.Matched) {
                routingMatch = new RoutingMatch(0, ((RoutingResult.Matched)result).getDescription(), (Function1)this.addUriTemplateFilter.invoke(this.filter.invoke(this.handler)));
                return routingMatch;
            } else {
                if (!(result instanceof RoutingResult.NotMatched)) throw new NoWhenBranchMatchedException();
                routingMatch = new RoutingMatch(1, ((RoutingResult.NotMatched)result).getDescription(), (Function1)this.filter.invoke(arg_0 -> TemplatedRoute.match$lambda$0(this, result, arg_0)));
            }
            return routingMatch;
        } else {
            routingMatch = new RoutingMatch(2, RouterDescription.Companion.getUnavailable(), (Function1)this.filter.invoke(arg_0 -> TemplatedRoute.match$lambda$1(this, arg_0)));
        }
        return routingMatch;
    }

    @NotNull
    public String toString() {
        return "template=" + this.uriTemplate + " AND " + this.router.getDescription();
    }

    private static final Object match$lambda$0(TemplatedRoute this$0, RoutingResult $result, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.responseFor.invoke((Object)((RoutingResult.NotMatched)$result).getStatus());
    }

    private static final Object match$lambda$1(TemplatedRoute this$0, Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"<unused var>");
        return this$0.responseFor.invoke((Object)Status.NOT_FOUND);
    }
}

