/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ServerControl;
import java.util.Objects;
import java.util.Optional;

class ServerControlBuilder {
    private static final long OPT_BIT_CAN_BLOCK_RELOAD = 1L;
    private long optBits;
    private Double canSkipUntil;
    private Boolean canSkipDateRanges;
    private Double holdBack;
    private Double partHoldBack;
    private boolean canBlockReload;

    ServerControlBuilder() {
        if (!(this instanceof ServerControl.Builder)) {
            throw new UnsupportedOperationException("Use: new ServerControl.Builder()");
        }
    }

    public final ServerControl.Builder from(ServerControl instance) {
        Optional<Double> partHoldBackOptional;
        Optional<Double> holdBackOptional;
        Optional<Boolean> canSkipDateRangesOptional;
        Objects.requireNonNull(instance, "instance");
        Optional<Double> canSkipUntilOptional = instance.canSkipUntil();
        if (canSkipUntilOptional.isPresent()) {
            this.canSkipUntil(canSkipUntilOptional);
        }
        if ((canSkipDateRangesOptional = instance.canSkipDateRanges()).isPresent()) {
            this.canSkipDateRanges(canSkipDateRangesOptional);
        }
        if ((holdBackOptional = instance.holdBack()).isPresent()) {
            this.holdBack(holdBackOptional);
        }
        if ((partHoldBackOptional = instance.partHoldBack()).isPresent()) {
            this.partHoldBack(partHoldBackOptional);
        }
        this.canBlockReload(instance.canBlockReload());
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder canSkipUntil(double canSkipUntil) {
        this.canSkipUntil = canSkipUntil;
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder canSkipUntil(Optional<Double> canSkipUntil) {
        this.canSkipUntil = canSkipUntil.orElse(null);
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder canSkipDateRanges(boolean canSkipDateRanges) {
        this.canSkipDateRanges = canSkipDateRanges;
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder canSkipDateRanges(Optional<Boolean> canSkipDateRanges) {
        this.canSkipDateRanges = canSkipDateRanges.orElse(null);
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder holdBack(double holdBack) {
        this.holdBack = holdBack;
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder holdBack(Optional<Double> holdBack) {
        this.holdBack = holdBack.orElse(null);
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder partHoldBack(double partHoldBack) {
        this.partHoldBack = partHoldBack;
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder partHoldBack(Optional<Double> partHoldBack) {
        this.partHoldBack = partHoldBack.orElse(null);
        return (ServerControl.Builder)this;
    }

    public final ServerControl.Builder canBlockReload(boolean canBlockReload) {
        this.canBlockReload = canBlockReload;
        this.optBits |= 1L;
        return (ServerControl.Builder)this;
    }

    public ServerControl build() {
        return new ImmutableServerControl(this);
    }

    private boolean canBlockReloadIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private static final class ImmutableServerControl
    implements ServerControl {
        private final Double canSkipUntil;
        private final Boolean canSkipDateRanges;
        private final Double holdBack;
        private final Double partHoldBack;
        private final boolean canBlockReload;

        private ImmutableServerControl(ServerControlBuilder builder) {
            this.canSkipUntil = builder.canSkipUntil;
            this.canSkipDateRanges = builder.canSkipDateRanges;
            this.holdBack = builder.holdBack;
            this.partHoldBack = builder.partHoldBack;
            this.canBlockReload = builder.canBlockReloadIsSet() ? builder.canBlockReload : ServerControl.super.canBlockReload();
        }

        @Override
        public Optional<Double> canSkipUntil() {
            return Optional.ofNullable(this.canSkipUntil);
        }

        @Override
        public Optional<Boolean> canSkipDateRanges() {
            return Optional.ofNullable(this.canSkipDateRanges);
        }

        @Override
        public Optional<Double> holdBack() {
            return Optional.ofNullable(this.holdBack);
        }

        @Override
        public Optional<Double> partHoldBack() {
            return Optional.ofNullable(this.partHoldBack);
        }

        @Override
        public boolean canBlockReload() {
            return this.canBlockReload;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableServerControl && this.equalTo((ImmutableServerControl)another);
        }

        private boolean equalTo(ImmutableServerControl another) {
            return Objects.equals(this.canSkipUntil, another.canSkipUntil) && Objects.equals(this.canSkipDateRanges, another.canSkipDateRanges) && Objects.equals(this.holdBack, another.holdBack) && Objects.equals(this.partHoldBack, another.partHoldBack) && this.canBlockReload == another.canBlockReload;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.canSkipUntil);
            h += (h << 5) + Objects.hashCode(this.canSkipDateRanges);
            h += (h << 5) + Objects.hashCode(this.holdBack);
            h += (h << 5) + Objects.hashCode(this.partHoldBack);
            h += (h << 5) + Boolean.hashCode(this.canBlockReload);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ServerControl{");
            if (this.canSkipUntil != null) {
                builder.append("canSkipUntil=").append(this.canSkipUntil);
            }
            if (this.canSkipDateRanges != null) {
                if (builder.length() > 14) {
                    builder.append(", ");
                }
                builder.append("canSkipDateRanges=").append(this.canSkipDateRanges);
            }
            if (this.holdBack != null) {
                if (builder.length() > 14) {
                    builder.append(", ");
                }
                builder.append("holdBack=").append(this.holdBack);
            }
            if (this.partHoldBack != null) {
                if (builder.length() > 14) {
                    builder.append(", ");
                }
                builder.append("partHoldBack=").append(this.partHoldBack);
            }
            if (builder.length() > 14) {
                builder.append(", ");
            }
            builder.append("canBlockReload=").append(this.canBlockReload);
            return builder.append("}").toString();
        }
    }
}

