/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.osfileutil;

import ir.amirab.util.ExecKt;
import ir.amirab.util.osfileutil.DesktopFileUtils;
import java.io.File;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lir/amirab/util/osfileutil/LinuxFileUtils;", "Lir/amirab/util/osfileutil/DesktopFileUtils;", "<init>", "()V", "openFileInternal", "", "file", "Ljava/io/File;", "openFolderOfFileInternal", "openFolderInternal", "folder", "encodePath", "", "path", "utils"})
public final class LinuxFileUtils
extends DesktopFileUtils {
    @Override
    protected boolean openFileInternal(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String[] stringArray = new String[2];
        stringArray[0] = "xdg-open";
        Intrinsics.checkNotNullExpressionValue((Object)file.getPath(), (String)"getPath(...)");
        return ExecKt.execAndWait$default(stringArray, 0L, 2, null);
    }

    @Override
    protected boolean openFolderOfFileInternal(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String uri = "file://" + this.encodePath(string);
        String[] stringArray = new String[]{"dbus-send", "--print-reply", "--dest=org.freedesktop.FileManager1", "/org/freedesktop/FileManager1", "org.freedesktop.FileManager1.ShowItems", "array:string:" + uri, "string:"};
        boolean dbusSendResult = ExecKt.execAndWait$default(stringArray, 0L, 2, null);
        if (dbusSendResult) {
            return true;
        }
        String[] stringArray2 = new String[2];
        stringArray2[0] = "xdg-open";
        Intrinsics.checkNotNullExpressionValue((Object)file.getParent(), (String)"getParent(...)");
        boolean xdgOpenResult = ExecKt.execAndWait$default(stringArray2, 0L, 2, null);
        return xdgOpenResult;
    }

    @Override
    protected boolean openFolderInternal(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        String[] stringArray = new String[2];
        stringArray[0] = "xdg-open";
        Intrinsics.checkNotNullExpressionValue((Object)folder.getParent(), (String)"getParent(...)");
        return ExecKt.execAndWait$default(stringArray, 0L, 2, null);
    }

    private final String encodePath(String path) {
        char[] cArray = new char[]{'/'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, LinuxFileUtils::encodePath$lambda$0, (int)30, null);
    }

    private static final CharSequence encodePath$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = URLEncoder.encode(it, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }
}

