/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.datasize;

import ir.amirab.util.datasize.BaseSize;
import ir.amirab.util.datasize.CommonSizeConvertConfigs;
import ir.amirab.util.datasize.CommonSizeUnits;
import ir.amirab.util.datasize.ConvertSizeConfig;
import ir.amirab.util.datasize.ExtensionsKt;
import ir.amirab.util.datasize.SizeFactors;
import ir.amirab.util.datasize.SizeUnit;
import ir.amirab.util.datasize.SizeWithUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lir/amirab/util/datasize/SizeConverter;", "", "<init>", "()V", "sizeToBytes", "", "sizeWithUnit", "Lir/amirab/util/datasize/SizeWithUnit;", "bytesToSize", "bytes", "target", "Lir/amirab/util/datasize/ConvertSizeConfig;", "convert", "src", "utils"})
public final class SizeConverter {
    @NotNull
    public static final SizeConverter INSTANCE = new SizeConverter();

    private SizeConverter() {
    }

    public final long sizeToBytes(@NotNull SizeWithUnit sizeWithUnit) {
        Intrinsics.checkNotNullParameter((Object)sizeWithUnit, (String)"sizeWithUnit");
        return (long)this.convert(sizeWithUnit, ExtensionsKt.fixedFactor(CommonSizeConvertConfigs.INSTANCE.getBinaryBytes(), SizeFactors.FactorValue.None)).getValue();
    }

    @NotNull
    public final SizeWithUnit bytesToSize(long bytes, @NotNull ConvertSizeConfig target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.convert(new SizeWithUnit(bytes, CommonSizeUnits.INSTANCE.getBinaryBytes()), target);
    }

    @NotNull
    public final SizeWithUnit convert(@NotNull SizeWithUnit src, @NotNull ConvertSizeConfig target) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        long valueWithoutFactor = src.getUnit().getFactors().removeFactor(src.getValue(), src.getUnit().getFactorValue());
        double valueWithBaseSize = (double)valueWithoutFactor * src.getUnit().getBaseSize().scaleInto(target.getBaseSize());
        SizeFactors.FactorValue factorValue = target.getFactors().bestFactor((long)valueWithBaseSize, target.getAcceptedFactors());
        double finalValue = target.getFactors().withFactor(valueWithBaseSize, factorValue);
        SizeFactors sizeFactors = target.getFactors();
        BaseSize baseSize = target.getBaseSize();
        return new SizeWithUnit(finalValue, new SizeUnit(factorValue, baseSize, sizeFactors));
    }
}

