/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.updateapplier;

import com.abdownloadmanager.updateapplier.BaseUpdateApplier;
import com.abdownloadmanager.updateapplier.UpdateDownloader;
import com.abdownloadmanager.updateapplier.UpdateInstaller;
import com.abdownloadmanager.updateapplier.UpdateInstallerByWindowsExecutable;
import com.abdownloadmanager.updateapplier.UpdateInstallerFromArchiveFile;
import com.abdownloadmanager.updateapplier.UpdatePreparer;
import com.abdownloadmanager.updatechecker.UpdateInfo;
import com.abdownloadmanager.updatechecker.UpdateSource;
import ir.amirab.util.platform.Platform;
import ir.amirab.util.platform.PlatformFInder;
import ir.amirab.util.platform.PlatformKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/abdownloadmanager/updateapplier/DesktopDirectLinkUpdateApplier;", "Lcom/abdownloadmanager/updateapplier/BaseUpdateApplier;", "installationFolder", "", "appName", "updateFolder", "logDir", "updatePreparer", "Lcom/abdownloadmanager/updateapplier/UpdateDownloader;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/abdownloadmanager/updateapplier/UpdateDownloader;)V", "getUpdatePreparer", "Lcom/abdownloadmanager/updateapplier/UpdatePreparer;", "updateSupported", "", "validateAppStateOnApplyUpdate", "", "getBestDownloadSource", "Lcom/abdownloadmanager/updatechecker/UpdateSource;", "updateInfo", "Lcom/abdownloadmanager/updatechecker/UpdateInfo;", "getUpdateInstaller", "Lcom/abdownloadmanager/updateapplier/UpdateInstaller;", "preparedUpdate", "Lcom/abdownloadmanager/updateapplier/UpdatePreparer$PreparedUpdate;", "isAppInstalledWithNSIS", "isArchiveFile", "name", "isExeFile", "updater"})
@SourceDebugExtension(value={"SMAP\nDesktopDirectLinkUpdateApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopDirectLinkUpdateApplier.kt\ncom/abdownloadmanager/updateapplier/DesktopDirectLinkUpdateApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n808#2,11:92\n*S KotlinDebug\n*F\n+ 1 DesktopDirectLinkUpdateApplier.kt\ncom/abdownloadmanager/updateapplier/DesktopDirectLinkUpdateApplier\n*L\n32#1:92,11\n*E\n"})
public final class DesktopDirectLinkUpdateApplier
extends BaseUpdateApplier {
    @Nullable
    private final String installationFolder;
    @NotNull
    private final String appName;
    @NotNull
    private final String updateFolder;
    @NotNull
    private final String logDir;
    @NotNull
    private final UpdateDownloader updatePreparer;

    public DesktopDirectLinkUpdateApplier(@Nullable String installationFolder, @NotNull String appName, @NotNull String updateFolder, @NotNull String logDir, @NotNull UpdateDownloader updatePreparer) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)updateFolder, (String)"updateFolder");
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        Intrinsics.checkNotNullParameter((Object)updatePreparer, (String)"updatePreparer");
        this.installationFolder = installationFolder;
        this.appName = appName;
        this.updateFolder = updateFolder;
        this.logDir = logDir;
        this.updatePreparer = updatePreparer;
    }

    @Override
    @NotNull
    public UpdatePreparer getUpdatePreparer() {
        return this.updatePreparer;
    }

    @Override
    public boolean updateSupported() {
        String string = this.installationFolder;
        if (string == null) {
            return false;
        }
        String installationFolder = string;
        return new File(installationFolder).canWrite();
    }

    @Override
    public void validateAppStateOnApplyUpdate() {
        if (this.installationFolder == null) {
            boolean bl = false;
            String string = "update applier can only apply update if installation folder is not null";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UpdateSource getBestDownloadSource(@NotNull UpdateInfo updateInfo) {
        Object v0;
        List downloadableSources;
        block6: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)updateInfo, (String)"updateInfo");
            Iterable $this$filterIsInstance$iv = updateInfo.getUpdateSource();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UpdateSource.DirectDownloadLink)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloadableSources = (List)destination$iv$iv;
            iterable = downloadableSources;
            for (Object t : iterable) {
                UpdateSource.DirectDownloadLink it = (UpdateSource.DirectDownloadLink)t;
                boolean bl = false;
                if (!this.isArchiveFile(it.getName())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        UpdateSource.DirectDownloadLink downloadSource = v0;
        if (Intrinsics.areEqual((Object)Platform.Companion.getCurrentPlatform(), (Object)Platform.Desktop.Windows.INSTANCE)) {
            Iterator iterator;
            block7: {
                Iterable iterable = downloadableSources;
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    Iterator iterator3 = iterator2.next();
                    UpdateSource.DirectDownloadLink it = (UpdateSource.DirectDownloadLink)((Object)iterator3);
                    boolean bl = false;
                    if (!this.isExeFile(it.getName())) continue;
                    iterator = iterator3;
                    break block7;
                }
                iterator = null;
            }
            UpdateSource.DirectDownloadLink exeDirectDownloadLink = (UpdateSource.DirectDownloadLink)((Object)iterator);
            if (this.isAppInstalledWithNSIS() && exeDirectDownloadLink != null) {
                downloadSource = exeDirectDownloadLink;
            }
        }
        UpdateSource.DirectDownloadLink directDownloadLink = downloadSource;
        if (directDownloadLink == null) {
            boolean bl = false;
            String string = "Can't find proper download link for your platform! Please update it manually";
            throw new IllegalArgumentException(string.toString());
        }
        return directDownloadLink;
    }

    @Override
    @NotNull
    public UpdateInstaller getUpdateInstaller(@NotNull UpdatePreparer.PreparedUpdate preparedUpdate) {
        UpdateInstaller updateInstaller;
        Intrinsics.checkNotNullParameter((Object)preparedUpdate, (String)"preparedUpdate");
        boolean cfr_ignored_0 = preparedUpdate instanceof UpdateDownloader.PreparedUpdateFile;
        File downloadedFile = ((UpdateDownloader.PreparedUpdateFile)preparedUpdate).getFile();
        String string = downloadedFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (this.isArchiveFile(string)) {
            Object appFolderInArchive = PlatformKt.isMac((PlatformFInder)((PlatformFInder)Platform.Companion)) ? this.appName + ".app" : this.appName;
            String string2 = this.installationFolder;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            File file = FilesKt.resolve((File)new File(this.updateFolder), (String)"extracted");
            String string4 = this.logDir;
            updateInstaller = new UpdateInstallerFromArchiveFile(downloadedFile, string3, file, (String)appFolderInArchive, string4);
        } else {
            String string5 = downloadedFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            if (this.isExeFile(string5)) {
                updateInstaller = new UpdateInstallerByWindowsExecutable(downloadedFile);
            } else {
                String string6 = downloadedFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                String string7 = "can't install " + this.extension(string6) + " format automatically! please update it manually!";
                throw new IllegalStateException(string7.toString());
            }
        }
        return updateInstaller;
    }

    private final boolean isAppInstalledWithNSIS() {
        return new File(this.installationFolder, "uninstall.exe").exists();
    }

    private final boolean isArchiveFile(String name) {
        return StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null);
    }

    private final boolean isExeFile(String name) {
        return StringsKt.endsWith$default((String)name, (String)".exe", (boolean)false, (int)2, null);
    }
}

