/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.desktop.win;

import com.github.markusbernhardt.proxy.jna.win.WinHttp;
import com.github.markusbernhardt.proxy.jna.win.WinHttpHelpers;
import com.github.markusbernhardt.proxy.jna.win.WinHttpProxyInfo;
import com.github.markusbernhardt.proxy.search.desktop.win.CommonWindowsSearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.win.WinProxyConfig;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.ProxySelector;
import java.util.Properties;

public class WinProxySearchStrategy
extends CommonWindowsSearchStrategy {
    static final int WINHTTP_ACCESS_TYPE_DEFAULT_PROXY = 0;
    static final int WINHTTP_ACCESS_TYPE_NO_PROXY = 1;
    static final int WINHTTP_ACCESS_TYPE_NAMED_PROXY = 3;

    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting Windows proxy settings", new Object[0]);
        WinProxyConfig windowsProxyConfig = this.readWindowsProxyConfig();
        if (windowsProxyConfig.getAccessType() == 1) {
            return null;
        }
        return this.createFixedProxySelector(windowsProxyConfig);
    }

    @Override
    public String getName() {
        return "windows";
    }

    public WinProxyConfig readWindowsProxyConfig() {
        WinHttpProxyInfo winHttpProxyInfo = new WinHttpProxyInfo();
        boolean result = WinHttp.INSTANCE.WinHttpGetDefaultProxyConfiguration(winHttpProxyInfo);
        if (!result) {
            return null;
        }
        return new WinProxyConfig(winHttpProxyInfo.dwAccessType != null ? winHttpProxyInfo.dwAccessType.intValue() : 0, WinHttpHelpers.getAndFreeGlobalString(winHttpProxyInfo.lpszProxy), WinHttpHelpers.getAndFreeGlobalString(winHttpProxyInfo.lpszProxyBypass));
    }

    private ProxySelector createFixedProxySelector(WinProxyConfig winProxyConfig) throws ProxyException {
        String proxyString = winProxyConfig.getProxy();
        String bypassList = winProxyConfig.getProxyBypass();
        if (proxyString == null) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Windows uses manual settings: {} with bypass list: {}", proxyString, bypassList);
        Properties p = this.parseProxyList(proxyString);
        ProtocolDispatchSelector ps = this.buildProtocolDispatchSelector(p);
        ProxySelector result = this.setByPassListOnSelector(bypassList, ps);
        return result;
    }
}

