/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser.firefox;

import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProfileSource;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

class FirefoxSettingParser {
    public Properties parseSettings(FirefoxProfileSource source) throws IOException, ConfigurationException {
        File settingsFile = this.getSettingsFile(source);
        Properties result = new Properties();
        if (settingsFile == null) {
            return result;
        }
        try (BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(settingsFile)));){
            String line;
            while ((line = fin.readLine()) != null) {
                if (!(line = line.trim()).startsWith("user_pref(\"network.proxy")) continue;
                line = line.substring(10, line.length() - 2);
                int index = line.indexOf(",");
                String key = this.removeDoubleQuotes(line.substring(0, index).trim());
                String value = this.removeDoubleQuotes(line.substring(index + 1).trim());
                result.put(key, value);
            }
        }
        return result;
    }

    private String removeDoubleQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected File getSettingsFile(FirefoxProfileSource source) throws IOException, ConfigurationException {
        block11: {
            File profilesIniFile = source.getProfilesIni();
            if (profilesIniFile.exists()) {
                INIConfiguration profilesIni = new INIConfiguration();
                try (FileReader fileReader = new FileReader(profilesIniFile);){
                    profilesIni.read((Reader)fileReader);
                    List keysFF67 = profilesIni.getSections().stream().filter(s -> s.startsWith("Install")).collect(Collectors.toList());
                    if (!keysFF67.isEmpty()) {
                        Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings for FF67+ detected.", new Object[0]);
                        for (String keyFF67 : keysFF67) {
                            File settingsFile;
                            Object propDefault;
                            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Current FF67+ section key is: {}", keysFF67);
                            SubnodeConfiguration section = profilesIni.getSection(keyFF67);
                            Object propLocked = section.getProperty("Locked");
                            if (propLocked == null || !"1".equals(propLocked.toString()) || (propDefault = section.getProperty("Default")) == null) continue;
                            File profileFolder = new File(profilesIniFile.getParentFile().getAbsolutePath(), propDefault.toString());
                            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder is {}", profileFolder);
                            File file = settingsFile = new File(profileFolder, "prefs.js");
                            return file;
                        }
                        break block11;
                    }
                    for (String section : profilesIni.getSections()) {
                        File settingsFile;
                        Object propPath;
                        SubnodeConfiguration confSection = profilesIni.getSection(section);
                        if (confSection == null) continue;
                        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Current entry, key: {}, value: {}", section, confSection.toString());
                        Object propName = confSection.getProperty("Name");
                        Object propRelative = confSection.getProperty("IsRelative");
                        if (propName == null || propRelative == null || !"default".equals(propName.toString()) || !"1".equals(propRelative.toString()) || (propPath = confSection.getProperty("Path")) == null) continue;
                        File profileFolder = new File(profilesIniFile.getParentFile().getAbsolutePath(), propPath.toString());
                        Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder is {}", profileFolder);
                        File file = settingsFile = new File(profileFolder, "prefs.js");
                        return file;
                    }
                }
            }
        }
        Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder not found!", new Object[0]);
        return null;
    }
}

